/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.exports;

import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailColExportsVo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ExcelHelpProcess {
    private static final Logger log = LoggerFactory.getLogger(ExcelHelpProcess.class);
    private static final String LETTER_KEY = "Y";
    private static final String REG = "^[0-9]+(.[0-9]+)?$";

    public static void exportsColAssignment(AuditCustomerDetailCollectionVo customerColDetail, CustomerAuditDetailColExportsVo auditDetailColExports, SimpleDateFormat dateFormat) {
        Date activityEndTime;
        BeanUtils.copyProperties((Object)customerColDetail, (Object)auditDetailColExports);
        Date activityBeginTime = customerColDetail.getActivityBeginTime();
        if (!Objects.isNull(activityBeginTime)) {
            String string = dateFormat.format(activityBeginTime);
        }
        if (!Objects.isNull(activityEndTime = customerColDetail.getActivityEndTime())) {
            String string = dateFormat.format(activityEndTime);
        }
        String isDeductionFeePool = customerColDetail.getIsDeductionFeePool();
        auditDetailColExports.setIsDeductionFeePool(ExcelHelpProcess.letterConversion(isDeductionFeePool));
        String wholeAudit = customerColDetail.getWholeAudit();
        auditDetailColExports.setWholeAudit(ExcelHelpProcess.letterConversion(wholeAudit));
        String isSpecialTicket = customerColDetail.getIsSpecialTicket();
        auditDetailColExports.setIsSpecialTicket(ExcelHelpProcess.letterConversion(isSpecialTicket));
        String isPushSap = customerColDetail.getIsPushSap();
        auditDetailColExports.setIsPushSap(ExcelHelpProcess.letterConversion(isPushSap));
        String endCaseForm = customerColDetail.getEndCaseForm();
        auditDetailColExports.setEndCaseForm(ExcelHelpProcess.numberConversion(endCaseForm));
    }

    private static String letterConversion(String letter) {
        if (StringUtils.isEmpty((CharSequence)letter)) {
            return "";
        }
        return StringUtils.equals((CharSequence)letter, (CharSequence)LETTER_KEY) ? "\u662f" : "\u5426";
    }

    private static String numberConversion(String number) {
        String[] numSplit;
        if (StringUtils.isEmpty((CharSequence)number)) {
            return "";
        }
        ArrayList conversionList = Lists.newArrayList();
        String discountCode = EndCaseFormEnum.DISCOUNT.getCode();
        String reimburseCode = EndCaseFormEnum.REIMBURSE.getCode();
        String redInvoiceCode = EndCaseFormEnum.RED_INVOICE.getCode();
        String withOrderCode = EndCaseFormEnum.WITH_ORDER.getCode();
        for (String split : numSplit = number.split(",")) {
            if (!split.matches(REG)) continue;
            if (StringUtils.equals((CharSequence)split, (CharSequence)discountCode)) {
                conversionList.add(EndCaseFormEnum.DISCOUNT.getValue());
                continue;
            }
            if (StringUtils.equals((CharSequence)split, (CharSequence)reimburseCode)) {
                conversionList.add(EndCaseFormEnum.REIMBURSE.getValue());
                continue;
            }
            if (StringUtils.equals((CharSequence)split, (CharSequence)redInvoiceCode)) {
                conversionList.add(EndCaseFormEnum.RED_INVOICE.getValue());
                continue;
            }
            if (!StringUtils.equals((CharSequence)split, (CharSequence)withOrderCode)) continue;
            conversionList.add(EndCaseFormEnum.WITH_ORDER.getValue());
        }
        return !conversionList.isEmpty() ? StringUtils.join((Iterable)conversionList, (String)",") : "";
    }

    public static List<String> chineseToNumber(String chineseStr) {
        String[] split;
        if (StringUtils.isEmpty((CharSequence)chineseStr)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        for (String str : split = chineseStr.split(",")) {
            if (StringUtils.equals((CharSequence)str, (CharSequence)EndCaseFormEnum.DISCOUNT.getValue())) {
                resultList.add(EndCaseFormEnum.DISCOUNT.getCode());
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)EndCaseFormEnum.REIMBURSE.getValue())) {
                resultList.add(EndCaseFormEnum.REIMBURSE.getCode());
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)EndCaseFormEnum.RED_INVOICE.getValue())) {
                resultList.add(EndCaseFormEnum.RED_INVOICE.getCode());
                continue;
            }
            if (!StringUtils.equals((CharSequence)str, (CharSequence)EndCaseFormEnum.WITH_ORDER.getValue())) continue;
            resultList.add(EndCaseFormEnum.WITH_ORDER.getCode());
        }
        return resultList;
    }

    public static String whetherConversion(String whetherChinese) {
        if (StringUtils.isEmpty((CharSequence)whetherChinese)) {
            return "";
        }
        return StringUtils.equals((CharSequence)whetherChinese, (CharSequence)"\u662f") ? LETTER_KEY : "N";
    }
}

