/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditImportService;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerAuditDetailImportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AuditCustomerAuditDetailImportProcess
implements ImportProcess<AuditCustomerAuditDetailImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditCustomerAuditDetailImportProcess.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private AuditImportService auditImportService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditCustomerAuditDetailImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap errorMap = Maps.newHashMap();
        try {
            if (data.values() == null || data.values().isEmpty()) {
                throw new IllegalArgumentException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
            }
            Map<String, List<AuditCustomerAuditDetailImportsVo>> map = Lists.newArrayList(data.values()).stream().collect(Collectors.groupingBy(e -> e.getAuditCode()));
            for (Map.Entry<String, List<AuditCustomerAuditDetailImportsVo>> entry : map.entrySet()) {
                AuditDto auditDto = this.auditImportService.findAuditDtoByCode(entry.getKey());
                auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
                IAudit audit = this.auditService.getAudit(auditDto);
                Collection importsVoList1 = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entry.getValue(), AuditCustomerAuditDetailImportsVo.class, CustomerAuditDetailImportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                List result = this.auditImportService.validate(new ArrayList(importsVoList1), auditDto, (Map)errorMap);
                if (0 != errorMap.size()) continue;
                auditDto.setAuditCustomerDetailList(result);
                audit.customerBatchImport(auditDto);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("\u6838\u9500\u5f52\u96c6\u5bfc\u5165\u5f02\u5e38\u4fe1\u606f", (Throwable)e2);
            throw new IllegalArgumentException(e2.getMessage());
        }
        HashMap<Integer, String> resultErrorMap = new HashMap<Integer, String>();
        data.forEach((key, value) -> {
            String msg = (String)errorMap.get(value.getAuditDetailCode());
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                msg = "\u7b2c" + (key + 1) + "\u884c" + msg;
                resultErrorMap.put((Integer)key, msg);
            }
        });
        return resultErrorMap;
    }

    public Class<AuditCustomerAuditDetailImportsVo> findCrmExcelVoClass() {
        return AuditCustomerAuditDetailImportsVo.class;
    }

    public String getTemplateCode() {
        return "AUDIT_CUSTOMER_AUDIT_DETAIL_IMPORT";
    }

    public String getTemplateName() {
        return "\u5ba2\u6237\u6838\u9500\u660e\u7ec6\u6279\u91cf\u5bfc\u5165";
    }
}

