/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.biz.crm.tpm.business.audit.local.service.helper.AuditRedInvoiceProductPageCacheHelper;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceProductDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditRedInvoiceProductImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditRedInvoiceProductImportProcess
implements ImportProcess<AuditRedInvoiceProductImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditRedInvoiceProductImportProcess.class);
    @Autowired(required=false)
    private AuditRedInvoiceProductPageCacheHelper auditRedInvoiceProductPageCacheHelper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private TerminalVoService terminalVoService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditRedInvoiceProductImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        log.error("\u7b2c0\u6b65\u83b7\u53d6params={}", params);
        Validate.notNull(data, (String)"\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58cacheKey\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        log.error("\u7b2c\u4e00\u6b65\u83b7\u53d6cacheKey={}", cacheKey);
        log.info("\u7ea2\u5b57\u53d1\u7968\u4ea7\u54c1\u5bfc\u5165,data:{}", (Object)JsonUtils.obj2JsonString(data.values()));
        if (CollectionUtil.isEmpty(data)) {
            return null;
        }
        try {
            Map map = this.dictToolkitService.findConvertMapByDictTypeCode("product_base_unit");
            log.error("\u7b2c\u4e8c\u6b65\u83b7\u53d6\u7b26\u53f7\u5b57\u5178={}", (Object)map);
            HashSet proCodes = new HashSet();
            ArrayList storeCodes = new ArrayList();
            data.forEach((index, importVo) -> {
                if (StringUtils.isEmpty((CharSequence)importVo.getProductCode())) {
                    errorMap.put((Integer)index, "\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
                proCodes.add(importVo.getProductCode());
                if (StringUtils.isNotEmpty((CharSequence)importVo.getStoreCode())) {
                    storeCodes.add(importVo.getStoreCode());
                }
                if (Objects.isNull(importVo.getQuantity())) {
                    errorMap.put((Integer)index, "\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isEmpty((CharSequence)importVo.getUnitName())) {
                    errorMap.put((Integer)index, "\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (Objects.isNull(importVo.getAmount())) {
                    errorMap.put((Integer)index, "\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
            if (!CollectionUtils.isEmpty(errorMap.keySet())) {
                return errorMap;
            }
            List proList = this.productVoService.findByCodes(new ArrayList(proCodes));
            Map<Object, Object> maMap = new HashMap();
            if (!CollectionUtil.isEmpty((Collection)proList)) {
                maMap = proList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (oldV, newV) -> newV));
            }
            log.error("\u7b2c\u4e09\u6b65\u83b7\u53d6\u4fc3\u9500\u7269\u6599={}\uff0c\u7269\u6599\u7f16\u7801={}", maMap, proCodes);
            HashMap finalMaMap = maMap;
            Map<Object, Object> terminalVoMap = new HashMap();
            if (!CollectionUtils.isEmpty(storeCodes)) {
                List terminalVoList = this.terminalVoService.findByTerminalCodes(storeCodes);
                terminalVoMap = terminalVoList.stream().collect(Collectors.toMap(TerminalVo::getTerminalCode, Function.identity()));
            }
            HashMap finalTerminalVoMap = terminalVoMap;
            data.forEach((index, importVo) -> {
                if (!finalMaMap.containsKey(importVo.getProductCode())) {
                    errorMap.put((Integer)index, "\u672a\u67e5\u627e\u5230\u7269\u6599\u4fe1\u606f");
                } else {
                    ProductVo productVo = (ProductVo)finalMaMap.get(importVo.getProductCode());
                    importVo.setProductName(productVo.getProductName());
                    importVo.setProductBrandCode(productVo.getProductBrandCode());
                    importVo.setProductBrandName(productVo.getProductBrandName());
                    importVo.setProductCategoryCode(productVo.getProductCategoryCode());
                    importVo.setProductCategoryName(productVo.getProductCategoryName());
                    importVo.setProductItemCode(productVo.getProductLevelCode());
                    importVo.setProductItemName(productVo.getProductLevelName());
                    importVo.setBusinessFormatCode(productVo.getBusinessFormatCode());
                    if (!map.containsKey(importVo.getUnitName())) {
                        errorMap.put((Integer)index, "\u65e0\u6cd5\u8bc6\u522b" + importVo.getUnitName());
                    } else {
                        String unitCode = (String)map.get(importVo.getUnitName());
                        if (!unitCode.equals(productVo.getBaseUnit())) {
                            errorMap.put((Integer)index, "\u5355\u4f4d[" + importVo.getUnitName() + "]\u7269\u6599\u4fe1\u606f[" + importVo.getProductCode() + "]\u4e0a\u7684\u57fa\u672c\u5355\u4f4d\u4e0d\u4e00\u81f4");
                        } else {
                            importVo.setBaseUnit(unitCode);
                        }
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)importVo.getStoreCode())) {
                    TerminalVo terminalVo = (TerminalVo)finalTerminalVoMap.get(importVo.getStoreCode());
                    if (terminalVo == null) {
                        errorMap.put((Integer)index, "\u95e8\u5e97\u7f16\u7801\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230");
                    } else {
                        importVo.setStoreName(terminalVo.getTerminalName());
                    }
                }
            });
            if (CollectionUtils.isEmpty(errorMap.keySet())) {
                ArrayList importVos = Lists.newArrayList(data.values());
                Collection dtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)importVos, AuditRedInvoiceProductImportVo.class, AuditRedInvoiceProductDto.class, HashSet.class, ArrayList.class, new String[0]);
                log.error("\u7b2c\u56db\u6b65\u4fdd\u5b58\u7f13\u5b58\u6570\u636e={}", (Object)dtoList);
                this.auditRedInvoiceProductPageCacheHelper.importNewItem((String)cacheKey, (List)dtoList);
                log.error("\u5b8c\u6210");
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return errorMap;
    }

    public Class<AuditRedInvoiceProductImportVo> findCrmExcelVoClass() {
        return AuditRedInvoiceProductImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_AUDIT_RED_INVOICE_PRODUCT_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u7ea2\u5b57\u53d1\u7968\u4ea7\u54c1\u5bfc\u5165";
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_RED_INVOICE_PRODUCT_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u7ea2\u5b57\u53d1\u7968\u4ea7\u54c1\u5bfc\u5165";
    }
}

