/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.imports;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceVo;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailColImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CustomerAuditDetailColImportsProcess
implements ImportProcess<CustomerAuditDetailColImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(CustomerAuditDetailColImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private AccountSubjectService accountSubjectService;
    @Autowired(required=false)
    private CostCenterVoService costCenterVoService;
    @Autowired(required=false)
    private AuditInvoiceManageService auditInvoiceManageService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, CustomerAuditDetailColImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        HashMap<Integer, String> errMap = new HashMap<Integer, String>();
        try {
            String cacheKey = this.getCacheKey(params);
            log.info("\u6838\u9500cacheKey:{}", (Object)cacheKey);
            log.info("\u6838\u9500\u5bfc\u5165\u53c2\u6570______:[{}],[{}]", params, data);
            AuditDto auditDto = new AuditDto();
            auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
            IAudit audit = this.auditService.getAudit(auditDto);
            auditDto.setCacheKey(cacheKey);
            List<AuditCustomerDetailCollectionDto> result = this.validate(data, errMap);
            log.info("\u4f20\u5165\u7684\u53c2\u6570:{}", result);
            if (errMap.isEmpty()) {
                auditDto.setAuditCustomerDetailCollectionList(result);
                audit.customerColImport(auditDto);
            }
        }
        catch (Exception e) {
            errMap.put(1, errMap.getOrDefault(1, "") + " | " + e.getMessage());
            log.error("", (Throwable)e);
        }
        return errMap;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        liquibase.util.Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58\u53ef\u4ee5\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    private List<AuditCustomerDetailCollectionDto> validate(LinkedHashMap<Integer, CustomerAuditDetailColImportsVo> data, Map<Integer, String> errMap) {
        List costCenterVos;
        List accountSubjectVoList;
        List accountSubjectVoList2;
        log.info("\u6838\u9500\u5bfc\u5165\u7684data-values:{}", data.values());
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(data.values()), (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        List reimburseItems = data.values().stream().map(CustomerAuditDetailColImportsVo::getReimburseItem).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        HashMap accountSubjectVoMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(reimburseItems) && CollectionUtil.isNotEmpty((Collection)(accountSubjectVoList2 = this.accountSubjectService.findListByCode(reimburseItems)))) {
            accountSubjectVoMap.putAll(accountSubjectVoList2.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode, Function.identity(), (n, o) -> n)));
        }
        List taxSubjects = data.values().stream().map(CustomerAuditDetailColImportsVo::getTaxSubject).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
        HashMap taxSubjectsMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(taxSubjects) && CollectionUtil.isNotEmpty((Collection)(accountSubjectVoList = this.accountSubjectService.findListByCode(taxSubjects)))) {
            taxSubjectsMap.putAll(accountSubjectVoList.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode, Function.identity(), (n, o) -> n)));
        }
        List costCenterCodes = data.values().stream().map(CustomerAuditDetailColImportsVo::getCostCenter).collect(Collectors.toList());
        HashMap costCenterVoMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(costCenterCodes) && CollectionUtil.isNotEmpty((Collection)(costCenterVos = this.costCenterVoService.findByCodes(costCenterCodes, YesOrNoEnum.YES.getCode())))) {
            costCenterVoMap.putAll(costCenterVos.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode, Function.identity(), (n, o) -> n)));
        }
        ArrayList<AuditCustomerDetailCollectionDto> auditCustomerDetailCollectionDtoList = new ArrayList<AuditCustomerDetailCollectionDto>();
        boolean i = true;
        data.forEach((index, value) -> {
            ArrayList<String> errMgsLit = new ArrayList<String>();
            try {
                AccountSubjectVo accountSubjectVo;
                value.setAuditDetailCode(null);
                value.setActivityDetailCode(null);
                value.setActivityCode(null);
                value.setActivityName(null);
                value.setActivityTypeCode(null);
                value.setActivityTypeName(null);
                value.setActivityFormCode(null);
                value.setActivityFormName(null);
                value.setActivityBeginTime(null);
                value.setActivityEndTime(null);
                value.setSalesOrgCode(null);
                value.setSaleOrgName(null);
                value.setSystemCode(null);
                value.setSystemName(null);
                value.setCustomerSupplierType(null);
                value.setCustomerCode(null);
                value.setCustomerName(null);
                AccountSubjectVo accountSubjectVo1 = (AccountSubjectVo)taxSubjectsMap.get(value.getTaxSubject());
                if (accountSubjectVo1 != null) {
                    value.setTaxSubjectName(accountSubjectVo1.getAccountSubjectName());
                } else {
                    value.setTaxSubject(null);
                }
                value.setSupplierCode(null);
                value.setSupplierName(null);
                value.setProductBrandCode(null);
                value.setProductBrandName(null);
                value.setProductCategoryCode(null);
                value.setProductCategoryName(null);
                value.setProductItemCode(null);
                value.setProductItemName(null);
                value.setProductCode(null);
                value.setProductName(null);
                value.setCustomerFeeAmount(null);
                value.setIsDeductionFeePool(YesOrNoEnum.getByValue((String)value.getIsDeductionFeePool()));
                value.setEndCaseForm(null);
                value.setImpactProductCode(null);
                value.setImpactProductName(null);
                value.setApplyAmount(null);
                value.setAuditAmount(null);
                value.setWithholdingAmount(null);
                value.setThisChargeAgainstPrepayAmount(null);
                value.setAlreadyAuditAmount(null);
                value.setThisAuditAmount(null);
                value.setWholeAudit(null);
                if (StringUtils.isNotEmpty((CharSequence)value.getDiscountTaxAmount()) && StringUtils.isNotEmpty((CharSequence)value.getDiscountTaxRate())) {
                    value.setDiscountAmount(new BigDecimal(value.getDiscountTaxAmount()).multiply(BigDecimal.ONE.subtract(new BigDecimal(value.getDiscountTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP))).setScale(2, RoundingMode.HALF_UP).toPlainString());
                }
                if (StringUtils.isNotEmpty((CharSequence)value.getDiscountTaxAmount()) && StringUtils.isNotEmpty((CharSequence)value.getDiscountAmount())) {
                    value.setDiscountTaxDeduction(new BigDecimal(value.getDiscountTaxAmount()).subtract(new BigDecimal(value.getDiscountAmount())).setScale(2, RoundingMode.HALF_UP).toPlainString());
                }
                if (StringUtils.isNotEmpty((CharSequence)value.getReimburseTaxAmount()) && StringUtils.isNotEmpty((CharSequence)value.getReimburseTaxRate())) {
                    value.setReimburseAmount(new BigDecimal(value.getReimburseTaxAmount()).divide(BigDecimal.ONE.add(new BigDecimal(value.getReimburseTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP)), 6, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP).toPlainString());
                }
                if (StringUtils.isNotEmpty((CharSequence)value.getReimburseAmount()) && StringUtils.isNotEmpty((CharSequence)value.getReimburseTaxRate())) {
                    value.setTaxQuota(new BigDecimal(value.getReimburseAmount()).multiply(new BigDecimal(value.getReimburseTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP)).setScale(2, RoundingMode.HALF_UP).toPlainString());
                }
                if ((accountSubjectVo = (AccountSubjectVo)accountSubjectVoMap.get(value.getReimburseItem())) == null) {
                    value.setReimburseItem(null);
                } else {
                    value.setReimburseItemName(accountSubjectVo.getAccountSubjectName());
                }
                value.setIsSpecialTicket(YesOrNoEnum.getByValue((String)value.getIsSpecialTicket()));
                CostCenterVo costCenterVo = (CostCenterVo)costCenterVoMap.get(value.getCostCenter());
                if (costCenterVo != null) {
                    value.setCostCenterName(costCenterVo.getCostCenterName());
                    value.setProfitCenter(costCenterVo.getProfitCenterCode());
                    value.setProfitCenterName(costCenterVo.getProfitCenterName());
                } else {
                    value.setCostCenter(null);
                }
                value.setIsPushSap(YesOrNoEnum.getByValue((String)value.getIsPushSap()));
                value.setHeadFeeAmount(null);
                value.setDepartmentFeeAmount(null);
                value.setIntraCompanyAmount(null);
                value.setOffPointAmount(null);
                value.setEndCaseHeadFeeAmount(null);
                value.setEndCaseDepartmentFeeAmount(null);
                value.setEndCaseCustomerFeeAmount(null);
                value.setEndCaseIntraCompanyAmount(null);
                value.setEndCaseOffPointAmount(null);
                AuditCustomerDetailCollectionDto auditCustomerDetailCollectionDto = new AuditCustomerDetailCollectionDto();
                BeanUtils.copyProperties((Object)value, (Object)auditCustomerDetailCollectionDto);
                String invoiceCode = auditCustomerDetailCollectionDto.getInvoiceCode();
                String invoiceNumber = auditCustomerDetailCollectionDto.getInvoiceNumber();
                if (StringUtils.isNotBlank((CharSequence)invoiceCode) && StringUtils.isNotBlank((CharSequence)invoiceNumber)) {
                    List<String> invoiceSplit = Arrays.asList(invoiceCode.split(","));
                    List<String> split = Arrays.asList(invoiceNumber.split(","));
                    int length = invoiceSplit.size();
                    if (length != split.size()) {
                        errMgsLit.add("\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u7801\u6570\u91cf\u4e0d\u80fd\u5339\u914d");
                    }
                    ArrayList<AuditInvoiceManageDto> invoiceManageDtos = new ArrayList<AuditInvoiceManageDto>();
                    for (int j = 0; j < length; ++j) {
                        AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
                        String code = invoiceSplit.get(j);
                        String no = split.get(j);
                        if (StringUtils.isNotBlank((CharSequence)code) && code.equals("0")) {
                            auditInvoiceManageDto.setInvoiceCode(null);
                        } else {
                            auditInvoiceManageDto.setInvoiceCode(code);
                        }
                        auditInvoiceManageDto.setInvoiceNo(no);
                        invoiceManageDtos.add(auditInvoiceManageDto);
                    }
                    List auditInvoiceItemVos = this.auditInvoiceManageService.findByInvoiceNoCode(invoiceManageDtos);
                    if (CollectionUtils.isEmpty((Collection)auditInvoiceItemVos)) {
                        errMgsLit.add("\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u7801\u5b58\u5728\u4e0d\u80fd\u5339\u914d\u53d1\u7968\u7ba1\u7406\u6570\u636e");
                    }
                    List auditInvoiceVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditInvoiceItemVos, AuditInvoiceItemVo.class, AuditInvoiceVo.class, HashSet.class, ArrayList.class, new String[0]);
                    String activityDetailCode = value.getActivityDetailCode();
                    auditInvoiceVos.forEach(ai -> ai.setActivityDetailCode(activityDetailCode));
                    auditCustomerDetailCollectionDto.setAuditInvoiceFinalCache(auditInvoiceVos);
                    auditCustomerDetailCollectionDto.setInvoiceCode(invoiceCode);
                    auditCustomerDetailCollectionDto.setInvoiceNumber(invoiceNumber);
                } else {
                    if (StringUtils.isNotBlank((CharSequence)invoiceCode) && StringUtils.isBlank((CharSequence)invoiceNumber)) {
                        errMgsLit.add("\u586b\u5199\u4e86\u53d1\u7968\u4ee3\u7801,\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isNotBlank((CharSequence)invoiceNumber) && StringUtils.isBlank((CharSequence)invoiceCode)) {
                        errMgsLit.add("\u586b\u5199\u4e86\u53d1\u7968\u53f7\u7801\uff0c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                auditCustomerDetailCollectionDto.setDiscountTaxAmount(new BigDecimal(value.getDiscountTaxAmount()));
                auditCustomerDetailCollectionDto.setDiscountAmount(new BigDecimal(value.getDiscountAmount()));
                auditCustomerDetailCollectionDto.setDiscountTaxDeduction(new BigDecimal(value.getDiscountTaxDeduction()));
                auditCustomerDetailCollectionDto.setReimburseTaxAmount(new BigDecimal(value.getReimburseTaxAmount()));
                auditCustomerDetailCollectionDto.setReimburseAmount(new BigDecimal(value.getReimburseAmount()));
                auditCustomerDetailCollectionDto.setTaxQuota(new BigDecimal(value.getTaxQuota()));
                auditCustomerDetailCollectionDto.setIndividualIncomeTax(new BigDecimal(value.getIndividualIncomeTax()));
                auditCustomerDetailCollectionDtoList.add(auditCustomerDetailCollectionDto);
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (StringUtils.isEmpty((CharSequence)message)) {
                    message = "\u7a7a\u6307\u9488!";
                }
                errMgsLit.add(message);
                errMap.put((Integer)index, String.join((CharSequence)",", errMgsLit));
            }
        });
        return auditCustomerDetailCollectionDtoList;
    }

    public Class<CustomerAuditDetailColImportsVo> findCrmExcelVoClass() {
        return CustomerAuditDetailColImportsVo.class;
    }

    public String getTemplateCode() {
        return "customer_audit_detail_col_import";
    }

    public String getTemplateName() {
        return "\u5ba2\u6237\u6838\u9500\u660e\u7ec6\u5f52\u96c6\u5bfc\u5165";
    }
}

