/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.imports;

import cn.hutool.json.JSONUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailDiscountImportsVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerAuditDetailDiscountImportsProcess
implements ImportProcess<CustomerAuditDetailDiscountImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(CustomerAuditDetailDiscountImportsProcess.class);
    @Autowired(required=false)
    private AuditService auditService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, CustomerAuditDetailDiscountImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.info("\u6838\u9500\u5bfc\u5165\u53c2\u6570++++++:[{}],[{}]", params, (Object)JSONUtil.toJsonStr(data.values()));
        String cacheKey = this.getCacheKey(params);
        IAudit audit = this.auditService.getAudit(null);
        try {
            if (data.values() == null || data.values().isEmpty()) {
                throw new IllegalArgumentException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
            }
            ArrayList importsVoList = Lists.newArrayList(data.values());
            audit.discountAdjustImport(cacheKey, (List)importsVoList);
        }
        catch (Exception e) {
            log.error("\u6838\u9500\u5f52\u96c6\u5bfc\u5165\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        return null;
    }

    private String getBusinessUnitCode(Map<String, Object> params) {
        Object businessUnitCode = params.get("businessUnitCode");
        return (String)businessUnitCode;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58\u53ef\u4ee5\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    public Class<CustomerAuditDetailDiscountImportsVo> findCrmExcelVoClass() {
        return CustomerAuditDetailDiscountImportsVo.class;
    }

    public String getTemplateCode() {
        return "customer_audit_detail_discount_import";
    }

    public String getTemplateName() {
        return "\u5ba2\u6237\u6838\u9500\u660e\u7ec6\u6298\u6263\u8c03\u6574\u5bfc\u5165";
    }
}

