/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.imports;

import cn.hutool.json.JSONUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditImportService;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailImportsVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Component
public class CustomerAuditDetailImportsProcess
implements ImportProcess<CustomerAuditDetailImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(CustomerAuditDetailImportsProcess.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private AuditImportService auditImportService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, CustomerAuditDetailImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String uuidkey = UuidCrmUtil.general() + ":" + df.format(new Date());
        log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165,key:{}\u53c2\u6570++++++:[{}],[{}]", new Object[]{uuidkey, params, JSONUtil.toJsonStr(data.values())});
        String cacheKey = this.getCacheKey(params);
        String companyCode = this.getCompanyCode(params);
        String businessUnitCode = this.getBusinessUnitCode(params);
        AuditDto auditDto = new AuditDto();
        auditDto.setUuidkey(uuidkey);
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit audit = this.auditService.getAudit(auditDto);
        auditDto.setBusinessUnitCode(businessUnitCode);
        auditDto.setCacheKey(cacheKey);
        log.info("\u5bfc\u5165\u7f13\u5b58key{" + cacheKey + "}");
        auditDto.setCompanyCode(companyCode);
        HashMap errorMap = Maps.newHashMap();
        try {
            if (data.values() == null || data.values().isEmpty()) {
                throw new IllegalArgumentException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
            }
            log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165\u9a8c\u8bc1\u5f00\u59cb,uuidkey:{}", (Object)uuidkey);
            List result = this.auditImportService.validate2(data, auditDto, (Map)errorMap);
            log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165\u9a8c\u8bc1\u7ed3\u675f,uuidkey:{}", (Object)uuidkey);
            log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165\uff0cuuidkey:{},errorMap.size:{},errorMap.values:{}", new Object[]{uuidkey, errorMap.size(), JsonUtils.obj2JsonString(errorMap.values())});
            if (0 == errorMap.size()) {
                log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165\u5f00\u59cb\u6267\u884c\u5bfc\u5165\u65b9\u6cd5\u8bba,uuidkey:{}", (Object)uuidkey);
                auditDto.setAuditCustomerDetailList(result);
                auditDto.setIsCollection(Boolean.valueOf(true));
                StopWatch stopWatch2 = new StopWatch();
                stopWatch2.start();
                audit.customerImport(auditDto);
                stopWatch2.stop();
                log.info("\u7ed3\u6848\u6838\u9500\u5bfc\u5165\u653e\u5165\u7f13\u5b58\uff0c\u672c\u6b21\u8017\u65f6\uff1a" + DateUtil.millisecondToStr((long)stopWatch2.getLastTaskTimeMillis()));
            }
        }
        catch (Exception e) {
            log.error("\u6838\u9500\u5f52\u96c6\u5bfc\u5165\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165\u6210\u529f,uuidkey:{}", (Object)uuidkey);
        return errorMap;
    }

    private String getCompanyCode(Map<String, Object> params) {
        Object companyCode = params.get("companyCode");
        return (String)companyCode;
    }

    private String getBusinessUnitCode(Map<String, Object> params) {
        Object businessUnitCode = params.get("businessUnitCode");
        return (String)businessUnitCode;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58\u53ef\u4ee5\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    public Class<CustomerAuditDetailImportsVo> findCrmExcelVoClass() {
        return CustomerAuditDetailImportsVo.class;
    }

    public String getTemplateCode() {
        return "customer_audit_detail_import";
    }

    public String getTemplateName() {
        return "\u5ba2\u6237\u6838\u9500\u660e\u7ec6\u5bfc\u5165";
    }
}

