/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.imports;

import cn.hutool.json.JSONUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditImportService;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.EcCustomerAuditDetailImportsVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.util.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EcCustomerAuditDetailImportsProcess
implements ImportProcess<EcCustomerAuditDetailImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(EcCustomerAuditDetailImportsProcess.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private AuditImportService auditImportService;

    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    public Map<Integer, String> execute(LinkedHashMap<Integer, EcCustomerAuditDetailImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.info("\u7535\u5546\u7ed3\u6848\u6838\u9500\u5bfc\u5165+++++++++++++++++++++++++++++++++++++++");
        log.info("\u6838\u9500\u5bfc\u5165\u53c2\u6570++++++:[{}],[{}]", params, (Object)JSONUtil.toJsonStr(data.values()));
        String cacheKey = this.getCacheKey(params);
        String companyCode = this.getCompanyCode(params);
        String businessUnitCode = this.getBusinessUnitCode(params);
        String whetherSpeciallyApproved = this.getWhetherSpeciallyApproved(params);
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit audit = this.auditService.getAudit(auditDto);
        auditDto.setBusinessUnitCode(businessUnitCode);
        auditDto.setCacheKey(cacheKey);
        auditDto.setCompanyCode(companyCode);
        auditDto.setWhetherSpeciallyApproved(whetherSpeciallyApproved);
        try {
            if (data.values() == null || data.values().isEmpty()) {
                throw new IllegalArgumentException("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
            }
            ArrayList importsVoList = Lists.newArrayList(data.values());
            List result = this.auditImportService.ecValidate((List)importsVoList, auditDto);
            auditDto.setAuditCustomerDetailList(result);
            auditDto.setIsCollection(Boolean.valueOf(true));
            audit.customerImport(auditDto);
        }
        catch (Exception e) {
            log.error("\u7535\u5546\u6838\u9500\u5f52\u96c6\u5bfc\u5165\u5f02\u5e38\u4fe1\u606f", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        log.info("\u7535\u5546\u7ed3\u6848\u6838\u9500\u5bfc\u5165-----------------------------------");
        return null;
    }

    private String getWhetherSpeciallyApproved(Map<String, Object> params) {
        Object whetherSpeciallyApproved = params.get("whetherSpeciallyApproved");
        return (String)whetherSpeciallyApproved;
    }

    private String getCompanyCode(Map<String, Object> params) {
        Object companyCode = params.get("companyCode");
        return (String)companyCode;
    }

    private String getBusinessUnitCode(Map<String, Object> params) {
        Object businessUnitCode = params.get("businessUnitCode");
        return (String)businessUnitCode;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58\u53ef\u4ee5\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    public Class<EcCustomerAuditDetailImportsVo> findCrmExcelVoClass() {
        return EcCustomerAuditDetailImportsVo.class;
    }

    public String getTemplateCode() {
        return "ec_customer_audit_detail_import";
    }

    public String getTemplateName() {
        return "\u5ba2\u6237\u6838\u9500\u660e\u7ec6\u5bfc\u5165";
    }
}

