/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.imports;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditSupplierDetailDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.SupplierAuditDetailImportsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SupplierAuditDetailImportsProcess
implements ImportProcess<SupplierAuditDetailImportsVo> {
    private static final Logger log = LoggerFactory.getLogger(SupplierAuditDetailImportsProcess.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private AccountSubjectService accountSubjectService;
    @Autowired(required=false)
    private CostCenterVoService costCenterVoService;

    public Map<Integer, String> execute(LinkedHashMap<Integer, SupplierAuditDetailImportsVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        String cacheKey = this.getCacheKey(params);
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit audit = this.auditService.getAudit(auditDto);
        auditDto.setCacheKey(cacheKey);
        HashMap<Integer, String> errorMap = new HashMap<Integer, String>();
        List<AuditSupplierDetailDto> result = this.validate(data, errorMap);
        if (CollectionUtils.isEmpty(errorMap.keySet())) {
            auditDto.setAuditSupplierDetailDtoList(result);
            audit.supplierImport(auditDto);
        }
        return errorMap;
    }

    private Map<String, CostCenterVo> queryCostCenter(Collection<SupplierAuditDetailImportsVo> importsVoList) {
        Map<Object, Object> costCenterVoMap = Maps.newHashMap();
        if (CollUtil.isEmpty(importsVoList)) {
            return costCenterVoMap;
        }
        List costCenterList = importsVoList.stream().map(SupplierAuditDetailImportsVo::getCostCenter).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costCenterList)) {
            List costCenterVoList = this.costCenterVoService.findByCodeList(costCenterList);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(costCenterList) || costCenterList.size() < 1) {
                return costCenterVoMap;
            }
            costCenterVoMap = costCenterVoList.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode, Function.identity(), (a, b) -> a));
        }
        return costCenterVoMap;
    }

    private List<AuditSupplierDetailDto> validate(LinkedHashMap<Integer, SupplierAuditDetailImportsVo> data, Map<Integer, String> errorMap) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(data.values()), (String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        List payWayList = this.dictDataVoService.findByDictTypeCode("tpm_pay_type");
        Map<Object, Object> payWayMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)payWayList)) {
            payWayMap = payWayList.stream().collect(Collectors.toMap(DictDataVo::getDictValue, Function.identity()));
        }
        Map<String, AccountSubjectVo> accountSubjectVoMap = this.accountSubjectInfoToMap(data.values());
        Map<String, CostCenterVo> costCenterVoMap = this.queryCostCenter(data.values());
        ArrayList<AuditSupplierDetailDto> auditSupplierDetailDtos = new ArrayList<AuditSupplierDetailDto>();
        Map<Object, Object> finalPayWayMap = payWayMap;
        data.forEach((index, value) -> {
            AuditSupplierDetailDto auditSupplierDetailDto = new AuditSupplierDetailDto();
            auditSupplierDetailDto.setId(value.getId());
            ArrayList<String> errorList = new ArrayList<String>();
            if (StringUtils.isNotEmpty((CharSequence)value.getThisEndCaseTaxAmount()) && this.paramsVaild(value.getThisEndCaseTaxAmount(), "\u672c\u6b21\u7ed3\u6848\u91d1\u989d\uff08\u542b\u7a0e\uff09", true, errorList)) {
                auditSupplierDetailDto.setThisEndCaseTaxAmount(new BigDecimal(value.getThisEndCaseTaxAmount()));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getTaxRate()) && this.paramsVaild(value.getTaxRate(), "\u7a0e\u7387", true, errorList)) {
                auditSupplierDetailDto.setTaxRate(value.getTaxRate());
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getWholeAudit()) && this.isYesOrNo(value.getWholeAudit(), "\u662f\u5426\u5b8c\u5168\u7ed3\u6848", errorList)) {
                auditSupplierDetailDto.setWholeAudit(this.alphabeticCharacter(value.getWholeAudit()));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getPayWayCode())) {
                DictDataVo dictDataVo = (DictDataVo)finalPayWayMap.get(value.getPayWayCode());
                if (dictDataVo == null) {
                    errorList.add("\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u6b63\u786e");
                } else {
                    auditSupplierDetailDto.setPayWayCode(dictDataVo.getDictCode());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getReimburseItem())) {
                AccountSubjectVo accountSubjectVo = (AccountSubjectVo)accountSubjectVoMap.get(value.getReimburseItem());
                if (accountSubjectVo == null) {
                    errorList.add("\u62a5\u9500\u9879\u76ee\u4e0d\u6b63\u786e");
                } else {
                    auditSupplierDetailDto.setReimburseItem(value.getReimburseItem());
                    auditSupplierDetailDto.setReimburseItemName(accountSubjectVo.getAccountSubjectName());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getCostCenter())) {
                CostCenterVo costCenterVo = (CostCenterVo)costCenterVoMap.get(value.getCostCenter());
                if (ObjectUtil.isNotNull((Object)costCenterVo)) {
                    auditSupplierDetailDto.setCostCenter(costCenterVo.getCostCenterCode());
                    auditSupplierDetailDto.setCostCenterName(costCenterVo.getCostCenterName());
                    auditSupplierDetailDto.setProfitCenter(costCenterVo.getProfitCenterCode());
                    auditSupplierDetailDto.setProfitCenterName(costCenterVo.getProfitCenterName());
                } else {
                    errorList.add("\u6210\u672c\u4e2d\u5fc3[" + value.getCostCenter() + "]\u586b\u5199\u6709\u8bef!");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getDeemedSale()) && this.isYesOrNo(value.getDeemedSale(), "\u89c6\u540c\u9500\u552e", errorList)) {
                auditSupplierDetailDto.setDeemedSale(this.alphabeticCharacter(value.getDeemedSale()));
            }
            if (StringUtils.isNotEmpty((CharSequence)value.getIsPushSap()) && this.isYesOrNo(value.getIsPushSap(), "\u662f\u5426\u4e0a\u5e10", errorList)) {
                auditSupplierDetailDto.setIsPushSap(this.alphabeticCharacter(value.getIsPushSap()));
            }
        });
        return auditSupplierDetailDtos;
    }

    private Map<String, AccountSubjectVo> accountSubjectInfoToMap(Collection<SupplierAuditDetailImportsVo> importsVoList) throws IllegalArgumentException {
        List accountSubjectVoList;
        List codes = null;
        try {
            codes = importsVoList.stream().filter(detailImport -> StringUtils.isNotEmpty((CharSequence)detailImport.getReimburseItem())).map(SupplierAuditDetailImportsVo::getReimburseItem).distinct().collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u83b7\u53d6\u79d1\u76ee\u5f02\u5e38:" + e.getMessage());
        }
        Map<Object, Object> accountSubjectMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(codes) && codes.size() > 0 && !com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)(accountSubjectVoList = this.accountSubjectService.findListByCode(codes)))) {
            accountSubjectMap = accountSubjectVoList.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode, Function.identity(), (s1, s2) -> s2));
        }
        return accountSubjectMap;
    }

    private boolean isYesOrNo(String params, String message, List<String> errorList) {
        if (!"\u662f".equals(params) && !"\u5426".equals(params)) {
            errorList.add(message + "\u5fc5\u987b\u586b\u5199\u662f\u6216\u8005\u5426");
            return false;
        }
        return true;
    }

    private String alphabeticCharacter(String letter) {
        return letter.equals("\u662f") ? "Y" : "N";
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        liquibase.util.Validate.notNull((Object)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a");
        return (String)cacheKey;
    }

    private boolean paramsVaild(String param, String message, boolean verifyDecimals, List<String> errorMsgList) {
        boolean pass = true;
        if (!SupplierAuditDetailImportsProcess.isValidNumber(param)) {
            errorMsgList.add(message + "\u8f93\u5165\u6709\u8bef");
            pass = false;
        }
        if (!this.isValidDecimals(param) && verifyDecimals) {
            errorMsgList.add(message + "\u53ea\u80fd\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570");
            pass = false;
        }
        return pass;
    }

    private static boolean isValidNumber(String str) {
        String reg = "^-?[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }

    private boolean isValidDecimals(String str) {
        String reg = "^(\\-)?[0-9]+(\\.[0-9]{0,2})?$";
        return str.matches(reg);
    }

    public Class<SupplierAuditDetailImportsVo> findCrmExcelVoClass() {
        return SupplierAuditDetailImportsVo.class;
    }

    public String getTemplateCode() {
        return "supplier_audit_detail_import";
    }

    public String getTemplateName() {
        return "\u4f9b\u5e94\u5546\u6838\u9500\u660e\u7ec6\u5bfc\u5165";
    }
}

