/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.listener;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.audit.local.listener.UpAccountApportionEvent;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
public class UpAccountApportionListener {
    private static final Logger log = LoggerFactory.getLogger(UpAccountApportionListener.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Async
    @TransactionalEventListener(classes={UpAccountApportionEvent.class})
    public void onUpAccountApportion(UpAccountApportionEvent event) {
        log.info("\u7ed3\u6848\u6838\u9500\u4e0a\u8d26\u5206\u644a\u5f00\u59cb+++++++++++++++++++++++++++++++");
        String auditCode = "";
        try {
            Thread.sleep(2000L);
            this.loginUserService.refreshAuthentication((Object)event.getLoginUser());
            AuditDto dto = event.getAuditDto();
            auditCode = dto.getAuditCode();
            log.info("\u7ed3\u6848\u6838\u9500\u4e0a\u8d26\u5206\u644a\u6838\u9500\u7f16\u7801[{}]", (Object)dto.getAuditCode());
            IAudit thisAudit = this.auditService.getAudit(dto);
            thisAudit.upAccountApportion(dto);
            log.info("\u7ed3\u6848\u6838\u9500\u4e0a\u8d26\u5206\u644a\u7ed3\u675f\u6838\u9500\u7f16\u7801[{}]", (Object)dto.getAuditCode());
        }
        catch (Exception e) {
            log.error("\u7ed3\u6848\u6838\u9500\u4e0a\u8d26\u5206\u644a\u5931\u8d25\u6838\u9500\u7f16\u7801[{}]", (Object)auditCode);
            log.error("", (Throwable)e);
        }
    }
}

