/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.local.entity.AuditAutoConfiguration;
import com.biz.crm.tpm.business.audit.local.mapper.AuditAutoConfigurationMapper;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditAutoConfigurationDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditAutoConfigurationVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditAutoConfigurationRepository
extends ServiceImpl<AuditAutoConfigurationMapper, AuditAutoConfiguration> {
    public Page<AuditAutoConfigurationVo> findConfigurationPage(Pageable pageable, AuditAutoConfigurationDto configuration) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditAutoConfigurationVo> configurationPage = ((AuditAutoConfigurationMapper)this.baseMapper).findConfigurationPage((Page<AuditAutoConfigurationVo>)page, configuration);
        List records = configurationPage.getRecords();
        if (CollUtil.isNotEmpty((Collection)records)) {
            records.forEach(item -> {
                String endCaseForm = item.getEndCaseForm();
                if (CharSequenceUtil.isNotEmpty((CharSequence)endCaseForm)) {
                    item.setEndCaseFormList(Stream.of(endCaseForm.split(",")).collect(Collectors.toList()));
                }
            });
        }
        configurationPage.setRecords(records);
        return configurationPage;
    }

    public AuditAutoConfigurationVo getConfigurationById(String id) {
        AuditAutoConfiguration auditAutoConfiguration = (AuditAutoConfiguration)((Object)((AuditAutoConfigurationMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        AuditAutoConfigurationVo auditAutoConfigurationVo = new AuditAutoConfigurationVo();
        if (ObjectUtil.isNotNull((Object)((Object)auditAutoConfiguration))) {
            BeanUtils.copyProperties((Object)((Object)auditAutoConfiguration), (Object)auditAutoConfigurationVo);
        }
        return auditAutoConfigurationVo;
    }

    public void configurationCreateOrModify(AuditAutoConfiguration createOrUpdateConfiguration, Boolean insertFlag) {
        if (insertFlag.booleanValue()) {
            ((AuditAutoConfigurationMapper)this.baseMapper).insert((Object)createOrUpdateConfiguration);
        } else {
            ((AuditAutoConfigurationMapper)this.baseMapper).updateById((Object)createOrUpdateConfiguration);
        }
    }

    public void deleteConfiguration(String id) {
        ((AuditAutoConfigurationMapper)this.baseMapper).deleteBatchIds(Arrays.asList(id.split(",")));
    }

    public List<AuditAutoConfiguration> findAutoConfigurationByDate(String autoAudit) {
        return ((AuditAutoConfigurationMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(AuditAutoConfiguration.class).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(StringUtils.isNotBlank((CharSequence)autoAudit), AuditAutoConfiguration::getAutoAudit, (Object)autoAudit));
    }
}

