/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollectionExtend;
import com.biz.crm.tpm.business.audit.local.mapper.AuditCustomerDetailCollectionExtendMapper;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceDto;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditCustomerDetailCollectionExtendRepository
extends ServiceImpl<AuditCustomerDetailCollectionExtendMapper, AuditCustomerDetailCollectionExtend> {
    public List<AuditCustomerDetailCollectionExtend> findByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetailCollectionExtend::getAuditCode, (Object)auditCode)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    public List<AuditCustomerDetailCollectionExtend> findByAuditDetailCodes(List<String> auditDetailCodes) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditCustomerDetailCollectionExtend::getAuditDetailCode, auditDetailCodes)).list();
    }

    public List<AuditCustomerDetailCollectionExtend> findByRedOrderOffsetNo(String redOrderNo) {
        if (StringUtils.isEmpty((CharSequence)redOrderNo)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetailCollectionExtend::getRedOrderOffsetNo, (Object)redOrderNo)).list();
    }

    public List<AuditCustomerDetailCollectionExtend> updateRedInvoiceOffsetStatus(AuditRedInvoiceDto redInvoiceDto) {
        if (StringUtils.isNotEmpty((CharSequence)redInvoiceDto.getRedOrderOffsetNo()) && StringUtils.isNotEmpty((CharSequence)redInvoiceDto.getMassageCode())) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetailCollectionExtend::getRedOrderOffsetNo, (Object)redInvoiceDto.getRedOrderOffsetNo())).list();
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Lists.newArrayList();
            }
            ArrayList<AuditCustomerDetailCollectionExtend> updateExtends = new ArrayList<AuditCustomerDetailCollectionExtend>();
            for (AuditCustomerDetailCollectionExtend extend : list) {
                AuditCustomerDetailCollectionExtend updateExtend = new AuditCustomerDetailCollectionExtend();
                updateExtend.setId(extend.getId());
                updateExtend.setRedOrderOffsetNo(redInvoiceDto.getMassageCode());
                updateExtends.add(updateExtend);
            }
            if (!CollectionUtils.isEmpty(updateExtends)) {
                this.updateBatchById(updateExtends);
            }
            return list;
        }
        return Lists.newArrayList();
    }
}

