/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollection;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollectionExtend;
import com.biz.crm.tpm.business.audit.local.mapper.AuditCustomerDetailCollectionExtendMapper;
import com.biz.crm.tpm.business.audit.local.mapper.AuditCustomerDetailCollectionMapper;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionExtendRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditRepository;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditFindDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditTotalReimburseTaxAmountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditCustomerDetailCollectionRepository
extends ServiceImpl<AuditCustomerDetailCollectionMapper, AuditCustomerDetailCollection> {
    @Autowired
    private AuditCustomerDetailCollectionMapper auditCustomerDetailCollectionMapper;
    @Autowired(required=false)
    private AuditCustomerDetailCollectionExtendMapper auditCustomerDetailCollectionExtendMapper;
    @Autowired
    private AuditRepository auditRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditCustomerDetailCollectionExtendRepository auditCustomerDetailCollectionExtendRepository;

    public Page<AuditCustomerDetailCollection> findByConditions(Pageable pageable, AuditCustomerDetailCollection auditDetailCollection) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditCustomerDetailCollection> pageList = this.auditCustomerDetailCollectionMapper.findByConditions((Page<AuditCustomerDetailCollection>)page, auditDetailCollection);
        return pageList;
    }

    public Page<AuditCustomerDetailCollectionVo> auditDetail(Pageable pageable, AuditCustomerDetailCollectionDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditCustomerDetailCollectionVo> pageList = this.auditCustomerDetailCollectionMapper.auditDetail((Page<AuditCustomerDetailCollectionVo>)page, dto);
        return pageList;
    }

    public Page<AuditCustomerDetailCollectionVo> auditUpAccountDetail(Pageable pageable, AuditCustomerDetailCollectionDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditCustomerDetailCollectionVo> pageList = this.auditCustomerDetailCollectionMapper.auditUpAccountDetail((Page<AuditCustomerDetailCollectionVo>)page, dto);
        return pageList;
    }

    public List<AuditCustomerDetailCollectionVo> auditDetail(AuditCustomerDetailCollectionDto dto) {
        if (!StringUtils.isNotEmpty((CharSequence)dto.getActivityBeginTimeYearMonthStr())) {
            Validate.notNull((Object)dto.getActivityBeginTime(), (String)"\u8303\u56f4\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getActivityEndTime(), (String)"\u8303\u56f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        return this.auditCustomerDetailCollectionMapper.findAuditDetail(dto, TenantUtils.getTenantCode());
    }

    public List<String> auditDetailCustomerList(AuditCustomerDetailCollectionDto dto) {
        if (!StringUtils.isNotEmpty((CharSequence)dto.getActivityBeginTimeYearMonthStr())) {
            Validate.notNull((Object)dto.getActivityBeginTime(), (String)"\u8303\u56f4\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getActivityEndTime(), (String)"\u8303\u56f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        List<String> detailCollections = this.auditCustomerDetailCollectionMapper.auditDetailCustomerList(dto, TenantUtils.getTenantCode());
        return detailCollections;
    }

    public List<String> auditDetailEndCaseCustomerList(AuditCustomerDetailCollectionDto dto) {
        if (!StringUtils.isNotEmpty((CharSequence)dto.getActivityBeginTimeYearMonthStr())) {
            Validate.notNull((Object)dto.getActivityBeginTime(), (String)"\u8303\u56f4\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)dto.getActivityEndTime(), (String)"\u8303\u56f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        List<String> detailCollections = this.auditCustomerDetailCollectionMapper.auditDetailEndCaseCustomerList(dto, TenantUtils.getTenantCode());
        return detailCollections;
    }

    public List<AuditCustomerDetailCollection> findAuditCustomerDetailCollectionByDetailPlanItemCodeList(List<String> detailItemCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditCustomerDetailCollection::getActivityDetailCode, detailItemCodeList)).list();
    }

    public List<AuditCustomerDetailCollection> findByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetailCollection::getAuditCode, (Object)auditCode)).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List<AuditCustomerDetailCollectionExtend> extendList = this.auditCustomerDetailCollectionExtendRepository.findByAuditCode(auditCode);
            Map collect = extendList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
            list.forEach(item -> {
                AuditCustomerDetailCollectionExtend auditCustomerDetailCollectionExtend = (AuditCustomerDetailCollectionExtend)((Object)((Object)collect.get(item.getId())));
                if (auditCustomerDetailCollectionExtend != null) {
                    BeanUtils.copyProperties((Object)((Object)auditCustomerDetailCollectionExtend), (Object)item);
                }
            });
        }
        return list;
    }

    public BigDecimal findAuditAmountForVariable(AuditCustomerDetailCollectionDto dto) {
        return this.auditCustomerDetailCollectionMapper.findAuditAmountForVariable(dto);
    }

    public List<AuditCustomerDetailCollectionVo> findByActivityDetailCodes(Set<String> activityDetailCodes) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditCustomerDetailCollection::getActivityDetailCode, activityDetailCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection auditCustomerDetailCollectionVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditCustomerDetailCollection.class, AuditCustomerDetailCollectionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditCustomerDetailCollectionVos;
    }

    public List<AuditCustomerDetailCollection> findDetailByAuditCode(String auditCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditCustomerDetailCollection::getAuditCode, (Object)auditCode)).list();
    }

    public List<AuditCustomerDetailCollection> findByCodes(List<String> codeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(AuditCustomerDetailCollection::getActivityDetailCode, codeList)).list();
    }

    public List<AuditCustomerDetailCollectionVo> findByDetailPlanItemCodes(Set<String> itemCodes, Set<String> codeList) {
        return this.auditCustomerDetailCollectionMapper.findByDetailPlanItemCodes(itemCodes, codeList, TenantUtils.getTenantCode());
    }

    public List<AuditCustomerDetailCollection> findByAuditCodes(Set<String> set) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(AuditCustomerDetailCollection::getAuditCode, set)).list();
    }

    public List<AuditCustomerDetailCollection> findByAuditCodeAndAuditDetailCode(String auditCode, List<String> auditDetailCodes, boolean notEmpty) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditCustomerDetailCollection::getAuditCode, (Object)auditCode)).in(notEmpty, AuditCustomerDetailCollection::getAuditDetailCode, auditDetailCodes)).list();
    }

    public List<AuditCustomerDetailCollection> findByAuditDetailCodes(List<String> auditDetailCodeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditCustomerDetailCollection::getAuditDetailCode, auditDetailCodeList)).list();
    }

    public List<AuditCustomerDetailCollection> findDetailCodesByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return new ArrayList<AuditCustomerDetailCollection>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditCustomerDetailCollection::getAuditCode, (Object)auditCode)).list();
    }

    public void updateWholeAudit(AuditDto dto) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditCustomerDetailCollection::getAuditCode, (Object)dto.getAuditCode())).set(AuditCustomerDetailCollection::getWholeAudit, (Object)YesOrNoEnum.NO.getCode())).update();
    }

    public void updateByConditions(List<AuditCustomerDetailCollection> customerDetailCollections) {
        if (CollectionUtils.isEmpty(customerDetailCollections)) {
            return;
        }
        this.auditCustomerDetailCollectionMapper.updateByConditions(customerDetailCollections);
        customerDetailCollections = customerDetailCollections.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getRedOrderOffsetNo())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerDetailCollections)) {
            List auditCustomerDetailCollectionExtends = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerDetailCollections, AuditCustomerDetailCollection.class, AuditCustomerDetailCollectionExtend.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.auditCustomerDetailCollectionExtendMapper.updateByConditions(auditCustomerDetailCollectionExtends);
        }
    }

    public void updateRedInvoiceStatus(AuditRedInvoiceDto redInvoiceDto) {
        if (StringUtils.isNotBlank((CharSequence)redInvoiceDto.getRedOrderNo()) && StringUtils.isNotBlank((CharSequence)redInvoiceDto.getRedOrderCreateStatus())) {
            this.auditCustomerDetailCollectionMapper.updateRedInvoiceStatus(redInvoiceDto);
        }
    }

    public Page<AuditCustomerDetailCollectionVo> findDetailByConditions(Pageable pageable, AuditFindDetailDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditCustomerDetailCollectionMapper.findDetailByConditions((Page<AuditCustomerDetailCollectionVo>)page, dto, TenantUtils.getTenantCode());
    }

    public List<AuditTotalReimburseTaxAmountVo> findAuditVoListByCondition(AuditQueryDto dto) {
        return this.auditCustomerDetailCollectionMapper.findAuditVoListByCondition(dto, TenantUtils.getTenantCode());
    }

    public List<AuditCustomerDetailCollectionVo> findDetailByActivityDetailCodeList(AuditFindDetailDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getActivityCodeList()) && CollectionUtils.isEmpty((Collection)dto.getActivityDetailCodeList())) {
            return Collections.emptyList();
        }
        return this.auditCustomerDetailCollectionMapper.findDetailByActivityDetailCodeList(dto, TenantUtils.getTenantCode());
    }

    public void updateDiffAmountByAuditDetailCode(String auditDetailCode, BigDecimal diffAmount) {
        if (StringUtils.isNotEmpty((CharSequence)auditDetailCode) && Objects.nonNull(diffAmount)) {
            AuditCustomerDetailCollection detailCollection = (AuditCustomerDetailCollection)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetailCollection::getAuditDetailCode, (Object)auditDetailCode)).one());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditCustomerDetailCollection::getAuditDetailCode, (Object)auditDetailCode)).set(AuditCustomerDetailCollection::getReimburseAmount, (Object)detailCollection.getReimburseAmount().add(diffAmount))).update();
        }
    }

    public boolean saveBatch(Collection<AuditCustomerDetailCollection> entityList) {
        boolean b = super.saveBatch(entityList);
        if (b) {
            Collection auditCustomerDetailCollectionExtends = this.nebulaToolkitService.copyCollectionByWhiteList(entityList, AuditCustomerDetailCollection.class, AuditCustomerDetailCollectionExtend.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.auditCustomerDetailCollectionExtendRepository.saveBatch(auditCustomerDetailCollectionExtends);
        }
        return b;
    }

    public boolean remove(String auditCode) {
        boolean b = super.remove((Wrapper)Wrappers.lambdaUpdate(AuditCustomerDetailCollection.class).eq(AuditCustomerDetailCollection::getAuditCode, (Object)auditCode));
        if (b) {
            this.auditCustomerDetailCollectionExtendRepository.remove((Wrapper)Wrappers.lambdaUpdate(AuditCustomerDetailCollectionExtend.class).eq(AuditCustomerDetailCollectionExtend::getAuditCode, (Object)auditCode));
        }
        return b;
    }

    public boolean remove(List<String> detailCodeList) {
        boolean b = super.remove((Wrapper)Wrappers.lambdaQuery().in(AuditCustomerDetailCollection::getAuditDetailCode, detailCodeList));
        if (b) {
            this.auditCustomerDetailCollectionExtendRepository.remove((Wrapper)Wrappers.lambdaQuery().in(AuditCustomerDetailCollectionExtend::getAuditDetailCode, detailCodeList));
        }
        return b;
    }

    public List<AuditCustomerDetailCollectionVo> findByUpAccountActivityCodes(Set<String> upAccountCodes) {
        if (CollectionUtils.isEmpty(upAccountCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditCustomerDetailCollection::getUpAccountActivityCode, upAccountCodes)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection auditCustomerDetailCollectionVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditCustomerDetailCollection.class, AuditCustomerDetailCollectionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditCustomerDetailCollectionVos;
    }

    public List<AuditCustomerDetailCollection> findByRedOrderNo(String redOrderNo) {
        if (StringUtils.isEmpty((CharSequence)redOrderNo)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetailCollection::getRedOrderNo, (Object)redOrderNo)).list();
    }

    public void updateRedInvoiceStatusById(AuditRedInvoiceDto redInvoiceDto, List<String> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            ArrayList<AuditCustomerDetailCollection> detailCollectionList = new ArrayList<AuditCustomerDetailCollection>();
            for (String id : ids) {
                AuditCustomerDetailCollection detailCollection = new AuditCustomerDetailCollection();
                detailCollection.setId(id);
                detailCollection.setRedOrderCreateStatus(redInvoiceDto.getRedOrderCreateStatus());
                detailCollectionList.add(detailCollection);
            }
            this.updateBatchById(detailCollectionList);
        }
    }
}

