/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetail;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailExtend;
import com.biz.crm.tpm.business.audit.local.mapper.AuditCustomerDetailExtendMapper;
import com.biz.crm.tpm.business.audit.local.mapper.AuditCustomerDetailMapper;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailExtendRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditRepository;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceDto;
import com.biz.crm.tpm.business.audit.sdk.dto.CustomerCostAuditStatisticsDto;
import com.biz.crm.tpm.business.audit.sdk.dto.report.CostPoolAuditReportDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerCostAuditStatisticsItemVo;
import com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditCustomerDetailRepository
extends ServiceImpl<AuditCustomerDetailMapper, AuditCustomerDetail> {
    @Autowired
    private AuditCustomerDetailMapper auditCustomerDetailMapper;
    @Autowired(required=false)
    private AuditCustomerDetailExtendMapper auditCustomerDetailExtendMapper;
    @Autowired(required=false)
    private AuditRepository auditRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditCustomerDetailExtendRepository auditCustomerDetailExtendRepository;

    public Page<AuditCustomerDetail> findByConditions(Pageable pageable, AuditCustomerDetail auditDetail) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditCustomerDetail> pageList = this.auditCustomerDetailMapper.findByConditions((Page<AuditCustomerDetail>)page, auditDetail);
        return pageList;
    }

    public List<CustomerCostAuditStatisticsItemVo> listAuditStatistics(CustomerCostAuditStatisticsDto dto) {
        return this.auditCustomerDetailMapper.listAuditStatistics(dto);
    }

    public List<AuditCustomerDetail> findByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetail::getAuditCode, (Object)auditCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            List<AuditCustomerDetailExtend> extendList = this.auditCustomerDetailExtendRepository.findByAuditCode(auditCode);
            Map collect = extendList.stream().collect(Collectors.toMap(UuidEntity::getId, Function.identity()));
            list.forEach(item -> {
                AuditCustomerDetailExtend auditCustomerDetailExtend = (AuditCustomerDetailExtend)((Object)((Object)collect.get(item.getId())));
                if (auditCustomerDetailExtend != null) {
                    BeanUtils.copyProperties((Object)((Object)auditCustomerDetailExtend), (Object)item);
                }
            });
        }
        return list;
    }

    public List<AuditCustomerDetail> findByCodes(List<String> codeList) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(AuditCustomerDetail::getActivityDetailCode, codeList)).list();
    }

    public List<AuditCustomerDetailVo> findByPlanCodes(Set<String> codeList) {
        return this.auditCustomerDetailMapper.findByPlanCodes(codeList);
    }

    public List<AuditCustomerDetailCollectionVo> findAuditCustomerDetails(AuditCustomerDetailCollectionDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.auditCustomerDetailMapper.findAuditCustomerDetails(dto);
    }

    public AuditCustomerDetail findByAuditDetailCode(String auditDetailCode) {
        if (StringUtils.isEmpty((CharSequence)auditDetailCode)) {
            return null;
        }
        return (AuditCustomerDetail)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetail::getAuditDetailCode, (Object)auditDetailCode)).one());
    }

    public List<AuditCustomerDetail> findByAuditDetailCodeList(List<String> codeList) {
        if (CollUtil.isEmpty(codeList)) {
            return null;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(AuditCustomerDetail::getAuditDetailCode, codeList)).list();
        if (CollUtil.isEmpty((Collection)list)) {
            return null;
        }
        return list;
    }

    public List<AuditCustomerDetail> findDetailByAuditCode(List<String> auditCodes) {
        if (CollUtil.isEmpty(auditCodes)) {
            return null;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditCustomerDetail::getAuditCode, auditCodes)).list();
        if (CollUtil.isEmpty((Collection)list)) {
            return null;
        }
        return list;
    }

    public Set<String> findDetailAutoAudit(String auditCode, Set<String> activityCodeList) {
        List<String> list = this.auditCustomerDetailMapper.findDetailAutoAudit(auditCode, activityCodeList);
        return !CollectionUtils.isEmpty(list) ? new HashSet<String>(list) : new HashSet();
    }

    public List<AuditCustomerDetail> findByAuditCodeAndAuditDetailCode(String auditCode, List<String> auditDetailCodes, boolean notEmpty) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditCustomerDetail::getAuditCode, (Object)auditCode)).in(notEmpty, AuditCustomerDetail::getAuditDetailCode, auditDetailCodes)).list();
    }

    public void updateWholeAudit(AuditDto dto) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditCustomerDetail::getAuditCode, (Object)dto.getAuditCode())).set(AuditCustomerDetail::getWholeAudit, (Object)YesOrNoEnum.NO.getCode())).update();
    }

    public void updateByConditions(List<AuditCustomerDetail> customerDetails) {
        if (CollectionUtils.isEmpty(customerDetails)) {
            return;
        }
        this.auditCustomerDetailMapper.updateByConditions(customerDetails);
        customerDetails = customerDetails.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getRedOrderOffsetNo())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(customerDetails)) {
            List auditCustomerDetailExtends = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerDetails, AuditCustomerDetail.class, AuditCustomerDetailExtend.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.auditCustomerDetailExtendMapper.updateByConditions(auditCustomerDetailExtends);
        }
    }

    public void updateRedInvoiceStatus(AuditRedInvoiceDto redInvoiceDto) {
        if (StringUtils.isNotBlank((CharSequence)redInvoiceDto.getRedOrderNo()) && StringUtils.isNotBlank((CharSequence)redInvoiceDto.getRedOrderCreateStatus())) {
            this.auditCustomerDetailMapper.updateRedInvoiceStatus(redInvoiceDto);
        }
    }

    public List<AuditCustomerDetailVo> findListByDetailPlanCodes(List<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return Lists.newArrayList();
        }
        return ((AuditCustomerDetailMapper)this.getBaseMapper()).findListByDetailPlanCodes(detailPlanCodes);
    }

    public List<String> findProcessDateByActivityDetailCodes(String detailPlanItemCode) {
        if (StringUtils.isEmpty((CharSequence)detailPlanItemCode)) {
            return Lists.newArrayList();
        }
        List<Date> dates = ((AuditCustomerDetailMapper)this.getBaseMapper()).findProcessDateByActivityDetailCodes(detailPlanItemCode);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dates.stream().map(df::format).collect(Collectors.toList());
    }

    public List<AuditCustomerDetailVo> findByActivityDetailCodesExcludeAuditCode(List<String> activityDetailCodes, String auditCode) {
        List<AuditCustomerDetailVo> list = ((AuditCustomerDetailMapper)this.getBaseMapper()).findByActivityDetailCodesExcludeAuditCode(activityDetailCodes, auditCode);
        return list;
    }

    public void updateByConditions2(List<AuditCustomerDetail> customerDetails2) {
    }

    public List<AuditCustomerDetailVo> findDetailByListAuditCustomerDetailDto(List<AuditCustomerDetailDto> dtos, String processStatus, List<String> activityFormCodeList) {
        List<AuditCustomerDetailVo> list = ((AuditCustomerDetailMapper)this.getBaseMapper()).findDetailByListAuditCustomerDetailDto(dtos, processStatus, activityFormCodeList);
        return list;
    }

    public Page<AuditCustomerDetailVo> findAuditDetailList(Pageable pageable, AuditCustomerDetailDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.auditCustomerDetailMapper.findAuditDetailList((Page<AuditCustomerDetailVo>)page, dto);
    }

    public List<AuditCustomerDetail> findByActivityDetailCodeList(Set<String> constituentDetailPlanItemCodes) {
        if (CollectionUtils.isEmpty(constituentDetailPlanItemCodes)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditCustomerDetail::getActivityDetailCode, constituentDetailPlanItemCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<AuditCustomerDetailVo> findByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return null;
        }
        return ((AuditCustomerDetailMapper)this.getBaseMapper()).findByProcessNo(processNo);
    }

    public List<AuditCustomerDetail> findByActivityDetailCodeListExcludeThis(HashSet<String> activityDetailCodes, List<String> idList) {
        if (CollectionUtils.isEmpty(activityDetailCodes) && CollectionUtils.isEmpty(idList)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditCustomerDetail::getActivityDetailCode, activityDetailCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).notIn(UuidEntity::getId, idList)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Set auditCodes = list.stream().filter(o -> DelFlagStatusEnum.NORMAL.getCode().equals(o.getDelFlag())).map(AuditCustomerDetail::getAuditCode).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(auditCodes)) {
            List<AuditVo> auditVos = this.auditRepository.findByCodes(new ArrayList<String>(auditCodes));
            if (!CollectionUtils.isEmpty(auditVos)) {
                Set finalAuditCodes = auditCodes = auditVos.stream().map(AuditVo::getAuditCode).collect(Collectors.toSet());
                list = list.stream().filter(o -> finalAuditCodes.contains(o.getAuditCode())).collect(Collectors.toList());
            } else {
                return Lists.newArrayList();
            }
        }
        return list;
    }

    public List<AuditCustomerDetail> findByActivityDetailCodeListExcludeThisAuditCode(HashSet<String> activityDetailCodes, String auditCode) {
        if (CollectionUtils.isEmpty(activityDetailCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(AuditCustomerDetail::getActivityDetailCode, activityDetailCodes)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).notIn(StringUtils.isNotEmpty((CharSequence)auditCode), AuditCustomerDetail::getAuditCode, new Object[]{auditCode})).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Set auditCodes = list.stream().filter(o -> DelFlagStatusEnum.NORMAL.getCode().equals(o.getDelFlag())).map(AuditCustomerDetail::getAuditCode).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(auditCodes)) {
            List<AuditVo> auditVos = this.auditRepository.findByCodes(new ArrayList<String>(auditCodes));
            if (!CollectionUtils.isEmpty(auditVos)) {
                Set finalAuditCodes = auditCodes = auditVos.stream().map(AuditVo::getAuditCode).collect(Collectors.toSet());
                list = list.stream().filter(o -> finalAuditCodes.contains(o.getAuditCode())).collect(Collectors.toList());
            } else {
                return Lists.newArrayList();
            }
        }
        return list;
    }

    public int auditDetailCanClose(List<String> detailPlanItemCodeList) {
        if (CollectionUtils.isEmpty(detailPlanItemCodeList)) {
            return 0;
        }
        return this.auditCustomerDetailMapper.auditDetailCanClose(TenantUtils.getTenantCode(), detailPlanItemCodeList);
    }

    public void updateDiffAmountByAuditDetailCode(String auditDetailCode, BigDecimal diffAmount) {
        if (StringUtils.isNotEmpty((CharSequence)auditDetailCode) && Objects.nonNull(diffAmount)) {
            AuditCustomerDetail detail = (AuditCustomerDetail)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditCustomerDetail::getAuditDetailCode, (Object)auditDetailCode)).one());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditCustomerDetail::getAuditDetailCode, (Object)auditDetailCode)).set(AuditCustomerDetail::getReimburseAmount, (Object)detail.getReimburseAmount().add(diffAmount))).update();
        }
    }

    public Page<CostPoolAuditReportVo> findManualUpdateCostPoolReport(Page<CostPoolAuditReportVo> page, CostPoolAuditReportDto dto) {
        if (Objects.isNull(dto)) {
            return page;
        }
        return ((AuditCustomerDetailMapper)this.getBaseMapper()).findManualUpdateCostPoolReport(page, dto);
    }

    public List<AuditCustomerDetailVo> findDetailSumByAuditDetailCodes(List<String> auditDetailCodes) {
        if (CollectionUtils.isEmpty(auditDetailCodes)) {
            return Lists.newArrayList();
        }
        return ((AuditCustomerDetailMapper)this.getBaseMapper()).findDetailSumByAuditDetailCodes(auditDetailCodes);
    }

    public boolean save(AuditCustomerDetail entity) {
        boolean b = super.save((Object)entity);
        if (b) {
            AuditCustomerDetailExtend auditCustomerDetailExtend = (AuditCustomerDetailExtend)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditCustomerDetailExtend.class, null, null, new String[0]));
            this.auditCustomerDetailExtendRepository.save((Object)auditCustomerDetailExtend);
        }
        return b;
    }

    public boolean remove(String auditCode) {
        boolean b = super.remove((Wrapper)Wrappers.lambdaUpdate(AuditCustomerDetail.class).eq(AuditCustomerDetail::getAuditCode, (Object)auditCode));
        if (b) {
            this.auditCustomerDetailExtendRepository.remove((Wrapper)Wrappers.lambdaUpdate(AuditCustomerDetailExtend.class).eq(AuditCustomerDetailExtend::getAuditCode, (Object)auditCode));
        }
        return b;
    }

    public boolean remove(List<String> detailCodeList) {
        boolean b = super.remove((Wrapper)Wrappers.lambdaQuery().in(AuditCustomerDetail::getAuditDetailCode, detailCodeList));
        if (b) {
            this.auditCustomerDetailExtendRepository.remove((Wrapper)Wrappers.lambdaQuery().in(AuditCustomerDetailExtend::getAuditDetailCode, detailCodeList));
        }
        return b;
    }

    public void updateRedInvoiceStatusById(AuditRedInvoiceDto redInvoiceDto, List<String> ids) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(ids)) {
            ArrayList<AuditCustomerDetail> detailList = new ArrayList<AuditCustomerDetail>();
            for (String id : ids) {
                AuditCustomerDetail detail = new AuditCustomerDetail();
                detail.setId(id);
                detail.setRedOrderCreateStatus(redInvoiceDto.getRedOrderCreateStatus());
                detailList.add(detail);
            }
            this.updateBatchById(detailList);
        }
    }

    public Page<CostPoolAuditReportVo> findManualUpdateCostPoolReportForRedInvoice(Page<CostPoolAuditReportVo> page, CostPoolAuditReportDto dto) {
        if (Objects.isNull(dto)) {
            return page;
        }
        return ((AuditCustomerDetailMapper)this.getBaseMapper()).findManualUpdateCostPoolReportForRedInvoice(page, dto);
    }
}

