/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.local.entity.AuditInfoAttachment;
import com.biz.crm.tpm.business.audit.local.mapper.AuditInfoAttachmentMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditInfoAttachmentRepository
extends ServiceImpl<AuditInfoAttachmentMapper, AuditInfoAttachment> {
    @Autowired
    private AuditInfoAttachmentMapper auditInfoAttachmentMapper;

    public Page<AuditInfoAttachment> findByConditions(Pageable pageable, AuditInfoAttachment auditInfoAttachment) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditInfoAttachment> pageList = this.auditInfoAttachmentMapper.findByConditions((Page<AuditInfoAttachment>)page, auditInfoAttachment);
        return pageList;
    }

    public List<AuditInfoAttachment> findByCode(String auditCode, String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditCode) || StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return new ArrayList<AuditInfoAttachment>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInfoAttachment::getAuditCode, (Object)auditCode)).eq(AuditInfoAttachment::getAuditDetailCode, (Object)auditDetailCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<AuditInfoAttachment> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return new ArrayList<AuditInfoAttachment>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInfoAttachment::getAuditCode, (Object)auditCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<AuditInfoAttachment> findByIds(Set<String> auditInfoIds) {
        if (CollectionUtils.isEmpty(auditInfoIds)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditInfoAttachment::getAuditInfoId, auditInfoIds)).list();
    }

    public void deleteByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return;
        }
        this.remove((Wrapper)Wrappers.lambdaUpdate(AuditInfoAttachment.class).eq(AuditInfoAttachment::getAuditCode, (Object)auditCode));
    }
}

