/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.local.entity.AuditInfo;
import com.biz.crm.tpm.business.audit.local.mapper.AuditInfoMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditInfoRepository
extends ServiceImpl<AuditInfoMapper, AuditInfo> {
    @Autowired
    private AuditInfoMapper auditInfoMapper;

    public Page<AuditInfo> findByConditions(Pageable pageable, AuditInfo auditInfo) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditInfo> pageList = this.auditInfoMapper.findByConditions((Page<AuditInfo>)page, auditInfo);
        return pageList;
    }

    public List<AuditInfo> findByCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditInfo::getAuditCode, (Object)auditCode)).list();
    }

    public List<AuditInfo> findByCodes(Set<String> auditCodeSet) {
        if (CollectionUtils.isEmpty(auditCodeSet)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditInfo::getAuditCode, auditCodeSet)).list();
    }

    public void deleteByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return;
        }
        this.remove((Wrapper)Wrappers.lambdaUpdate(AuditInfo.class).eq(AuditInfo::getAuditCode, (Object)auditCode));
    }
}

