/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceEventDto;
import com.biz.crm.tpm.business.audit.local.entity.AuditInvoice;
import com.biz.crm.tpm.business.audit.local.mapper.AuditInvoiceMapper;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditInvoiceDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditInvoiceRepository
extends ServiceImpl<AuditInvoiceMapper, AuditInvoice> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AuditInvoiceMapper auditInvoiceMapper;

    public Page<AuditInvoice> findByConditions(Pageable pageable, AuditInvoice auditInvoice) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditInvoice> pageList = this.auditInvoiceMapper.findByConditions((Page<AuditInvoice>)page, auditInvoice);
        return pageList;
    }

    public List<AuditInvoice> findByCode(String auditCode, String auditDetailCode) {
        if (StringUtils.isBlank((CharSequence)auditCode) || StringUtils.isBlank((CharSequence)auditDetailCode)) {
            return new ArrayList<AuditInvoice>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInvoice::getAuditCode, (Object)auditCode)).eq(AuditInvoice::getAuditDetailCode, (Object)auditDetailCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<AuditInvoiceVo> findByAuditDetailCode(Set<String> set) {
        return this.auditInvoiceMapper.findByAuditDetailCode(set);
    }

    public List<AuditInvoice> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return new ArrayList<AuditInvoice>();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInvoice::getAuditCode, (Object)auditCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<AuditInvoice> findNoCode(String invoiceNumber, String invoiceCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInvoice::getInvoiceNumber, (Object)invoiceNumber)).eq(AuditInvoice::getInvoiceCode, (Object)invoiceCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<AuditInvoice> findByNo(String invoiceNumber) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInvoice::getInvoiceNumber, (Object)invoiceNumber)).isNull(AuditInvoice::getInvoiceCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
    }

    public List<AuditInvoice> findByNoCode(String invoiceNumber, String invoiceCode, String auditCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInvoice::getInvoiceNumber, (Object)invoiceNumber)).eq(AuditInvoice::getInvoiceCode, (Object)invoiceCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).notIn(AuditInvoice::getAuditCode, new Object[]{auditCode})).list();
    }

    public List<AuditInvoice> findByNoAuditCode(String invoiceNumber, String auditCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInvoice::getInvoiceNumber, (Object)invoiceNumber)).isNull(AuditInvoice::getInvoiceCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).notIn(AuditInvoice::getAuditCode, new Object[]{auditCode})).list();
    }

    public void deleteAuditInvoiceByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<AuditInvoice> findByAuditCodes(Collection<String> auditCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditInvoice::getAuditCode, auditCodes)).list();
    }

    public void deleteAuditInvoiceByAuditCodes(Set<String> set) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(AuditInvoice::getAuditCode, set)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<AuditInvoiceVo> findByIds(List<String> ids) {
        return this.auditInvoiceMapper.findByIds(ids, TenantUtils.getTenantCode());
    }

    public List<AuditInvoiceVo> findInvoiceOtherAudit(List<AuditInvoiceDto> auditInvoiceDtos) {
        if (CollectionUtils.isEmpty(auditInvoiceDtos)) {
            return Lists.newArrayList();
        }
        return this.auditInvoiceMapper.findInvoiceOtherAudit(auditInvoiceDtos);
    }

    public List<AuditInvoiceVo> findAuditInvoiceByInvoice(List<AuditInvoiceEventDto.Item> items) {
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        return this.auditInvoiceMapper.findAuditInvoiceByInvoice(items);
    }

    public void deleteByCodeList(List<String> deleteCodeList) {
        if (CollectionUtils.isEmpty(deleteCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(AuditInvoice::getAuditCode, deleteCodeList)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<AuditInvoiceVo> findInvoiceByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditInvoice::getAuditCode, (Object)auditCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection auditInvoiceVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditInvoice.class, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditInvoiceVos;
    }

    public void deleteByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditInvoice::getAuditCode, (Object)auditCode)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }
}

