/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.audit.local.entity.AuditManualApportion;
import com.biz.crm.tpm.business.audit.local.mapper.AuditManualApportionMapper;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditManualApportionDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditManualApportionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditManualApportionRepository
extends ServiceImpl<AuditManualApportionMapper, AuditManualApportion> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<AuditManualApportionVo> findManualApportion(String auditDetailCode) {
        if (StringUtils.isEmpty((CharSequence)auditDetailCode)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(AuditManualApportion::getAuditDetailCode, (Object)auditDetailCode)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditManualApportion.class, AuditManualApportionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public void removeByDetailCode(String auditDetailCode) {
        this.remove((Wrapper)Wrappers.lambdaUpdate(AuditManualApportion.class).eq(AuditManualApportion::getAuditDetailCode, (Object)auditDetailCode));
    }

    public void saveBatchData(List<AuditManualApportionDto> dtos) {
        if (!CollectionUtils.isEmpty(dtos)) {
            Collection auditManualApportions = this.nebulaToolkitService.copyCollectionByWhiteList(dtos, AuditManualApportionDto.class, AuditManualApportion.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            auditManualApportions.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            this.saveBatch(auditManualApportions);
        }
    }
}

