/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.local.entity.Audit;
import com.biz.crm.tpm.business.audit.local.mapper.AuditMapper;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditBatchSubmitDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditBatchSubmitQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerAuditDetailQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDetailLookDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditProductUpAccountDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditSupplierDetailDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CheckStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditDetailLookVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditProductUpAccountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSubmitAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.tpm.business.audit.sdk.vo.PreEndResultRequestEntityVo;
import com.biz.crm.tpm.business.audit.sdk.vo.report.AuditManageActivityTypeFeeVo;
import com.biz.crm.tpm.business.audit.sdk.vo.report.AuditManageChannelFeeVo;
import com.biz.crm.tpm.business.audit.sdk.vo.report.AuditManageOneProductFeeVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AuditRepository
extends ServiceImpl<AuditMapper, Audit> {
    private static final Logger log = LoggerFactory.getLogger(AuditRepository.class);
    @Autowired
    private AuditMapper auditMapper;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Page<AuditVo> findByConditions(Pageable pageable, AuditDto audit) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditVo> pageList = this.auditMapper.findByConditions((Page<AuditVo>)page, audit);
        return pageList;
    }

    public List<PreEndResultRequestEntityVo> selectUnSynchronizexdAll() {
        return this.auditMapper.selectUnSynchronizexdAll();
    }

    public void updatSynchronizationByUuids(List<String> auditCodes) {
        this.auditMapper.updatSynchronizationByUuids(auditCodes);
    }

    public List<PreEndResultRequestEntityVo> findRequestEntityVoByIds(List<String> idList) {
        return this.auditMapper.findRequestEntityVoByIds(idList);
    }

    public Page<PreEndResultRequestEntityVo> selectUnSynchronizexdPage(Pageable pageable) {
        return this.auditMapper.selectUnSynchronizexdPage(pageable);
    }

    public AuditCustomerVo findByCode(String code) {
        return this.auditMapper.findByCode(code);
    }

    public Integer findByName(String substring) {
        if (StringUtils.isBlank((CharSequence)substring)) {
            return 0;
        }
        return this.auditMapper.findByName(substring);
    }

    public List<AuditVo> findByCodes(List<String> auditCodes) {
        if (CollectionUtils.isEmpty(auditCodes)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Audit::getAuditCode, auditCodes)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection auditVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, Audit.class, AuditVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditVos;
    }

    public Page<AuditVo> findBatchSubmit(Page<AuditVo> page, AuditBatchSubmitQueryDto audit) {
        if (StringUtils.isNotEmpty((CharSequence)audit.getAuditCode()) && (audit.getAuditCode().contains(",") || audit.getAuditCode().contains(" "))) {
            audit.setAuditCodeList(Arrays.asList(audit.getAuditCode().split("[, \uff0c]")));
            audit.setAuditCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)audit.getActivityDetailCode()) && (audit.getActivityDetailCode().contains(",") || audit.getActivityDetailCode().contains(" "))) {
            audit.setActivityDetailCodeList(Arrays.asList(audit.getActivityDetailCode().split("[, \uff0c]")));
            audit.setActivityDetailCode(null);
        }
        Page<AuditVo> batchSubmit = this.auditMapper.findBatchSubmit(page, audit);
        log.info("\u6279\u91cf\u63d0\u4ea4\u67e5\u8be2\u7ed3\u679c:{}", batchSubmit);
        if (CollectionUtil.isNotEmpty((Collection)batchSubmit.getRecords())) {
            batchSubmit.getRecords().forEach(item -> {
                if (StringUtils.isEmpty((CharSequence)item.getCheckStatus())) {
                    item.setCheckStatus(CheckStatusEnum.UNEXAMINED.getCode());
                }
            });
        }
        return batchSubmit;
    }

    public Page<AuditCustomerDetailVo> findCustomerAuditDetail(Pageable pageable, AuditCustomerAuditDetailQueryDto audit) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)audit.getAuditCode()) && (audit.getAuditCode().contains(",") || audit.getAuditCode().contains(" "))) {
            audit.setAuditCodeList(Arrays.asList(audit.getAuditCode().split("[, \uff0c]")));
            audit.setAuditCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)audit.getActivityDetailCode()) && (audit.getActivityDetailCode().contains(",") || audit.getActivityDetailCode().contains(" "))) {
            audit.setActivityDetailCodeList(Arrays.asList(audit.getActivityDetailCode().split("[, \uff0c]")));
            audit.setActivityDetailCode(null);
        }
        Page<AuditCustomerDetailVo> batchSubmit = this.auditMapper.findCustomerAuditDetail((Page<AuditCustomerDetailVo>)page, audit);
        return batchSubmit;
    }

    public Page<AuditCustomerDetailVo> findBatchDetailSubmit(Page<AuditCustomerDetailVo> page, AuditBatchSubmitQueryDto audit) {
        if (StringUtils.isNotEmpty((CharSequence)audit.getAuditCode()) && (audit.getAuditCode().contains(",") || audit.getAuditCode().contains(" "))) {
            audit.setAuditCodeList(Arrays.asList(audit.getAuditCode().split("[, \uff0c]")));
            audit.setAuditCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)audit.getActivityDetailCode()) && (audit.getActivityDetailCode().contains(",") || audit.getActivityDetailCode().contains(" "))) {
            audit.setActivityDetailCodeList(Arrays.asList(audit.getActivityDetailCode().split("[, \uff0c]")));
            audit.setActivityDetailCode(null);
        }
        Page<AuditCustomerDetailVo> batchSubmit = this.auditMapper.findBatchDetailSubmit(page, audit);
        log.info("\u6279\u91cf\u63d0\u4ea4\u67e5\u8be2\u7ed3\u679c:{}", batchSubmit);
        return batchSubmit;
    }

    public Page<AuditCustomerDetailVo> findAuditDetailGroupSubmit(Page<AuditCustomerDetailVo> page, AuditBatchSubmitQueryDto audit) {
        Page<AuditCustomerDetailVo> batchSubmit = this.auditMapper.findAuditDetailGroupSubmit(page, audit);
        log.info("\u6279\u91cf\u63d0\u4ea4\u67e5\u8be2\u7ed3\u679c:{}", batchSubmit);
        return batchSubmit;
    }

    public void updateAuditProcess(List<String> auditCodeList, String processStatus, String processNo) {
        this.auditMapper.updateAuditProcess(auditCodeList, processStatus, processNo);
    }

    public List<String> findAuditCode(AuditBatchSubmitDto auditBatchSubmit) {
        return this.auditMapper.findAuditCode(auditBatchSubmit);
    }

    public Audit getAuditById(String auditId) {
        if (CharSequenceUtil.isEmpty((CharSequence)auditId)) {
            return null;
        }
        return (Audit)((Object)((AuditMapper)this.baseMapper).selectById((Serializable)((Object)auditId)));
    }

    public void updateByCode(String auditCode, String taxRate, boolean containReimburse) {
        String reimburseUpAccountStatus = null;
        if (containReimburse) {
            reimburseUpAccountStatus = UpAccountStatusEnum.AWAIT_UP_ACCOUNT.getCode();
        }
        if (StringUtils.isNotBlank((CharSequence)auditCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(Audit::getAuditCode, (Object)auditCode)).set(StringUtils.isNotEmpty((CharSequence)taxRate), Audit::getTaxRate, (Object)taxRate).set(Audit::getReimburseUpAccountStatus, (Object)reimburseUpAccountStatus)).update();
        }
    }

    public void updateByCode2(String auditCode, String taxRate) {
        if (StringUtils.isNotBlank((CharSequence)auditCode) && StringUtils.isNotEmpty((CharSequence)taxRate)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(Audit::getAuditCode, (Object)auditCode)).set(StringUtils.isNotEmpty((CharSequence)taxRate), Audit::getTaxRate, (Object)taxRate).update();
        }
    }

    public Audit findEntityByAuditCode(String auditCode) {
        return (Audit)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Audit::getAuditCode, (Object)auditCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<Audit> findByAuditCodeList(List<String> auditCodeList) {
        if (CollectionUtils.isEmpty(auditCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Audit::getAuditCode, auditCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void updateProcessStatusByAuditCodeList(AuditDto auditDto, List<String> auditCodeList) {
        if (CollectionUtils.isEmpty(auditCodeList) || Objects.isNull(auditDto) || StringUtils.isEmpty((CharSequence)auditDto.getProcessStatus())) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Audit::getProcessStatus, (Object)auditDto.getProcessStatus())).set(Objects.nonNull(auditDto.getProcessDate()), Audit::getProcessDate, (Object)auditDto.getProcessDate()).set(Audit::getApprovalAccount, (Object)auditDto.getApprovalAccount())).set(Audit::getApprovalName, (Object)auditDto.getApprovalName())).in(Audit::getAuditCode, auditCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public void updateAppendices(AuditDto auditDto) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Audit::getAppendices, (Object)auditDto.getAppendices())).eq(Audit::getAuditCode, (Object)auditDto.getAuditCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).update();
    }

    public Page<AuditVo> findByAuditName(Pageable pageable, String auditName) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditVo> pageList = this.auditMapper.findByAuditName((Page<AuditVo>)page, auditName, TenantUtils.getTenantCode());
        return pageList;
    }

    public void updateCheckStatusByCode(String auditCode, String checkStatus) {
        if (StringUtils.isBlank((CharSequence)auditCode) || StringUtils.isBlank((CharSequence)checkStatus)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Audit::getCheckStatus, (Object)checkStatus)).eq(Audit::getAuditCode, (Object)auditCode)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).update();
    }

    public void updateRejectByAuditCodes(List<String> rejectCodes) {
        if (CollectionUtils.isNotEmpty(rejectCodes)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(Audit::getAuditCode, rejectCodes)).set(Audit::getProcessStatus, (Object)ProcessStatusEnum.REJECT.getDictCode())).set(Audit::getReject, null)).update();
        }
    }

    public void updateInvoiceTaxAmountCollect(String auditCode, BigDecimal InvoiceTaxAmountCollect) {
        if (StringUtils.isNotEmpty((CharSequence)auditCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Audit::getInvoiceTaxAmountCollect, (Object)InvoiceTaxAmountCollect)).eq(Audit::getAuditCode, (Object)auditCode)).update();
        }
    }

    public AuditSubmitAmountVo findSubmitAmount(AuditBatchSubmitQueryDto audit) {
        return this.auditMapper.findSubmitAmount(audit);
    }

    public Audit findOneByCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return null;
        }
        Audit one = (Audit)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Audit::getAuditCode, (Object)auditCode)).one());
        return one;
    }

    public Page<AuditVo> findPageForOut(Pageable pageable, AuditDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((AuditMapper)this.baseMapper).findPageForOut((Page<AuditVo>)page, dto);
    }

    public Page<AuditProductUpAccountVo> tpmAuditUpAccount(Pageable pageable, AuditProductUpAccountDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AuditProductUpAccountVo> pageList = this.auditMapper.tpmAuditUpAccount((Page<AuditProductUpAccountVo>)page, dto);
        return pageList;
    }

    public void updateReimburseStatusById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).set(Audit::getReimburseUpAccountStatus, (Object)UpAccountStatusEnum.AWAIT_UP_ACCOUNT.getCode())).update();
    }

    public void updateReimburseStatusNullById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(UuidEntity::getId, (Object)id)).set(Audit::getReimburseUpAccountStatus, null)).update();
    }

    public Page<AuditDetailLookVo> auditDetailLook(Pageable pageable, AuditDetailLookDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditMapper.auditDetailLook((Page<AuditDetailLookVo>)page, dto);
    }

    public Page<AuditCustomerDetailCollectionVo> auditReport(Pageable pageable, AuditCustomerDetailCollectionDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditCustomerDetailCollectionDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return this.auditMapper.auditReport((Page<AuditCustomerDetailCollectionVo>)page, dto);
    }

    public List<AuditCustomerDetailCollectionVo> findByActivityDetailCodes(List<String> itemCodeSet) {
        if (CollectionUtils.isEmpty(itemCodeSet)) {
            return null;
        }
        return ((AuditMapper)this.baseMapper).findByActivityDetailCodes(itemCodeSet);
    }

    public Audit findBusinessUnitByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return null;
        }
        return (Audit)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Audit::getProcessNo, (Object)processNo)).last("limit 1")).one());
    }

    public Audit findOneByCondition(AuditDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getAuditDimensionality()) && StringUtils.isNotEmpty((CharSequence)dto.getDimensionalityKey()) && StringUtils.isNotEmpty((CharSequence)dto.getAutoAuditLock())) {
            return (Audit)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(Audit::getAuditDimensionality, (Object)dto.getAuditDimensionality())).eq(Audit::getDimensionalityKey, (Object)dto.getDimensionalityKey())).eq(Audit::getAutoAuditLock, (Object)dto.getAutoAuditLock())).one());
        }
        return null;
    }

    public void updateAutoAuditLock() {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(Audit::getAutoAuditLock, (Object)YesOrNoEnum.YES.getCode())).set(Audit::getAutoAuditLock, (Object)YesOrNoEnum.NO.getCode())).update();
    }

    public List<String> getAuditByLock() {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Audit::getAutoAuditLock, (Object)YesOrNoEnum.YES.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return list.stream().map(Audit::getAuditCode).collect(Collectors.toList());
        }
        return null;
    }

    public void updatePassByAuditCodes(List<String> auditCodes) {
        if (CollectionUtils.isEmpty(auditCodes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(Audit::getAuditCode, auditCodes)).set(Audit::getProcessStatus, (Object)ProcessStatusEnum.PASS.getDictCode())).set(Audit::getProcessDate, (Object)new Date())).update();
    }

    public void updateProcessStatusByAuditCodeList2(AuditDto auditDto, List<String> auditCodeList) {
        if (CollectionUtils.isEmpty(auditCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(Audit::getProcessStatus, (Object)auditDto.getProcessStatus())).set(Objects.nonNull(auditDto.getProcessDate()), Audit::getProcessDate, (Object)auditDto.getProcessDate()).set(Audit::getApprovalAccount, (Object)auditDto.getApprovalAccount())).set(Audit::getApprovalName, (Object)auditDto.getApprovalName())).in(Audit::getAuditCode, auditCodeList)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).update();
    }

    public Page<AuditManageOneProductFeeVo> findPageItemForManageOneProductFee(Page<AuditManageOneProductFeeVo> page, List<String> yearList, String companyCode, String productCode) {
        return ((AuditMapper)this.getBaseMapper()).findPageItemForManageOneProductFee(page, yearList, companyCode, productCode);
    }

    public Page<AuditManageActivityTypeFeeVo> findPageItemForManageActivityTypeFee(Page<AuditManageActivityTypeFeeVo> page, List<String> yearList) {
        return ((AuditMapper)this.getBaseMapper()).findPageItemForManageActivityTypeFee(page, yearList);
    }

    public Page<AuditManageChannelFeeVo> findPageItemForManageChannelFee(Page<AuditManageChannelFeeVo> page, List<String> yearList) {
        return ((AuditMapper)this.getBaseMapper()).findPageItemForManageChannelFee(page, yearList);
    }

    public Page<AuditSupplierDetailVo> supplierAuditReport(Pageable pageable, AuditSupplierDetailDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isEmpty((CharSequence)dto.getTenantCode())) {
            dto.setTenantCode(TenantUtils.getTenantCode());
        }
        return ((AuditMapper)this.getBaseMapper()).supplierAuditReport((Page<AuditSupplierDetailVo>)page, dto);
    }
}

