/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.local.entity.CostPoolAuditReport;
import com.biz.crm.tpm.business.audit.local.mapper.CostPoolAuditReportMapper;
import com.biz.crm.tpm.business.audit.sdk.dto.report.CostPoolAuditReportDto;
import com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CostPoolAuditReportRepository
extends ServiceImpl<CostPoolAuditReportMapper, CostPoolAuditReport> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<CostPoolAuditReportVo> findListByDimensionKeys(List<String> dimensionKeys) {
        if (CollectionUtils.isEmpty(dimensionKeys)) {
            return Lists.newArrayList();
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CostPoolAuditReport::getDimensionKey, dimensionKeys)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        Collection costPoolAuditReportVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, CostPoolAuditReport.class, CostPoolAuditReportVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)costPoolAuditReportVos;
    }

    public Page<CostPoolAuditReportVo> costPoolReportSystem(Pageable pageable, CostPoolAuditReportDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<CostPoolAuditReportVo> pageList = ((CostPoolAuditReportMapper)this.getBaseMapper()).costPoolReportSystem((Page<CostPoolAuditReportVo>)page, dto);
        return pageList;
    }

    public Page<CostPoolAuditReportVo> costPoolReportRegion(Pageable pageable, CostPoolAuditReportDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<CostPoolAuditReportVo> pageList = ((CostPoolAuditReportMapper)this.getBaseMapper()).costPoolReportRegion((Page<CostPoolAuditReportVo>)page, dto);
        return pageList;
    }

    public Page<CostPoolAuditReportVo> costPoolReport(Pageable pageable, CostPoolAuditReportDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<CostPoolAuditReportVo> pageList = ((CostPoolAuditReportMapper)this.getBaseMapper()).costPoolReport((Page<CostPoolAuditReportVo>)page, dto);
        return pageList;
    }

    public void deleteByDto(CostPoolAuditReportDto dto) {
        Validate.notNull((Object)dto, (String)"\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEnterCostPoolDateBegin(), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEnterCostPoolDateEnd(), (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.remove((Wrapper)Wrappers.lambdaUpdate(CostPoolAuditReport.class).between(CostPoolAuditReport::getEnterCostPoolDate, (Object)dto.getEnterCostPoolDateBegin(), (Object)dto.getEnterCostPoolDateEnd()));
    }
}

