/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.repository;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.local.entity.TaxAccount;
import com.biz.crm.tpm.business.audit.local.mapper.TaxAccountMapper;
import com.biz.crm.tpm.business.audit.sdk.enumeration.TaxTypeEnum;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jodd.util.StringUtil;
import org.springframework.stereotype.Component;

@Component
public class TaxAccountRepository
extends ServiceImpl<TaxAccountMapper, TaxAccount> {
    public TaxAccount findByReimburseTaxRate(String reimburseTaxRate, TaxTypeEnum type) {
        if (StringUtil.isEmpty((CharSequence)reimburseTaxRate) || Objects.isNull(type)) {
            return null;
        }
        return (TaxAccount)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TaxAccount::getReimburseTaxRate, (Object)reimburseTaxRate)).eq(TaxAccount::getType, (Object)type.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public List<TaxAccount> findByTaxRateList(Set<String> taxRates, TaxTypeEnum type) {
        if (CollectionUtil.isEmpty(taxRates) || Objects.isNull(type)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(TaxAccount::getReimburseTaxRate, taxRates)).eq(TaxAccount::getType, (Object)type.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }
}

