/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.audit;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.local.repository.AuditProductUpAccountRepository;
import com.biz.crm.tpm.business.audit.local.service.AuditProcess;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.AuditUseBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.payment.receipt.sdk.dto.PaymentReceiptDto;
import com.biz.crm.tpm.business.payment.receipt.sdk.service.PaymentReceiptSdkService;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessMappingService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class AuditProcessImpl
implements AuditProcess {
    private static final Logger log = LoggerFactory.getLogger(AuditProcessImpl.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProcessBusinessMappingService processBusinessMappingService;
    @Autowired(required=false)
    private PaymentReceiptSdkService paymentReceiptSdkService;
    @Autowired(required=false)
    @Lazy
    private List<IAudit> auditStrategyList;
    @Autowired(required=false)
    private AuditProductUpAccountRepository auditProductUpAccountRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @Override
    public void auditProcessComplete(ProcessStatusDto dto, boolean isManualOperation) {
        log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u5ba1\u6279\u56de\u8c03\u53c2\u6570\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)dto));
        String processStatus = dto.getProcessStatus();
        ProcessStatusEnum processStatusEnum = ProcessStatusEnum.getStatusEnumByDictCode((String)processStatus);
        Assert.notNull((Object)processStatusEnum, (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25\uff0c\u5ba1\u6279\u72b6\u6001\u4e0d\u5408\u6cd5!");
        List auditCodeList = dto.getBusinessNoList();
        Assert.notEmpty((Collection)auditCodeList, (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25\uff0c\u6838\u9500\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        switch (processStatusEnum) {
            case PASS: 
            case REJECT: 
            case RECOVER: {
                break;
            }
            default: {
                throw new IllegalArgumentException("\u5f53\u524d\u5ba1\u6279\u72b6\u6001[" + processStatusEnum.getValue() + "]\u672a\u914d\u7f6e,\u5ba1\u6279\u5931\u8d25!");
            }
        }
        List list = this.auditService.findByAuditCodeList(auditCodeList);
        Assert.notNull((Object)list, (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u6838\u9500\u5355\u636e!");
        ArrayList<String> keys = new ArrayList<String>();
        try {
            for (AuditVo auditVo : list) {
                Object lockKey = "audit:approval:";
                lockKey = (String)lockKey + auditVo.getAuditCode();
                keys.add((String)lockKey);
                boolean lock = this.redisLockService.tryLock((String)lockKey, TimeUnit.MINUTES, 10L);
                if (lock) continue;
                log.info("\u7ed3\u6848\u6838\u9500\u5ba1\u6279\u901a\u8fc7\u6838\u9500\u5355:{}\u6b63\u5728\u88ab\u9501\u5b9a", lockKey);
                return;
            }
            Collection auditDtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditVo.class, AuditDto.class, HashSet.class, ArrayList.class, new String[0]);
            switch (processStatusEnum) {
                case PASS: {
                    List<AuditDto> reject;
                    List pass = auditDtoList.stream().filter(o -> StringUtils.isEmpty((CharSequence)o.getReject()) || YesOrNoEnum.NO.getCode().equals(o.getReject())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(pass)) {
                        for (AuditDto auditDto : pass) {
                            IAudit thisAudit = this.getAudit(auditDto);
                            auditDto.setManualOperation(isManualOperation);
                            log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u5ba1\u6279\u901a\u8fc71:\u6838\u9500\u5355\u53f7:{}", (Object)auditDto.getAuditCode());
                            thisAudit.approvalPass(auditDto);
                            log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u5ba1\u6279\u901a\u8fc72:\u6838\u9500\u5355\u53f7:{}", (Object)auditDto.getAuditCode());
                        }
                    }
                    if (!CollectionUtils.isNotEmpty(reject = auditDtoList.stream().filter(o -> YesOrNoEnum.YES.getCode().equals(o.getReject())).collect(Collectors.toList()))) break;
                    AuditDto auditDto = (AuditDto)reject.get(0);
                    List rejectCodes = reject.stream().map(AuditDto::getAuditCode).collect(Collectors.toList());
                    log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u5ba1\u6279\u9a73\u56de1:\u6838\u9500\u5355\u53f7:{}", (Object)JsonUtils.obj2JsonString(rejectCodes));
                    this.processBusinessMappingService.deleteByBusinessNosAndpProcessNo(rejectCodes, auditDto.getProcessNo());
                    this.rejectOperation(reject, ProcessStatusEnum.REJECT.getDictCode());
                    log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u5ba1\u6279\u9a73\u56de2:\u6838\u9500\u5355\u53f7:{}", (Object)JsonUtils.obj2JsonString(rejectCodes));
                    break;
                }
                case REJECT: 
                case RECOVER: {
                    this.rejectOperation(auditDtoList, processStatus);
                    break;
                }
            }
            log.info("\u7ed3\u6848\u6838\u9500\u5ba1\u6279\u901a\u8fc7\u6210\u529f:\u53c2\u6570\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)dto));
        }
        catch (Exception e) {
            log.info("\u7ed3\u6848\u6838\u9500\u5ba1\u6279\u901a\u8fc7\u51fa\u9519:\u53c2\u6570\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)dto));
            log.error("\u7ed3\u6848\u6838\u9500\u5ba1\u6279\u901a\u8fc7\u51fa\u9519", (Throwable)e);
            throw e;
        }
        finally {
            keys.forEach(key -> {
                if (this.redisLockService.isLock(key)) {
                    this.redisLockService.unlock(key);
                }
            });
        }
    }

    @Override
    public void autoPassAudit(List<String> auditCodes) {
        List list = this.auditService.findByAuditCodeList(auditCodes);
        Collection auditDtoList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditVo.class, AuditDto.class, HashSet.class, ArrayList.class, new String[0]);
        this.auditService.updatePassByAuditCodes(auditCodes);
        for (AuditDto auditDto : auditDtoList) {
            IAudit thisAudit = this.getAudit(auditDto);
            auditDto.setAutoApproved(true);
            if (BusinessUnitEnum.isOnlineBusinessUnit((String)auditDto.getBusinessUnitCode()) || BusinessUnitEnum.isDefaultBusinessUnit((String)auditDto.getBusinessUnitCode())) {
                log.info("\u81ea\u52a8\u7ed3\u6848\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7,\u5f00\u59cb\u5206\u644a\u6838\u9500\u5355\u53f7\uff1a{}", (Object)auditDto.getAuditCode());
                thisAudit.upAccountApportion(auditDto);
            }
            thisAudit.approvalPass(auditDto);
        }
    }

    private void rejectOperation(Collection<AuditDto> auditDtos, String processStatus) {
        List rejectCodes = auditDtos.stream().map(AuditDto::getAuditCode).collect(Collectors.toList());
        this.auditService.updateRejectByAuditCodes(rejectCodes);
        for (AuditDto auditDto : auditDtos) {
            this.cancelChargeAgainstPrepayAmount(auditDto);
            this.returnAuditBudget(auditDto);
            this.paymentRejectProcessStatusHandle(auditDto, processStatus);
        }
    }

    private void paymentRejectProcessStatusHandle(AuditDto auditDto, String processStatus) {
        if (ObjectUtil.isNull((Object)auditDto) || !CharSequenceUtil.equals((CharSequence)auditDto.getPaymentType(), (CharSequence)"1")) {
            return;
        }
        String auditCode = auditDto.getAuditCode();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        PaymentReceiptVo paymentReceiptVo = this.paymentReceiptSdkService.findByAuditCode(auditCode);
        if (ObjectUtil.isNull((Object)paymentReceiptVo)) {
            return;
        }
        PaymentReceiptDto paymentReceiptDto = new PaymentReceiptDto();
        paymentReceiptDto.setProcessState(processStatus);
        paymentReceiptDto.setPaySuccessDate(dateFormat.format(new Date()));
        paymentReceiptDto.setPaymentReceiptCode(paymentReceiptVo.getPaymentReceiptCode());
        this.paymentReceiptSdkService.updatePaymentReceiptProcess(paymentReceiptDto);
    }

    private void returnAuditBudget(AuditDto auditDto) {
        IAudit thisAudit = this.getAudit(auditDto);
        thisAudit.returnAuditBudget(auditDto, AuditUseBudgetTypeEnum.USE_RETURN);
    }

    private void cancelChargeAgainstPrepayAmount(AuditDto auditDto) {
        IAudit thisAudit = this.getAudit(auditDto);
        thisAudit.cancelChargeAgainstPrepayAmount(auditDto);
    }

    private void returnInvoices(AuditDto auditDto) {
        IAudit thisAudit = this.getAudit(auditDto);
        thisAudit.returnInvoices(auditDto);
    }

    public IAudit getAudit(AuditDto audit) {
        for (IAudit audit1 : this.auditStrategyList) {
            if (!audit1.isSupport(audit)) continue;
            return audit1;
        }
        for (IAudit iAudit : this.auditStrategyList) {
            if (!iAudit.isDefault()) continue;
            return iAudit;
        }
        return null;
    }
}

