/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.audit;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.sap.fi.sdk.dto.AccountingVoucherDto;
import com.biz.crm.mn.third.system.sap.fi.sdk.vo.SapAccountingVoucherVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormAuditDto;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.local.entity.Audit;
import com.biz.crm.tpm.business.audit.local.entity.AuditInfo;
import com.biz.crm.tpm.business.audit.local.entity.AuditInfoAttachment;
import com.biz.crm.tpm.business.audit.local.entity.AuditInvoice;
import com.biz.crm.tpm.business.audit.local.entity.AuditSupplierDetail;
import com.biz.crm.tpm.business.audit.local.entity.AuditSupplierMaterialPurchase;
import com.biz.crm.tpm.business.audit.local.repository.AuditSupplierAlreadyAmountRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditSupplierInfoRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditSupplierMaterialFileRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditSupplierMaterialPurchaseRepository;
import com.biz.crm.tpm.business.audit.local.service.audit.AbstractAudit;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditBatchSubmitDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditOutDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditSupplierAlreadyAmountDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditSupplierDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.QueryAuditInfoDto;
import com.biz.crm.tpm.business.audit.sdk.dto.log.AuditLogEventDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CacheTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.SaveTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.SuccessAndFailEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.event.log.AuditEventLogListener;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInfoAttachmentVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInfoVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditPayPrepayVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditPayVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierMaterialFileVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierMaterialPurchaseVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.tpm.business.audit.sdk.vo.SupplierAuditDetailExportsVo;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.service.TpmMaterialPurchasingOrderService;
import com.biz.crm.tpm.business.material.purchasing.order.sdk.vo.TpmMaterialPurchasingOrderAuditFileVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.AuditUseBudgetTypeEnum;
import com.biz.crm.tpm.business.month.budget.sdk.vo.ChangeBudgetVo;
import com.biz.crm.tpm.business.prepayment.details.sdk.service.PrepaymentDetailsService;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.BeachPrepaymentDetailsVo;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.PrepaymentDetailsVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SupplierAuditImpl
extends AbstractAudit {
    private static final Logger log = LoggerFactory.getLogger(SupplierAuditImpl.class);
    @Autowired(required=false)
    private AuditSupplierInfoRepository auditSupplierInfoRepository;
    @Autowired(required=false)
    private PrepaymentDetailsService prepaymentDetailsService;
    @Autowired(required=false)
    private AuditSupplierMaterialPurchaseRepository auditSupplierMaterialPurchaseRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private TpmMaterialPurchasingOrderService materialPurchasingOrderService;
    @Autowired(required=false)
    private AuditSupplierMaterialFileRepository auditSupplierMaterialFileRepository;
    @Autowired(required=false)
    private AuditSupplierAlreadyAmountRepository auditSupplierAlreadyAmountRepository;

    public boolean isSupport(AuditDto auditDto) {
        if (auditDto == null) {
            return false;
        }
        return EndCaseTypeEnum.SUPPLIER.getCode().equals(auditDto.getEndCaseType());
    }

    public void create(AuditDto audit) {
        Audit auditEntity = super.createAudit(audit, null, null);
        audit.setAuditCode(auditEntity.getAuditCode());
        List<AuditSupplierDetailVo> auditSupplierDetailVoList = this.findSupplierAuditDetailFromCache(audit.getCacheKey());
        if (!SaveTypeEnum.TEMPORARY_SAVE.getCode().equals(audit.getSaveType())) {
            this.createValidateDetail(auditSupplierDetailVoList);
        }
        this.webSocketHelper.sendMsg("\u6821\u9a8c\u6570\u636e\u7ed3\u675f");
        if (CollectionUtils.isNotEmpty(auditSupplierDetailVoList)) {
            ArrayList<AuditSupplierMaterialPurchaseVo> auditSupplierMaterialPurchaseVoList = new ArrayList<AuditSupplierMaterialPurchaseVo>();
            int i = 0;
            int size = auditSupplierDetailVoList.size();
            for (AuditSupplierDetailVo auditSupplierDetailVo : auditSupplierDetailVoList) {
                if (++i % 2000 == 0) {
                    this.webSocketHelper.sendMsg("\u4fdd\u5b58\u4f9b\u5e94\u5546\u6838\u9500\u660e\u7ec6\u6570\u636e\u3010" + i + "/" + size + "\u3011");
                }
                auditSupplierDetailVo.setAuditCode(auditEntity.getAuditCode());
                String code2 = (String)this.generateCodeService.generateCode("HM", 1, Integer.valueOf(5), 0L, TimeUnit.DAYS).get(0);
                auditSupplierDetailVo.setAuditDetailCode(code2);
                auditSupplierDetailVo.setTenantCode(TenantUtils.getTenantCode());
                List activityDetailItemList = auditSupplierDetailVo.getActivityDetailItemList();
                for (String activityDetailItemCode : activityDetailItemList) {
                    AuditSupplierMaterialPurchaseVo auditSupplierMaterialPurchaseVo = new AuditSupplierMaterialPurchaseVo();
                    auditSupplierMaterialPurchaseVo.setAuditCode(auditEntity.getAuditCode());
                    auditSupplierMaterialPurchaseVo.setAuditDetailCode(code2);
                    auditSupplierMaterialPurchaseVo.setActivityDetailItemCode(activityDetailItemCode);
                    auditSupplierMaterialPurchaseVoList.add(auditSupplierMaterialPurchaseVo);
                }
            }
            Collection auditSupplierDetails = this.nebulaToolkitService.copyCollectionByBlankList(auditSupplierDetailVoList, AuditSupplierDetailVo.class, AuditSupplierDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            auditSupplierDetails.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            this.auditSupplierDetailRepository.saveBatch(auditSupplierDetails);
            if (CollectionUtils.isNotEmpty(auditSupplierMaterialPurchaseVoList)) {
                this.webSocketHelper.sendMsg("\u4fdd\u5b58\u5173\u8054\u5173\u7cfb");
                Collection auditSupplierMaterialPurchases = this.nebulaToolkitService.copyCollectionByWhiteList(auditSupplierMaterialPurchaseVoList, AuditSupplierMaterialPurchaseVo.class, AuditSupplierMaterialPurchase.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                auditSupplierMaterialPurchases.forEach(item -> {
                    item.setId(null);
                    item.setTenantCode(TenantUtils.getTenantCode());
                });
                this.auditSupplierMaterialPurchaseRepository.saveBatch(auditSupplierMaterialPurchases);
                this.webSocketHelper.sendMsg("\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u7ed3\u675f");
            }
        }
        this.saveInvoiceInfo(this.getAuditInvoiceFromCache(audit.getCacheKey()), audit);
        this.saveAuditInfoFromCache(auditEntity.getAuditCode(), audit.getCacheKey());
        this.deleteAuditDetailCache(audit.getCacheKey());
        this.deleteAuditInfoCache(audit.getCacheKey());
        if (SaveTypeEnum.SUBMIT.getCode().equals(audit.getSaveType())) {
            this.supplierSubmitApproval(audit, audit.getProcessBusiness());
        }
        AuditLogEventDto logEventDto = new AuditLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(audit);
        SerializableBiConsumer & Serializable onCreate = AuditEventLogListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditEventLogListener.class, (SerializableBiConsumer)onCreate);
    }

    private void deleteAuditInfoCache(String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.redisTemplate.delete((Object)(cacheKey + CacheTypeEnum.AUDIT_INFO.getCode()));
    }

    public AuditVo findAuditInfo(QueryAuditInfoDto dto) {
        String cacheKey = dto.getCacheKey();
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditVo auditVo = new AuditVo();
        List<AuditInfoVo> auditInfoVoList = this.getAuditInfoFromCache(cacheKey);
        auditVo.setAuditInfoList(auditInfoVoList);
        List<AuditSupplierDetailVo> detail = this.findSupplierAuditDetailFromCache(cacheKey);
        if (CollectionUtils.isNotEmpty(detail)) {
            auditVo.setAppendices(detail.get(0).getAppendices());
        }
        return auditVo;
    }

    private void saveAuditInfoFromCache(String auditCode, String cacheKey) {
        List<AuditInfoVo> auditInfoVos = this.findAuditInfoFromCache(cacheKey);
        if (CollectionUtils.isNotEmpty(auditInfoVos)) {
            this.auditInfoRepository.deleteByAuditCode(auditCode);
            this.auditInfoAttachmentRepository.deleteByAuditCode(auditCode);
            for (AuditInfoVo auditInfoVo : auditInfoVos) {
                AuditInfo auditInfo = (AuditInfo)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)auditInfoVo, AuditInfo.class, null, null, new String[0]));
                auditInfo.setId(null);
                auditInfo.setTenantCode(TenantUtils.getTenantCode());
                auditInfo.setAuditCode(auditCode);
                this.auditInfoRepository.save((Object)auditInfo);
                List auditInfoAttachmentVoList = auditInfoVo.getAuditInfoAttachmentVoList();
                if (!CollectionUtils.isNotEmpty((Collection)auditInfoAttachmentVoList)) continue;
                Collection auditInfoAttachments = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditInfoAttachmentVoList, AuditInfoAttachmentVo.class, AuditInfoAttachment.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                auditInfoAttachments.forEach(item -> {
                    item.setId(null);
                    item.setTenantCode(TenantUtils.getTenantCode());
                    item.setAuditInfoId(auditInfo.getId());
                    item.setAuditCode(auditCode);
                });
                this.auditInfoAttachmentRepository.saveBatch(auditInfoAttachments);
            }
        }
    }

    private List<AuditInfoVo> findAuditInfoFromCache(String cacheKey) {
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)(cacheKey = cacheKey + CacheTypeEnum.AUDIT_INFO.getCode())))) {
            List range = this.redisTemplate.opsForList().range((Object)cacheKey, 0L, -1L);
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
            return range;
        }
        return Lists.newArrayList();
    }

    public List<String> findCacheMaterialPurchaseCode(AuditDto dto) {
        List<AuditSupplierDetailVo> auditSupplierDetailVoList;
        String cacheKey = dto.getCacheKey();
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)cacheKey) || StringUtils.isNotEmpty((CharSequence)dto.getAuditCode()) ? 1 : 0) != 0, (String)"\u7f13\u5b58key\u6216\u8005\u6838\u9500\u5355\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)cacheKey) && CollectionUtils.isNotEmpty(auditSupplierDetailVoList = this.findSupplierAuditDetailFromCache(cacheKey))) {
            return auditSupplierDetailVoList.stream().map(AuditSupplierDetailVo::getPurchaseCode).collect(Collectors.toList());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getAuditCode()) && CollectionUtils.isNotEmpty(auditSupplierDetailVoList = this.auditSupplierDetailRepository.findVoListByAuditCode(dto.getAuditCode()))) {
            return auditSupplierDetailVoList.stream().map(AuditSupplierDetailVo::getPurchaseCode).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void supplierSubmitApproval(AuditDto dto, ProcessBusinessDto processBusiness) {
        Validate.notNull((Object)dto, (String)"\u63d0\u4ea4\u5ba1\u6279\u6d41\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.submitApprovalValidate(dto);
        boolean hasLock = false;
        String redisLockKey = String.format("AUDIT_SUPPLIER_SUBMIT_LOCK_KEY:%s", dto.getAuditCode());
        try {
            hasLock = this.redisLockService.tryLock(redisLockKey, TimeUnit.SECONDS, 30L);
            Validate.isTrue((boolean)hasLock, (String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
            processBusiness.setBusinessNo(dto.getAuditCode());
            processBusiness.setProcessTitle(dto.getAuditName());
            JSONObject jsonObject = JsonUtils.toJSONObject((Object)dto);
            processBusiness.setBusinessFormJson(jsonObject.toJSONString());
            processBusiness.setBusinessCode("supplier_ordinary_audit_process");
            ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
            Audit audit = new Audit();
            audit.setId(dto.getId());
            audit.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
            audit.setProcessNo(processBusinessVo.getProcessNo());
            this.auditRepository.updateById((Object)audit);
        }
        finally {
            if (hasLock) {
                this.redisLockService.unlock(redisLockKey);
            }
        }
    }

    private void createValidateDetail(List<AuditSupplierDetailVo> auditSupplierDetailVoList) {
        if (CollectionUtils.isNotEmpty(auditSupplierDetailVoList)) {
            int i = 0;
            for (AuditSupplierDetailVo item : auditSupplierDetailVoList) {
                Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)item.getEndCaseFormList()), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (long)(++i));
                Validate.isTrue((item.getEndCaseFormList().size() == 1 ? 1 : 0) != 0, (String)"\u884c\u9879\u76ee\u3010%s\u3011\u7ed3\u6848\u5f62\u5f0f\u53ea\u80fd\u662f\u62a5\u9500", (long)i);
                Validate.isTrue((boolean)item.getEndCaseFormList().contains(EndCaseFormEnum.REIMBURSE.getCode()), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u7ed3\u6848\u5f62\u5f0f\u53ea\u80fd\u662f\u62a5\u9500", (long)i);
                Validate.notNull((Object)item.getWholeAudit(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notNull((Object)item.getThisEndCaseTaxAmount(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u672c\u6b21\u7ed3\u6848\u91d1\u989d(\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notBlank((CharSequence)item.getTaxRate(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notBlank((CharSequence)item.getReimburseItem(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u62a5\u9500\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notBlank((CharSequence)item.getCostCenter(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notBlank((CharSequence)item.getProfitCenter(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u5229\u6da6\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
            }
            long count = auditSupplierDetailVoList.stream().map(AuditSupplierDetailVo::getSupplierCode).distinct().count();
            Validate.isTrue((count <= 1L ? 1 : 0) != 0, (String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u4f9b\u5e94\u5546", (Object[])new Object[0]);
        }
    }

    private void deleteAuditDetailCache(String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.redisTemplate.delete((Object)(cacheKey + CacheTypeEnum.SUPPLIER_AUDIT_DETAIL.getCode()));
    }

    public void update(AuditDto audit) {
        AuditDto oldDto = new AuditDto();
        Audit auditEntity = super.updateAudit(audit, oldDto, null, null, null);
        List<AuditSupplierDetailVo> auditSupplierDetailVoList = this.findSupplierAuditDetailFromCache(audit.getCacheKey());
        log.info("\u4f9b\u5e94\u5546\u7269\u6599\u8d39\u7ed3\u6848\u7f13\u5b58\u6570\u636e:auditSupplierDetailVoList:{}", (Object)JsonUtils.obj2JsonString(auditSupplierDetailVoList));
        if (!SaveTypeEnum.TEMPORARY_SAVE.getCode().equals(audit.getSaveType())) {
            this.createValidateDetail(auditSupplierDetailVoList);
        }
        this.auditSupplierDetailRepository.remove((Wrapper)Wrappers.lambdaUpdate(AuditSupplierDetail.class).eq(AuditSupplierDetail::getAuditCode, (Object)auditEntity.getAuditCode()));
        if (CollectionUtils.isNotEmpty(auditSupplierDetailVoList)) {
            ArrayList<AuditSupplierMaterialPurchaseVo> auditSupplierMaterialPurchaseVoList = new ArrayList<AuditSupplierMaterialPurchaseVo>();
            for (AuditSupplierDetailVo auditSupplierDetailVo : auditSupplierDetailVoList) {
                auditSupplierDetailVo.setAuditCode(auditEntity.getAuditCode());
                if (!StringUtils.isEmpty((CharSequence)auditSupplierDetailVo.getAuditDetailCode())) continue;
                String code2 = (String)this.generateCodeService.generateCode("HM", 1, Integer.valueOf(5), 0L, TimeUnit.DAYS).get(0);
                auditSupplierDetailVo.setAuditDetailCode(code2);
                List activityDetailItemList = auditSupplierDetailVo.getActivityDetailItemList();
                for (String activityDetailItemCode : activityDetailItemList) {
                    AuditSupplierMaterialPurchaseVo auditSupplierMaterialPurchaseVo = new AuditSupplierMaterialPurchaseVo();
                    auditSupplierMaterialPurchaseVo.setAuditCode(auditEntity.getAuditCode());
                    auditSupplierMaterialPurchaseVo.setAuditDetailCode(code2);
                    auditSupplierMaterialPurchaseVo.setActivityDetailItemCode(activityDetailItemCode);
                    auditSupplierMaterialPurchaseVoList.add(auditSupplierMaterialPurchaseVo);
                }
            }
            Collection auditSupplierDetails = this.nebulaToolkitService.copyCollectionByBlankList(auditSupplierDetailVoList, AuditSupplierDetailVo.class, AuditSupplierDetail.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            auditSupplierDetails.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            this.auditSupplierDetailRepository.saveBatch(auditSupplierDetails);
            if (CollectionUtils.isNotEmpty(auditSupplierMaterialPurchaseVoList)) {
                this.auditSupplierMaterialPurchaseRepository.deleteByAuditCode(auditEntity.getAuditCode());
                this.webSocketHelper.sendMsg("\u4fdd\u5b58\u5173\u8054\u5173\u7cfb");
                Collection auditSupplierMaterialPurchases = this.nebulaToolkitService.copyCollectionByWhiteList(auditSupplierMaterialPurchaseVoList, AuditSupplierMaterialPurchaseVo.class, AuditSupplierMaterialPurchase.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                auditSupplierMaterialPurchases.forEach(item -> {
                    item.setId(null);
                    item.setTenantCode(TenantUtils.getTenantCode());
                });
                this.auditSupplierMaterialPurchaseRepository.saveBatch(auditSupplierMaterialPurchases);
                this.webSocketHelper.sendMsg("\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u7ed3\u675f");
            }
        }
        HashSet<String> setAuditCode = new HashSet<String>();
        setAuditCode.add(auditEntity.getAuditCode());
        this.updateAuditInvoiceRelation(setAuditCode);
        this.saveInvoiceInfo(this.getAuditInvoiceFromCache(audit.getCacheKey()), audit);
        this.saveAuditInfoFromCache(auditEntity.getAuditCode(), audit.getCacheKey());
        if (SaveTypeEnum.SUBMIT.getCode().equals(audit.getSaveType())) {
            this.supplierSubmitApproval(audit, audit.getProcessBusiness());
        }
        this.deleteAuditDetailCache(audit.getCacheKey());
        AuditLogEventDto logEventDto = new AuditLogEventDto();
        logEventDto.setOriginal(oldDto);
        logEventDto.setNewest(audit);
        SerializableBiConsumer & Serializable onUpdate = AuditEventLogListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditEventLogListener.class, (SerializableBiConsumer)onUpdate);
    }

    private void updateValidateDetail(List<AuditSupplierDetailVo> auditSupplierDetailVoList) {
        if (CollectionUtils.isNotEmpty(auditSupplierDetailVoList)) {
            int i = 0;
            for (AuditSupplierDetailVo item : auditSupplierDetailVoList) {
                Validate.notNull((Object)item.getThisEndCaseAmount(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u672c\u6b21\u7ed3\u6848\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{++i});
                Validate.notNull((Object)item.getWholeAudit(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notBlank((CharSequence)item.getTaxRate(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notBlank((CharSequence)item.getReimburseItem(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u62a5\u9500\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notBlank((CharSequence)item.getCostCenter(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u6210\u672c\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
                Validate.notBlank((CharSequence)item.getProfitCenter(), (String)"\u884c\u9879\u76ee\u3010%s\u3011\u5229\u6da6\u4e2d\u5fc3\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
            }
        }
    }

    public AuditVo findByAuditCode(String auditCode) {
        AuditVo auditVo = super.findAuditByAuditCode(auditCode);
        String cacheKey = "AUDIT:" + auditVo.getAuditCode();
        auditVo.setCacheKey(cacheKey);
        List auditSupplierDetails = ((LambdaQueryChainWrapper)this.auditSupplierDetailRepository.lambdaQuery().eq(AuditSupplierDetail::getAuditCode, (Object)auditVo.getAuditCode())).list();
        List<AuditInvoiceVo> auditInvoiceVos = this.findAuditInvoice(auditCode, cacheKey);
        if (CollectionUtils.isNotEmpty((Collection)auditSupplierDetails)) {
            List<AuditSupplierMaterialPurchaseVo> auditSupplierMaterialPurchaseVos = this.auditSupplierMaterialPurchaseRepository.findByAuditCode(auditCode);
            Map<Object, Object> auditSupplierMaterialPurchaseMap = new HashMap();
            if (CollectionUtils.isNotEmpty(auditSupplierMaterialPurchaseVos)) {
                auditSupplierMaterialPurchaseMap = auditSupplierMaterialPurchaseVos.stream().collect(Collectors.groupingBy(AuditSupplierMaterialPurchaseVo::getAuditDetailCode));
            }
            Collection auditSupplierDetailVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)auditSupplierDetails, AuditSupplierDetail.class, AuditSupplierDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            for (AuditSupplierDetailVo auditSupplierDetailVo : auditSupplierDetailVos) {
                List auditSupplierMaterialPurchaseVos1 = (List)auditSupplierMaterialPurchaseMap.get(auditSupplierDetailVo.getAuditDetailCode());
                auditSupplierDetailVo.setActivityDetailItemList(auditSupplierMaterialPurchaseVos1.stream().map(AuditSupplierMaterialPurchaseVo::getActivityDetailItemCode).collect(Collectors.toList()));
                this.setAuditInvoiceForDetail(auditSupplierDetailVo, auditInvoiceVos);
            }
            this.cacheSupplierAuditDetail(cacheKey, (List)auditSupplierDetailVos);
        }
        this.findAuditInfoByAuditCode(auditCode);
        return auditVo;
    }

    private List<AuditInvoice> findAuditInfoByAuditCode(String auditCode) {
        String cacheKey;
        List<AuditInfo> list = this.auditInfoRepository.findByCode(auditCode);
        List<AuditInvoice> invoiceList = this.auditInvoiceRepository.findByAuditCode(auditCode);
        if (CollectionUtils.isNotEmpty(list)) {
            Set<String> auditInfoIds = list.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            List auditInfoVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(list, AuditInfo.class, AuditInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            List<AuditInfoAttachment> infoAttachments = this.auditInfoAttachmentRepository.findByIds(auditInfoIds);
            if (CollectionUtils.isNotEmpty(infoAttachments)) {
                Collection auditInfoAttachmentVos = this.nebulaToolkitService.copyCollectionByBlankList(infoAttachments, AuditInfoAttachment.class, AuditInfoAttachmentVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                Map<String, List<AuditInfoAttachmentVo>> attachmentVoMap = auditInfoAttachmentVos.stream().collect(Collectors.groupingBy(AuditInfoAttachmentVo::getAuditInfoId));
                auditInfoVos.forEach(i -> {
                    List infoAttachmentVos = (List)attachmentVoMap.get(i.getId());
                    i.setAuditInfoAttachmentVoList(infoAttachmentVos);
                });
            }
            cacheKey = "AUDIT:" + auditCode + CacheTypeEnum.AUDIT_INFO.getCode();
            this.redisTemplate.delete((Object)cacheKey);
            this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, auditInfoVos.toArray());
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        }
        if (CollectionUtils.isNotEmpty(invoiceList)) {
            List auditInvoiceVos = (List)this.nebulaToolkitService.copyCollectionByBlankList(invoiceList, AuditInvoice.class, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            cacheKey = "AUDIT:" + auditCode + CacheTypeEnum.AUDIT_INVOICE.getCode();
            this.redisTemplate.delete((Object)cacheKey);
            this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, auditInvoiceVos.toArray());
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        }
        return invoiceList;
    }

    private void setAuditInvoiceForDetail(AuditSupplierDetailVo auditSupplierDetailVo, List<AuditInvoiceVo> auditInvoices) {
        if (Objects.isNull(auditSupplierDetailVo)) {
            return;
        }
        if (CollectionUtils.isEmpty(auditInvoices)) {
            return;
        }
        String invoiceCode = null;
        String invoiceNumber = null;
        for (AuditInvoiceVo auditInvoice : auditInvoices) {
            if (StringUtils.isEmpty((CharSequence)auditInvoice.getInvoiceCode())) {
                auditInvoice.setInvoiceCode("0");
            }
            invoiceCode = StringUtils.isEmpty(invoiceCode) ? auditInvoice.getInvoiceCode() : invoiceCode + "," + auditInvoice.getInvoiceCode();
            if (StringUtils.isEmpty(invoiceNumber)) {
                invoiceNumber = auditInvoice.getInvoiceNumber();
                continue;
            }
            invoiceNumber = invoiceNumber + "," + auditInvoice.getInvoiceNumber();
        }
        auditSupplierDetailVo.setInvoiceCode(invoiceCode);
        auditSupplierDetailVo.setInvoiceNumber(invoiceNumber);
    }

    private List<AuditInvoiceVo> findAuditInvoice(String auditCode, String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditInvoiceVo> auditInvoiceVos = this.findInvoiceFromCache(cacheKey);
        if (CollectionUtils.isEmpty(auditInvoiceVos)) {
            List<AuditInvoice> auditInvoices = this.auditInvoiceRepository.findByAuditCode(auditCode);
            if (CollectionUtils.isEmpty(auditInvoices)) {
                return Lists.newArrayList();
            }
            Collection auditInvoiceVos1 = this.nebulaToolkitService.copyCollectionByWhiteList(auditInvoices, AuditInvoice.class, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)auditInvoiceVos1;
        }
        return auditInvoiceVos;
    }

    private List<AuditInvoiceVo> findInvoiceFromCache(String cacheKey) {
        cacheKey = cacheKey + CacheTypeEnum.AUDIT_INVOICE.getCode();
        List<Object> auditInvoiceVoList = new ArrayList<AuditInvoiceVo>();
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)cacheKey))) {
            auditInvoiceVoList = this.redisTemplate.opsForList().range((Object)cacheKey, 0L, -1L);
            return auditInvoiceVoList;
        }
        return auditInvoiceVoList;
    }

    public String saveSupplierAuditDetail(AuditVo vo) {
        Validate.notNull((Object)vo, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)vo.getAuditSupplierDetailDtoList()), (String)"\u4f9b\u5e94\u5546\u6838\u9500\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)vo.getCacheKey())) {
            vo.setCacheKey("AUDIT:" + UuidCrmUtil.general());
        }
        List auditSupplierDetailList = vo.getAuditSupplierDetailDtoList();
        List<AuditSupplierDetailVo> supplierAuditDetailCache = this.findSupplierAuditDetailFromCache(vo.getCacheKey());
        log.info("\u7269\u6599\u8d39\u6838\u9500\u4fdd\u5b58\u7f13\u5b58\uff1a\u7f13\u5b58key:{},supplierAuditDetailCache\uff1a{}", (Object)vo.getCacheKey(), (Object)JsonUtils.obj2JsonString(supplierAuditDetailCache));
        auditSupplierDetailList.addAll(supplierAuditDetailCache);
        Map<String, List<AuditSupplierDetailVo>> collect = auditSupplierDetailList.stream().collect(Collectors.groupingBy(o -> o.getPurchaseCode() + o.getSupplierCode() + o.getMaterialCode()));
        HashSet purchaseCodeList = new HashSet();
        ArrayList<AuditSupplierDetailVo> sumSupplierDetailList = new ArrayList<AuditSupplierDetailVo>();
        collect.forEach((key, value) -> {
            value.forEach(item -> purchaseCodeList.add(item.getPurchaseCode()));
            AuditSupplierDetailVo auditSupplierDetailVo = new AuditSupplierDetailVo();
            BeanUtils.copyProperties(value.get(0), (Object)auditSupplierDetailVo);
            if (StringUtils.isNotEmpty((CharSequence)auditSupplierDetailVo.getId())) {
                auditSupplierDetailVo.setId(UuidCrmUtil.general());
            }
            if (StringUtils.isEmpty((CharSequence)auditSupplierDetailVo.getEndCaseForm())) {
                auditSupplierDetailVo.setEndCaseForm(EndCaseFormEnum.REIMBURSE.getCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)auditSupplierDetailVo.getEndCaseForm())) {
                String[] split = auditSupplierDetailVo.getEndCaseForm().split(",");
                auditSupplierDetailVo.setEndCaseFormList(Arrays.asList(split));
            }
            auditSupplierDetailVo.setPurchaseAmount(value.stream().map(AuditSupplierDetailVo::getPurchaseAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            auditSupplierDetailVo.setPurchaseQuantity(value.stream().map(AuditSupplierDetailVo::getPurchaseQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            auditSupplierDetailVo.setSignQuantity(value.stream().map(AuditSupplierDetailVo::getSignQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            auditSupplierDetailVo.setActivityDetailItemList(value.stream().map(AuditSupplierDetailVo::getActivityDetailItemCode).collect(Collectors.toList()));
            sumSupplierDetailList.add(auditSupplierDetailVo);
        });
        this.cacheSupplierAuditDetail(vo.getCacheKey(), sumSupplierDetailList);
        return vo.getCacheKey();
    }

    private void addMaterialPurchaseAuditInfoToCache(Set<String> purchaseCodeList, Set<String> activityFormCodeList, String cacheKey) {
        if (CollectionUtils.isEmpty(purchaseCodeList)) {
            return;
        }
        this.clearAuditInfoCache(cacheKey);
        List<AuditInfoVo> auditInfoVoList = this.findActivityFormAuditInfo(activityFormCodeList);
        this.findMaterialPurchasingOrderAuditInfo(auditInfoVoList, purchaseCodeList);
        this.cacheSupplierAuditInfo(auditInfoVoList, cacheKey);
    }

    private void cacheSupplierAuditInfo(List<AuditInfoVo> auditInfoVoList, String cacheKey) {
        if (CollectionUtils.isEmpty(auditInfoVoList)) {
            return;
        }
        if (StringUtils.isEmpty((CharSequence)cacheKey)) {
            return;
        }
        cacheKey = cacheKey + CacheTypeEnum.AUDIT_INFO.getCode();
        this.redisTemplate.delete((Object)cacheKey);
        this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, auditInfoVoList.toArray());
        this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
    }

    private void findMaterialPurchasingOrderAuditInfo(List<AuditInfoVo> auditInfoVoList, Set<String> purchaseCodeList) {
        List auditFileVoList;
        if (CollectionUtils.isNotEmpty(auditInfoVoList) && CollectionUtils.isNotEmpty((Collection)(auditFileVoList = this.materialPurchasingOrderService.findAuditInfoByPurchaseCodes(purchaseCodeList)))) {
            AuditInfoVo auditInfoVo = auditInfoVoList.get(0);
            ArrayList<AuditInfoAttachmentVo> attachmentVoList = new ArrayList<AuditInfoAttachmentVo>();
            for (TpmMaterialPurchasingOrderAuditFileVo tpmMaterialPurchasingOrderAuditFileVo : auditFileVoList) {
                AuditInfoAttachmentVo auditInfoAttachmentVo = new AuditInfoAttachmentVo();
                auditInfoAttachmentVo.setFileCode(tpmMaterialPurchasingOrderAuditFileVo.getFileCode());
                auditInfoAttachmentVo.setOriginalFileName(tpmMaterialPurchasingOrderAuditFileVo.getOriginalFileName());
                attachmentVoList.add(auditInfoAttachmentVo);
            }
            auditInfoVo.setAuditInfoAttachmentVoList(attachmentVoList);
        }
    }

    private List<AuditInfoVo> findActivityFormAuditInfo(Set<String> activityFormCodeList) {
        ArrayList<AuditInfoVo> auditInfoVoList = new ArrayList<AuditInfoVo>();
        List activityFormVos = this.activityFormService.findActivityFormByCode(activityFormCodeList);
        if (CollectionUtils.isNotEmpty((Collection)activityFormVos)) {
            for (ActivityFormVo activityFormVo : activityFormVos) {
                List activityFormAuditDtoList = activityFormVo.getActivityFormAuditDtoList();
                if (!CollectionUtils.isNotEmpty((Collection)activityFormAuditDtoList)) continue;
                for (ActivityFormAuditDto activityFormAuditDto : activityFormAuditDtoList) {
                    AuditInfoVo auditInfoVo = new AuditInfoVo();
                    auditInfoVo.setId(UUID.randomUUID().toString().replace("-", ""));
                    auditInfoVo.setActivityFormCode(activityFormVo.getActivityFormCode());
                    auditInfoVo.setActivityFormName(activityFormVo.getActivityFormName());
                    if (Objects.nonNull(activityFormAuditDto.getMnApprovalCollect())) {
                        auditInfoVo.setDescription(activityFormAuditDto.getMnApprovalCollect().getName());
                    }
                    auditInfoVoList.add(auditInfoVo);
                }
            }
        }
        return auditInfoVoList;
    }

    public Page<AuditSupplierDetailVo> queryAuditSupplierDetailInfo(Pageable pageable, AuditDto auditDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isEmpty((CharSequence)auditDto.getCacheKey())) {
            return page;
        }
        String cacheKey = auditDto.getCacheKey() + CacheTypeEnum.SUPPLIER_AUDIT_DETAIL.getCode();
        if (Boolean.FALSE.equals(this.redisTemplate.hasKey((Object)cacheKey))) {
            this.findByAuditCode(auditDto.getId());
        }
        Long size = this.redisTemplate.opsForList().size((Object)cacheKey);
        page.setTotal(size.longValue());
        List range = this.redisTemplate.opsForList().range((Object)cacheKey, (long)((pageable.getPageNumber() - 1) * pageable.getPageSize()), (long)(pageable.getPageNumber() * pageable.getPageSize() - 1));
        if (CollectionUtils.isEmpty((Collection)range)) {
            return page;
        }
        ArrayList<AuditSupplierDetailVo> auditSupplierDetailVoList = new ArrayList<AuditSupplierDetailVo>();
        for (Object o : range) {
            AuditSupplierDetailVo auditSupplierDetailVo = (AuditSupplierDetailVo)o;
            List endCaseFormList = auditSupplierDetailVo.getEndCaseFormList();
            String endCaseForm = auditSupplierDetailVo.getEndCaseForm();
            if (CollectionUtils.isEmpty((Collection)endCaseFormList) && StringUtils.isNotBlank((CharSequence)endCaseForm)) {
                auditSupplierDetailVo.setEndCaseFormList(Stream.of(endCaseForm.split(",")).collect(Collectors.toList()));
            }
            auditSupplierDetailVoList.add(auditSupplierDetailVo);
        }
        this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        page.setRecords(auditSupplierDetailVoList);
        return page;
    }

    public void deleteSupplierDetail(AuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getIds()), (String)"\u8981\u5220\u9664\u7684\u4f9b\u5e94\u5546\u6838\u9500\u660e\u7ec6id\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditSupplierDetailVo> supplierAuditDetail = this.findSupplierAuditDetailFromCache(dto.getCacheKey());
        ArrayList<AuditSupplierDetailVo> auditSupplierDetailVoList = new ArrayList<AuditSupplierDetailVo>();
        supplierAuditDetail.forEach(item -> {
            if (dto.getIds().contains(item.getId())) {
                return;
            }
            auditSupplierDetailVoList.add((AuditSupplierDetailVo)item);
        });
        this.cacheSupplierAuditDetail(dto.getCacheKey(), auditSupplierDetailVoList);
    }

    public void changeSupplierAuditDetail(AuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getAuditSupplierDetailDtoList()), (String)"\u8981\u4fee\u6539\u7684\u4f9b\u5e94\u5546\u6838\u9500\u660e\u7ec6\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set idSets = dto.getAuditSupplierDetailDtoList().stream().map(UuidDto::getId).collect(Collectors.toSet());
        Map auditSupplierDetailMap = dto.getAuditSupplierDetailDtoList().stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        List<AuditSupplierDetailVo> supplierAuditDetailList = this.findSupplierAuditDetailFromCache(dto.getCacheKey());
        ArrayList<AuditSupplierDetailVo> auditSupplierDetailList = new ArrayList<AuditSupplierDetailVo>();
        supplierAuditDetailList.forEach(item -> {
            if (idSets.contains(item.getId())) {
                AuditSupplierDetailDto auditSupplierDetailDto = (AuditSupplierDetailDto)auditSupplierDetailMap.get(item.getId());
                BeanUtils.copyProperties((Object)auditSupplierDetailDto, (Object)item);
                item.setAuditInfoVoList(auditSupplierDetailDto.getAuditInfoAttachmentDtoList());
                if (StringUtils.isEmpty((CharSequence)item.getTaxRate())) {
                    item.setTaxRate("0");
                }
                if (Objects.nonNull(item.getThisEndCaseTaxAmount()) && StringUtils.isNotEmpty((CharSequence)item.getTaxRate())) {
                    item.setThisEndCaseAmount(item.getThisEndCaseTaxAmount().divide(new BigDecimal(item.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP).add(BigDecimal.ONE), 6, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
                }
                if (Objects.nonNull(item.getThisEndCaseAmount()) && StringUtils.isNotEmpty((CharSequence)item.getTaxRate())) {
                    item.setTaxQuota(item.getThisEndCaseAmount().multiply(new BigDecimal(item.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP)));
                }
            }
            auditSupplierDetailList.add((AuditSupplierDetailVo)item);
        });
        this.cacheSupplierAuditDetail(dto.getCacheKey(), auditSupplierDetailList);
    }

    public void batchChangePayWay(AuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getIds()), (String)"\u8981\u4fee\u6539\u7684id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPayType(), (String)"\u9009\u62e9\u7684\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditSupplierDetailVo> supplierAuditDetailList = this.findSupplierAuditDetailFromCache(dto.getCacheKey());
        this.cacheSupplierAuditDetail(dto.getCacheKey(), supplierAuditDetailList);
    }

    public Integer getExportTotal(AuditDto auditDto) {
        Validate.notNull((Object)auditDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditSupplierDetailVo> supplierAuditDetails = this.findSupplierAuditDetailFromCache(auditDto.getCacheKey());
        return supplierAuditDetails.size();
    }

    public List<SupplierAuditDetailExportsVo> getSupplierExportData(AuditDto auditDto) {
        Validate.notNull((Object)auditDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditSupplierDetailVo> supplierAuditDetails = this.findSupplierAuditDetailFromCache(auditDto.getCacheKey());
        log.info("\u4f9b\u5e94\u5546\u660e\u7ec6\u5bfc\u51fa\u6570\u636e\uff1a{}", (Object)JsonUtils.obj2JsonString(supplierAuditDetails));
        if (CollectionUtils.isNotEmpty(supplierAuditDetails)) {
            Collection supplierAuditDetailExportsVos = this.nebulaToolkitService.copyCollectionByBlankList(supplierAuditDetails, AuditSupplierDetailVo.class, SupplierAuditDetailExportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            return (List)supplierAuditDetailExportsVos;
        }
        return new ArrayList<SupplierAuditDetailExportsVo>();
    }

    public void supplierImport(AuditDto auditDto) {
        Validate.notNull((Object)auditDto, (String)"\u8f93\u5165\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditDto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String cacheKey = auditDto.getCacheKey();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)auditDto.getAuditSupplierDetailDtoList()), (String)"\u4f9b\u5e94\u5546\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List canChangeSupplierDetailDto = auditDto.getAuditSupplierDetailDtoList();
        Map auditSupplierDetailDtoMap = canChangeSupplierDetailDto.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
        List<AuditSupplierDetailVo> supplierAuditDetailCache = this.findSupplierAuditDetailFromCache(auditDto.getCacheKey());
        for (AuditSupplierDetailVo auditSupplierDetailVo : supplierAuditDetailCache) {
            AuditSupplierDetailDto auditSupplierDetailDto = (AuditSupplierDetailDto)auditSupplierDetailDtoMap.get(auditSupplierDetailVo.getId());
            if (auditSupplierDetailDto == null) continue;
            if (Objects.nonNull(auditSupplierDetailDto.getThisEndCaseTaxAmount())) {
                auditSupplierDetailVo.setThisEndCaseTaxAmount(auditSupplierDetailDto.getThisEndCaseTaxAmount());
            }
            if (StringUtils.isNotEmpty((CharSequence)auditSupplierDetailDto.getTaxRate())) {
                auditSupplierDetailVo.setTaxRate(auditSupplierDetailDto.getTaxRate());
            }
            if (Objects.nonNull(auditSupplierDetailVo.getThisEndCaseTaxAmount()) && StringUtils.isNotEmpty((CharSequence)auditSupplierDetailVo.getTaxRate())) {
                auditSupplierDetailVo.setThisEndCaseAmount(auditSupplierDetailVo.getThisEndCaseTaxAmount().divide(new BigDecimal(auditSupplierDetailVo.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP).add(BigDecimal.ONE), 6, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
            }
            if (Objects.nonNull(auditSupplierDetailVo.getThisEndCaseAmount()) && StringUtils.isNotEmpty((CharSequence)auditSupplierDetailVo.getTaxRate())) {
                auditSupplierDetailVo.setTaxQuota(auditSupplierDetailVo.getThisEndCaseAmount().multiply(new BigDecimal(auditSupplierDetailVo.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP)));
            }
            if (StringUtils.isNotEmpty((CharSequence)auditSupplierDetailDto.getWholeAudit())) {
                auditSupplierDetailVo.setWholeAudit(auditSupplierDetailDto.getWholeAudit());
            }
            if (StringUtils.isNotEmpty((CharSequence)auditSupplierDetailDto.getPayWayCode())) {
                auditSupplierDetailVo.setPayWayCode(auditSupplierDetailDto.getPayWayCode());
            }
            if (StringUtils.isNotEmpty((CharSequence)auditSupplierDetailDto.getReimburseItem())) {
                auditSupplierDetailVo.setReimburseItem(auditSupplierDetailDto.getReimburseItem());
                auditSupplierDetailVo.setReimburseItemName(auditSupplierDetailDto.getReimburseItemName());
            }
            if (StringUtils.isNotEmpty((CharSequence)auditSupplierDetailDto.getCostCenter())) {
                auditSupplierDetailVo.setCostCenter(auditSupplierDetailDto.getCostCenter());
                auditSupplierDetailVo.setCostCenterName(auditSupplierDetailDto.getCostCenterName());
                auditSupplierDetailVo.setProfitCenter(auditSupplierDetailDto.getProfitCenter());
                auditSupplierDetailVo.setProfitCenterName(auditSupplierDetailDto.getProfitCenterName());
            }
            if (StringUtils.isNotEmpty((CharSequence)auditSupplierDetailDto.getDeemedSale())) {
                auditSupplierDetailVo.setDeemedSale(auditSupplierDetailDto.getDeemedSale());
            }
            if (!StringUtils.isNotEmpty((CharSequence)auditSupplierDetailDto.getIsPushSap())) continue;
            auditSupplierDetailVo.setIsPushSap(auditSupplierDetailDto.getIsPushSap());
        }
        this.cacheSupplierAuditDetail(cacheKey, supplierAuditDetailCache);
    }

    public void approvalPass(AuditDto dto) {
        List list = ((LambdaQueryChainWrapper)this.auditSupplierDetailRepository.lambdaQuery().eq(AuditSupplierDetail::getAuditCode, (Object)dto.getAuditCode())).list();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)list), (String)"\u672a\u627e\u5230\u6838\u9500\u4f9b\u5e94\u5546\u660e\u7ec6", (Object[])new Object[0]);
        ArrayList<AuditSupplierAlreadyAmountDto> auditSupplierAlreadyAmountDtos = new ArrayList<AuditSupplierAlreadyAmountDto>();
        for (AuditSupplierDetail auditSupplierDetail : list) {
            AuditSupplierAlreadyAmountDto auditSupplierAlreadyAmountDto = new AuditSupplierAlreadyAmountDto();
            auditSupplierAlreadyAmountDto.setPurchaseCode(auditSupplierDetail.getPurchaseCode());
            auditSupplierAlreadyAmountDto.setSupplierCode(auditSupplierDetail.getSupplierCode());
            auditSupplierAlreadyAmountDto.setMaterialCode(auditSupplierDetail.getMaterialCode());
            auditSupplierAlreadyAmountDto.setWholeAudit(auditSupplierDetail.getWholeAudit());
            auditSupplierAlreadyAmountDto.setAlreadyAuditAmount(auditSupplierDetail.getThisEndCaseAmount());
            auditSupplierAlreadyAmountDtos.add(auditSupplierAlreadyAmountDto);
        }
        this.auditSupplierAlreadyAmountRepository.updateAlreadyAmount(auditSupplierAlreadyAmountDtos);
        this.supplierUpAccount(dto.getAuditCode());
    }

    private void supplierUpAccount(String auditCode) {
        Audit audit = this.auditRepository.findOneByCode(auditCode);
        AuditVo auditVo = (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditVo.class, null, null, new String[0]);
        List<AuditSupplierDetailVo> auditSupplierDetailVoList = this.auditSupplierDetailRepository.findVoListByAuditCode(auditCode);
        ArrayList<AuditSupplierDetailVo> reimburseAuditSupplierDetailList = new ArrayList<AuditSupplierDetailVo>();
        for (AuditSupplierDetailVo item : auditSupplierDetailVoList) {
            if (UpAccountStatusEnum.UP_ACCOUNTED.getCode().equals(audit.getReimburseUpAccountStatus()) || !item.getEndCaseForm().contains(EndCaseFormEnum.REIMBURSE.getCode())) continue;
            reimburseAuditSupplierDetailList.add(item);
        }
        if (CollectionUtils.isNotEmpty(reimburseAuditSupplierDetailList)) {
            Audit audit1 = new Audit();
            List auditInvoiceList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditInvoiceRepository.lambdaQuery().eq(AuditInvoice::getAuditCode, (Object)auditVo.getAuditCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            try {
                audit1 = this.supplierReimburseUpAccount(auditVo, reimburseAuditSupplierDetailList, auditInvoiceList);
                audit1.setReimburseUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTED.getCode());
            }
            catch (Exception e) {
                log.error("\u4f9b\u5e94\u5546\u7ed3\u6848\u6838\u9500\u5931\u8d25\uff1a", (Throwable)e);
                audit1.setReimburseUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNT_FAILD.getCode());
            }
            this.auditRepository.updateById((Object)audit1);
            ArrayList auditInvoiceList1 = new ArrayList();
            auditInvoiceList.forEach(i -> {
                AuditInvoice auditInvoice = new AuditInvoice();
                auditInvoice.setId(i.getId());
                auditInvoice.setChangeAmount(i.getChangeAmount());
                auditInvoiceList1.add(auditInvoice);
            });
            if (CollectionUtils.isNotEmpty(auditInvoiceList1)) {
                this.auditInvoiceRepository.updateBatchById(auditInvoiceList1);
            }
        }
    }

    private Audit supplierReimburseUpAccount(AuditVo auditVo, List<AuditSupplierDetailVo> detailList, List<AuditInvoice> auditInvoiceList) {
        int invoiceNum;
        Integer accId = 1;
        if (this.redisTemplate.hasKey((Object)"AUDIT:ACC_ID").booleanValue()) {
            Object o = this.redisTemplate.opsForValue().get((Object)"AUDIT:ACC_ID");
            accId = (Integer)o;
            accId = accId + 1;
            this.redisTemplate.opsForValue().set((Object)"AUDIT:ACC_ID", (Object)accId);
        } else {
            this.redisTemplate.opsForValue().set((Object)"AUDIT:ACC_ID", (Object)accId);
        }
        auditVo.setAccId(Integer.toString(accId));
        Audit audit1 = new Audit();
        audit1.setId(auditVo.getId());
        audit1.setAccId(auditVo.getAccId());
        boolean isSpecial = false;
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(auditInvoiceList), (String)"\u53d1\u7968\u4e0d\u80fd\u4f4d\u7a7a", (Object[])new Object[0]);
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("tpm_audit_invoice_type");
        Map dictDataVoMap = dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        DictDataVo dictDataVo = (DictDataVo)dictDataVoMap.get(auditInvoiceList.get(0).getInvoiceType());
        if (dictDataVo != null) {
            Map extendMap = dictDataVo.getExtendMap();
            String ext1 = (String)extendMap.get("ext1");
            isSpecial = YesOrNoEnum.YES.getCode().equals(ext1);
        }
        Validate.isTrue(((invoiceNum = auditVo.getAppendices().intValue()) > 0 ? 1 : 0) != 0, (String)"\u53d1\u7968\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal reimburseTaxAmount = detailList.stream().map(AuditSupplierDetailVo::getThisEndCaseTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        AbstractCrmUserIdentity user = this.loginUserService.getAbstractLoginUser();
        AccountingVoucherDto accountingVoucherDto = new AccountingVoucherDto();
        AccountingVoucherDto.ItData itData = new AccountingVoucherDto.ItData();
        accountingVoucherDto.setIT_DATA(itData);
        ArrayList<AccountingVoucherDto.ItData.Item> itemList = new ArrayList<AccountingVoucherDto.ItData.Item>();
        AccountingVoucherDto.ItData.Item item1 = new AccountingVoucherDto.ItData.Item();
        item1.setACC_ID(auditVo.getAccId());
        item1.setTPID(auditVo.getAuditCode());
        item1.setOBJECT_ID(auditVo.getAuditCode());
        item1.setBUKRS(auditVo.getCompanyCode());
        item1.setINVOCE_NUM(String.valueOf(invoiceNum));
        item1.setUSNAM(user.getAccount());
        item1.setFLH("1");
        item1.setBSCHL("40");
        item1.setSAKNR(detailList.get(0).getReimburseItem());
        item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).toPlainString());
        item1.setPRCTR(detailList.get(0).getProfitCenter());
        item1.setKOSTL(detailList.get(0).getCostCenter());
        itemList.add(item1);
        if (isSpecial) {
            BigDecimal invoiceTaxAmount = auditInvoiceList.stream().map(AuditInvoice::getInvoiceTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            boolean changeFlag = false;
            if (reimburseTaxAmount.compareTo(invoiceTaxAmount) != 0) {
                changeFlag = true;
            }
            BigDecimal invoiceTaxAmount2 = BigDecimal.ZERO;
            BigDecimal changeAmount = BigDecimal.ZERO;
            for (AuditInvoice auditInvoice : auditInvoiceList) {
                AccountingVoucherDto.ItData.Item item3 = new AccountingVoucherDto.ItData.Item();
                item3.setACC_ID(auditVo.getAccId());
                item3.setTPID(auditVo.getAuditCode());
                item3.setOBJECT_ID(auditVo.getAuditCode());
                item3.setBUKRS(auditVo.getCompanyCode());
                item3.setINVOCE_NUM(String.valueOf(invoiceNum));
                item3.setINVOICE_NO(auditInvoice.getInvoiceNumber());
                item3.setUSNAM(user.getAccount());
                item3.setFLH("2");
                item3.setBSCHL("40");
                item3.setSAKNR(auditInvoice.getTaxSubject());
                item3.setAMOUNT(auditInvoice.getTaxAmount().setScale(2, RoundingMode.HALF_UP).toPlainString());
                invoiceTaxAmount2 = invoiceTaxAmount2.add(auditInvoice.getTaxAmount().setScale(2, RoundingMode.HALF_UP));
                item3.setPRCTR(detailList.get(0).getProfitCenter());
                itemList.add(item3);
            }
            if (changeFlag) {
                auditInvoiceList = auditInvoiceList.stream().sorted(Comparator.comparing(AuditInvoice::getTaxRate).thenComparing(AuditInvoice::getTaxAmount).reversed()).collect(Collectors.toList());
                AccountingVoucherDto.ItData.Item item6 = new AccountingVoucherDto.ItData.Item();
                item6.setACC_ID(auditVo.getAccId());
                item6.setTPID(auditVo.getAuditCode());
                item6.setOBJECT_ID(auditVo.getAuditCode());
                item6.setBUKRS(auditVo.getCompanyCode());
                item6.setINVOCE_NUM(String.valueOf(invoiceNum));
                item6.setUSNAM(user.getAccount());
                item6.setFLH("2");
                item6.setBSCHL("50");
                item6.setSAKNR("2221010701");
                BigDecimal changeTaxAmount = invoiceTaxAmount.subtract(reimburseTaxAmount);
                for (AuditInvoice auditInvoice : auditInvoiceList) {
                    if (changeTaxAmount.compareTo(auditInvoice.getInvoiceTaxAmount()) > 0) {
                        changeTaxAmount = changeTaxAmount.subtract(auditInvoice.getInvoiceTaxAmount());
                        changeAmount = changeAmount.add(auditInvoice.getTaxAmount());
                        auditInvoice.setChangeAmount(auditInvoice.getTaxAmount());
                        continue;
                    }
                    BigDecimal thisChangeAmount = changeTaxAmount.divide(new BigDecimal(auditInvoice.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.UP).add(BigDecimal.ONE), 6, RoundingMode.HALF_UP).multiply(new BigDecimal(auditInvoice.getTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.UP));
                    changeAmount = changeAmount.add(thisChangeAmount);
                    auditInvoice.setChangeAmount(thisChangeAmount);
                    break;
                }
                item6.setAMOUNT(changeAmount.setScale(2, RoundingMode.HALF_UP).negate().toPlainString());
                item6.setPRCTR(detailList.get(0).getProfitCenter());
                itemList.add(item6);
            }
            if (changeFlag) {
                item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).add(changeAmount).subtract(invoiceTaxAmount2).setScale(2, RoundingMode.HALF_UP).toPlainString());
            } else {
                item1.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).subtract(invoiceTaxAmount2).setScale(2, RoundingMode.HALF_UP).toPlainString());
            }
        }
        AccountingVoucherDto.ItData.Item item2 = new AccountingVoucherDto.ItData.Item();
        item2.setACC_ID(auditVo.getAccId());
        item2.setTPID(auditVo.getAuditCode());
        item2.setOBJECT_ID(auditVo.getAuditCode());
        item2.setBUKRS(auditVo.getCompanyCode());
        item2.setINVOCE_NUM(String.valueOf(invoiceNum));
        item2.setUSNAM(user.getAccount());
        item2.setFLH("3");
        item2.setBSCHL("31");
        item2.setKUNNR(detailList.get(0).getSupplierCode());
        item2.setSAKNR(null);
        item2.setAMOUNT(reimburseTaxAmount.setScale(2, RoundingMode.HALF_UP).negate().toPlainString());
        item2.setPRCTR(detailList.get(0).getProfitCenter());
        item2.setKOSTL(null);
        itemList.add(item2);
        itData.setItem(itemList);
        SapAccountingVoucherVo sapAccountingVoucherVo = this.sapCenterService.pushSapAccountingVoucher(accountingVoucherDto);
        String message = null;
        if (Objects.nonNull(sapAccountingVoucherVo)) {
            if (Objects.nonNull(sapAccountingVoucherVo.getET_BELNR()) && CollectionUtils.isNotEmpty((Collection)sapAccountingVoucherVo.getET_BELNR().getItem())) {
                for (SapAccountingVoucherVo.EtBelnr.Item item : sapAccountingVoucherVo.getET_BELNR().getItem()) {
                    audit1.setBelnr(item.getBELNR());
                    audit1.setBukrs(item.getBUKRS());
                    audit1.setGjahr(item.getGJAHR());
                }
                return audit1;
            }
            if (Objects.nonNull(sapAccountingVoucherVo.getET_MESSAGE()) && CollectionUtils.isNotEmpty((Collection)sapAccountingVoucherVo.getET_MESSAGE().getItem())) {
                for (SapAccountingVoucherVo.EtBelnr.Item item : sapAccountingVoucherVo.getET_MESSAGE().getItem()) {
                    if (!SuccessAndFailEnum.FAIL.getCode().equals(item.getTYPE())) continue;
                    message = item.getMESSAGE() + "||" + message;
                }
                if (StringUtils.isNotEmpty(message)) {
                    throw new RuntimeException(message);
                }
            }
        }
        return audit1;
    }

    public AuditVo queryCalculateHeaderData(AuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String cacheKey = dto.getCacheKey();
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditVo auditVo = new AuditVo();
        List<AuditSupplierDetailVo> supplierAuditDetailCache = this.findSupplierAuditDetailFromCache(cacheKey);
        auditVo.setThisEndCaseTaxTotalAmount(BigDecimal.ZERO);
        auditVo.setDiscountTaxTotalAmount(BigDecimal.ZERO);
        auditVo.setDiscountTotalAmount(BigDecimal.ZERO);
        auditVo.setThisEndCaseTotalAmount(BigDecimal.ZERO);
        auditVo.setAuditTaxTotalAmount(BigDecimal.ZERO);
        auditVo.setAuditTotalAmount(BigDecimal.ZERO);
        for (AuditSupplierDetailVo auditSupplierDetailVo : supplierAuditDetailCache) {
            auditVo.setThisEndCaseTaxTotalAmount(auditVo.getThisEndCaseTaxTotalAmount().add(Optional.ofNullable(auditSupplierDetailVo.getThisEndCaseTaxAmount()).orElse(BigDecimal.ZERO)));
        }
        return auditVo;
    }

    private String copySupplerAuditDetail(String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String newCacheKey = UuidCrmUtil.general();
        List<AuditSupplierDetailVo> supplierAuditDetailCache = this.findSupplierAuditDetailFromCache(cacheKey);
        if (CollectionUtils.isNotEmpty(supplierAuditDetailCache)) {
            this.cacheSupplierAuditDetail(newCacheKey, supplierAuditDetailCache);
        }
        return newCacheKey;
    }

    @Override
    public void cacheSupplierAuditDetail(String cacheKey, List<AuditSupplierDetailVo> auditSupplierDetailList) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cacheKey = cacheKey + CacheTypeEnum.SUPPLIER_AUDIT_DETAIL.getCode();
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)cacheKey))) {
            this.redisTemplate.delete((Object)cacheKey);
        }
        if (CollectionUtils.isNotEmpty(auditSupplierDetailList)) {
            this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, auditSupplierDetailList.toArray());
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        }
    }

    @Override
    public List<AuditSupplierDetailVo> findSupplierAuditDetailFromCache(String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cacheKey = cacheKey + CacheTypeEnum.SUPPLIER_AUDIT_DETAIL.getCode();
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)cacheKey))) {
            List range;
            List auditSupplierDetailList = range = this.redisTemplate.opsForList().range((Object)cacheKey, 0L, -1L);
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
            return auditSupplierDetailList;
        }
        return Lists.newArrayList();
    }

    public void clearAuditDetailCache(AuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.deleteAuditDetailCache(dto.getCacheKey());
    }

    @Override
    protected ChangeBudgetVo budgetDispose(AuditDto dto, AuditUseBudgetTypeEnum auditUseBudgetType, boolean handReturn) {
        return null;
    }

    @Override
    protected void submitApprovalValidate(AuditDto dto) {
    }

    public AuditDto atomicAudit(AuditDto audit) {
        return null;
    }

    public List<String> getActivityCodeFromCache(String cacheKey) {
        return null;
    }

    public List<AuditPayVo> collectSupplierPayInfo(AuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditSupplierDetailVo> supplierAuditDetailCache = this.findSupplierAuditDetailFromCache(dto.getCacheKey());
        Set supplierCodes = supplierAuditDetailCache.stream().map(AuditSupplierDetailVo::getSupplierCode).collect(Collectors.toSet());
        Map<Object, Object> supplierVoMap = new HashMap();
        Map<Object, Object> beachPrepaymentDetailsVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(supplierCodes)) {
            List supplierVoList = this.supplierVoService.findBySupplierCodes(new ArrayList(supplierCodes));
            supplierVoMap = supplierVoList.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity()));
            List beachPrepaymentDetailsVoList = this.prepaymentDetailsService.findBySupplierCode(supplierCodes);
            if (CollectionUtils.isNotEmpty((Collection)beachPrepaymentDetailsVoList)) {
                beachPrepaymentDetailsVoMap = beachPrepaymentDetailsVoList.stream().collect(Collectors.toMap(BeachPrepaymentDetailsVo::getSupplierCode, Function.identity()));
            }
        }
        ArrayList<AuditPayVo> auditPayVoList = new ArrayList<AuditPayVo>();
        Map<String, List<AuditSupplierDetailVo>> collect = supplierAuditDetailCache.stream().collect(Collectors.groupingBy(AuditSupplierDetailVo::getSupplierCode));
        HashMap finalSupplierVoMap = supplierVoMap;
        HashMap finalBeachPrepaymentDetailsVoMap = beachPrepaymentDetailsVoMap;
        collect.forEach((key, value) -> {
            AuditSupplierDetailVo auditSupplierDetailVo = (AuditSupplierDetailVo)value.get(0);
            AuditPayVo auditPayVo = new AuditPayVo();
            auditPayVo.setSupplierCode(key);
            auditPayVo.setSupplierName(auditSupplierDetailVo.getSupplierName());
            SupplierVo supplierVo = (SupplierVo)finalSupplierVoMap.get(key);
            if (supplierVo != null) {
                auditPayVo.setAccountName(supplierVo.getContactName());
                auditPayVo.setReceiptAccount(supplierVo.getBankCard());
                auditPayVo.setOpenAccountBank(supplierVo.getBankAccount());
                auditPayVo.setUnionpayCode(supplierVo.getUnionPayBankCard());
                BigDecimal thisAuditTotalAmount = value.stream().map(AuditSupplierDetailVo::getThisEndCaseTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                auditPayVo.setThisAuditTotalAmount(thisAuditTotalAmount);
                auditPayVo.setThisChargeAgainstPrepayTotalAmount(null);
                auditPayVo.setEMailInformPeople("todo");
            }
            BeachPrepaymentDetailsVo beachPrepaymentDetailsVo = (BeachPrepaymentDetailsVo)finalBeachPrepaymentDetailsVoMap.get(key);
            ArrayList<AuditPayPrepayVo> auditPayPrepayList = new ArrayList<AuditPayPrepayVo>();
            if (beachPrepaymentDetailsVo != null && CollectionUtils.isNotEmpty((Collection)beachPrepaymentDetailsVo.getPrepaymentDetailsList())) {
                for (PrepaymentDetailsVo prepaymentDetailsVo : beachPrepaymentDetailsVo.getPrepaymentDetailsList()) {
                    AuditPayPrepayVo auditPayPrepayVo = (AuditPayPrepayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepaymentDetailsVo, AuditPayPrepayVo.class, null, null, new String[0]);
                    auditPayPrepayVo.setActivitiesDetailCode(prepaymentDetailsVo.getActivityDetailNo());
                    auditPayPrepayVo.setThisPayType(prepaymentDetailsVo.getPaymentType());
                    auditPayPrepayVo.setReason(prepaymentDetailsVo.getPrepaymentReason());
                    auditPayPrepayList.add(auditPayPrepayVo);
                }
            }
            auditPayVo.setAuditPayPrepayList(auditPayPrepayList);
            auditPayVoList.add(auditPayVo);
        });
        return auditPayVoList;
    }

    public AuditVo queryPrintInfo(String auditCode) {
        AuditVo auditVo = super.findAuditByAuditCode(auditCode);
        List auditSupplierDetails = ((LambdaQueryChainWrapper)this.auditSupplierDetailRepository.lambdaQuery().eq(AuditSupplierDetail::getAuditCode, (Object)auditVo.getAuditCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)auditSupplierDetails)) {
            Collection auditSupplierDetailVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)auditSupplierDetails, AuditSupplierDetail.class, AuditSupplierDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            auditVo.setAuditSupplierDetailDtoList((List)auditSupplierDetailVos);
        }
        return auditVo;
    }

    public AuditDto autoAudit(AuditDto auditDto) {
        return null;
    }

    @Override
    public List<AuditDto> autoAuditChange(AuditDto auditDto) {
        return null;
    }

    public void setCostCenter(String businessUnitCode, String businessFormatCode, AuditCustomerDetailVo auditCustomerDetailVo) {
    }

    public void manualReturnBudget(AuditDto auditDto, boolean handReturn) {
    }

    public List<AuditVo> findPrintInfo(String auditCode, List<String> auditDetailCodes) {
        AuditVo auditVo = super.findAuditByAuditCode(auditCode);
        List auditSupplierDetails = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditSupplierDetailRepository.lambdaQuery().eq(AuditSupplierDetail::getAuditCode, (Object)auditVo.getAuditCode())).in(CollectionUtils.isNotEmpty(auditDetailCodes), AuditSupplierDetail::getAuditDetailCode, auditDetailCodes)).list();
        if (CollectionUtils.isNotEmpty((Collection)auditSupplierDetails)) {
            Collection auditSupplierDetailVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)auditSupplierDetails, AuditSupplierDetail.class, AuditSupplierDetailVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            auditVo.setAuditSupplierDetailDtoList((List)auditSupplierDetailVos);
        }
        return (List)auditVo;
    }

    public void createForOut(AuditOutDto audit) {
    }

    private void cacheAuditInvoice(String cacheKey, List<AuditInvoiceVo> list) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cacheKey = cacheKey + CacheTypeEnum.AUDIT_INVOICE.getCode();
        if (this.redisTemplate.hasKey((Object)cacheKey).booleanValue()) {
            this.redisTemplate.delete((Object)cacheKey);
        }
        if (CollectionUtils.isNotEmpty(list)) {
            this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, list.toArray());
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        }
    }

    public AuditVo findByAuditDetailCodes(AuditDto dto) {
        Validate.notBlank((CharSequence)dto.getAuditCode(), (String)"\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditVo auditVo = new AuditVo();
        Audit audit = this.auditRepository.findOneByCode(dto.getAuditCode());
        if (Objects.nonNull((Object)audit)) {
            auditVo.setAuditCode(audit.getAuditCode());
            auditVo.setAppendices(audit.getAppendices());
        }
        List<AuditInvoice> list = this.auditInvoiceRepository.findByAuditCode(dto.getAuditCode());
        String cacheKey = "AUDIT:" + UuidCrmUtil.general();
        auditVo.setCacheKey(cacheKey);
        if (CollectionUtils.isNotEmpty(list)) {
            Collection auditInvoiceVos = this.nebulaToolkitService.copyCollectionByBlankList(list, AuditInvoice.class, AuditInvoiceVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.clearAuditInvoiceCache(cacheKey);
            this.cacheAuditInvoice(cacheKey, (List)auditInvoiceVos);
        }
        List<AuditInfo> auditInfoList = this.auditInfoRepository.findByCode(dto.getAuditCode());
        ArrayList<AuditInfoVo> auditInfoVoList = new ArrayList<AuditInfoVo>();
        if (CollectionUtils.isNotEmpty(auditInfoList)) {
            Collection auditInfoVos = this.nebulaToolkitService.copyCollectionByBlankList(auditInfoList, AuditInfo.class, AuditInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            Set<String> auditInfoIds = auditInfoList.stream().map(UuidEntity::getId).collect(Collectors.toSet());
            List<AuditInfoAttachment> infoAttachments = this.auditInfoAttachmentRepository.findByIds(auditInfoIds);
            HashMap<String, List<AuditInfoAttachmentVo>> auditInfoAttachmentVoMap = new HashMap<String, List<AuditInfoAttachmentVo>>();
            if (CollectionUtils.isNotEmpty(infoAttachments)) {
                Collection auditInfoAttachmentVos = this.nebulaToolkitService.copyCollectionByBlankList(infoAttachments, AuditInfoAttachment.class, AuditInfoAttachmentVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                Map<String, List<AuditInfoAttachmentVo>> map = auditInfoAttachmentVos.stream().collect(Collectors.groupingBy(AuditInfoAttachmentVo::getAuditInfoId));
                auditInfoAttachmentVoMap.putAll(map);
            }
            for (AuditInfoVo auditInfoVo : auditInfoVos) {
                List auditInfoAttachmentVos = (List)auditInfoAttachmentVoMap.get(auditInfoVo.getId());
                auditInfoVo.setAuditInfoAttachmentVoList(auditInfoAttachmentVos);
                auditInfoVoList.add(auditInfoVo);
            }
        }
        auditVo.setAuditInfoList(auditInfoVoList);
        return auditVo;
    }

    public void deleteCustomerDetail(AuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getIds()), (String)"\u8981\u5220\u9664\u7684\u5ba2\u6237\u6838\u9500\u660e\u7ec6id\u4e0d\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getCacheKey(), (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditSupplierDetailVo> auditSupplierDetailVoList = this.findSupplierAuditDetailFromCache(dto.getCacheKey());
        ArrayList<AuditSupplierDetailVo> auditSupplierDetailVos = new ArrayList<AuditSupplierDetailVo>();
        auditSupplierDetailVoList.forEach(item -> {
            if (dto.getIds().contains(item.getId())) {
                return;
            }
            auditSupplierDetailVos.add((AuditSupplierDetailVo)item);
        });
        this.cacheSupplierAuditDetail(dto.getCacheKey(), auditSupplierDetailVos);
    }

    public void supplierMaterialSaveCacheAuditInfo(AuditDto dto) {
        List auditSupplierMaterialFileVoList;
        String cacheKey = dto.getCacheKey();
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cacheKey = cacheKey + CacheTypeEnum.AUDIT_INFO.getCode();
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)cacheKey))) {
            this.redisTemplate.delete((Object)cacheKey);
        }
        if (CollectionUtils.isEmpty((Collection)(auditSupplierMaterialFileVoList = dto.getAuditSupplierMaterialFileVoList()))) {
            return;
        }
        this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, new Object[]{auditSupplierMaterialFileVoList});
        this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
    }

    public List<AuditSupplierMaterialFileVo> supplierMaterialFindCacheAuditInfo(AuditDto dto) {
        String cacheKey = dto.getCacheKey();
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        cacheKey = cacheKey + CacheTypeEnum.AUDIT_INFO.getCode();
        if (Boolean.TRUE.equals(this.redisTemplate.hasKey((Object)cacheKey))) {
            List<AuditSupplierMaterialFileVo> auditSupplierMaterialFileVos = this.auditSupplierMaterialFileRepository.findListVoByAuditCode(dto.getAuditCode());
            if (CollectionUtils.isEmpty(auditSupplierMaterialFileVos)) {
                return Lists.newArrayList();
            }
            this.redisTemplate.opsForList().rightPushAll((Object)cacheKey, new Object[]{auditSupplierMaterialFileVos});
            this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
            return auditSupplierMaterialFileVos;
        }
        List range = this.redisTemplate.opsForList().range((Object)cacheKey, 0L, -1L);
        this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        if (CollectionUtils.isEmpty((Collection)range)) {
            return Lists.newArrayList();
        }
        List auditSupplierMaterialFileVos = range;
        return auditSupplierMaterialFileVos;
    }

    @Override
    public void submitBatchApproval(AuditBatchSubmitDto auditBatchSubmit) {
        List<String> auditCodeList = auditBatchSubmit.getAuditCodeList();
        ArrayList successLockList = Lists.newArrayList();
        if (CollUtil.isEmpty((Collection)auditCodeList)) {
            auditCodeList = this.auditRepository.findAuditCode(auditBatchSubmit);
        }
        MarsAuthorityContextHolder.getContext().setListCode("");
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(auditCodeList), (String)"\u672a\u627e\u5230\u54cd\u5e94\u6838\u9500\u6570\u636e", (Object[])new Object[0]);
        auditCodeList = auditCodeList.stream().distinct().collect(Collectors.toList());
        try {
            for (String auditCode : auditCodeList) {
                String redisLockKey = String.format("AUDIT_SUBMIT_LOCK_KEY:%s", auditCode);
                boolean successFlag = this.redisLockService.tryLock(redisLockKey, TimeUnit.SECONDS, 60L);
                Validate.isTrue((boolean)successFlag, (String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[0]);
                successLockList.add(redisLockKey);
            }
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditRepository.lambdaQuery().in(Audit::getAuditCode, auditCodeList)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            Map auditMap = list.stream().collect(Collectors.toMap(Audit::getAuditCode, Function.identity(), (a1, a2) -> a2));
            for (String auditCode : auditCodeList) {
                this.webSocketHelper.sendMsg("\u5f00\u59cb\u63d0\u4ea4\u6838\u9500\u7f16\u7801\uff1a" + auditCode);
                Audit audit = (Audit)((Object)auditMap.get(auditCode));
                Validate.notNull((Object)((Object)audit), (String)"\u672a\u627e\u5230\u6838\u9500\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u6838\u9500\u6570\u636e", (Object[])new Object[]{auditCode});
                log.info("\u6838\u9500\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)((Object)audit)));
                String processStatus = audit.getProcessStatus();
                if (CharSequenceUtil.equals((CharSequence)ProcessStatusEnum.COMMIT.getDictCode(), (CharSequence)processStatus) || CharSequenceUtil.equals((CharSequence)ProcessStatusEnum.PASS.getDictCode(), (CharSequence)processStatus) || CharSequenceUtil.equals((CharSequence)ProcessStatusEnum.COLSE.getDictCode(), (CharSequence)processStatus) || CharSequenceUtil.equals((CharSequence)ProcessStatusEnum.REJECTING.getDictCode(), (CharSequence)processStatus)) {
                    throw new IllegalArgumentException("\u53ea\u80fd\u63d0\u4ea4\u5904\u4e8e\u9a73\u56de\uff0c\u8ffd\u56de\uff0c\u5f85\u63d0\u4ea4\u72b6\u6001\u7684\u6838\u9500\u7533\u8bf7");
                }
                AuditDto auditDto = (AuditDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditDto.class, null, null, new String[0]);
                this.submitApprovalValidate(auditDto);
            }
            this.webSocketHelper.sendMsg("\u63d0\u4ea4\u5ba1\u6279\u6d41\u7a0b");
            ProcessBusinessDto processBusiness = auditBatchSubmit.getProcessBusiness();
            processBusiness.setBusinessNoList(auditCodeList);
            String general = UuidCrmUtil.general();
            processBusiness.setBusinessNo(general);
            processBusiness.setBusinessCode("supplier_ordinary_audit_process");
            ProcessBusinessVo processBusinessVo = this.processBatchBusinessService.processStart(processBusiness);
            this.auditRepository.updateAuditProcess(auditCodeList, ProcessStatusEnum.COMMIT.getDictCode(), processBusinessVo.getProcessNo());
        }
        catch (Exception e) {
            log.error("\u7269\u6599\u8d39\u7ed3\u6848\u6838\u9500\u6279\u91cf\u63d0\u4ea4\u6838\u9500\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            successLockList.forEach(successLock -> this.redisLockService.unlock(successLock));
        }
    }
}

