/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.helper;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.factory.sdk.service.FactoryVoService;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.audit.local.repository.AuditRedInvoiceProductRepository;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceProductDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditRedInvoiceProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditRedInvoiceProductPageCacheHelper
extends MnPageCacheHelper<AuditRedInvoiceProductVo, AuditRedInvoiceProductDto> {
    @Autowired(required=false)
    private AuditRedInvoiceProductRepository auditRedInvoiceProductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private FactoryVoService factoryVoService;

    public String getCacheKeyPrefix() {
        return "audit_red_invoice_product:item_cache:";
    }

    public Class<AuditRedInvoiceProductDto> getDtoClass() {
        return AuditRedInvoiceProductDto.class;
    }

    public Class<AuditRedInvoiceProductVo> getVoClass() {
        return AuditRedInvoiceProductVo.class;
    }

    public List<AuditRedInvoiceProductDto> findDtoListFromRepository(AuditRedInvoiceProductDto dto, String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)dto.getAuditCode())) {
            return Lists.newArrayList();
        }
        List<AuditRedInvoiceProductDto> dtoList = this.auditRedInvoiceProductRepository.findDtoAndAttachListByAuditCode(dto.getAuditCode());
        dtoList.sort(Comparator.comparing(AuditRedInvoiceProductDto::getLineCode));
        return dtoList;
    }

    public List<AuditRedInvoiceProductDto> newItem(String cacheKey, List<AuditRedInvoiceProductDto> itemList) {
        String tenantCode = TenantUtils.getTenantCode();
        for (AuditRedInvoiceProductDto productDto : itemList) {
            Validate.notBlank((CharSequence)productDto.getProductCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            productDto.setId(UUID.randomUUID().toString().replace("-", ""));
            productDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            productDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            productDto.setTenantCode(tenantCode);
        }
        return Lists.newArrayList(itemList);
    }

    public List<AuditRedInvoiceProductDto> copyItem(String cacheKey, List<AuditRedInvoiceProductDto> itemList) {
        List newItemList = (List)this.nebulaToolkitService.copyCollectionByBlankList(itemList, AuditRedInvoiceProductDto.class, AuditRedInvoiceProductDto.class, HashSet.class, ArrayList.class, new String[0]);
        for (AuditRedInvoiceProductDto newItem : newItemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setLineCode(null);
        }
        return newItemList;
    }

    public void updateItem(String cacheKey, List<AuditRedInvoiceProductDto> itemList) {
    }

    public Object getDtoKey(AuditRedInvoiceProductDto productDto) {
        return productDto.getId();
    }

    public String getCheckedStatus(AuditRedInvoiceProductDto productDto) {
        return productDto.getChecked();
    }

    public void importNewItem(String cacheKey, List<AuditRedInvoiceProductDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        for (AuditRedInvoiceProductDto newItem : itemList) {
            newItem.setId(UUID.randomUUID().toString().replace("-", ""));
            newItem.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            newItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            newItem.setTenantCode(TenantUtils.getTenantCode());
        }
        Object[] newIdArr = itemList.stream().map(this::getDtoKey).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        Map updateMap = itemList.stream().collect(Collectors.toMap(this::getDtoKey, Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }

    public List<AuditRedInvoiceProductVo> dtoListToVoList(List<AuditRedInvoiceProductDto> dtoList) {
        ArrayList<AuditRedInvoiceProductVo> list = new ArrayList<AuditRedInvoiceProductVo>();
        if (CollectionUtils.isEmpty(dtoList)) {
            return list;
        }
        for (AuditRedInvoiceProductDto productDto : dtoList) {
            AuditRedInvoiceProductVo productVo = (AuditRedInvoiceProductVo)this.nebulaToolkitService.copyObjectByBlankList((Object)productDto, this.getVoClass(), HashSet.class, ArrayList.class, new String[0]);
            list.add(productVo);
        }
        return list;
    }
}

