/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.helper;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WebSocketHelper {
    private static final Logger log = LoggerFactory.getLogger(WebSocketHelper.class);
    @Value(value="${spring.application.name:}")
    private String applicationName;
    @Autowired(required=false)
    private ChannelMsgService channelMsgService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public void sendMsg(String remark) {
        this.sendMsg(remark, ExecStatusEnum.RUNNING.getKey());
    }

    public void sendMsg(String remark, String execStatus) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("remark", (Object)remark);
        String time = DateUtil.getDateStrByFormat((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        jsonObject.put("time", (Object)time);
        jsonObject.put("applicationName", (Object)this.applicationName);
        jsonObject.put("execStatus", (Object)execStatus);
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)jsonObject, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String modelCode = "audit_save";
        log.info(" \u6838\u9500\u4fdd\u5b58 model send msg: tenantCode = {} , applicationName = {} , modelCode = {} ,remark = {}", new Object[]{tenantCode, this.applicationName, modelCode, remark});
        UserIdentity loginUser = this.loginUserService.getLoginUser();
        this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, this.applicationName, modelCode, loginUser.getAccount(), jsonBytes);
    }
}

