/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollection;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionRepository;
import com.biz.crm.tpm.business.audit.sdk.service.AuditCustomerDetailCollectionSdkService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditCustomerDetailSdkService")
public class AuditCustomerDetailCollectionSdkServiceImpl
implements AuditCustomerDetailCollectionSdkService {
    private static final Logger log = LoggerFactory.getLogger(AuditCustomerDetailCollectionSdkServiceImpl.class);
    @Autowired(required=false)
    private AuditCustomerDetailCollectionRepository auditCustomerDetailCollectionRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public List<AuditCustomerDetailCollectionVo> findByPlanCodes(Set<String> codeList) {
        if (CollectionUtils.isEmpty(codeList) || codeList.size() == 0) {
            return new ArrayList<AuditCustomerDetailCollectionVo>();
        }
        return this.auditCustomerDetailCollectionRepository.findByDetailPlanItemCodes(null, codeList);
    }

    public List<AuditCustomerDetailCollectionVo> findByAuditCodes(Set<String> codeList) {
        if (CollectionUtils.isEmpty(codeList) || codeList.size() == 0) {
            return new ArrayList<AuditCustomerDetailCollectionVo>();
        }
        List<AuditCustomerDetailCollection> auditCustomerDetailCollections = this.auditCustomerDetailCollectionRepository.findByAuditCodes(codeList);
        if (CollectionUtils.isEmpty(auditCustomerDetailCollections)) {
            return new ArrayList<AuditCustomerDetailCollectionVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditCustomerDetailCollections, AuditCustomerDetailCollection.class, AuditCustomerDetailCollectionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditCustomerDetailCollectionVo> findByDetailPlanItemCodes(Set<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes) || itemCodes.size() == 0) {
            return new ArrayList<AuditCustomerDetailCollectionVo>();
        }
        return this.auditCustomerDetailCollectionRepository.findByDetailPlanItemCodes(itemCodes, null);
    }
}

