/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.local.entity.Audit;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollection;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditRepository;
import com.biz.crm.tpm.business.audit.local.service.AuditCustomerService;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.RedOrderCreateStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class AuditCustomerDetailServiceImpl
implements AuditCustomerService {
    private static final Logger log = LoggerFactory.getLogger(AuditCustomerDetailServiceImpl.class);
    @Autowired(required=false)
    private AuditCustomerDetailRepository auditCustomerDetailRepository;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private AuditRepository auditRepository;
    @Autowired(required=false)
    private AuditCustomerDetailCollectionRepository auditCustomerDetailCollectionRepository;

    @Override
    public Page<AuditCustomerDetailVo> findAuditDetailList(Pageable pageable, AuditCustomerDetailDto dto) {
        List activityCodeList;
        Page<AuditCustomerDetailVo> detailVoPage;
        List result;
        if (StringUtils.isNotEmpty((CharSequence)dto.getSynchronization())) {
            if (YesOrNoEnum.YES.getCode().equals(dto.getSynchronization())) {
                dto.setSynchronization("1");
            } else {
                dto.setSynchronization("0");
            }
        }
        if (CollectionUtil.isEmpty((Collection)(result = (detailVoPage = this.auditCustomerDetailRepository.findAuditDetailList(pageable, dto)).getRecords()))) {
            return detailVoPage;
        }
        result.forEach(item -> {
            if ("1".equals(item.getSynchronization())) {
                item.setSynchronizationMsg("\u662f");
            } else {
                item.setSynchronizationMsg("\u5426");
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)result)) {
            List<String> auditDetailCodes = result.stream().map(AuditCustomerDetailVo::getAuditDetailCode).collect(Collectors.toList());
            List<AuditCustomerDetailVo> sumList = this.auditCustomerDetailRepository.findDetailSumByAuditDetailCodes(auditDetailCodes);
            Map<Object, Object> sumMap = new HashMap();
            if (CollectionUtils.isNotEmpty(sumList)) {
                sumMap = sumList.stream().collect(Collectors.toMap(AuditCustomerDetailVo::getAuditDetailCode, Function.identity()));
            }
            for (AuditCustomerDetailVo item2 : result) {
                AuditCustomerDetailVo one = (AuditCustomerDetailVo)sumMap.get(item2.getAuditDetailCode());
                if (one == null) continue;
                item2.setUpAccountAuditCode(one.getUpAccountAuditCode());
                item2.setUpAccountActivityCode(one.getUpAccountActivityCode());
            }
        }
        if (CollectionUtil.isEmpty(activityCodeList = result.stream().filter(k -> StringUtil.isNotEmpty((String)k.getActivityCode())).map(AuditCustomerDetailVo::getActivityCode).distinct().collect(Collectors.toList()))) {
            return detailVoPage;
        }
        List activityDetailPlanVoList = this.activityDetailPlanSdkService.findActivityDetailPlanByCodes(activityCodeList);
        if (CollectionUtil.isEmpty((Collection)activityDetailPlanVoList)) {
            return detailVoPage;
        }
        Map<String, ActivityDetailPlanVo> detailPlanVoMap = activityDetailPlanVoList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getDetailPlanCode())).collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, v -> v, (newValue, oldValue) -> newValue));
        if (CollectionUtil.isEmpty(detailPlanVoMap)) {
            return detailVoPage;
        }
        result.stream().filter(k -> StringUtil.isNotEmpty((String)k.getActivityCode())).filter(k -> Objects.nonNull(detailPlanVoMap.get(k.getActivityCode()))).forEach(item -> {
            ActivityDetailPlanVo activityDetailPlanVo = (ActivityDetailPlanVo)detailPlanVoMap.get(item.getActivityCode());
            item.setDepartmentCode(activityDetailPlanVo.getDepartmentCode());
            item.setDepartmentName(activityDetailPlanVo.getDepartmentName());
        });
        detailVoPage.setRecords(result);
        return detailVoPage;
    }

    @Override
    public Boolean auditDetailCanClose(List<String> detailPlanItemCodeList) {
        if (CollectionUtil.isEmpty(detailPlanItemCodeList)) {
            return true;
        }
        return this.auditCustomerDetailRepository.auditDetailCanClose(detailPlanItemCodeList) == 0;
    }

    @Override
    public void updateUpAccountStatus(List<String> auditCodeList) {
        if (CollectionUtils.isEmpty(auditCodeList)) {
            return;
        }
        for (String auditCode : auditCodeList) {
            this.updateOneUpAccountStatus(auditCode);
        }
    }

    private void updateOneUpAccountStatus(String auditCode) {
        List redInvoiceList;
        List discountList;
        List<AuditCustomerDetailCollection> list = this.auditCustomerDetailCollectionRepository.findByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Audit audit = this.auditRepository.findOneByCode(auditCode);
        long reimburseCount = list.stream().map(AuditCustomerDetailCollection::getEndCaseForm).filter(StringUtils::isNotEmpty).filter(o -> o.contains(EndCaseFormEnum.REIMBURSE.getCode())).count();
        if (reimburseCount > 0L) {
            Audit audit1 = new Audit();
            audit1.setId(audit.getId());
            audit1.setReimburseUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTING.getCode());
            this.auditRepository.updateById((Object)audit1);
        }
        if (CollectionUtils.isNotEmpty(discountList = list.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getEndCaseForm())).filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.DISCOUNT.getCode())).collect(Collectors.toList()))) {
            List partition = Lists.partition(discountList, (int)1000);
            for (List auditCustomerDetails : partition) {
                ArrayList<AuditCustomerDetailCollection> detailCollectionList = new ArrayList<AuditCustomerDetailCollection>();
                for (AuditCustomerDetailCollection detail : auditCustomerDetails) {
                    AuditCustomerDetailCollection detailCollection = new AuditCustomerDetailCollection();
                    detailCollection.setId(detail.getId());
                    detailCollection.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTING.getCode());
                    detailCollectionList.add(detailCollection);
                }
                this.auditCustomerDetailCollectionRepository.updateBatchById(detailCollectionList);
            }
        }
        if (CollectionUtils.isNotEmpty(redInvoiceList = list.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getEndCaseForm())).filter(o -> o.getEndCaseForm().contains(EndCaseFormEnum.RED_INVOICE.getCode())).collect(Collectors.toList()))) {
            if (BusinessUnitEnum.isOnlineBusinessUnit((String)audit.getBusinessUnitCode())) {
                ArrayList<AuditCustomerDetailCollection> detailCollectionList = new ArrayList<AuditCustomerDetailCollection>();
                for (AuditCustomerDetailCollection detail : redInvoiceList) {
                    AuditCustomerDetailCollection detailCollection = new AuditCustomerDetailCollection();
                    detailCollection.setId(detail.getId());
                    detailCollection.setRedOrderCreateStatus(RedOrderCreateStatusEnum.IN_CREATE.getCode());
                    detailCollectionList.add(detailCollection);
                }
                this.auditCustomerDetailCollectionRepository.updateBatchById(detailCollectionList);
            } else {
                Audit audit1 = new Audit();
                audit1.setId(audit.getId());
                audit1.setRedOrderCreateStatus(RedOrderCreateStatusEnum.IN_CREATE.getCode());
                this.auditRepository.updateById((Object)audit1);
            }
        }
    }
}

