/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.local.entity.Audit;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollection;
import com.biz.crm.tpm.business.audit.local.entity.AuditSonCompanyDiscountSum;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditSonCompanyDiscountSumRepository;
import com.biz.crm.tpm.business.audit.local.service.AuditHelperService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSonCompanyDiscountSumVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditHelperServiceImpl
implements AuditHelperService {
    protected static final String AUDIT_SON_UP_ACCOUNT = "V-";
    @Autowired(required=false)
    private AuditSonCompanyDiscountSumRepository auditSonCompanyDiscountSumRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private ActivityFormService activityFormService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private AuditCustomerDetailCollectionRepository auditCustomerDetailCollectionRepository;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public List<AuditSonCompanyDiscountSumVo> sonCompanyCollectionDetail(List<AuditCustomerDetailCollection> discountUpAccountList, Audit audit) {
        Collection values;
        List<AuditSonCompanyDiscountSum> auditSonCompanyDiscountSums;
        List<String> upAccountActivityCode = discountUpAccountList.stream().map(AuditCustomerDetailCollection::getUpAccountActivityCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(upAccountActivityCode) && CollectionUtils.isNotEmpty(auditSonCompanyDiscountSums = this.auditSonCompanyDiscountSumRepository.findListByUpAccountActivityCodes(upAccountActivityCode))) {
            Collection auditSonCompanyDiscountSumVos = this.nebulaToolkitService.copyCollectionByWhiteList(auditSonCompanyDiscountSums, AuditSonCompanyDiscountSum.class, AuditSonCompanyDiscountSumVo.class, HashSet.class, ArrayList.class, new String[0]);
            return (List)auditSonCompanyDiscountSumVos;
        }
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("mdm_business_format");
        Map<Object, Object> businessFormatDictMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dictDataVoList)) {
            businessFormatDictMap = dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        }
        Set customerCodes = discountUpAccountList.stream().map(AuditCustomerDetailCollection::getCustomerCode).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
        Map<Object, Object> customerVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerCodes)) {
            List customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList(customerCodes));
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        Map<Object, Object> subComActivityDetailPlanItemVoMap = new HashMap();
        if (BusinessUnitEnum.SON_COMPANY.getCode().equals(audit.getBusinessUnitCode())) {
            List activityDetailCodes = discountUpAccountList.stream().map(AuditCustomerDetailCollection::getActivityDetailCode).collect(Collectors.toList());
            List subComActivityDetailPlanItemVoList = this.subComActivityDetailPlanItemVoService.findItemsByPlanItemCodes(activityDetailCodes);
            subComActivityDetailPlanItemVoMap = subComActivityDetailPlanItemVoList.stream().collect(Collectors.toMap(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode, Function.identity()));
        }
        List activityFormList = discountUpAccountList.stream().map(AuditCustomerDetailCollection::getActivityFormCode).distinct().collect(Collectors.toList());
        List activityFormVoList = this.activityFormService.findByCodes(activityFormList);
        Map<Object, Object> activityFormVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(activityFormList)) {
            activityFormVoMap = activityFormVoList.stream().collect(Collectors.toMap(ActivityFormVo::getActivityFormCode, Function.identity()));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        ArrayList<AuditCustomerDetailCollection> updateUpAccountActivityCodeList = new ArrayList<AuditCustomerDetailCollection>();
        HashMap<String, AuditSonCompanyDiscountSum> auditSonCompanyDiscountSumMap = new HashMap<String, AuditSonCompanyDiscountSum>();
        for (AuditCustomerDetailCollection one : discountUpAccountList) {
            AuditCustomerDetailCollection auditCustomerDetailCollection = new AuditCustomerDetailCollection();
            auditCustomerDetailCollection.setId(one.getId());
            DictDataVo dictDataVo = (DictDataVo)businessFormatDictMap.get(audit.getBusinessFormatCode());
            Validate.notNull((Object)dictDataVo, (String)"\u672a\u67e5\u8be2\u5230\u4e1a\u6001\u3010%s\u3011\u7684\u6570\u636e\u5b57\u5178", (Object[])new Object[]{one.getBusinessFormatCode()});
            Map extendMap = dictDataVo.getExtendMap();
            String zfyt = null;
            if (extendMap != null) {
                zfyt = (String)extendMap.get("ZFYT");
            }
            Validate.notBlank((CharSequence)zfyt, (String)"\u4e1a\u6001\u3010%s\u3011\u672a\u7ef4\u62a4sap\u503c", (Object[])new Object[]{one.getBusinessFormatCode()});
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(one.getCustomerCode());
            String kunnr = null;
            String vkorg = null;
            String vtweg = null;
            if (customerVo == null && BusinessUnitEnum.SON_COMPANY.getCode().equals(audit.getBusinessUnitCode())) {
                kunnr = one.getCustomerCode();
                vkorg = audit.getCompanyCode();
                SubComActivityDetailPlanItemVo subComActivityDetailPlanItemVo = (SubComActivityDetailPlanItemVo)subComActivityDetailPlanItemVoMap.get(one.getActivityDetailCode());
                vtweg = subComActivityDetailPlanItemVo.getDistributionChannelCode();
            } else if (customerVo == null && BusinessUnitEnum.VERTICAL.getCode().equals(audit.getBusinessUnitCode())) {
                kunnr = one.getCustomerErpCode();
                vkorg = one.getSalesInstitutionErpCode();
                vtweg = one.getDistributionChannelCode();
            } else {
                kunnr = customerVo.getErpCode();
                vkorg = customerVo.getSalesInstitutionErpCode();
                vtweg = customerVo.getCustomerChannelCode();
            }
            ActivityFormVo activityFormVo = (ActivityFormVo)activityFormVoMap.get(one.getActivityFormCode());
            Validate.notNull((Object)activityFormVo, (String)"\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u3010%s\u3011\u672a\u627e\u5230", (Object[])new Object[]{one.getActivityFormCode()});
            String zfcxxs = activityFormVo.getSapCode();
            String key = zfyt + vkorg + vtweg + kunnr + zfcxxs;
            AuditSonCompanyDiscountSum auditSonCompanyDiscountSum1 = (AuditSonCompanyDiscountSum)((Object)auditSonCompanyDiscountSumMap.get(key));
            if (auditSonCompanyDiscountSum1 == null) {
                AuditSonCompanyDiscountSum auditSonCompanyDiscountSum = new AuditSonCompanyDiscountSum();
                String code = (String)this.generateCodeService.generateCode(AUDIT_SON_UP_ACCOUNT, 1, Integer.valueOf(14), 0L, TimeUnit.DAYS).get(0);
                auditSonCompanyDiscountSum.setUpAccountAuditCode(code);
                auditSonCompanyDiscountSum.setUpAccountActivityCode(code);
                auditSonCompanyDiscountSum.setKunnr(kunnr);
                auditSonCompanyDiscountSum.setVkorg(vkorg);
                auditSonCompanyDiscountSum.setVtweg(vtweg);
                auditSonCompanyDiscountSum.setZfamt1(one.getDiscountUpAccount().toPlainString());
                auditSonCompanyDiscountSum.setZfcxxs(zfcxxs);
                auditSonCompanyDiscountSum.setZfhdbegin(sdf.format(one.getActivityBeginTime()));
                auditSonCompanyDiscountSum.setZfhdend(sdf.format(one.getActivityEndTime()));
                auditSonCompanyDiscountSum.setZfyt(zfyt);
                auditSonCompanyDiscountSumMap.put(key, auditSonCompanyDiscountSum);
                auditCustomerDetailCollection.setUpAccountActivityCode(code);
            } else {
                String activityEndTime;
                auditSonCompanyDiscountSum1.setZfamt1(new BigDecimal(auditSonCompanyDiscountSum1.getZfamt1()).add(one.getDiscountUpAccount()).toPlainString());
                String activityBeginTime = sdf.format(one.getActivityBeginTime());
                if (activityBeginTime.compareTo(auditSonCompanyDiscountSum1.getZfhdbegin()) < 0) {
                    auditSonCompanyDiscountSum1.setZfhdbegin(activityBeginTime);
                }
                if ((activityEndTime = sdf.format(one.getActivityEndTime())).compareTo(auditSonCompanyDiscountSum1.getZfhdend()) > 0) {
                    auditSonCompanyDiscountSum1.setZfhdend(activityEndTime);
                }
                auditSonCompanyDiscountSumMap.put(key, auditSonCompanyDiscountSum1);
                auditCustomerDetailCollection.setUpAccountActivityCode(auditSonCompanyDiscountSum1.getUpAccountActivityCode());
            }
            updateUpAccountActivityCodeList.add(auditCustomerDetailCollection);
        }
        if (CollectionUtils.isNotEmpty(updateUpAccountActivityCodeList)) {
            this.auditCustomerDetailCollectionRepository.updateBatchById(updateUpAccountActivityCodeList);
        }
        if (CollectionUtils.isNotEmpty(values = auditSonCompanyDiscountSumMap.values())) {
            values.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            this.auditSonCompanyDiscountSumRepository.saveBatch(values);
            Collection auditSonCompanyDiscountSumVos = this.nebulaToolkitService.copyCollectionByWhiteList(values, AuditSonCompanyDiscountSum.class, AuditSonCompanyDiscountSumVo.class, HashSet.class, ArrayList.class, new String[0]);
            return (List)auditSonCompanyDiscountSumVos;
        }
        return null;
    }
}

