/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.cost.center.sdk.service.CostCenterVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.factory.sdk.service.FactoryVoService;
import com.biz.crm.mdm.business.factory.sdk.vo.FactoryVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.account.subject.sdk.service.AccountSubjectService;
import com.biz.crm.tpm.business.account.subject.sdk.vo.AccountSubjectVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.AuditInvoiceItemVo;
import com.biz.crm.tpm.business.audit.local.entity.Audit;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetail;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditInvoiceRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditRepository;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditInvoiceDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CustomerSupplierTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditImportService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceVo;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerAuditDetailImportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.EcCustomerAuditDetailImportsVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.ExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.service.TpmHeadSchemeForecastService;
import com.biz.crm.tpm.business.scheme.forecast.sdk.vo.TpmHeadSchemeForecastVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.jsonwebtoken.lang.Assert;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="auditImportService")
public class AuditImportServiceImpl
implements AuditImportService {
    private static final Logger log = LoggerFactory.getLogger(AuditImportServiceImpl.class);
    @Autowired(required=false)
    private AccountSubjectService accountSubjectService;
    @Autowired(required=false)
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private CostCenterVoService costCenterVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private AuditRepository auditRepository;
    @Autowired(required=false)
    private FactoryVoService factoryVoService;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired(required=false)
    private AuditCustomerDetailRepository auditCustomerDetailRepository;
    @Autowired(required=false)
    private AuditInvoiceRepository auditInvoiceRepository;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private TpmHeadSchemeForecastService tpmHeadSchemeForecastService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    private String alphabeticCharacter(String letter) {
        return letter.equals("\u662f") ? "Y" : "N";
    }

    private List<String> endCaseFormConversion(String endCaseForm) {
        String[] endCaseFormSplit;
        if (StringUtils.isEmpty((CharSequence)endCaseForm)) {
            return new ArrayList<String>();
        }
        ArrayList endCaseFormList = Lists.newArrayList();
        endCaseForm = endCaseForm.replace("\uff0c", ",");
        String[] stringArray = endCaseFormSplit = endCaseForm.split(",");
        int n = stringArray.length;
        block14: for (int i = 0; i < n; ++i) {
            String caseForm;
            switch (caseForm = stringArray[i]) {
                case "\u6298\u6263": {
                    endCaseFormList.add(EndCaseFormEnum.DISCOUNT.getCode());
                    continue block14;
                }
                case "\u62a5\u9500": {
                    endCaseFormList.add(EndCaseFormEnum.REIMBURSE.getCode());
                    continue block14;
                }
                case "\u7ea2\u5b57\u53d1\u7968": {
                    endCaseFormList.add(EndCaseFormEnum.RED_INVOICE.getCode());
                    continue block14;
                }
                case "\u968f\u5355": {
                    endCaseFormList.add(EndCaseFormEnum.WITH_ORDER.getCode());
                    continue block14;
                }
                case "\u5976\u5361": {
                    endCaseFormList.add(EndCaseFormEnum.MILK_CARD.getCode());
                    continue block14;
                }
            }
        }
        return endCaseFormList;
    }

    public AuditDto findAuditDtoByCode(String code) {
        Audit audit = (Audit)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditRepository.lambdaQuery().eq(Audit::getAuditCode, (Object)code)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        Assert.notNull((Object)((Object)audit), (String)("\u6838\u9500\u5355\u53f7\u3010" + code + "\u3011\u672a\u627e\u5230!"));
        Assert.isTrue((ProcessStatusEnum.PREPARE.getKey().equals(audit.getProcessStatus()) || ProcessStatusEnum.REJECT.getKey().equals(audit.getProcessStatus()) || ProcessStatusEnum.RECOVER.getKey().equals(audit.getProcessStatus()) ? 1 : 0) != 0, (String)("\u6838\u9500\u5355\u53f7\u3010" + code + "\u3011\u4e0d\u662f\u5f85\u63d0\u4ea4\u3001\u9a73\u56de\u6216\u8ffd\u56de\u72b6\u6001\uff0c\u4e0d\u80fd\u7f16\u8f91\uff01"));
        return (AuditDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditDto.class, HashSet.class, ArrayList.class, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AuditCustomerDetailDto> validate(List<CustomerAuditDetailImportsVo> importsVoList, AuditDto auditDto, Map<String, String> errorMap) throws Exception {
        List activityDetailPlanBudgetVos;
        List activityDetailCodes;
        List supplierVos;
        List productVos;
        List productVos2;
        List<AuditCustomerDetail> auditCustomerDetails;
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("tpm_audit_invoice_type");
        Map<String, DictDataVo> dictDataVoMap = dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        ArrayList resultList = Lists.newArrayList();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i = 0;
        Map<String, CostCenterVo> costCenterVoMap = this.queryCostCenter(importsVoList);
        Map<String, AccountSubjectVo> accountSubjectMap = this.accountSubjectInfoToMap(importsVoList, "\u7a0e\u8d39\u79d1\u76ee", 1);
        Map<String, AccountSubjectVo> reimburseItemMap = this.accountSubjectInfoToMap(importsVoList, "\u62a5\u9500\u9879\u76ee", 2);
        List productCodes = importsVoList.stream().map(CustomerAuditDetailImportsVo::getProductCode).collect(Collectors.toList());
        List impactProductCodes = importsVoList.stream().map(CustomerAuditDetailImportsVo::getImpactProductCode).collect(Collectors.toList());
        List<String> auditDetailCodes = importsVoList.stream().map(CustomerAuditDetailImportsVo::getAuditDetailCode).collect(Collectors.toList());
        HashMap<String, String> auditMap = new HashMap<String, String>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(auditDetailCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(auditCustomerDetails = this.auditCustomerDetailRepository.findByAuditDetailCodeList(auditDetailCodes))) {
            auditMap.putAll(auditCustomerDetails.stream().collect(Collectors.toMap(AuditCustomerDetail::getAuditDetailCode, AuditCustomerDetail::getAuditCode, (a, b) -> a)));
        }
        Map<Object, Object> productMap = new HashMap();
        Map<Object, Object> impactProductMap = new HashMap();
        String companyCode = auditDto.getCompanyCode();
        String businessUnitCode = auditDto.getBusinessUnitCode();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(productCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(productVos2 = this.productVoService.findByCodes(productCodes)))) {
            productMap = productVos2.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
        }
        Map<Object, Object> facMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(impactProductCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(productVos = this.productVoService.findByCodes(impactProductCodes)))) {
            impactProductMap = productVos.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
            HashSet<String> codes = new HashSet<String>();
            for (ProductVo productVo : productVos) {
                if (!StringUtils.isNotBlank((CharSequence)productVo.getBusinessFormatCode())) continue;
                codes.add(companyCode + productVo.getBusinessFormatCode() + businessUnitCode);
            }
            List factoryVos = this.factoryVoService.findDetailByOnlyKeys(new ArrayList(codes));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)factoryVos)) {
                facMap = factoryVos.stream().collect(Collectors.toMap(FactoryVo::getOnlyKey, FactoryVo::getFactory, (oldV, newV) -> newV));
            }
        }
        HashMap<String, String> supplierMap = new HashMap<String, String>();
        List supplierCodes = importsVoList.stream().map(CustomerAuditDetailImportsVo::getSupplierCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplierCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(supplierVos = this.supplierVoService.findBySupplierCodes(supplierCodes)))) {
            Map<String, String> map = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, SupplierVo::getSupplierName, (a, b) -> a));
            supplierMap.putAll(map);
        }
        String discountCode = EndCaseFormEnum.DISCOUNT.getCode();
        String reimburseCode = EndCaseFormEnum.REIMBURSE.getCode();
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("Purchase method");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)formatMap), (String)"\u672a\u67e5\u8be2\u5230\u8d2d\u4e70\u65b9\u5f0f\u5b57\u5178!Purchase method", (Object[])new Object[0]);
        Map payMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_pay_type");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)payMap), (String)"\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u5178!tpm_pay_type", (Object[])new Object[0]);
        Map productBaseUnitMap = this.dictToolkitService.findConvertMapByDictTypeCode("product_base_unit");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)productBaseUnitMap), (String)"\u672a\u67e5\u8be2\u5230\u5546\u54c1\u57fa\u672c\u5355\u4f4d\u5b57\u5178!Purchase method", (Object[])new Object[0]);
        Map customerSupplierMap = this.dictToolkitService.findConvertMapByDictTypeCode("customer_supplier");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)customerSupplierMap), (String)"\u672a\u67e5\u8be2\u5230\u5ba2\u5546\u7c7b\u578b\u5b57\u5178!customer_supplier", (Object[])new Object[0]);
        Map yesNoMap = this.dictToolkitService.findConvertMapByDictTypeCode("yesOrNO");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)yesNoMap), (String)"\u672a\u67e5\u8be2\u5230\u5b57\u5178!yesOrNO", (Object[])new Object[0]);
        for (CustomerAuditDetailImportsVo customerAuditDetailImports : importsVoList) {
            ArrayList errorMsgList = Lists.newArrayList();
            try {
                AccountSubjectVo reimburseItemAccountSubject;
                String reimburseItem;
                AccountSubjectVo accountSubjectVo;
                String taxSubject;
                List<String> endCaseFormList;
                String endCaseForm;
                String s;
                String supplierCode;
                String impactProductCode;
                String overdue;
                String auditType;
                String customerSupplierType;
                String baseUnit;
                String productCode;
                String isPushSap;
                String wholeAudit;
                String deemedSale;
                String payWayCode;
                ++i;
                AuditCustomerDetailDto auditCustomerDetail = new AuditCustomerDetailDto();
                if (StringUtils.isNotBlank((CharSequence)customerAuditDetailImports.getCostCenter())) {
                    CostCenterVo costCenterVo = costCenterVoMap.get(customerAuditDetailImports.getCostCenter());
                    if (ObjectUtil.isNotNull((Object)costCenterVo)) {
                        auditCustomerDetail.setCostCenter(costCenterVo.getCostCenterCode());
                        auditCustomerDetail.setCostCenterName(costCenterVo.getCostCenterName());
                        auditCustomerDetail.setCostCenterNameI(costCenterVo.getCostCenterName());
                        auditCustomerDetail.setProfitCenter(costCenterVo.getProfitCenterCode());
                        auditCustomerDetail.setProfitCenterName(costCenterVo.getProfitCenterName());
                    } else {
                        errorMsgList.add("\u6210\u672c\u4e2d\u5fc3[" + customerAuditDetailImports.getCostCenter() + "]\u586b\u5199\u6709\u8bef!");
                    }
                } else {
                    auditCustomerDetail.setProfitCenter(null);
                    auditCustomerDetail.setProfitCenterName(null);
                }
                BeanUtils.copyProperties((Object)customerAuditDetailImports, (Object)auditCustomerDetail);
                this.auditDetailAssignment(auditCustomerDetail, customerAuditDetailImports, i, format, auditMap, errorMsgList, dictDataVoMap);
                String buyWay = customerAuditDetailImports.getBuyWay();
                if (StringUtils.isNotBlank((CharSequence)buyWay)) {
                    String s2 = (String)formatMap.get(buyWay);
                    if (StringUtils.isBlank((CharSequence)s2)) {
                        errorMsgList.add("\u8d2d\u4e70\u65b9\u5f0f\u586b\u5199\u6709\u8bef!");
                    }
                    auditCustomerDetail.setBuyWay(s2);
                }
                if (StringUtils.isNotBlank((CharSequence)(payWayCode = customerAuditDetailImports.getPayWayCode()))) {
                    auditCustomerDetail.setPayWayName(payWayCode);
                    String s3 = (String)payMap.get(payWayCode);
                    if (StringUtils.isBlank((CharSequence)s3)) {
                        errorMsgList.add("\u4ed8\u6b3e\u65b9\u5f0f\u586b\u5199\u6709\u8bef!");
                    }
                    auditCustomerDetail.setPayWayCode(s3);
                }
                if (CharSequenceUtil.isEmpty((CharSequence)(deemedSale = customerAuditDetailImports.getDeemedSale()))) {
                    auditCustomerDetail.setDeemedSale(com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.NO.getCode());
                } else {
                    String deemedSaleStr = CharSequenceUtil.equals((CharSequence)deemedSale, (CharSequence)com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getValue()) ? com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getCode() : com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.NO.getCode();
                    auditCustomerDetail.setDeemedSale(deemedSaleStr);
                }
                String isDeductionFeePool = customerAuditDetailImports.getIsDeductionFeePool();
                if (StringUtils.isNotEmpty((CharSequence)isDeductionFeePool)) {
                    auditCustomerDetail.setIsDeductionFeePool(this.alphabeticCharacter(isDeductionFeePool));
                }
                if (StringUtils.isNotEmpty((CharSequence)(wholeAudit = customerAuditDetailImports.getWholeAudit()))) {
                    auditCustomerDetail.setWholeAudit(this.alphabeticCharacter(wholeAudit));
                }
                if (StringUtils.isNotEmpty((CharSequence)(isPushSap = customerAuditDetailImports.getIsPushSap()))) {
                    auditCustomerDetail.setIsPushSap(this.alphabeticCharacter(isPushSap));
                }
                if (StringUtils.isNotBlank((CharSequence)(productCode = customerAuditDetailImports.getProductCode()))) {
                    List productVos3 = (List)productMap.get(productCode);
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)productVos3)) {
                        errorMsgList.add("\u4ea7\u54c1\u7f16\u7801\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230\u4ea7\u54c1\u4fe1\u606f!");
                    }
                    auditCustomerDetail.setProductName(((ProductVo)productVos3.get(0)).getProductName());
                }
                if (StringUtils.isNotBlank((CharSequence)(baseUnit = customerAuditDetailImports.getBaseUnit()))) {
                    String s4 = (String)productBaseUnitMap.get(baseUnit);
                    if (StringUtils.isBlank((CharSequence)s4)) {
                        errorMsgList.add("\u5355\u4f4d\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230!");
                    }
                    auditCustomerDetail.setBaseUnit(s4);
                }
                if (StringUtils.isNotBlank((CharSequence)(customerSupplierType = customerAuditDetailImports.getCustomerSupplierType()))) {
                    String s5 = (String)customerSupplierMap.get(customerSupplierType);
                    if (StringUtils.isBlank((CharSequence)s5)) {
                        errorMsgList.add("\u5ba2\u5546\u7c7b\u578b\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230!");
                    }
                    auditCustomerDetail.setCustomerSupplierType(s5);
                }
                if (StringUtils.isNotBlank((CharSequence)(auditType = customerAuditDetailImports.getAuditType()))) {
                    String s6 = TpmAuditTypeEnum.getCodeByDesc((String)auditType);
                    if (StringUtils.isBlank((CharSequence)s6)) {
                        errorMsgList.add("\u6838\u9500\u65b9\u5f0f\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230!");
                    }
                    auditCustomerDetail.setAuditType(s6);
                }
                if (StringUtils.isNotBlank((CharSequence)(overdue = customerAuditDetailImports.getOverdue()))) {
                    String s7 = (String)yesNoMap.get(overdue);
                    if (StringUtils.isBlank((CharSequence)s7)) {
                        errorMsgList.add("\u662f\u5426\u903e\u671f\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230!");
                    }
                    auditCustomerDetail.setOverdue(s7);
                }
                if (StringUtils.isNotBlank((CharSequence)(impactProductCode = customerAuditDetailImports.getImpactProductCode()))) {
                    List productVos4 = (List)impactProductMap.get(impactProductCode);
                    ProductVo productVo = new ProductVo();
                    if (CollectionUtil.isNotEmpty((Collection)productVos4)) {
                        productVo = (ProductVo)productVos4.get(0);
                    } else {
                        errorMsgList.add("\u51b2\u5dee\u4ea7\u54c1\u7f16\u7801\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230\u4ea7\u54c1\u4fe1\u606f!");
                    }
                    auditCustomerDetail.setImpactProductName(productVo.getProductName());
                    if (StringUtils.isBlank((CharSequence)baseUnit)) {
                        auditCustomerDetail.setBaseUnit(productVo.getBaseUnit());
                    }
                    if (StringUtils.isBlank((CharSequence)customerAuditDetailImports.getFactory())) {
                        String s8 = (String)facMap.get(companyCode + productVo.getBusinessFormatCode() + businessUnitCode);
                        auditCustomerDetail.setFactory(s8);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(supplierCode = customerAuditDetailImports.getSupplierCode())) && (s = (String)supplierMap.get(supplierCode)) == null) {
                    errorMsgList.add("\u4f9b\u5e94\u5546\u7f16\u7801\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230\u4f9b\u5e94\u5546\u4fe1\u606f!");
                }
                if (StringUtils.isBlank((CharSequence)(endCaseForm = customerAuditDetailImports.getEndCaseForm()))) {
                    errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(endCaseFormList = this.endCaseFormConversion(endCaseForm))) {
                    errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                } else {
                    auditCustomerDetail.setEndCaseFormList(endCaseFormList);
                }
                this.importRequiredVerification(i, discountCode, reimburseCode, auditCustomerDetail, isDeductionFeePool, wholeAudit, endCaseFormList, errorMsgList);
                auditCustomerDetail.setEndCaseForm(StringUtils.join(endCaseFormList, (String)","));
                if (Objects.nonNull(auditCustomerDetail.getDiscountTaxAmount()) && auditCustomerDetail.getDiscountTaxAmount().compareTo(BigDecimal.ZERO) != 0 && (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(endCaseFormList) || !endCaseFormList.contains(EndCaseFormEnum.DISCOUNT.getCode()))) {
                    errorMsgList.add("\u6298\u6263\u5e94\u5904\u7406\u91d1\u989d\u4e0d\u4e3a0\uff0c\u7ed3\u6848\u5f62\u5f0f\u5fc5\u987b\u5305\u542b\u6298\u6263");
                }
                if (Objects.nonNull(auditCustomerDetail.getReimburseTaxAmount()) && auditCustomerDetail.getReimburseTaxAmount().compareTo(BigDecimal.ZERO) != 0 && (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(endCaseFormList) || !endCaseFormList.contains(EndCaseFormEnum.REIMBURSE.getCode()) && !endCaseFormList.contains(EndCaseFormEnum.RED_INVOICE.getCode()))) {
                    errorMsgList.add("\u62a5\u9500\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e0d\u4e3a0\uff0c\u7ed3\u6848\u5f62\u5f0f\u5fc5\u987b\u5305\u542b\u62a5\u9500\u6216\u8005\u7ea2\u5b57\u53d1\u7968");
                }
                if (StringUtils.isNotEmpty((CharSequence)(taxSubject = auditCustomerDetail.getTaxSubject())) && !Objects.isNull(accountSubjectVo = accountSubjectMap.get(taxSubject))) {
                    auditCustomerDetail.setTaxSubjectName(accountSubjectVo.getAccountSubjectName());
                }
                if (StringUtils.isNotEmpty((CharSequence)(reimburseItem = auditCustomerDetail.getReimburseItem())) && !Objects.isNull(reimburseItemAccountSubject = reimburseItemMap.get(reimburseItem))) {
                    auditCustomerDetail.setReimburseItemName(reimburseItemAccountSubject.getAccountSubjectName());
                }
                if (Objects.nonNull(auditCustomerDetail.getReimburseTaxAmount()) && StringUtils.isNotEmpty((CharSequence)auditCustomerDetail.getReimburseTaxRate())) {
                    auditCustomerDetail.setReimburseAmount(auditCustomerDetail.getReimburseTaxAmount().divide(new BigDecimal(auditCustomerDetail.getReimburseTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP).add(BigDecimal.ONE), 6, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
                }
                resultList.add(auditCustomerDetail);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                errorMsgList.add(e.getMessage());
                log.info("\u62a5\u9519\u4fe1\u606fmessage\uff1a{}", (Object)errorMsgList);
            }
            finally {
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)errorMsgList)) continue;
                errorMap.put(customerAuditDetailImports.getAuditDetailCode(), String.join((CharSequence)",", errorMsgList));
                log.info("\u62a5\u9519\u7a3d\u6838Map:{}", errorMap);
            }
        }
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)auditDto.getBusinessUnitCode()) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(activityDetailCodes = resultList.stream().map(AuditCustomerDetailDto::getActivityDetailCode).collect(Collectors.toList())) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(activityDetailPlanBudgetVos = this.activityDetailPlanItemSdkService.findPlanItemCodeByActivityDetailItemCodes(activityDetailCodes)))) {
            List tpmHeadSchemeForecastVos;
            Map<String, List<ActivityDetailPlanBudgetVo>> activityDetailPlanBudgetVoMap = activityDetailPlanBudgetVos.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getRelatePlanItemCode));
            List planItemCodes = activityDetailPlanBudgetVos.stream().map(ActivityDetailPlanBudgetVo::getRelatePlanItemCode).distinct().collect(Collectors.toList());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(planItemCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(tpmHeadSchemeForecastVos = this.tpmHeadSchemeForecastService.findByPlanItemCodes(planItemCodes)))) {
                Map tpmHeadSchemeForecastVoMap = tpmHeadSchemeForecastVos.stream().collect(Collectors.toMap(TpmHeadSchemeForecastVo::getSchemeItemCode, Function.identity()));
                List<String> idList = resultList.stream().map(AuditCustomerDetailDto::getId).collect(Collectors.toList());
                List<AuditCustomerDetail> auditCustomerDetails2 = this.auditCustomerDetailRepository.findByActivityDetailCodeListExcludeThis(new HashSet<String>(activityDetailCodes), idList);
                Map<String, List<AuditCustomerDetail>> oldAuditCustomerDetailMap = auditCustomerDetails2.stream().collect(Collectors.groupingBy(AuditCustomerDetail::getActivityDetailCode));
                Map thisAuditCustomerDetailMap = resultList.stream().collect(Collectors.toMap(AuditCustomerDetailDto::getActivityDetailCode, Function.identity()));
                activityDetailPlanBudgetVoMap.forEach((key, value) -> {
                    BigDecimal endCaseAmount = BigDecimal.ZERO;
                    TpmHeadSchemeForecastVo tpmHeadSchemeForecastVo = (TpmHeadSchemeForecastVo)tpmHeadSchemeForecastVoMap.get(key);
                    for (ActivityDetailPlanBudgetVo activityDetailPlanBudgetVo : value) {
                        AuditCustomerDetailDto auditCustomerDetailDto;
                        String detailPlanItemCode = activityDetailPlanBudgetVo.getDetailPlanItemCode();
                        List auditCustomerDetails1 = (List)oldAuditCustomerDetailMap.get(detailPlanItemCode);
                        if (CollectionUtils.isNotEmpty((Collection)auditCustomerDetails1)) {
                            endCaseAmount = endCaseAmount.add(auditCustomerDetails1.stream().map(AuditCustomerDetail::getThisAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        }
                        if ((auditCustomerDetailDto = (AuditCustomerDetailDto)thisAuditCustomerDetailMap.get(detailPlanItemCode)) == null) continue;
                        endCaseAmount = endCaseAmount.add(auditCustomerDetailDto.getThisAuditAmount());
                    }
                    BigDecimal actualAuditAmount = Optional.ofNullable(tpmHeadSchemeForecastVo.getActualAuditAmount()).orElse(tpmHeadSchemeForecastVo.getEstimatedWriteOffAmount());
                    Validate.isTrue((endCaseAmount.compareTo(actualAuditAmount) <= 0 ? 1 : 0) != 0, (String)"\u65b9\u6848\u660e\u7ec6\u7f16\u7801\u3010%s\u3011\u8d85\u51fa\u5b9e\u9645\u6838\u9500\u91d1\u989d\uff0c\u8bf7\u9009\u62e9\u9884\u7b97", (Object[])new Object[]{key});
                });
            }
        }
        this.verifyCustomer(resultList, auditDto);
        return resultList;
    }

    public List<AuditCustomerDetailDto> ecValidate(List<EcCustomerAuditDetailImportsVo> importsVoList, AuditDto auditDto) {
        List generalExpensesDtos;
        List costCenterVoList;
        List accountSubjectVos;
        List productVos;
        List productCodes;
        List impactProductVos;
        List customerVos;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(importsVoList)) {
            throw new RuntimeException("\u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<Object, Object> supplierVoMap = new HashMap();
        List supplierCodes = importsVoList.stream().map(EcCustomerAuditDetailImportsVo::getSupplierCode).filter(Objects::nonNull).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplierCodes)) {
            List supplierVos = this.supplierVoService.findBySupplierCodes(supplierCodes);
            supplierVoMap = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, Function.identity()));
        }
        List endCaseCustomerCodes = importsVoList.stream().map(EcCustomerAuditDetailImportsVo::getEndCaseCustomerCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> customerVoMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(endCaseCustomerCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(customerVos = this.customerVoService.findBaseByCustomerCodes(endCaseCustomerCodes)))) {
            customerVoMap = customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        List impactProductCodes = importsVoList.stream().map(EcCustomerAuditDetailImportsVo::getImpactProductCode).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> productVoMap = new HashMap();
        Map<Object, Object> facMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(impactProductCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(impactProductVos = this.productVoService.findByCodes(impactProductCodes)))) {
            productVoMap = impactProductVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
            HashSet<String> codes = new HashSet<String>();
            for (ProductVo productVo : impactProductVos) {
                if (!StringUtils.isNotBlank((CharSequence)productVo.getBusinessFormatCode())) continue;
                codes.add(auditDto.getCompanyCode() + productVo.getBusinessFormatCode() + auditDto.getBusinessUnitCode());
            }
            List factoryVos = this.factoryVoService.findDetailByOnlyKeys(new ArrayList(codes));
            if (CollectionUtils.isNotEmpty((Collection)factoryVos)) {
                facMap = factoryVos.stream().collect(Collectors.toMap(FactoryVo::getOnlyKey, FactoryVo::getFactory, (oldV, newV) -> newV));
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(productCodes = importsVoList.stream().map(EcCustomerAuditDetailImportsVo::getProductCode).filter(Objects::nonNull).collect(Collectors.toList())) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(productVos = this.productVoService.findByCodes(productCodes)))) {
            productVoMap.putAll(productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity())));
        }
        List reimburseItems = importsVoList.stream().map(EcCustomerAuditDetailImportsVo::getReimburseItem).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> accountSubjectVoMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(reimburseItems) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(accountSubjectVos = this.accountSubjectService.findListByCode(reimburseItems)))) {
            accountSubjectVoMap = accountSubjectVos.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode, Function.identity()));
        }
        List costCenters = importsVoList.stream().map(EcCustomerAuditDetailImportsVo::getCostCenter).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> costCenterVoMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costCenters) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(costCenterVoList = this.costCenterVoService.findByCodeList(costCenters)))) {
            costCenterVoMap = costCenterVoList.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode, Function.identity()));
        }
        ArrayList<AuditCustomerDetailDto> dtos = new ArrayList<AuditCustomerDetailDto>();
        List activityDetailCodes = importsVoList.stream().filter(o -> StringUtils.isEmpty((CharSequence)o.getId())).map(EcCustomerAuditDetailImportsVo::getActivityDetailCode).collect(Collectors.toList());
        Map<Object, Object> generalExpensesMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(activityDetailCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(generalExpensesDtos = this.generalExpensesService.findByDetailCodeList(activityDetailCodes)))) {
            generalExpensesMap = generalExpensesDtos.stream().collect(Collectors.toMap(ExpensesDto::getExpensesCode, Function.identity()));
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (EcCustomerAuditDetailImportsVo vo : importsVoList) {
            ProductVo productVo;
            AuditCustomerDetailDto dto = new AuditCustomerDetailDto();
            BeanUtils.copyProperties((Object)vo, (Object)dto);
            Validate.notBlank((CharSequence)vo.getActivityDetailCode(), (String)"\u6d3b\u52a8\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getActivityCode(), (String)"\u6d3b\u52a8\u7533\u8bf7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getActivityTypeCode(), (String)"\u6d3b\u52a8\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getActivityFormCode(), (String)"\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getActivityBeginTime(), (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getActivityEndTime(), (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getCustomerSupplierType(), (String)"\u5ba2\u5546\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getEndCaseForm(), (String)"\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getThisAuditAmount(), (String)"\u672c\u6b21\u7ed3\u6848\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getWholeAudit(), (String)"\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)vo.getIsPushSap(), (String)"\u662f\u5426\u4e0a\u5e10\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            try {
                dto.setActivityBeginTime(format.parse(vo.getActivityBeginTime()));
                dto.setActivityEndTime(format.parse(vo.getActivityEndTime()));
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            dto.setEndCaseForm(EndCaseFormEnum.transitionStr((String)vo.getEndCaseForm()));
            dto.setWholeAudit(com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.getByValue((String)vo.getWholeAudit()));
            dto.setIsPushSap(com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.getByValue((String)vo.getIsPushSap()));
            dto.setApplyAmount(this.stringTransitionBigDecimal(vo.getApplyAmount(), "\u7533\u8bf7\u91d1\u989d"));
            dto.setAuditAmount(this.stringTransitionBigDecimal(vo.getAuditAmount(), "\u9884\u6838\u9500\u91d1\u989d"));
            dto.setWithholdingAmount(this.stringTransitionBigDecimal(vo.getWithholdingAmount(), "\u9884\u63d0\u91d1\u989d"));
            dto.setDiscountChargeAgainstPrepayAmount(this.stringTransitionBigDecimal(vo.getDiscountChargeAgainstPrepayAmount(), "\u6298\u6263\u51b2\u9500\u9884\u4ed8\u91d1\u989d"));
            dto.setReimburseChargeAgainstPrepayAmount(this.stringTransitionBigDecimal(vo.getReimburseChargeAgainstPrepayAmount(), "\u62a5\u9500\u51b2\u9500\u9884\u4ed8\u91d1\u989d"));
            dto.setThisAuditAmount(this.stringTransitionBigDecimal(vo.getThisAuditAmount(), "\u672c\u6b21\u7ed3\u6848\u91d1\u989d"));
            dto.setAlreadyAuditAmount(this.stringTransitionBigDecimal(vo.getAlreadyAuditAmount(), "\u5df2\u7ed3\u6848\u91d1\u989d"));
            dto.setActivityDetailAlreadyEndCaseAmount(this.stringTransitionBigDecimal(vo.getActivityDetailAlreadyEndCaseAmount(), "\u7535\u5546\u6d3b\u52a8\u660e\u7ec6\u5df2\u7ed3\u6848\u91d1\u989d"));
            dto.setDiscountTaxAmount(this.stringTransitionBigDecimal(vo.getDiscountTaxAmount(), "\u6298\u6263\u5e94\u5904\u7406\u91d1\u989d"));
            dto.setDiscountTaxDeduction(this.stringTransitionBigDecimal(vo.getDiscountTaxDeduction(), "\u6298\u6263\u6263\u7a0e\u91d1\u989d"));
            dto.setDiscountAmount(this.stringTransitionBigDecimal(vo.getDiscountAmount(), "\u5165\u8d39\u7528\u6c60\u91d1\u989d"));
            dto.setReimburseTaxAmount(this.stringTransitionBigDecimal(vo.getReimburseTaxAmount(), "\u62a5\u9500\u91d1\u989d(\u542b\u7a0e)"));
            dto.setReimburseAmount(this.stringTransitionBigDecimal(vo.getReimburseAmount(), "\u62a5\u9500\u91d1\u989d(\u672a\u7a0e)"));
            dto.setTaxQuota(this.stringTransitionBigDecimal(vo.getTaxQuota(), "\u7a0e\u989d"));
            String endCaseForm = vo.getEndCaseForm();
            List<String> endCaseFormList = this.endCaseFormConversion(endCaseForm);
            dto.setEndCaseFormList(endCaseFormList);
            dto.setEndCaseForm(StringUtils.join(endCaseFormList, (String)","));
            if (StringUtils.isNotEmpty((CharSequence)vo.getSupplierCode())) {
                SupplierVo supplierVo = (SupplierVo)supplierVoMap.get(vo.getSupplierCode());
                if (supplierVo != null) {
                    dto.setSupplierName(supplierVo.getSupplierName());
                } else {
                    throw new RuntimeException("\u4f9b\u5e94\u5546" + vo.getSupplierCode() + "\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getEndCaseCustomerCode())) {
                CustomerVo customerVo = (CustomerVo)customerVoMap.get(vo.getEndCaseCustomerCode());
                if (customerVo != null) {
                    dto.setEndCaseCustomerName(customerVo.getCustomerName());
                } else {
                    throw new RuntimeException("\u7ed3\u6848\u5ba2\u6237" + vo.getEndCaseCustomerCode() + "\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getImpactProductCode())) {
                productVo = (ProductVo)productVoMap.get(vo.getImpactProductCode());
                if (productVo != null) {
                    dto.setImpactProductName(productVo.getProductName());
                    dto.setOffsetProductCode(vo.getImpactProductCode());
                    dto.setOffsetProductName(dto.getImpactProductName());
                    dto.setBaseUnit(productVo.getBaseUnit());
                    String onlyKey = auditDto.getCompanyCode() + productVo.getBusinessFormatCode() + auditDto.getBusinessUnitCode();
                    dto.setFactory((String)facMap.get(onlyKey));
                } else {
                    throw new RuntimeException("\u51b2\u5dee\u4ea7\u54c1" + vo.getImpactProductCode() + "\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getProductCode())) {
                productVo = (ProductVo)productVoMap.get(vo.getProductCode());
                if (productVo != null) {
                    dto.setProductName(productVo.getProductName());
                } else {
                    throw new RuntimeException("\u4ea7\u54c1" + vo.getProductCode() + "\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getReimburseItem())) {
                AccountSubjectVo accountSubjectVo = (AccountSubjectVo)accountSubjectVoMap.get(vo.getReimburseItem());
                if (accountSubjectVo != null) {
                    dto.setReimburseItemName(accountSubjectVo.getAccountSubjectName());
                } else {
                    throw new RuntimeException("\u62a5\u9500\u9879\u76ee" + vo.getReimburseItem() + "\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230");
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)vo.getCostCenter())) {
                CostCenterVo costCenterVo = (CostCenterVo)costCenterVoMap.get(vo.getCostCenter());
                if (costCenterVo != null) {
                    dto.setCostCenterNameI(costCenterVo.getCostCenterName());
                    dto.setCostCenterName(costCenterVo.getCostCenterName());
                    dto.setProfitCenter(costCenterVo.getProfitCenterCode());
                    dto.setProfitCenterName(costCenterVo.getProfitCenterName());
                } else {
                    throw new RuntimeException("\u6210\u672c\u4e2d\u5fc3" + vo.getCostCenter() + "\u672a\u5728\u7cfb\u7edf\u4e2d\u67e5\u8be2\u5230");
                }
            }
            dto.setDeemedSale(com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.NO.getCode());
            if (StringUtils.isEmpty((CharSequence)vo.getId())) {
                GeneralExpensesDto generalExpensesDto = (GeneralExpensesDto)generalExpensesMap.get(vo.getActivityDetailCode());
                Validate.notNull((Object)generalExpensesDto, (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u3010%s\u3011,\u672a\u5728\u7cfb\u7edf\u4e2d\u627e\u5230", (Object[])new Object[]{vo.getActivityDetailCode()});
                if (!com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getCode().equals(auditDto.getWhetherSpeciallyApproved())) {
                    Validate.isTrue((!com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getCode().equals(generalExpensesDto.getWholeAudit()) ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u7ec6\u6848\u660e\u7ec6\u3010%s\u3011,\u5df2\u7ecf\u5b8c\u5168\u7ed3\u6848", (Object[])new Object[]{vo.getActivityDetailCode()});
                }
                this.newAddItem(dto, vo, generalExpensesDto);
            }
            dtos.add(dto);
        }
        for (AuditCustomerDetailDto dto : dtos) {
            dto.setEcSplit(this.getThisEcSplit(dtos, dto.getActivityDetailCode()));
        }
        log.info("\u7535\u5546\u7ed3\u6848\u6838\u9500\u5bfc\u5165dtos:{}", (Object)JsonUtils.obj2JsonString(dtos));
        return dtos;
    }

    private String getThisEcSplit(List<AuditCustomerDetailDto> dtos, String activityDetailCode) {
        long count = dtos.stream().map(AuditCustomerDetailDto::getActivityDetailCode).filter(o -> o.equals(activityDetailCode)).count();
        if (count > 1L) {
            return com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getCode();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AuditCustomerDetailDto> validate2(LinkedHashMap<Integer, CustomerAuditDetailImportsVo> data, AuditDto auditDto, Map<Integer, String> errorMap) {
        List activityDetailPlanBudgetVos;
        List activityDetailCodes;
        List supplierVos;
        List productVos;
        List productVos2;
        List<AuditCustomerDetail> auditCustomerDetails;
        List dictDataVoList = this.dictDataVoService.findByDictTypeCode("tpm_audit_invoice_type");
        Map<String, DictDataVo> dictDataVoMap = dictDataVoList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, Function.identity()));
        String uuidkey = auditDto.getUuidkey();
        log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165\u9a8c\u8bc11,uuidkey:{}", (Object)uuidkey);
        ArrayList resultList = Lists.newArrayList();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int i = 0;
        ArrayList<CustomerAuditDetailImportsVo> importsVoList = new ArrayList<CustomerAuditDetailImportsVo>(data.values());
        Map<String, CostCenterVo> costCenterVoMap = this.queryCostCenter(importsVoList);
        Map<String, AccountSubjectVo> accountSubjectMap = this.accountSubjectInfoToMap(importsVoList, "\u7a0e\u8d39\u79d1\u76ee", 1);
        Map<String, AccountSubjectVo> reimburseItemMap = this.accountSubjectInfoToMap(importsVoList, "\u62a5\u9500\u9879\u76ee", 2);
        List productCodes = importsVoList.stream().map(CustomerAuditDetailImportsVo::getProductCode).collect(Collectors.toList());
        List impactProductCodes = importsVoList.stream().map(CustomerAuditDetailImportsVo::getImpactProductCode).collect(Collectors.toList());
        List<String> auditDetailCodes = importsVoList.stream().map(CustomerAuditDetailImportsVo::getAuditDetailCode).collect(Collectors.toList());
        HashMap<String, String> auditMap = new HashMap<String, String>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(auditDetailCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(auditCustomerDetails = this.auditCustomerDetailRepository.findByAuditDetailCodeList(auditDetailCodes))) {
            auditMap.putAll(auditCustomerDetails.stream().collect(Collectors.toMap(AuditCustomerDetail::getAuditDetailCode, AuditCustomerDetail::getAuditCode, (a, b) -> a)));
        }
        Map<Object, Object> productMap = new HashMap();
        Map<Object, Object> impactProductMap = new HashMap();
        String companyCode = auditDto.getCompanyCode();
        String businessUnitCode = auditDto.getBusinessUnitCode();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(productCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(productVos2 = this.productVoService.findByCodes(productCodes)))) {
            productMap = productVos2.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
        }
        Map<Object, Object> facMap = new HashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(impactProductCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(productVos = this.productVoService.findByCodes(impactProductCodes)))) {
            impactProductMap = productVos.stream().collect(Collectors.groupingBy(ProductVo::getProductCode));
            HashSet<String> codes = new HashSet<String>();
            for (ProductVo productVo : productVos) {
                if (!StringUtils.isNotBlank((CharSequence)productVo.getBusinessFormatCode())) continue;
                codes.add(companyCode + productVo.getBusinessFormatCode() + businessUnitCode);
            }
            List factoryVos = this.factoryVoService.findDetailByOnlyKeys(new ArrayList(codes));
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)factoryVos)) {
                facMap = factoryVos.stream().collect(Collectors.toMap(FactoryVo::getOnlyKey, FactoryVo::getFactory, (oldV, newV) -> newV));
            }
        }
        HashMap<String, String> supplierMap = new HashMap<String, String>();
        List supplierCodes = importsVoList.stream().map(CustomerAuditDetailImportsVo::getSupplierCode).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplierCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(supplierVos = this.supplierVoService.findBySupplierCodes(supplierCodes)))) {
            Map<String, String> map = supplierVos.stream().collect(Collectors.toMap(SupplierVo::getSupplierCode, SupplierVo::getSupplierName, (a, b) -> a));
            supplierMap.putAll(map);
        }
        String discountCode = EndCaseFormEnum.DISCOUNT.getCode();
        String reimburseCode = EndCaseFormEnum.REIMBURSE.getCode();
        Map formatMap = this.dictToolkitService.findConvertMapByDictTypeCode("Purchase method");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)formatMap), (String)"\u672a\u67e5\u8be2\u5230\u8d2d\u4e70\u65b9\u5f0f\u5b57\u5178!Purchase method", (Object[])new Object[0]);
        Map payMap = this.dictToolkitService.findConvertMapByDictTypeCode("tpm_pay_type");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)payMap), (String)"\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u65b9\u5f0f\u5b57\u5178!tpm_pay_type", (Object[])new Object[0]);
        Map productBaseUnitMap = this.dictToolkitService.findConvertMapByDictTypeCode("product_base_unit");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)productBaseUnitMap), (String)"\u672a\u67e5\u8be2\u5230\u5546\u54c1\u57fa\u672c\u5355\u4f4d\u5b57\u5178!Purchase method", (Object[])new Object[0]);
        Map customerSupplierMap = this.dictToolkitService.findConvertMapByDictTypeCode("customer_supplier");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)customerSupplierMap), (String)"\u672a\u67e5\u8be2\u5230\u5ba2\u5546\u7c7b\u578b\u5b57\u5178!customer_supplier", (Object[])new Object[0]);
        Map yesNoMap = this.dictToolkitService.findConvertMapByDictTypeCode("yesOrNO");
        Validate.isTrue((boolean)ObjectUtils.isNotEmpty((Object)yesNoMap), (String)"\u672a\u67e5\u8be2\u5230\u5b57\u5178!yesOrNO", (Object[])new Object[0]);
        log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165\u9a8c\u8bc12,uuidkey:{}", (Object)uuidkey);
        int detailSize = data.values().size();
        for (Map.Entry<Integer, CustomerAuditDetailImportsVo> entry : data.entrySet()) {
            CustomerAuditDetailImportsVo customerAuditDetailImports = entry.getValue();
            ArrayList errorMsgList = Lists.newArrayList();
            try {
                AccountSubjectVo reimburseItemAccountSubject;
                String reimburseItem;
                AccountSubjectVo accountSubjectVo;
                String taxSubject;
                String endCaseForm;
                String s;
                String supplierCode;
                String impactProductCode;
                String overdue;
                String auditType;
                String customerSupplierType;
                String baseUnit;
                String productCode;
                String isPushSap;
                String wholeAudit;
                String deemedSale;
                String payWayCode;
                if (++i % 2000 == 0) {
                    log.info("\u7ed3\u6848\u6838\u9500\u7f16\u8f91\u5bfc\u5165\u9a8c\u8bc1\u884c\u660e\u7ec6:uuidkey:{},\u7b2c{}\u884c,\u603b\u5171{}\u884c", new Object[]{uuidkey, i, detailSize});
                }
                AuditCustomerDetailDto auditCustomerDetail = new AuditCustomerDetailDto();
                if (StringUtils.isNotBlank((CharSequence)customerAuditDetailImports.getCostCenter())) {
                    CostCenterVo costCenterVo = costCenterVoMap.get(customerAuditDetailImports.getCostCenter());
                    if (ObjectUtil.isNotNull((Object)costCenterVo)) {
                        auditCustomerDetail.setCostCenter(costCenterVo.getCostCenterCode());
                        auditCustomerDetail.setCostCenterName(costCenterVo.getCostCenterName());
                        auditCustomerDetail.setCostCenterNameI(costCenterVo.getCostCenterName());
                        auditCustomerDetail.setProfitCenter(costCenterVo.getProfitCenterCode());
                        auditCustomerDetail.setProfitCenterName(costCenterVo.getProfitCenterName());
                    } else {
                        errorMsgList.add("\u6210\u672c\u4e2d\u5fc3[" + customerAuditDetailImports.getCostCenter() + "]\u586b\u5199\u6709\u8bef!");
                    }
                } else {
                    auditCustomerDetail.setProfitCenter(null);
                    auditCustomerDetail.setProfitCenterName(null);
                }
                BeanUtils.copyProperties((Object)customerAuditDetailImports, (Object)auditCustomerDetail);
                this.auditDetailAssignment(auditCustomerDetail, customerAuditDetailImports, i, format, auditMap, errorMsgList, dictDataVoMap);
                String buyWay = customerAuditDetailImports.getBuyWay();
                if (StringUtils.isNotBlank((CharSequence)buyWay)) {
                    String s2 = (String)formatMap.get(buyWay);
                    if (StringUtils.isBlank((CharSequence)s2)) {
                        errorMsgList.add("\u8d2d\u4e70\u65b9\u5f0f\u586b\u5199\u6709\u8bef!");
                    }
                    auditCustomerDetail.setBuyWay(s2);
                }
                if (StringUtils.isNotBlank((CharSequence)(payWayCode = customerAuditDetailImports.getPayWayCode()))) {
                    auditCustomerDetail.setPayWayName(payWayCode);
                    String s3 = (String)payMap.get(payWayCode);
                    if (StringUtils.isBlank((CharSequence)s3)) {
                        errorMsgList.add("\u4ed8\u6b3e\u65b9\u5f0f\u586b\u5199\u6709\u8bef!");
                    }
                    auditCustomerDetail.setPayWayCode(s3);
                }
                if (CharSequenceUtil.isEmpty((CharSequence)(deemedSale = customerAuditDetailImports.getDeemedSale()))) {
                    auditCustomerDetail.setDeemedSale(com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.NO.getCode());
                } else {
                    String deemedSaleStr = CharSequenceUtil.equals((CharSequence)deemedSale, (CharSequence)com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getValue()) ? com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getCode() : com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.NO.getCode();
                    auditCustomerDetail.setDeemedSale(deemedSaleStr);
                }
                String isDeductionFeePool = customerAuditDetailImports.getIsDeductionFeePool();
                if (StringUtils.isNotEmpty((CharSequence)isDeductionFeePool)) {
                    auditCustomerDetail.setIsDeductionFeePool(this.alphabeticCharacter(isDeductionFeePool));
                }
                if (StringUtils.isNotEmpty((CharSequence)(wholeAudit = customerAuditDetailImports.getWholeAudit()))) {
                    auditCustomerDetail.setWholeAudit(this.alphabeticCharacter(wholeAudit));
                }
                if (StringUtils.isNotEmpty((CharSequence)(isPushSap = customerAuditDetailImports.getIsPushSap()))) {
                    auditCustomerDetail.setIsPushSap(this.alphabeticCharacter(isPushSap));
                }
                if (StringUtils.isNotBlank((CharSequence)(productCode = customerAuditDetailImports.getProductCode()))) {
                    List productVos3 = (List)productMap.get(productCode);
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)productVos3)) {
                        errorMsgList.add("\u4ea7\u54c1\u7f16\u7801\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230\u4ea7\u54c1\u4fe1\u606f!");
                    }
                    auditCustomerDetail.setProductName(((ProductVo)productVos3.get(0)).getProductName());
                }
                if (StringUtils.isNotBlank((CharSequence)(baseUnit = customerAuditDetailImports.getBaseUnit()))) {
                    String s4 = (String)productBaseUnitMap.get(baseUnit);
                    if (StringUtils.isBlank((CharSequence)s4)) {
                        errorMsgList.add("\u5355\u4f4d\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230!");
                    }
                    auditCustomerDetail.setBaseUnit(s4);
                }
                if (StringUtils.isNotBlank((CharSequence)(customerSupplierType = customerAuditDetailImports.getCustomerSupplierType()))) {
                    String s5 = (String)customerSupplierMap.get(customerSupplierType);
                    if (StringUtils.isBlank((CharSequence)s5)) {
                        errorMsgList.add("\u5ba2\u5546\u7c7b\u578b\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230!");
                    }
                    auditCustomerDetail.setCustomerSupplierType(s5);
                }
                if (StringUtils.isNotBlank((CharSequence)(auditType = customerAuditDetailImports.getAuditType()))) {
                    String s6 = TpmAuditTypeEnum.getCodeByDesc((String)auditType);
                    if (StringUtils.isBlank((CharSequence)s6)) {
                        errorMsgList.add("\u6838\u9500\u65b9\u5f0f\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230!");
                    }
                    auditCustomerDetail.setAuditType(s6);
                }
                if (StringUtils.isNotBlank((CharSequence)(overdue = customerAuditDetailImports.getOverdue()))) {
                    String s7 = (String)yesNoMap.get(overdue);
                    if (StringUtils.isBlank((CharSequence)s7)) {
                        errorMsgList.add("\u662f\u5426\u903e\u671f\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230!");
                    }
                    auditCustomerDetail.setOverdue(s7);
                }
                if (StringUtils.isNotBlank((CharSequence)(impactProductCode = customerAuditDetailImports.getImpactProductCode()))) {
                    List productVos4 = (List)impactProductMap.get(impactProductCode);
                    ProductVo productVo = new ProductVo();
                    if (CollectionUtil.isNotEmpty((Collection)productVos4)) {
                        productVo = (ProductVo)productVos4.get(0);
                    } else {
                        errorMsgList.add("\u51b2\u5dee\u4ea7\u54c1\u7f16\u7801\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230\u4ea7\u54c1\u4fe1\u606f!");
                    }
                    auditCustomerDetail.setImpactProductName(productVo.getProductName());
                    if (StringUtils.isBlank((CharSequence)baseUnit)) {
                        auditCustomerDetail.setBaseUnit(productVo.getBaseUnit());
                    }
                    if (StringUtils.isBlank((CharSequence)customerAuditDetailImports.getFactory())) {
                        String s8 = (String)facMap.get(companyCode + productVo.getBusinessFormatCode() + businessUnitCode);
                        auditCustomerDetail.setFactory(s8);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)(supplierCode = customerAuditDetailImports.getSupplierCode())) && (s = (String)supplierMap.get(supplierCode)) == null) {
                    errorMsgList.add("\u4f9b\u5e94\u5546\u7f16\u7801\u586b\u5199\u6709\u8bef\uff0c\u672a\u5339\u914d\u5230\u4f9b\u5e94\u5546\u4fe1\u606f!");
                }
                if (StringUtils.isBlank((CharSequence)(endCaseForm = customerAuditDetailImports.getEndCaseForm()))) {
                    errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                List<String> endCaseFormList = this.endCaseFormConversion(endCaseForm);
                Validate.isTrue((boolean)com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(endCaseFormList), (String)"\u7ed3\u6848\u5f62\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                log.info("----------------------------------\u660e\u7ec6\u5bfc\u5165\u7ed3\u6848\u5f62\u5f0f\uff1a" + endCaseFormList);
                auditCustomerDetail.setEndCaseFormList(endCaseFormList);
                this.importRequiredVerification(i, discountCode, reimburseCode, auditCustomerDetail, isDeductionFeePool, wholeAudit, endCaseFormList, errorMsgList);
                auditCustomerDetail.setEndCaseForm(StringUtils.join(endCaseFormList, (String)","));
                if (Objects.nonNull(auditCustomerDetail.getDiscountTaxAmount()) && auditCustomerDetail.getDiscountTaxAmount().compareTo(BigDecimal.ZERO) != 0 && (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(endCaseFormList) || !endCaseFormList.contains(EndCaseFormEnum.DISCOUNT.getCode()))) {
                    errorMsgList.add("\u6298\u6263\u5e94\u5904\u7406\u91d1\u989d\u4e0d\u4e3a0\uff0c\u7ed3\u6848\u5f62\u5f0f\u5fc5\u987b\u5305\u542b\u6298\u6263");
                }
                if (Objects.nonNull(auditCustomerDetail.getReimburseTaxAmount()) && auditCustomerDetail.getReimburseTaxAmount().compareTo(BigDecimal.ZERO) != 0 && (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(endCaseFormList) || !endCaseFormList.contains(EndCaseFormEnum.REIMBURSE.getCode()) && !endCaseFormList.contains(EndCaseFormEnum.RED_INVOICE.getCode()))) {
                    errorMsgList.add("\u62a5\u9500\u91d1\u989d\uff08\u542b\u7a0e\uff09\u4e0d\u4e3a0\uff0c\u7ed3\u6848\u5f62\u5f0f\u5fc5\u987b\u5305\u542b\u62a5\u9500\u6216\u8005\u7ea2\u5b57\u53d1\u7968");
                }
                if (StringUtils.isNotEmpty((CharSequence)(taxSubject = auditCustomerDetail.getTaxSubject())) && !Objects.isNull(accountSubjectVo = accountSubjectMap.get(taxSubject))) {
                    auditCustomerDetail.setTaxSubjectName(accountSubjectVo.getAccountSubjectName());
                }
                if (StringUtils.isNotEmpty((CharSequence)(reimburseItem = auditCustomerDetail.getReimburseItem())) && !Objects.isNull(reimburseItemAccountSubject = reimburseItemMap.get(reimburseItem))) {
                    auditCustomerDetail.setReimburseItemName(reimburseItemAccountSubject.getAccountSubjectName());
                }
                if (Objects.nonNull(auditCustomerDetail.getReimburseTaxAmount()) && StringUtils.isNotEmpty((CharSequence)auditCustomerDetail.getReimburseTaxRate())) {
                    auditCustomerDetail.setReimburseAmount(auditCustomerDetail.getReimburseTaxAmount().divide(new BigDecimal(auditCustomerDetail.getReimburseTaxRate()).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP).add(BigDecimal.ONE), 6, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP));
                }
                resultList.add(auditCustomerDetail);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                errorMsgList.add(e.getMessage());
            }
            finally {
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)errorMsgList)) continue;
                errorMap.put(entry.getKey(), String.join((CharSequence)",", errorMsgList));
            }
        }
        if (BusinessUnitEnum.HEADQUARTERS.getCode().equals(auditDto.getBusinessUnitCode()) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(activityDetailCodes = resultList.stream().map(AuditCustomerDetailDto::getActivityDetailCode).collect(Collectors.toList())) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(activityDetailPlanBudgetVos = this.activityDetailPlanItemSdkService.findPlanItemCodeByActivityDetailItemCodes(activityDetailCodes)))) {
            List tpmHeadSchemeForecastVos;
            Map<String, List<ActivityDetailPlanBudgetVo>> activityDetailPlanBudgetVoMap = activityDetailPlanBudgetVos.stream().collect(Collectors.groupingBy(ActivityDetailPlanBudgetVo::getRelatePlanItemCode));
            List planItemCodes = activityDetailPlanBudgetVos.stream().map(ActivityDetailPlanBudgetVo::getRelatePlanItemCode).distinct().collect(Collectors.toList());
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(planItemCodes) && com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)(tpmHeadSchemeForecastVos = this.tpmHeadSchemeForecastService.findByPlanItemCodes(planItemCodes)))) {
                Map tpmHeadSchemeForecastVoMap = tpmHeadSchemeForecastVos.stream().collect(Collectors.toMap(TpmHeadSchemeForecastVo::getSchemeItemCode, Function.identity()));
                List<String> idList = resultList.stream().map(AuditCustomerDetailDto::getId).collect(Collectors.toList());
                List<AuditCustomerDetail> auditCustomerDetails2 = this.auditCustomerDetailRepository.findByActivityDetailCodeListExcludeThis(new HashSet<String>(activityDetailCodes), idList);
                Map<String, List<AuditCustomerDetail>> oldAuditCustomerDetailMap = auditCustomerDetails2.stream().collect(Collectors.groupingBy(AuditCustomerDetail::getActivityDetailCode));
                Map thisAuditCustomerDetailMap = resultList.stream().collect(Collectors.toMap(AuditCustomerDetailDto::getActivityDetailCode, Function.identity()));
                activityDetailPlanBudgetVoMap.forEach((key, value) -> {
                    BigDecimal endCaseAmount = BigDecimal.ZERO;
                    TpmHeadSchemeForecastVo tpmHeadSchemeForecastVo = (TpmHeadSchemeForecastVo)tpmHeadSchemeForecastVoMap.get(key);
                    for (ActivityDetailPlanBudgetVo activityDetailPlanBudgetVo : value) {
                        AuditCustomerDetailDto auditCustomerDetailDto;
                        String detailPlanItemCode = activityDetailPlanBudgetVo.getDetailPlanItemCode();
                        List auditCustomerDetails1 = (List)oldAuditCustomerDetailMap.get(detailPlanItemCode);
                        if (CollectionUtils.isNotEmpty((Collection)auditCustomerDetails1)) {
                            endCaseAmount = endCaseAmount.add(auditCustomerDetails1.stream().map(AuditCustomerDetail::getThisAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        }
                        if ((auditCustomerDetailDto = (AuditCustomerDetailDto)thisAuditCustomerDetailMap.get(detailPlanItemCode)) == null) continue;
                        endCaseAmount = endCaseAmount.add(auditCustomerDetailDto.getThisAuditAmount());
                    }
                    BigDecimal actualAuditAmount = Optional.ofNullable(tpmHeadSchemeForecastVo.getActualAuditAmount()).orElse(tpmHeadSchemeForecastVo.getEstimatedWriteOffAmount());
                    Validate.isTrue((endCaseAmount.compareTo(actualAuditAmount) <= 0 ? 1 : 0) != 0, (String)"\u65b9\u6848\u660e\u7ec6\u7f16\u7801\u3010%s\u3011\u8d85\u51fa\u5b9e\u9645\u6838\u9500\u91d1\u989d\uff0c\u8bf7\u9009\u62e9\u9884\u7b97", (Object[])new Object[]{key});
                });
            }
        }
        this.verifyCustomer(resultList, auditDto);
        return resultList;
    }

    private void newAddItem(AuditCustomerDetailDto dto, EcCustomerAuditDetailImportsVo vo, GeneralExpensesDto generalExpensesDto) {
        dto.setId(UuidCrmUtil.general());
        dto.setAdd(com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getCode());
        dto.setActivityCode(generalExpensesDto.getPromotionPlanCode());
        dto.setActivityName(generalExpensesDto.getPromotionPlanName());
        dto.setActivityTypeCode(generalExpensesDto.getActivityTypeCode());
        dto.setActivityTypeName(generalExpensesDto.getActivityTypeName());
        dto.setActivityFormCode(generalExpensesDto.getActivityFormCode());
        dto.setActivityFormName(generalExpensesDto.getActivityFormName());
        dto.setAuditConditionName(generalExpensesDto.getAuditConditionType());
        dto.setAuditFormulaCode(generalExpensesDto.getAuditConditionCode());
        dto.setAuditFormulaName(generalExpensesDto.getAuditConditionName());
        dto.setActivityBeginTime(generalExpensesDto.getStartDate());
        dto.setActivityEndTime(generalExpensesDto.getEndDate());
        dto.setCustomerCode(generalExpensesDto.getCustomerCode());
        dto.setCustomerName(generalExpensesDto.getCustomerName());
        dto.setApplyAmount(generalExpensesDto.getApplyAmount());
        dto.setSalesOrgCode(generalExpensesDto.getSalesOrgCode());
        dto.setSalesOrgName(generalExpensesDto.getSalesOrgName());
        dto.setSupplierCode(vo.getSupplierCode());
        dto.setSupplierName(vo.getSupplierName());
        dto.setProductBrandCode(generalExpensesDto.getProductBrandCode());
        dto.setProductBrandName(generalExpensesDto.getProductBrandName());
        if (StringUtils.isNotEmpty((CharSequence)vo.getCustomerCode()) && StringUtils.isEmpty((CharSequence)dto.getEndCaseCustomerCode())) {
            dto.setEndCaseCustomerCode(vo.getCustomerCode());
            dto.setEndCaseCustomerName(vo.getCustomerName());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()) || StringUtils.isNotEmpty((CharSequence)dto.getSupplierCode())) {
            if (StringUtils.isNotEmpty((CharSequence)dto.getSupplierCode())) {
                dto.setCustomerSupplierType(CustomerSupplierTypeEnum.SUPPLIER.getValue());
            } else {
                dto.setCustomerSupplierType(CustomerSupplierTypeEnum.CUSTOMER.getValue());
            }
        }
    }

    private BigDecimal stringTransitionBigDecimal(String str, String msg) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            ArrayList<String> errorMsgList = new ArrayList<String>();
            this.paramsVaild(str, msg, 0, true, errorMsgList);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(errorMsgList)) {
                throw new RuntimeException(String.join((CharSequence)",", errorMsgList));
            }
            return new BigDecimal(str);
        }
        return null;
    }

    private void verifyCustomer(List<AuditCustomerDetailDto> importsVoList, AuditDto auditDto) {
        if (StringUtils.isEmpty((CharSequence)auditDto.getAuditCode())) {
            return;
        }
        if (!BusinessUnitEnum.isOnlineBusinessUnit((String)auditDto.getBusinessUnitCode()) && auditDto.getIsCollection().booleanValue()) {
            if (importsVoList.stream().map(AuditCustomerDetailDto::getIsPushSap).distinct().count() > 1L) {
                throw new RuntimeException("\u662f\u5426\u4e0a\u5e10\u5fc5\u987b\u4e00\u81f4");
            }
            if (CollectionUtils.isNotEmpty(importsVoList) && YesOrNoEnum.YES.getCode().equals(importsVoList.get(0).getIsPushSap())) {
                if (importsVoList.stream().filter(o -> o.getEndCaseFormList().contains(EndCaseFormEnum.REIMBURSE.getCode())).map(AuditCustomerDetailDto::getCustomerSupplierType).distinct().count() > 1L) {
                    throw new RuntimeException("\u5ba2\u5546\u7c7b\u578b\u5fc5\u987b\u4e00\u81f4");
                }
                if (CustomerSupplierTypeEnum.CUSTOMER.getValue().equals(importsVoList.get(0).getCustomerSupplierType()) && importsVoList.stream().filter(o -> o.getEndCaseFormList().contains(EndCaseFormEnum.REIMBURSE.getCode())).map(AuditCustomerDetailDto::getCustomerCode).distinct().count() > 1L) {
                    throw new RuntimeException("\u5ba2\u6237\u7f16\u7801\u5fc5\u987b\u4e00\u81f4");
                }
                if (CustomerSupplierTypeEnum.SUPPLIER.getValue().equals(importsVoList.get(0).getCustomerSupplierType()) && importsVoList.stream().filter(o -> o.getEndCaseFormList().contains(EndCaseFormEnum.REIMBURSE.getCode())).map(AuditCustomerDetailDto::getSupplierCode).distinct().count() > 1L) {
                    throw new RuntimeException("\u4f9b\u5e94\u5546\u7f16\u7801\u5fc5\u987b\u4e00\u81f4");
                }
            }
        }
    }

    private Map<String, CostCenterVo> queryCostCenter(List<CustomerAuditDetailImportsVo> importsVoList) {
        Map<Object, Object> costCenterVoMap = Maps.newHashMap();
        if (CollUtil.isEmpty(importsVoList)) {
            return costCenterVoMap;
        }
        List costCenterList = importsVoList.stream().map(CustomerAuditDetailImportsVo::getCostCenter).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costCenterList)) {
            List costCenterVoList = this.costCenterVoService.findByCodeList(costCenterList);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(costCenterList) || costCenterList.size() < 1) {
                return costCenterVoMap;
            }
            costCenterVoMap = costCenterVoList.stream().collect(Collectors.toMap(CostCenterVo::getCostCenterCode, Function.identity(), (a, b) -> a));
        }
        return costCenterVoMap;
    }

    private void importRequiredVerification(int i, String discountCode, String reimburseCode, AuditCustomerDetailDto auditCustomerDetail, String isDeductionFeePool, String wholeAudit, List<String> endCaseFormList, List<String> errorMsgList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(endCaseFormList)) {
            return;
        }
        boolean discountCodeContains = endCaseFormList.contains(discountCode);
        boolean reimburseCodeContains = endCaseFormList.contains(reimburseCode);
        if (discountCodeContains || reimburseCodeContains) {
            if (StringUtils.isEmpty((CharSequence)isDeductionFeePool)) {
                errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u6298\u6263/\u62a5\u9500\u60c5\u51b5\u4e0b\uff0c\u662f\u5426\u6263\u51cf\u8d39\u7528\u6c60\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((CharSequence)wholeAudit)) {
                errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u6298\u6263/\u62a5\u9500\u60c5\u51b5\u4e0b\uff0c\u662f\u5426\u5b8c\u5168\u7ed3\u6848\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (StringUtils.isEmpty((CharSequence)auditCustomerDetail.getIsPushSap())) {
                errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u6298\u6263/\u62a5\u9500\u60c5\u51b5\u4e0b\uff0c\u662f\u5426\u4e0a\u5e10\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (Objects.isNull(auditCustomerDetail.getThisAuditAmount())) {
                errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u6298\u6263/\u62a5\u9500\u60c5\u51b5\u4e0b\uff0c\u672c\u6b21\u7ed3\u6848\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            if (discountCodeContains) {
                if (com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getCode().equals(auditCustomerDetail.getIsPushSap()) && Objects.isNull(auditCustomerDetail.getDiscountTaxAmount())) {
                    errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u6298\u6263\u60c5\u51b5\u4e0b\uff0c\u6298\u6263\u5e94\u5904\u7406\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (Objects.nonNull(auditCustomerDetail.getDiscountTaxAmount()) && StringUtils.isEmpty((CharSequence)auditCustomerDetail.getDiscountTaxRate())) {
                    errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u6298\u6263\u60c5\u51b5\u4e0b\uff0c\u6298\u6263\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (endCaseFormList.size() == 1) {
                    auditCustomerDetail.setReimburseTaxRate(null);
                    auditCustomerDetail.setReimburseTaxAmount(BigDecimal.ZERO);
                    auditCustomerDetail.setReimburseAmount(BigDecimal.ZERO);
                    auditCustomerDetail.setTaxQuota(BigDecimal.ZERO);
                }
            }
            if (reimburseCodeContains) {
                if (StringUtils.isEmpty((CharSequence)auditCustomerDetail.getReimburseItem())) {
                    errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u62a5\u9500\u60c5\u51b5\u4e0b\uff0c\u62a5\u9500\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (StringUtils.isEmpty((CharSequence)auditCustomerDetail.getCostCenter())) {
                    errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u62a5\u9500\u60c5\u51b5\u4e0b,\u6210\u672c\u4e2d\u5fc3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (Objects.isNull(auditCustomerDetail.getReimburseTaxAmount())) {
                    errorMsgList.add("\u7ed3\u6848\u5f62\u5f0f\u62a5\u9500\u60c5\u51b5\u4e0b,\u62a5\u9500\u91d1\u989d(\u542b\u7a0e)\u4e0d\u80fd\u4e3a\u7a7a!");
                }
                if (endCaseFormList.size() == 1) {
                    auditCustomerDetail.setDiscountTaxRate(null);
                    auditCustomerDetail.setDiscountTaxAmount(BigDecimal.ZERO);
                    auditCustomerDetail.setDiscountAmount(BigDecimal.ZERO);
                    auditCustomerDetail.setDiscountTaxDeduction(BigDecimal.ZERO);
                }
            }
        }
    }

    public Map<String, ProductVo> productInfoToMap(List<CustomerAuditDetailImportsVo> importsVoList) {
        Map<Object, Object> productMap = Maps.newHashMap();
        try {
            List productVoList;
            List productCodes = importsVoList.stream().filter(detailImport -> StringUtils.isNotEmpty((CharSequence)detailImport.getImpactProductCode())).map(CustomerAuditDetailImportsVo::getImpactProductCode).distinct().collect(Collectors.toList());
            if (!productCodes.isEmpty() && productCodes.size() > 0 && !com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findByCodes(productCodes)))) {
                productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (p1, p2) -> p2));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("" + e.getMessage());
        }
        return productMap;
    }

    private Map<String, AccountSubjectVo> accountSubjectInfoToMap(List<CustomerAuditDetailImportsVo> importsVoList, String message, int type) throws IllegalArgumentException {
        List accountSubjectVoList;
        List codes = null;
        try {
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    codes = importsVoList.stream().filter(detailImport -> StringUtils.isNotEmpty((CharSequence)detailImport.getReimburseItem())).map(CustomerAuditDetailImportsVo::getReimburseItem).distinct().collect(Collectors.toList());
                    break;
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u83b7\u53d6\u79d1\u76ee\u5f02\u5e38:" + e.getMessage());
        }
        Map<Object, Object> accountSubjectMap = Maps.newHashMap();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(codes) && codes.size() > 0 && !com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)(accountSubjectVoList = this.accountSubjectService.findListByCode(codes)))) {
            accountSubjectMap = accountSubjectVoList.stream().collect(Collectors.toMap(AccountSubjectVo::getAccountSubjectCode, Function.identity(), (s1, s2) -> s2));
        }
        return accountSubjectMap;
    }

    private boolean paramsVaild(String param, String message, int i, boolean b, List<String> errorMsgList) {
        boolean pass = true;
        if (!AuditImportServiceImpl.isValidNumber(param)) {
            errorMsgList.add(message + "\u8f93\u5165\u6709\u8bef");
            pass = false;
        }
        if (!this.isValidDecimals(param) && b) {
            errorMsgList.add(message + "\u53ea\u80fd\u8f93\u5165\u4e24\u4f4d\u5c0f\u6570");
            pass = false;
        }
        return pass;
    }

    private boolean isValidDecimals(String str) {
        String reg = "^(\\-)?[0-9]+(\\.[0-9]{0,2})?$";
        return str.matches(reg);
    }

    private static boolean isValidDate(String str) {
        boolean judgeresult = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            judgeresult = false;
        }
        return judgeresult;
    }

    private static boolean isValidNumber(String str) {
        String reg = "^-?[0-9]+(.[0-9]+)?$";
        return str.matches(reg);
    }

    private void auditDetailAssignment(AuditCustomerDetailDto auditCustomerDetail, CustomerAuditDetailImportsVo customerAuditDetailImports, int i, SimpleDateFormat format, Map<String, String> auditMap, List<String> errorMsgList, Map<String, DictDataVo> dictDataVoMap) throws IllegalAccessException {
        String appendices;
        String endCaseOffPointAmount;
        String endCaseIntraCompanyAmount;
        String endCaseCustomerFeeAmount;
        String endCaseDepartmentFeeAmount;
        String endCaseHeadFeeAmount;
        String offPointAmount;
        String intraCompanyAmount;
        String departmentFeeAmount;
        String headFeeAmount;
        String customerFeeAmount;
        String individualIncomeTax;
        String taxQuota;
        String reimburseAmount;
        String reimburseTaxAmount;
        String discountAmount;
        String discountTaxAmount;
        String thisAuditAmount;
        String alreadyAuditAmount;
        String withholdingAmount;
        String auditAmount;
        String reimburseChargeAgainstPrepayAmount;
        String discountChargeAgainstPrepayAmount;
        String selfInvestedBudgetAmount;
        String originalProductPrice;
        String activityPrice;
        String internalBudgetAmount;
        String budgetaryAmount;
        String sapOccurrenceAmount;
        String sapOccurrenceQuantity;
        String applyAmount;
        String activityEndTime;
        String activityBeginTime = customerAuditDetailImports.getActivityBeginTime();
        if (StringUtils.isNotEmpty((CharSequence)activityBeginTime)) {
            boolean beginFlag = AuditImportServiceImpl.isValidDate(activityBeginTime);
            if (!beginFlag) {
                errorMsgList.add("\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u8f93\u5165\u6709\u8bef");
            } else {
                try {
                    auditCustomerDetail.setActivityBeginTime(format.parse(activityBeginTime));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(activityEndTime = customerAuditDetailImports.getActivityEndTime()))) {
            boolean endFlag = AuditImportServiceImpl.isValidDate(activityEndTime);
            if (!endFlag) {
                errorMsgList.add("\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u8f93\u5165\u6709\u8bef");
            } else {
                try {
                    auditCustomerDetail.setActivityEndTime(format.parse(activityEndTime));
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(applyAmount = customerAuditDetailImports.getApplyAmount())) && this.paramsVaild(applyAmount, "\u7533\u8bf7\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setApplyAmount(new BigDecimal(applyAmount));
        }
        if (StringUtils.isNotBlank((CharSequence)(sapOccurrenceQuantity = customerAuditDetailImports.getSapOccurrenceQuantity())) && this.paramsVaild(sapOccurrenceQuantity, "\u5df2\u6267\u884c\u91cf", i, false, errorMsgList)) {
            auditCustomerDetail.setApplyAmount(new BigDecimal(sapOccurrenceQuantity));
        }
        if (StringUtils.isNotBlank((CharSequence)(sapOccurrenceAmount = customerAuditDetailImports.getSapOccurrenceAmount())) && this.paramsVaild(sapOccurrenceAmount, "\u5df2\u6267\u884c\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setApplyAmount(new BigDecimal(sapOccurrenceAmount));
        }
        if (StringUtils.isNotBlank((CharSequence)(budgetaryAmount = customerAuditDetailImports.getExtraBudgetaryAmount())) && this.paramsVaild(budgetaryAmount, "\u70b9\u5916\u9884\u7b97\u4f7f\u7528\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setApplyAmount(new BigDecimal(budgetaryAmount));
        }
        if (StringUtils.isNotBlank((CharSequence)(internalBudgetAmount = customerAuditDetailImports.getInternalBudgetAmount())) && this.paramsVaild(internalBudgetAmount, "\u70b9\u5185\u9884\u7b97\u4f7f\u7528\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setApplyAmount(new BigDecimal(internalBudgetAmount));
        }
        if (StringUtils.isNotBlank((CharSequence)(activityPrice = customerAuditDetailImports.getActivityPrice())) && this.paramsVaild(activityPrice, "\u6d3b\u52a8\u4ef7", i, false, errorMsgList)) {
            auditCustomerDetail.setActivityPrice(new BigDecimal(activityPrice));
        }
        if (StringUtils.isNotBlank((CharSequence)(originalProductPrice = customerAuditDetailImports.getOriginalProductPrice())) && this.paramsVaild(originalProductPrice, "\u4ea7\u54c1\u5355\u4ef7", i, false, errorMsgList)) {
            auditCustomerDetail.setOriginalProductPrice(new BigDecimal(originalProductPrice));
        }
        if (StringUtils.isNotBlank((CharSequence)(selfInvestedBudgetAmount = customerAuditDetailImports.getSelfInvestedBudgetAmount())) && this.paramsVaild(selfInvestedBudgetAmount, "\u81ea\u6295\u9884\u7b97\u4f7f\u7528\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setApplyAmount(new BigDecimal(selfInvestedBudgetAmount));
        }
        if (StringUtils.isNotBlank((CharSequence)(discountChargeAgainstPrepayAmount = customerAuditDetailImports.getDiscountChargeAgainstPrepayAmount())) && this.paramsVaild(discountChargeAgainstPrepayAmount, "\u6298\u6263\u51b2\u9500\u9884\u4ed8\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setApplyAmount(new BigDecimal(discountChargeAgainstPrepayAmount));
        }
        if (StringUtils.isNotBlank((CharSequence)(reimburseChargeAgainstPrepayAmount = customerAuditDetailImports.getReimburseChargeAgainstPrepayAmount())) && this.paramsVaild(reimburseChargeAgainstPrepayAmount, "\u62a5\u9500\u51b2\u9500\u9884\u4ed8\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setApplyAmount(new BigDecimal(reimburseChargeAgainstPrepayAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(auditAmount = customerAuditDetailImports.getAuditAmount())) && this.paramsVaild(auditAmount, "\u9884\u6838\u9500\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setAuditAmount(new BigDecimal(auditAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(withholdingAmount = customerAuditDetailImports.getWithholdingAmount())) && this.paramsVaild(withholdingAmount, "\u9884\u63d0\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setWithholdingAmount(new BigDecimal(withholdingAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(alreadyAuditAmount = customerAuditDetailImports.getAlreadyAuditAmount())) && this.paramsVaild(alreadyAuditAmount, "\u5df2\u7ed3\u6848\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setAlreadyAuditAmount(new BigDecimal(alreadyAuditAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(thisAuditAmount = customerAuditDetailImports.getThisAuditAmount())) && this.paramsVaild(thisAuditAmount, "\u672c\u6b21\u7ed3\u6848\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setThisAuditAmount(new BigDecimal(thisAuditAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(discountTaxAmount = customerAuditDetailImports.getDiscountTaxAmount())) && this.paramsVaild(discountTaxAmount, "\u6298\u6263\u5e94\u5904\u7406\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setDiscountTaxAmount(new BigDecimal(discountTaxAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(discountAmount = customerAuditDetailImports.getDiscountAmount())) && this.paramsVaild(discountAmount, "\u5165\u8d39\u7528\u6c60\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setDiscountAmount(new BigDecimal(discountAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(reimburseTaxAmount = customerAuditDetailImports.getReimburseTaxAmount())) && this.paramsVaild(reimburseTaxAmount, "\u62a5\u9500\u91d1\u989d(\u542b\u7a0e)", i, true, errorMsgList)) {
            auditCustomerDetail.setReimburseTaxAmount(new BigDecimal(reimburseTaxAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(reimburseAmount = customerAuditDetailImports.getReimburseAmount())) && this.paramsVaild(reimburseAmount, "\u62a5\u9500\u91d1\u989d(\u672a\u7a0e)", i, true, errorMsgList)) {
            auditCustomerDetail.setReimburseAmount(new BigDecimal(reimburseAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(taxQuota = customerAuditDetailImports.getTaxQuota())) && this.paramsVaild(taxQuota, "\u7a0e\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setTaxQuota(new BigDecimal(taxQuota));
        }
        if (StringUtils.isNotEmpty((CharSequence)(individualIncomeTax = customerAuditDetailImports.getIndividualIncomeTax())) && this.paramsVaild(individualIncomeTax, "\u4e2a\u4eba\u6240\u5f97\u8bf4", i, true, errorMsgList)) {
            auditCustomerDetail.setIndividualIncomeTax(new BigDecimal(individualIncomeTax));
        }
        if (StringUtils.isNotEmpty((CharSequence)(customerFeeAmount = customerAuditDetailImports.getCustomerFeeAmount())) && this.paramsVaild(customerFeeAmount, "\u5ba2\u6237\u627f\u62c5\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setCustomerFeeAmount(new BigDecimal(customerFeeAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(headFeeAmount = customerAuditDetailImports.getHeadFeeAmount())) && this.paramsVaild(headFeeAmount, "\u603b\u90e8\u627f\u62c5\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setHeadFeeAmount(new BigDecimal(headFeeAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(departmentFeeAmount = customerAuditDetailImports.getDepartmentFeeAmount())) && this.paramsVaild(departmentFeeAmount, "\u5927\u533a\u627f\u62c5\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setDepartmentFeeAmount(new BigDecimal(departmentFeeAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(intraCompanyAmount = customerAuditDetailImports.getIntraCompanyAmount())) && this.paramsVaild(intraCompanyAmount, "\u5206\u5b50\u516c\u53f8\u70b9\u5185\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setIntraCompanyAmount(new BigDecimal(intraCompanyAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(offPointAmount = customerAuditDetailImports.getOffPointAmount())) && this.paramsVaild(offPointAmount, "\u5206\u5b50\u516c\u53f8\u70b9\u5916\u91d1\u989d", i, false, errorMsgList)) {
            auditCustomerDetail.setOffPointAmount(new BigDecimal(offPointAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(endCaseHeadFeeAmount = customerAuditDetailImports.getEndCaseHeadFeeAmount())) && this.paramsVaild(endCaseHeadFeeAmount, "\u7ed3\u6848\u603b\u90e8\u627f\u62c5\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setEndCaseHeadFeeAmount(new BigDecimal(endCaseHeadFeeAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(endCaseDepartmentFeeAmount = customerAuditDetailImports.getEndCaseDepartmentFeeAmount())) && this.paramsVaild(endCaseDepartmentFeeAmount, "\u7ed3\u6848\u5927\u533a\u627f\u62c5\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setEndCaseDepartmentFeeAmount(new BigDecimal(endCaseDepartmentFeeAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(endCaseCustomerFeeAmount = customerAuditDetailImports.getEndCaseCustomerFeeAmount())) && this.paramsVaild(endCaseCustomerFeeAmount, "\u7ed3\u6848\u5ba2\u6237\u627f\u62c5\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setEndCaseCustomerFeeAmount(new BigDecimal(endCaseCustomerFeeAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(endCaseIntraCompanyAmount = customerAuditDetailImports.getEndCaseIntraCompanyAmount())) && this.paramsVaild(endCaseIntraCompanyAmount, "\u7ed3\u6848\u5206\u5b50\u516c\u53f8\u70b9\u5185\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setEndCaseIntraCompanyAmount(new BigDecimal(endCaseIntraCompanyAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(endCaseOffPointAmount = customerAuditDetailImports.getEndCaseOffPointAmount())) && this.paramsVaild(endCaseOffPointAmount, "\u7ed3\u6848\u5206\u5b50\u516c\u53f8\u70b9\u5916\u91d1\u989d", i, true, errorMsgList)) {
            auditCustomerDetail.setEndCaseOffPointAmount(new BigDecimal(endCaseOffPointAmount));
        }
        if (StringUtils.isNotEmpty((CharSequence)(appendices = customerAuditDetailImports.getAppendices())) && this.vaildInter(appendices, "\u9644\u4ef6\u603b\u6570", errorMsgList)) {
            auditCustomerDetail.setAppendices(Integer.valueOf(Integer.parseInt(appendices)));
        }
        String invoiceCode = customerAuditDetailImports.getInvoiceCode();
        String invoiceNumber = customerAuditDetailImports.getInvoiceNumber();
        if (StringUtils.isNotBlank((CharSequence)invoiceCode) && StringUtils.isNotBlank((CharSequence)invoiceNumber)) {
            List<String> invoiceSplit = Arrays.asList(invoiceCode.split(","));
            List<String> split = Arrays.asList(invoiceNumber.split(","));
            int length = invoiceSplit.size();
            if (length != split.size()) {
                errorMsgList.add("\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u7801\u6570\u91cf\u4e0d\u80fd\u5339\u914d");
            } else {
                if (Objects.nonNull(auditCustomerDetail.getAppendices())) {
                    if (auditCustomerDetail.getAppendices() < length) {
                        auditCustomerDetail.setAppendices(Integer.valueOf(length));
                    }
                } else {
                    auditCustomerDetail.setAppendices(Integer.valueOf(length));
                }
                String auditCode = auditMap.get(customerAuditDetailImports.getAuditDetailCode());
                ArrayList<AuditInvoiceManageDto> invoiceManageDtos = new ArrayList<AuditInvoiceManageDto>();
                ArrayList<AuditInvoiceDto> auditInvoiceDtos = new ArrayList<AuditInvoiceDto>();
                for (int j = 0; j < length; ++j) {
                    AuditInvoiceDto auditInvoiceDto = new AuditInvoiceDto();
                    AuditInvoiceManageDto auditInvoiceManageDto = new AuditInvoiceManageDto();
                    String code = invoiceSplit.get(j);
                    String no = split.get(j);
                    if (StringUtils.isNotBlank((CharSequence)code) && code.equals("0")) {
                        auditInvoiceManageDto.setInvoiceCode(null);
                        auditInvoiceDto.setInvoiceCode(null);
                    } else {
                        auditInvoiceManageDto.setInvoiceCode(code);
                        auditInvoiceDto.setInvoiceCode(code);
                    }
                    if (StringUtils.isNotBlank((CharSequence)auditCode)) {
                        auditInvoiceManageDto.setAuditCode(auditCode);
                        auditInvoiceDto.setAuditCode(auditCode);
                    }
                    auditInvoiceManageDto.setInvoiceNo(no);
                    auditInvoiceDto.setInvoiceNumber(no);
                    invoiceManageDtos.add(auditInvoiceManageDto);
                    auditInvoiceDtos.add(auditInvoiceDto);
                }
                List<AuditInvoiceVo> invoiceOtherAudit = this.auditInvoiceRepository.findInvoiceOtherAudit(auditInvoiceDtos);
                if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(invoiceOtherAudit)) {
                    String auditCodes = invoiceOtherAudit.stream().map(AuditInvoiceVo::getAuditCode).filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                    errorMsgList.add("\u8be5\u53d1\u7968\u5df2\u5b58\u5728\u6838\u9500\u3010" + auditCodes + "\u3011\u5173\u8054");
                } else {
                    List auditInvoiceItemVos = this.auditInvoiceManageService.findByInvoiceNoCode(invoiceManageDtos);
                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)auditInvoiceItemVos)) {
                        if (StringUtils.isNotEmpty((CharSequence)auditCode)) {
                            List<AuditInvoiceVo> auditInvoiceVoList = this.auditInvoiceRepository.findInvoiceByAuditCode(auditCode);
                            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(auditInvoiceVoList)) {
                                List invoiceCodeAndNos = auditInvoiceVoList.stream().map(o -> {
                                    if (StringUtils.isNotEmpty((CharSequence)o.getInvoiceCode())) {
                                        return o.getInvoiceCode() + "-" + o.getInvoiceNumber();
                                    }
                                    return o.getInvoiceNumber();
                                }).collect(Collectors.toList());
                                boolean invoiceError = false;
                                for (AuditInvoiceDto auditInvoiceDto : auditInvoiceDtos) {
                                    String importInvoiceCodeAndNo = StringUtils.isNotEmpty((CharSequence)auditInvoiceDto.getInvoiceCode()) ? auditInvoiceDto.getInvoiceCode() + "-" + auditInvoiceDto.getInvoiceNumber() : auditInvoiceDto.getInvoiceNumber();
                                    if (invoiceCodeAndNos.contains(importInvoiceCodeAndNo)) continue;
                                    invoiceError = true;
                                    errorMsgList.add("\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u7801\u3010" + importInvoiceCodeAndNo + "\u3011\u4e0d\u80fd\u5339\u914d\u53d1\u7968\u7ba1\u7406\u6570\u636e");
                                }
                                if (!invoiceError) {
                                    auditCustomerDetail.setAuditInvoiceFinalCache(auditInvoiceVoList);
                                    if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(auditInvoiceVoList) && StringUtils.isEmpty((CharSequence)auditCustomerDetail.getReimburseTaxRate())) {
                                        String taxRate = this.getInvoiceTaxRate(dictDataVoMap, auditInvoiceVoList);
                                        auditCustomerDetail.setReimburseTaxRate(taxRate);
                                    }
                                }
                            } else {
                                errorMsgList.add("\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u5339\u914d\u53d1\u7968\u7ba1\u7406\u6570\u636e");
                            }
                        } else {
                            errorMsgList.add("\u53d1\u7968\u53f7\u7801\u548c\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u5339\u914d\u53d1\u7968\u7ba1\u7406\u6570\u636e");
                        }
                    } else {
                        List auditInvoiceVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditInvoiceItemVos, AuditInvoiceItemVo.class, AuditInvoiceVo.class, HashSet.class, ArrayList.class, new String[0]);
                        auditCustomerDetail.setAuditInvoiceFinalCache(auditInvoiceVos);
                        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)auditInvoiceVos) && StringUtils.isEmpty((CharSequence)auditCustomerDetail.getReimburseTaxRate())) {
                            String taxRate = this.getInvoiceTaxRate(dictDataVoMap, auditInvoiceVos);
                            auditCustomerDetail.setReimburseTaxRate(taxRate);
                        }
                    }
                }
            }
            auditCustomerDetail.setInvoiceCode(null);
            auditCustomerDetail.setInvoiceNumber(null);
        } else {
            if (StringUtils.isNotBlank((CharSequence)invoiceCode) && StringUtils.isBlank((CharSequence)invoiceNumber)) {
                errorMsgList.add("\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isNotBlank((CharSequence)invoiceNumber) && StringUtils.isBlank((CharSequence)invoiceCode)) {
                errorMsgList.add("\u53d1\u7968\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private String getInvoiceTaxRate(Map<String, DictDataVo> dictDataVoMap, List<AuditInvoiceVo> auditInvoiceVoList) {
        DictDataVo dictDataVo = dictDataVoMap.get(auditInvoiceVoList.get(0).getInvoiceType());
        boolean isSpecial = false;
        if (dictDataVo != null) {
            Map extendMap = dictDataVo.getExtendMap();
            String ext1 = (String)extendMap.get("ext1");
            isSpecial = com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum.YES.getCode().equals(ext1);
        }
        if (isSpecial) {
            return auditInvoiceVoList.get(0).getTaxRate();
        }
        return "0";
    }

    private boolean vaildInter(String str, String msg, List<String> errorMsgList) {
        boolean pass = true;
        String reg = "^-?[0-9]+$";
        if (!str.matches(reg)) {
            errorMsgList.add(msg + "\u4e0d\u662f\u6574\u6570");
            pass = false;
        }
        return pass;
    }
}

