/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.service.AuditInvoiceManageService;
import com.biz.crm.tpm.business.audit.local.entity.AuditInvoice;
import com.biz.crm.tpm.business.audit.local.repository.AuditInvoiceRepository;
import com.biz.crm.tpm.business.audit.local.service.AuditInvoiceService;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CacheTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceExportsVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="auditInvoiceService")
public class AuditInvoiceServiceImpl
implements AuditInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(AuditInvoiceServiceImpl.class);
    @Autowired(required=false)
    private AuditInvoiceRepository auditInvoiceRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private RedisTemplate redisTemplate;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private AuditInvoiceManageService auditInvoiceManageService;
    @Autowired(required=false)
    private AuditService auditService;

    @Override
    public Boolean findByNoCode(String invoiceNumber, String invoiceCode, String auditCode) {
        Validate.notBlank((CharSequence)invoiceNumber, (String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditCode, (String)"\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditInvoice> invoice = null;
        if (StringUtils.isNotBlank((CharSequence)invoiceCode) && !invoiceCode.equals("0")) {
            invoice = this.auditInvoiceRepository.findByNoCode(invoiceNumber, invoiceCode, auditCode);
        } else if (StringUtils.isBlank((CharSequence)invoiceCode)) {
            invoice = this.auditInvoiceRepository.findByNoAuditCode(invoiceNumber, auditCode);
        }
        if (null == invoice || invoice.size() == 0 || Objects.isNull((Object)invoice.get(0))) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean findNoCode(String invoiceNumber, String invoiceCode) {
        Validate.notBlank((CharSequence)invoiceNumber, (String)"\u53d1\u7968\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditInvoice> invoice = null;
        if (StringUtils.isNotBlank((CharSequence)invoiceCode) && !invoiceCode.equals("0")) {
            invoice = this.auditInvoiceRepository.findNoCode(invoiceNumber, invoiceCode);
        } else if (StringUtils.isBlank((CharSequence)invoiceCode)) {
            invoice = this.auditInvoiceRepository.findByNo(invoiceNumber);
        }
        if (null == invoice || invoice.size() == 0 || Objects.isNull((Object)invoice.get(0))) {
            return false;
        }
        return true;
    }

    @Override
    public Integer getInvoiceExportTotal(String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditInvoiceVo> auditInvoiceFromCache = this.getAuditInvoiceFromCache(cacheKey);
        return auditInvoiceFromCache.size();
    }

    @Override
    public List<AuditInvoiceExportsVo> getInvoiceExportData(String cacheKey) {
        Validate.notBlank((CharSequence)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditInvoiceVo> auditInvoiceFromCache = this.getAuditInvoiceFromCache(cacheKey);
        if (CollectionUtil.isNotEmpty(auditInvoiceFromCache)) {
            Map formatMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_format");
            Map unitMap = this.dictToolkitService.findMapByDictTypeCode("mdm_business_unit");
            auditInvoiceFromCache.forEach(i -> {
                i.setBusinessUnitCode((String)unitMap.get(i.getBusinessUnitCode()));
                i.setBusinessFormatCode((String)formatMap.get(i.getBusinessFormatCode()));
            });
            return (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditInvoiceFromCache, AuditInvoiceVo.class, AuditInvoiceExportsVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        }
        return new ArrayList<AuditInvoiceExportsVo>();
    }

    @Override
    public List<AuditInvoice> findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        return this.auditInvoiceRepository.findByAuditCode(auditCode);
    }

    @Override
    public void deleteAuditInvoiceByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        this.auditInvoiceRepository.deleteAuditInvoiceByIds(ids);
    }

    @Override
    public List<AuditInvoice> findByAuditCodes(Collection<String> auditCodes) {
        if (CollectionUtils.isEmpty(auditCodes)) {
            return new ArrayList<AuditInvoice>();
        }
        return this.auditInvoiceRepository.findByAuditCodes(auditCodes);
    }

    @Override
    public void deleteAuditInvoiceByAuditCodes(Set<String> set) {
        if (CollectionUtils.isEmpty(set)) {
            return;
        }
        this.auditInvoiceRepository.deleteAuditInvoiceByAuditCodes(set);
    }

    @Override
    public List<AuditInvoiceVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return this.auditInvoiceRepository.findByIds(ids);
    }

    @Override
    public void deleteByCodeList(List<String> deleteCodeList) {
        Validate.notNull(deleteCodeList, (String)"\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List auditVos = this.auditService.findByAuditCodeList(deleteCodeList);
        Validate.notNull((Object)auditVos, (String)"\u6839\u636e\u6838\u9500\u7f16\u7801\u672a\u67e5\u8be2\u5230\u6838\u9500\u5355\uff01", (Object[])new Object[0]);
        for (AuditVo auditVo : auditVos) {
            if (ProcessStatusEnum.PREPARE.getDictCode().equals(auditVo.getProcessStatus()) || UpAccountStatusEnum.UP_ACCOUNT_FAILD.getCode().equals(auditVo.getReimburseUpAccountStatus())) continue;
            throw new RuntimeException("\u6838\u9500\u7f16\u7801\u3010{" + auditVo.getAuditCode() + "}\u3011\u4e0d\u6ee1\u8db3\u4e0a\u8d26\u5931\u8d25/\u5ba1\u6279\u72b6\u6001\u4e3a\u5f85\u63d0\u4ea4 \u7684\u5220\u9664\u6761\u4ef6");
        }
        List<AuditInvoice> invoices = this.auditInvoiceRepository.findByAuditCodes(deleteCodeList);
        Validate.notNull(invoices, (String)"\u672a\u67e5\u8be2\u5230\u9700\u5220\u9664\u5173\u7cfb\u7684\u53d1\u7968\uff01", (Object[])new Object[0]);
        this.auditInvoiceRepository.deleteByCodeList(deleteCodeList);
        ArrayList<AuditInvoiceManageDto> invoiceManageDtoList = new ArrayList<AuditInvoiceManageDto>();
        for (AuditInvoice auditInvoice : invoices) {
            AuditInvoiceManageDto invoiceManageDto = new AuditInvoiceManageDto();
            invoiceManageDto.setInvoiceNo(auditInvoice.getInvoiceNumber());
            invoiceManageDto.setInvoiceCode(auditInvoice.getInvoiceCode());
            invoiceManageDtoList.add(invoiceManageDto);
        }
        this.auditInvoiceManageService.updateByNoAndCode(invoiceManageDtoList, "N", null);
    }

    private List<AuditInvoiceVo> getAuditInvoiceFromCache(String cacheKey) {
        if (StringUtils.isEmpty((CharSequence)cacheKey)) {
            return new ArrayList<AuditInvoiceVo>();
        }
        if (!this.redisTemplate.hasKey((Object)(cacheKey = cacheKey + CacheTypeEnum.AUDIT_INVOICE.getCode())).booleanValue()) {
            return new ArrayList<AuditInvoiceVo>();
        }
        List auditInvoiceVoList = this.redisTemplate.opsForList().range((Object)cacheKey, 0L, -1L);
        ArrayList<AuditInvoiceVo> auditInvoiceVoListReturn = new ArrayList<AuditInvoiceVo>();
        for (Object o : auditInvoiceVoList) {
            AuditInvoiceVo auditInvoiceVo = (AuditInvoiceVo)o;
            auditInvoiceVoListReturn.add(auditInvoiceVo);
        }
        this.redisTemplate.expire((Object)cacheKey, 1L, TimeUnit.HOURS);
        return auditInvoiceVoListReturn;
    }

    @Override
    public List<AuditInvoiceVo> findByAuditDetailCode(Set<String> set) {
        if (CollectionUtil.isEmpty(set)) {
            return new ArrayList<AuditInvoiceVo>();
        }
        return this.auditInvoiceRepository.findByAuditDetailCode(set);
    }
}

