/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.biz.crm.tpm.business.audit.local.repository.AuditManualApportionRepository;
import com.biz.crm.tpm.business.audit.local.service.AuditManualApportionService;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditManualApportionDto;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuditManualApportionServiceImpl
implements AuditManualApportionService {
    private static final Logger log = LoggerFactory.getLogger(AuditManualApportionServiceImpl.class);
    @Autowired(required=false)
    private AuditManualApportionRepository auditManualApportionRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(List<AuditManualApportionDto> dtos) {
        this.verifySave(dtos);
        String auditDetailCode = dtos.get(0).getAuditDetailCode();
        this.auditManualApportionRepository.removeByDetailCode(auditDetailCode);
        this.auditManualApportionRepository.saveBatchData(dtos);
    }

    private void verifySave(List<AuditManualApportionDto> dtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(dtos) ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        int i = 0;
        for (AuditManualApportionDto dto : dtos) {
            Validate.notNull((Object)dto.getAuditCode(), (String)"\u7b2c\u3010%s\u3011\u884c\u6570\u636e\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{++i});
            Validate.notNull((Object)dto.getAuditDetailCode(), (String)"\u7b2c\u3010%s\u3011\u884c\u6570\u636e\u6838\u9500\u660e\u7ec6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
            Validate.notNull((Object)dto.getProductCode(), (String)"\u7b2c\u3010%s\u3011\u884c\u6570\u636e\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
            Validate.notNull((Object)dto.getApportionRatio(), (String)"\u7b2c\u3010%s\u3011\u884c\u6570\u636e\u5206\u644a\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{i});
        }
        Map<String, List<AuditManualApportionDto>> collect = dtos.stream().collect(Collectors.groupingBy(AuditManualApportionDto::getProductCode));
        collect.forEach((key, value) -> Validate.isTrue((value.size() <= 1 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u7f16\u7801\u53ea\u80fd\u8f93\u5165\u4e00\u4e2a", (Object[])new Object[0]));
        BigDecimal apportionRatio = dtos.stream().map(AuditManualApportionDto::getApportionRatio).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        Validate.isTrue((apportionRatio.compareTo(BigDecimal.ONE) == 0 ? 1 : 0) != 0, (String)"\u5206\u644a\u6bd4\u4f8b\u4e4b\u548c\u8981\u4e3a1", (Object[])new Object[0]);
    }
}

