/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.tpm.business.audit.sdk.service.AuditMsgService;
import com.biz.crm.tpm.business.audit.sdk.vo.SplitAuditCustomerDetailMsgVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AuditMsgServiceImpl
implements AuditMsgService {
    private static final Logger log = LoggerFactory.getLogger(AuditMsgServiceImpl.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired(required=false)
    private ChannelMsgService channelMsgService;

    public void sendProcessMsg(SplitAuditCustomerDetailMsgVo vo) {
        vo.setTime(new Date());
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)vo, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        log.info(" import model send msg: tenantCode = {} , applicationName = {} , modelCode = {} ", new Object[]{tenantCode, this.applicationName, "split_audit_customer_detail"});
        if (StringUtils.isNotBlank((CharSequence)vo.getAccount())) {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, this.applicationName, "split_audit_customer_detail", vo.getAccount(), jsonBytes);
        } else {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, this.applicationName, "split_audit_customer_detail", jsonBytes);
        }
    }
}

