/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.factory.sdk.service.FactoryVoService;
import com.biz.crm.mdm.business.factory.sdk.vo.FactoryVo;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.audit.local.entity.AuditRedInvoiceProduct;
import com.biz.crm.tpm.business.audit.local.repository.AuditRedInvoiceProductRepository;
import com.biz.crm.tpm.business.audit.local.service.AuditRedInvoiceProductService;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceProductDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditRedInvoiceProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="auditRedInvoiceProductService")
public class AuditRedInvoiceProductServiceImpl
extends MnPageCacheServiceImpl<AuditRedInvoiceProductVo, AuditRedInvoiceProductDto>
implements AuditRedInvoiceProductService {
    private static final Logger log = LoggerFactory.getLogger(AuditRedInvoiceProductServiceImpl.class);
    @Autowired(required=false)
    private AuditRedInvoiceProductRepository auditRedInvoiceProductRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private FactoryVoService factoryVoService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEdit(List<AuditRedInvoiceProductDto> productDtoList, String auditCode, String tenantCode) {
        if (CollectionUtils.isEmpty(productDtoList)) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>();
        for (AuditRedInvoiceProductDto item : productDtoList) {
            if (StringUtils.isBlank((CharSequence)item.getId())) {
                item.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                item.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                item.setId(UUID.randomUUID().toString().replace("-", ""));
            }
            if (StringUtils.isBlank((CharSequence)item.getLineCode())) {
                String code = (String)this.generateCodeService.generateCode("RIP", 1, Integer.valueOf(5), 0L, TimeUnit.DAYS).get(0);
                item.setLineCode(code);
            }
            item.setAuditCode(auditCode);
            item.setTenantCode(tenantCode);
            idList.add(item.getId());
        }
        if (!CollectionUtils.isEmpty(idList)) {
            this.auditRedInvoiceProductRepository.deleteBatchAuditRedInvoiceProduct(idList, tenantCode, auditCode);
        }
        if (!CollectionUtils.isEmpty(productDtoList)) {
            Collection products = this.nebulaToolkitService.copyCollectionByBlankList(productDtoList, AuditRedInvoiceProductDto.class, AuditRedInvoiceProduct.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.auditRedInvoiceProductRepository.saveOrUpdateBatch(products);
        }
    }

    @Override
    public void syncCache(String cacheKey, String auditCacheKey) {
        this.clearCache(auditCacheKey);
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheInitKey = this.helper.getRedisCacheInitKey(cacheKey);
        Set idKeys = this.redisTemplate.keys((Object)(redisCacheIdKey + "*"));
        ArrayList dataList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)idKeys)) {
            for (String idKey : idKeys) {
                String dataKey = idKey.replace("id:", "data:");
                List idList = this.redisService.lRange(idKey, 0L, -1L);
                dataList.addAll(this.redisTemplate.opsForHash().multiGet((Object)dataKey, (Collection)idList));
            }
            String dataListJson = JSONArray.toJSONString((Object)dataList);
            List dtoList = JSONArray.parseArray((String)dataListJson, AuditRedInvoiceProductDto.class);
            String auditCacheInitKey = this.helper.getRedisCacheInitKey(auditCacheKey);
            this.redisService.set(auditCacheInitKey, (Object)BooleanEnum.TRUE, this.helper.getExpireTime());
            this.helper.putCache(auditCacheKey, dtoList);
        }
    }

    @Override
    public void addItemCache(String cacheKey, List<AuditRedInvoiceProductDto> itemList, String companyCode, String businessUnitCode) {
        Validate.notBlank((CharSequence)companyCode, (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)businessUnitCode, (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List updateList = itemList.stream().filter(item -> idList.contains(this.helper.getDtoKey(item))).collect(Collectors.toList());
        this.helper.updateItem(cacheKey, updateList);
        List newItemList = this.helper.newItem(cacheKey, itemList);
        Object[] newIdArr = newItemList.stream().map(arg_0 -> ((MnPageCacheHelper)this.helper).getDtoKey(arg_0)).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.helper.getExpireTime()), newIdArr);
        updateList.addAll(newItemList);
        if (!CollectionUtils.isEmpty(updateList)) {
            HashSet<String> codes = new HashSet<String>();
            for (AuditRedInvoiceProductDto productDto : updateList) {
                if (!StringUtils.isNotBlank((CharSequence)productDto.getBusinessFormatCode())) continue;
                codes.add(companyCode + productDto.getBusinessFormatCode() + businessUnitCode);
            }
            List factoryVos = this.factoryVoService.findDetailByOnlyKeys(new ArrayList(codes));
            if (!CollectionUtils.isEmpty((Collection)factoryVos)) {
                Map<String, String> facMap = factoryVos.stream().collect(Collectors.toMap(FactoryVo::getOnlyKey, FactoryVo::getFactory, (oldV, newV) -> newV));
                for (AuditRedInvoiceProductDto productDto : updateList) {
                    if (!StringUtils.isNotBlank((CharSequence)productDto.getBusinessFormatCode())) continue;
                    String onlyKey = companyCode + productDto.getBusinessFormatCode() + businessUnitCode;
                    Validate.isTrue((boolean)facMap.containsKey(onlyKey), (String)"\u6839\u636e\u516c\u53f8\u4ee3\u7801[%s]\u4e1a\u52a1\u5355\u5143[%s]\u4ea7\u54c1\u4e1a\u6001[%s]\u672a\u67e5\u627e\u5230\u5de5\u5382", (Object[])new Object[0]);
                    productDto.setFactory(facMap.get(onlyKey));
                }
            }
        }
        Map updateMap = updateList.stream().collect(Collectors.toMap(arg_0 -> ((MnPageCacheHelper)this.helper).getDtoKey(arg_0), Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.helper.getExpireTime());
    }

    @Override
    public List<AuditRedInvoiceProductDto> findListByAuditCode(String auditCode) {
        if (StringUtils.isEmpty((CharSequence)auditCode)) {
            return Lists.newArrayList();
        }
        return this.auditRedInvoiceProductRepository.findListByAuditCode(auditCode);
    }

    public Page<AuditRedInvoiceProductVo> findCachePageList(Pageable pageable, AuditRedInvoiceProductDto dto, String cacheKey) {
        Validate.notBlank((CharSequence)dto.getAuditCacheKey(), (String)"\u6838\u9500\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String auditCacheIdKey = this.helper.getRedisCacheIdKey(dto.getAuditCacheKey());
        String auditCacheInitKey = this.helper.getRedisCacheInitKey(dto.getAuditCacheKey());
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        String redisCacheInitKey = this.helper.getRedisCacheInitKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheIdKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheIdKey);
            page.setTotal(total.longValue());
            List idList = this.redisService.lRange(redisCacheIdKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty((Collection)idList)) {
                List dataList = this.redisTemplate.opsForHash().multiGet((Object)redisCacheDataKey, (Collection)idList);
                String dataListJson = JSONArray.toJSONString((Object)dataList);
                List dtoList = JSONArray.parseArray((String)dataListJson, AuditRedInvoiceProductDto.class);
                List voList = this.helper.dtoListToVoList(dtoList);
                page.setRecords(voList);
            }
        } else if (!this.redisService.hasKey(redisCacheInitKey).booleanValue() && null != dto) {
            this.redisService.set(redisCacheInitKey, (Object)BooleanEnum.TRUE, this.helper.getExpireTime());
            if (this.redisService.hasKey(auditCacheIdKey).booleanValue()) {
                Set idKeys = this.redisTemplate.keys((Object)(auditCacheIdKey + "*"));
                ArrayList dataList = Lists.newArrayList();
                if (!CollectionUtils.isEmpty((Collection)idKeys)) {
                    for (String idKey : idKeys) {
                        String dataKey = idKey.replace("id:", "data:");
                        List idList = this.redisService.lRange(idKey, 0L, -1L);
                        dataList.addAll(this.redisTemplate.opsForHash().multiGet((Object)dataKey, (Collection)idList));
                    }
                    String dataListJson = JSONArray.toJSONString((Object)dataList);
                    List dtoList = JSONArray.parseArray((String)dataListJson, AuditRedInvoiceProductDto.class);
                    this.helper.putCache(cacheKey, dtoList);
                    page.setTotal((long)dtoList.size());
                    long start = page.offset();
                    if (page.getTotal() > start) {
                        long end = page.offset() + page.getSize();
                        if (page.getTotal() < end) {
                            end = page.getTotal();
                        }
                        List recordDtoList = dtoList.subList((int)page.offset(), (int)end);
                        List voList = this.helper.dtoListToVoList(recordDtoList);
                        page.setRecords(voList);
                    }
                }
            } else {
                List dtoList = this.helper.findDtoListFromRepository((Object)dto, cacheKey);
                if (!CollectionUtils.isEmpty((Collection)dtoList)) {
                    if (this.helper.initToCacheFromRepository()) {
                        this.helper.putCache(cacheKey, dtoList);
                        this.redisService.set(auditCacheInitKey, (Object)BooleanEnum.TRUE, this.helper.getExpireTime());
                        this.helper.putCache(dto.getAuditCacheKey(), dtoList);
                    }
                    page.setTotal((long)dtoList.size());
                    long start = page.offset();
                    if (page.getTotal() > start) {
                        long end = page.offset() + page.getSize();
                        if (page.getTotal() < end) {
                            end = page.getTotal();
                        }
                        List recordDtoList = dtoList.subList((int)page.offset(), (int)end);
                        List voList = this.helper.dtoListToVoList(recordDtoList);
                        page.setRecords(voList);
                    }
                }
            }
        }
        this.helper.fillVoListProperties(page.getRecords());
        return page;
    }

    public void addItemCache(String cacheKey, List<AuditRedInvoiceProductDto> itemList) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        Set idKeys = this.redisTemplate.keys((Object)(redisCacheIdKey + "*"));
        ArrayList dataList = Lists.newArrayList();
        ArrayList<AuditRedInvoiceProductDto> newItemList = new ArrayList<AuditRedInvoiceProductDto>();
        if (!CollectionUtils.isEmpty((Collection)idKeys)) {
            for (String idKey : idKeys) {
                String dataKey = idKey.replace("id:", "data:");
                List idList = this.redisService.lRange(idKey, 0L, -1L);
                dataList.addAll(this.redisTemplate.opsForHash().multiGet((Object)dataKey, (Collection)idList));
            }
            String dataListJson = JSONArray.toJSONString((Object)dataList);
            List dtoList = JSONArray.parseArray((String)dataListJson, AuditRedInvoiceProductDto.class);
            Set proCodes = dtoList.stream().map(AuditRedInvoiceProductDto::getProductCode).collect(Collectors.toSet());
            for (AuditRedInvoiceProductDto productDto : itemList) {
                if (!StringUtils.isNotBlank((CharSequence)productDto.getProductCode()) || proCodes.contains(productDto.getProductCode())) continue;
                newItemList.add(productDto);
            }
        } else {
            newItemList.addAll(itemList);
        }
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List updateList = newItemList.stream().filter(item -> idList.contains(this.helper.getDtoKey(item))).collect(Collectors.toList());
        this.helper.updateItem(cacheKey, updateList);
        List newItemList2 = this.helper.newItem(cacheKey, newItemList);
        Object[] newIdArr = newItemList2.stream().map(arg_0 -> ((MnPageCacheHelper)this.helper).getDtoKey(arg_0)).toArray();
        this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.helper.getExpireTime()), newIdArr);
        updateList.addAll(newItemList2);
        Map updateMap = updateList.stream().collect(Collectors.toMap(arg_0 -> ((MnPageCacheHelper)this.helper).getDtoKey(arg_0), Function.identity()));
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, updateMap);
        this.redisService.expire(redisCacheDataKey, this.helper.getExpireTime());
    }
}

