/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.retailer.sdk.service.CustomerRetailerVoService;
import com.biz.crm.mdm.business.customer.retailer.sdk.vo.CustomerRetailerVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.local.entity.CostPoolAuditReport;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailRepository;
import com.biz.crm.tpm.business.audit.local.repository.CostPoolAuditReportRepository;
import com.biz.crm.tpm.business.audit.local.service.AuditReportService;
import com.biz.crm.tpm.business.audit.sdk.dto.report.CostPoolAuditReportDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.TpmExamineCircularDto;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.CostPoolAuditReportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.security.sdk.login.UserIdentity;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuditReportServiceImpl
implements AuditReportService {
    private static final Logger log = LoggerFactory.getLogger(AuditReportServiceImpl.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private AuditCustomerDetailRepository auditCustomerDetailRepository;
    @Autowired(required=false)
    private CostPoolAuditReportRepository costPoolAuditReportRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required=false)
    private CustomerRetailerVoService customerRetailerVoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void manualUpdateCostPoolReport(UserIdentity loginUser, CostPoolAuditReportDto dto) {
        boolean hasLock = false;
        String key = "audit:manual_update_cost_pool_report_lock";
        try {
            hasLock = this.redisLockService.tryLock(key, TimeUnit.HOURS, 1L);
            Validate.isTrue((boolean)hasLock, (String)"\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868\uff0c\u8bf7\u7a0d\u540e", (Object[])new Object[0]);
            this.loginUserService.refreshAuthentication((Object)loginUser);
            log.info("\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868+++++++++++++++:dto:{}", (Object)JsonUtils.obj2JsonString((Object)dto));
            this.doManualUpdateCostPoolReport(dto);
            log.info("\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868---------------");
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868\u5931\u8d25", (Throwable)e);
        }
        finally {
            if (hasLock) {
                this.redisLockService.unlock(key);
            }
        }
    }

    @Override
    public Page<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> costPoolReportSystem(Pageable pageable, CostPoolAuditReportDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new CostPoolAuditReportDto();
        }
        return this.costPoolAuditReportRepository.costPoolReportSystem(pageable, dto);
    }

    @Override
    public Page<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> costPoolReportRegion(Pageable pageable, CostPoolAuditReportDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new CostPoolAuditReportDto();
        }
        return this.costPoolAuditReportRepository.costPoolReportRegion(pageable, dto);
    }

    @Override
    public Page<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> costPoolReport(Pageable pageable, CostPoolAuditReportDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new CostPoolAuditReportDto();
        }
        return this.costPoolAuditReportRepository.costPoolReport(pageable, dto);
    }

    private void doManualUpdateCostPoolReport(CostPoolAuditReportDto dto) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Validate.notNull((Object)dto.getEnterCostPoolDateBegin(), (String)"\u65e5\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEnterCostPoolDateEnd(), (String)"\u65e5\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dto.getEnterCostPoolDateBegin());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long beginMillis = calendar.getTimeInMillis();
        dto.setEnterCostPoolDateBegin(calendar.getTime());
        Date nowDate = calendar.getTime();
        calendar.setTime(dto.getEnterCostPoolDateEnd());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        long endMillis = calendar.getTimeInMillis();
        dto.setEnterCostPoolDateEnd(calendar.getTime());
        this.costPoolAuditReportRepository.deleteByDto(dto);
        long days = (endMillis - beginMillis) % 86400000L == 0L ? (endMillis - beginMillis) / 86400000L : (endMillis - beginMillis) / 86400000L + 1L;
        log.info("\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868 \u5171\u8981\u8dd1{}\u5929\u6570\u636e", (Object)days);
        int i = 0;
        while ((long)i < days) {
            calendar.setTime(nowDate);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            dto.setEnterCostPoolDateBegin(calendar.getTime());
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
            dto.setEnterCostPoolDateEnd(calendar.getTime());
            log.info("\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868 \u5f00\u59cb\u8dd1{}\u65e5\u671f\u7684\u6570\u636e+++", (Object)df.format(nowDate));
            this.saveAuditDiscountInfo(dto);
            this.saveAuditRedInvoiceInfo(dto);
            this.saveExamineCircularInfo(dto);
            log.info("\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868 \u5df2\u7ecf\u8dd1\u5b8c{}\u65e5\u671f\u7684\u6570\u636e---", (Object)df.format(nowDate));
            calendar.add(6, 1);
            nowDate = calendar.getTime();
            ++i;
        }
    }

    private void saveAuditRedInvoiceInfo(CostPoolAuditReportDto dto) {
        Page<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> pageResult;
        long current = 1L;
        long size = 2000L;
        Page page = new Page(current, size);
        do {
            page.setCurrent(current);
            pageResult = this.auditCustomerDetailRepository.findManualUpdateCostPoolReportForRedInvoice((Page<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo>)page, dto);
            log.info("\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868 \u7ea2\u5b57\u53d1\u7968 \u5f53\u524d\u9875:{},\u6bcf\u9875\u5927\u5c0f:{},\u5171{}\u6761\u6570\u636e", new Object[]{current, size, pageResult.getTotal()});
            this.saveOrUpdateAuditForRedInvoice(pageResult.getRecords());
            ++current;
        } while (pageResult.hasNext());
    }

    private void saveOrUpdateAuditForRedInvoice(List<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List<String> customerCodes = records.stream().map(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getCustomerCode).collect(Collectors.toList());
        records.forEach(item -> item.setEndCaseForm(EndCaseFormEnum.RED_INVOICE.getCode()));
        this.saveOrUpdate(customerCodes, records);
    }

    private void saveExamineCircularInfo(CostPoolAuditReportDto dto) {
        Page pageResult;
        TpmExamineCircularDto dto2 = new TpmExamineCircularDto();
        dto2.setEnterCostPoolDateBegin(dto.getEnterCostPoolDateBegin());
        dto2.setEnterCostPoolDateEnd(dto.getEnterCostPoolDateEnd());
        PageRequest pageable = PageRequest.of((int)1, (int)1000);
        do {
            pageResult = this.tpmExamineCircularService.findManualUpdateCostPoolReport((Pageable)pageable, dto2);
            log.info("\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868 \u8003\u6838\u901a\u62a51 \u5f53\u524d\u8fdb\u5ea6[{}/{}]\u5171{}\u6761\u6570\u636e", new Object[]{pageResult.getCurrent(), pageResult.getPages(), pageResult.getTotal()});
            this.saveOrUpdateExamineCircular(pageResult.getRecords());
            pageable = pageable.next();
        } while (pageResult.hasNext());
    }

    private void saveOrUpdateExamineCircular(List<CostPoolAuditReportVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List costPoolAuditReportVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(records, CostPoolAuditReportVo.class, com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        costPoolAuditReportVos.forEach(item -> item.setEndCaseForm(EndCaseFormEnum.DISCOUNT.getCode()));
        List<String> customerCodes = costPoolAuditReportVos.stream().map(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getCustomerCode).collect(Collectors.toList());
        this.saveOrUpdate(customerCodes, costPoolAuditReportVos);
    }

    private void saveAuditDiscountInfo(CostPoolAuditReportDto dto) {
        Page<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> pageResult;
        long current = 1L;
        long size = 2000L;
        Page page = new Page(current, size);
        do {
            page.setCurrent(current);
            pageResult = this.auditCustomerDetailRepository.findManualUpdateCostPoolReport((Page<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo>)page, dto);
            log.info("\u6b63\u5728\u624b\u52a8\u66f4\u65b0\u8d39\u7528\u6c60\u6838\u9500\u8868 \u6838\u9500 \u5f53\u524d\u9875:{},\u6bcf\u9875\u5927\u5c0f:{},\u5171{}\u6761\u6570\u636e", new Object[]{current, size, pageResult.getTotal()});
            this.saveOrUpdateAudit(pageResult.getRecords());
            ++current;
        } while (pageResult.hasNext());
    }

    private void saveOrUpdateAudit(List<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
        List<String> customerCodes = records.stream().map(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getCustomerCode).collect(Collectors.toList());
        records.forEach(item -> item.setEndCaseForm(EndCaseFormEnum.DISCOUNT.getCode()));
        this.saveOrUpdate(customerCodes, records);
    }

    private void saveOrUpdate(List<String> customerCodes, List<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> records) {
        Map<Object, Object> customerVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(customerCodes)) {
            List customerVoList = this.customerVoService.findBaseByCustomerCodes(new ArrayList<String>(customerCodes));
            customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        }
        for (com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo record : records) {
            CustomerVo customerVo = (CustomerVo)customerVoMap.get(record.getCustomerCode());
            if (customerVo == null) {
                record.setCustomerCode(record.getCustomerErpCode());
                continue;
            }
            record.setCustomerCode(customerVo.getErpCode());
            record.setSalesInstitutionCode(customerVo.getSalesInstitutionErpCode());
        }
        records.forEach(item -> item.setDimensionKey(item.getEndCaseForm() + item.getSalesInstitutionCode() + item.gainEnterCostPoolDateTransitionString() + item.getCustomerCode() + item.getSystemCode() + item.getRegionCode() + item.getAuditCode()));
        Set salesInstitutionCodes = records.stream().map(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getSalesInstitutionCode).collect(Collectors.toSet());
        Map<Object, Object> salesOrgVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(salesInstitutionCodes)) {
            List salesOrgVoList = this.salesOrgVoService.findByErpCodeList(new ArrayList(salesInstitutionCodes));
            salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getErpCode, Function.identity(), (o, n) -> o));
        }
        Map<String, List<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo>> costPoolAuditReportVoMap = records.stream().collect(Collectors.groupingBy(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getDimensionKey));
        ArrayList records2 = new ArrayList();
        HashMap finalSalesOrgVoMap = salesOrgVoMap;
        Map regionDictMap = this.dictToolkitService.findMapByDictTypeCode("MDM_CUSTOMIZE_ORG");
        List systemCodes = records.stream().map(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getSystemCode).distinct().collect(Collectors.toList());
        Map<Object, Object> customerRetailerVoMap = new HashMap();
        if (!CollectionUtils.isEmpty(systemCodes)) {
            List customerRetailerVos = this.customerRetailerVoService.findByCodes(systemCodes);
            customerRetailerVoMap = customerRetailerVos.stream().collect(Collectors.toMap(CustomerRetailerVo::getCustomerRetailerCode, Function.identity(), (o, n) -> n));
        }
        HashMap finalCustomerRetailerVoMap = customerRetailerVoMap;
        costPoolAuditReportVoMap.forEach((key, value) -> {
            CustomerRetailerVo customerRetailerVo;
            String regionName;
            com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo costPoolAuditReportVo = (com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo)value.get(0);
            SalesOrgVo salesOrgVo = (SalesOrgVo)finalSalesOrgVoMap.get(costPoolAuditReportVo.getSalesInstitutionCode());
            if (salesOrgVo != null) {
                costPoolAuditReportVo.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            }
            if (StringUtils.isNotEmpty((CharSequence)(regionName = (String)regionDictMap.get(costPoolAuditReportVo.getRegionCode())))) {
                costPoolAuditReportVo.setRegionName(regionName);
            }
            if ((customerRetailerVo = (CustomerRetailerVo)finalCustomerRetailerVoMap.get(costPoolAuditReportVo.getSystemCode())) != null) {
                costPoolAuditReportVo.setSystemName(customerRetailerVo.getCustomerRetailerName());
            }
            if (StringUtils.isNotEmpty((CharSequence)costPoolAuditReportVo.getRegionName()) && StringUtils.isNotEmpty((CharSequence)costPoolAuditReportVo.getSystemName())) {
                costPoolAuditReportVo.setQuantum(costPoolAuditReportVo.getRegionName() + costPoolAuditReportVo.getSystemName());
            }
            costPoolAuditReportVo.setAmount(value.stream().map(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            records2.add(costPoolAuditReportVo);
        });
        List<String> dimensionKeys = records2.stream().map(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getDimensionKey).collect(Collectors.toList());
        Map<Object, Object> costPoolAuditReportVoMap2 = new HashMap();
        if (!CollectionUtils.isEmpty(dimensionKeys)) {
            List<com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo> costPoolAuditReportVos = this.costPoolAuditReportRepository.findListByDimensionKeys(dimensionKeys);
            costPoolAuditReportVoMap2 = costPoolAuditReportVos.stream().collect(Collectors.toMap(com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo::getDimensionKey, Function.identity()));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        for (com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo record : records2) {
            record.setId(null);
            record.setTenantCode(TenantUtils.getTenantCode());
            com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo costPoolAuditReportVo = (com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo)costPoolAuditReportVoMap2.get(record.getDimensionKey());
            if (costPoolAuditReportVo != null) {
                record.setId(costPoolAuditReportVo.getId());
                record.setAmount(Optional.ofNullable(record.getAmount()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(costPoolAuditReportVo.getAmount()).orElse(BigDecimal.ZERO)));
                continue;
            }
            record.setYearMonthly(df.format(record.getEnterCostPoolDate()));
        }
        if (!CollectionUtils.isEmpty(records2)) {
            Collection costPoolAuditReports = this.nebulaToolkitService.copyCollectionByWhiteList(records2, com.biz.crm.tpm.business.audit.sdk.vo.report.CostPoolAuditReportVo.class, CostPoolAuditReport.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.costPoolAuditReportRepository.saveOrUpdateBatch(costPoolAuditReports);
        }
    }
}

