/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.enums.SalesOrgLevelTypeEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.supplier.sdk.dto.SupplierDto;
import com.biz.crm.mdm.business.supplier.sdk.service.SupplierVoService;
import com.biz.crm.mdm.business.supplier.sdk.vo.SupplierVo;
import com.biz.crm.mn.common.auth.sdk.vo.UrlAddressVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.third.system.ecrm.sdk.enumeration.PushECRMStatusEnum;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.PreEndResultRequestVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.local.entity.Audit;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetail;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollection;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollectionExtend;
import com.biz.crm.tpm.business.audit.local.entity.AuditInvoice;
import com.biz.crm.tpm.business.audit.local.exception.AuditTimestampException;
import com.biz.crm.tpm.business.audit.local.exception.CustomerException;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionExtendRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditEcAlreadyEndCaseAmountRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditInvoiceRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditSupplierDetailRepository;
import com.biz.crm.tpm.business.audit.local.service.AuditProcess;
import com.biz.crm.tpm.business.audit.local.service.AuditRedInvoiceProductService;
import com.biz.crm.tpm.business.audit.local.service.helper.WebSocketHelper;
import com.biz.crm.tpm.business.audit.sdk.dto.ActivityDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditAutoConfigurationDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditBatchSubmitDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditBatchSubmitQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailCollectionDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDetailLookDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditFindDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditOutDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditProductUpAccountDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceProductDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditSupplierDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.CustomerCostAuditStatisticsDto;
import com.biz.crm.tpm.business.audit.sdk.dto.QueryAuditInfoDto;
import com.biz.crm.tpm.business.audit.sdk.dto.QueryEndCaseInfoDto;
import com.biz.crm.tpm.business.audit.sdk.dto.SplitAuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.AuditMsgCheckTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CacheTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CheckStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.CustomerSupplierTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditMsgService;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.ActivityDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditAutoConfigurationVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditDetailLookVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditEcAlreadyEndCaseAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditEndCaseInfoVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceSdkVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditInvoiceVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditPayPrepayVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditPayVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditPrintVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditProductUpAccountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSubmitAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierDetailVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditSupplierMaterialFileVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.tpm.business.audit.sdk.vo.CustomerCostAuditStatisticsItemVo;
import com.biz.crm.tpm.business.audit.sdk.vo.MobileAuditApprovedInfo1Vo;
import com.biz.crm.tpm.business.audit.sdk.vo.MobileAuditApprovedInfo2Vo;
import com.biz.crm.tpm.business.audit.sdk.vo.PaymentReceiptPaySdkVo;
import com.biz.crm.tpm.business.audit.sdk.vo.PaymentReceiptShouldSdkVo;
import com.biz.crm.tpm.business.audit.sdk.vo.PreEndResultRequestEntityVo;
import com.biz.crm.tpm.business.audit.sdk.vo.SplitAuditCustomerDetailMsgVo;
import com.biz.crm.tpm.business.audit.sdk.vo.UpAccountAdjustVo;
import com.biz.crm.tpm.business.audit.sdk.vo.report.AuditManageActivityTypeFeeVo;
import com.biz.crm.tpm.business.audit.sdk.vo.report.AuditManageChannelFeeVo;
import com.biz.crm.tpm.business.audit.sdk.vo.report.AuditManageOneProductFeeVo;
import com.biz.crm.tpm.business.audit.summary.configure.sdk.service.TpmCustomerSummaryConfigureService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.service.DetailedForecastService;
import com.biz.crm.tpm.business.detailed.forecast.sdk.vo.DetailedForecastVo;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.dto.TpmDistributionCustomerAuditDataDto;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.service.TpmDistributionCustomerAuditDataService;
import com.biz.crm.tpm.business.distribution.customer.audit.data.sdk.vo.TpmDistributionCustomerAuditDataRespVo;
import com.biz.crm.tpm.business.month.budget.sdk.eunm.YesOrNoEnum;
import com.biz.crm.tpm.business.payment.receipt.sdk.service.PaymentReceiptSdkService;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptPayVo;
import com.biz.crm.tpm.business.payment.receipt.sdk.vo.PaymentReceiptShouldVo;
import com.biz.crm.tpm.business.prepayment.details.sdk.service.PrepaymentDetailsService;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.BeachPrepaymentDetailsVo;
import com.biz.crm.tpm.business.prepayment.details.sdk.vo.PrepaymentDetailsVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.scheme.forecast.sdk.enums.TpmAuditTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.biz.crm.tpm.business.third.system.local.service.Ce1MnjtService;
import com.biz.crm.tpm.business.third.system.sdk.dto.Ce1MnjtSearchDto;
import com.biz.crm.tpm.business.third.system.sdk.vo.Ce1MnjtFullVo2;
import com.biz.crm.tpm.business.variable.sdk.dto.CalculateDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.CalculateVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

@Service(value="auditService")
public class AuditServiceImpl
implements AuditService {
    private static final Logger log = LoggerFactory.getLogger(AuditServiceImpl.class);
    @Autowired(required=false)
    private WebSocketHelper webSocketHelper;
    @Autowired(required=false)
    private AuditRepository auditRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private List<IAudit> auditStrategyList;
    @Autowired(required=false)
    private AuditCustomerDetailRepository auditCustomerDetailRepository;
    @Autowired(required=false)
    private AuditSupplierDetailRepository auditSupplierDetailRepository;
    @Autowired(required=false)
    private SupplierVoService supplierVoService;
    @Autowired(required=false)
    private PrepaymentDetailsService prepaymentDetailsService;
    @Autowired(required=false)
    private AuditCustomerDetailCollectionRepository auditCustomerDetailCollectionRepository;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private EcrmService ecrmService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private DetailedForecastService detailedForecastService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private AuditInvoiceRepository auditInvoiceRepository;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private Ce1MnjtService ce1MnjtService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private VariableService variableService;
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    @Autowired(required=false)
    private AuditFormulaMainService auditFormulaMainService;
    @Autowired(required=false)
    private TpmCustomerSummaryConfigureService tpmCustomerSummaryConfigureService;
    @Autowired(required=false)
    private AuditRedInvoiceProductService auditRedInvoiceProductService;
    @Autowired(required=false)
    private AuditMsgService auditMsgService;
    @Autowired(required=false)
    private TpmDistributionCustomerAuditDataService tpmDistributionCustomerAuditDataService;
    @Autowired(required=false)
    protected AuditEcAlreadyEndCaseAmountRepository auditEcAlreadyEndCaseAmountRepository;
    @Autowired(required=false)
    private PaymentReceiptSdkService paymentReceiptSdkService;
    @Autowired(required=false)
    private AuditProcess auditProcess;
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private SubComActivityDesignBudgetService subComActivityDesignBudgetService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private AuditCustomerDetailCollectionExtendRepository auditCustomerDetailCollectionExtendRepository;

    public Page<AuditVo> findByConditions(Pageable pageable, AuditDto audit) {
        IAudit iAudit = this.getAudit(null);
        return iAudit.findByConditions(pageable, audit);
    }

    public AuditVo findByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        IAudit thisAudit = this.getAuditByAuditCode(auditCode);
        return thisAudit.findByAuditCode(auditCode);
    }

    public List<AuditVo> findByAuditCodeList(List<String> auditCodeList) {
        if (CollectionUtils.isEmpty(auditCodeList)) {
            return Collections.emptyList();
        }
        List<Audit> result = this.auditRepository.findByAuditCodeList(auditCodeList);
        if (CollectionUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(result, Audit.class, AuditVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private IAudit getAuditByAuditCode(String auditCode) {
        Audit auditEntity = (Audit)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditRepository.lambdaQuery().eq(Audit::getAuditCode, (Object)auditCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
        Validate.notNull((Object)((Object)auditEntity), (String)"\u6838\u9500\u7f16\u7801\u3010%s\u3011\u672a\u5728\u7cfb\u7edf\u4e2d\u627e\u5230", (Object[])new Object[]{auditCode});
        AuditDto auditDto = (AuditDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditEntity, AuditDto.class, null, null, new String[0]);
        return this.getAudit(auditDto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void create(AuditDto audit) {
        try {
            IAudit thisAudit = this.getAudit(audit);
            try {
                this.webSocketHelper.sendMsg("\u5f00\u59cb\u4fdd\u5b58");
                thisAudit.create(audit);
                this.webSocketHelper.sendMsg("\u7ed3\u6848\u6838\u9500\u6570\u636e\u5904\u7406\u6210\u529f", ExecStatusEnum.FINISH.getDictCode());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                if (!(e instanceof AuditTimestampException)) {
                    this.deleteVerifyTimestamp(audit);
                }
                throw e;
            }
        }
        catch (Exception e) {
            this.webSocketHelper.sendMsg("\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            throw e;
        }
    }

    public IAudit getAudit(AuditDto audit) {
        for (IAudit audit1 : this.auditStrategyList) {
            if (!audit1.isSupport(audit)) continue;
            return audit1;
        }
        for (IAudit iAudit : this.auditStrategyList) {
            if (!iAudit.isDefault()) continue;
            return iAudit;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(AuditDto audit) {
        try {
            try {
                IAudit thisAudit = this.getAudit(audit);
                this.webSocketHelper.sendMsg("\u5f00\u59cb\u66f4\u65b0");
                thisAudit.update(audit);
                this.webSocketHelper.sendMsg("\u7ed3\u6848\u6838\u9500\u6570\u636e\u5904\u7406\u6210\u529f", ExecStatusEnum.FINISH.getDictCode());
                log.info("\u7ed3\u6848\u6838\u9500\u66f4\u65b0\u6210\u529f\uff0c\u6838\u9500\u5355\u53f7{}", (Object)audit.getAuditCode());
            }
            catch (Exception e) {
                log.info("\u7ed3\u6848\u6838\u9500\u66f4\u65b0\u5f02\u5e38,\u6838\u9500\u7f16\u7801:{}", (Object)audit.getAuditCode());
                log.error("\u7ed3\u6848\u6838\u9500\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
                if (!(e instanceof AuditTimestampException)) {
                    this.deleteVerifyTimestamp(audit);
                }
                throw e;
            }
        }
        catch (Exception e) {
            this.webSocketHelper.sendMsg("\u66f4\u65b0\u4fdd\u5b58\u5931\u8d25\uff1a" + e.getMessage());
            throw e;
        }
    }

    private void deleteVerifyTimestamp(AuditDto audit) {
        String key = audit.getTimestampKey();
        if (StringUtils.isNotEmpty((CharSequence)key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.delete(idList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteDetail(List<String> detailCodeList) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.deleteDetail(detailCodeList);
    }

    public Page<AuditCustomerDetailCollectionVo> queryAuditCustomerDetailCollectionInfo(Pageable pageable, AuditDto auditDto) {
        IAudit thisAudit = this.getAudit(auditDto);
        return thisAudit.queryAuditCustomerDetailCollectionInfo(pageable, auditDto);
    }

    public Page<AuditCustomerDetailVo> queryAuditCustomerDetailInfo(Pageable pageable, AuditDto audit) {
        IAudit thisAudit = this.getAudit(audit);
        return thisAudit.queryAuditCustomerDetailInfo(pageable, audit);
    }

    public String collectionAuditCustomerDetail(AuditVo vo) {
        AuditDto dto = new AuditDto();
        dto.setEndCaseType(vo.getEndCaseType());
        IAudit thisAudit = this.getAudit(dto);
        log.info("\u7ed3\u6848\u6838\u9500\u5ba2\u6237\u62c6\u5206,\u6b65\u9aa42");
        return thisAudit.collectionAuditCustomerDetail(vo);
    }

    public void deleteCustomerDetail(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        thisAudit.deleteCustomerDetail(dto);
    }

    public void changeCustomerAuditDetail(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        thisAudit.changeCustomerAuditDetail(dto);
    }

    public void changeCustomerAuditCollectionDetail(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        thisAudit.changeCustomerAuditCollectionDetail(dto);
    }

    public String saveSupplierAuditDetail(AuditVo vo) {
        AuditDto auditDto = (AuditDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, AuditDto.class, null, null, new String[0]);
        IAudit thisAudit = this.getAudit(auditDto);
        return thisAudit.saveSupplierAuditDetail(vo);
    }

    public Page<AuditSupplierDetailVo> queryAuditSupplierDetailInfo(Pageable pageable, AuditDto audit) {
        IAudit thisAudit = this.getAudit(audit);
        return thisAudit.queryAuditSupplierDetailInfo(pageable, audit);
    }

    public void deleteSupplierDetail(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        thisAudit.deleteSupplierDetail(dto);
    }

    public void changeSupplierAuditDetail(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        thisAudit.changeSupplierAuditDetail(dto);
    }

    public void batchChangePayWay(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        thisAudit.batchChangePayWay(dto);
    }

    public void auditInfoAndInvoiceSave(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.auditInfoAndInvoiceSave(dto);
    }

    public Page<AuditInvoiceVo> queryAuditInvoiceInfo(Pageable pageable, AuditDto audit) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.queryAuditInvoiceInfo(pageable, audit);
    }

    public AuditVo findByAuditDetailCodes(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        return thisAudit.findByAuditDetailCodes(dto);
    }

    public void saveAuditInvoiceCache(AuditDto auditDto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.saveAuditInvoiceCache(auditDto);
    }

    public void changeAuditInvoiceCache(AuditDto auditDto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.changeAuditInvoiceCache(auditDto);
    }

    public void deleteAuditInvoice(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.deleteAuditInvoice(dto);
    }

    public void clearAuditInvoice(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.clearAuditInvoice(dto);
    }

    public UpAccountAdjustVo upAccountAdjust(List<String> auditDetailCodes) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.upAccountAdjust(auditDetailCodes);
    }

    public Map<String, Integer> getHasSaveNum(String cacheKey) {
        IAudit audit = this.getAudit(null);
        return audit.getHasSaveNum(cacheKey);
    }

    public Page<ActivityDetailVo> queryActivityDetailPage(Pageable pageable, ActivityDetailDto dto) {
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit thisAudit = this.getAudit(auditDto);
        return thisAudit.queryActivityDetailPage(pageable, dto);
    }

    public List<ActivityDetailVo> findActivityDetail(ActivityDetailDto activityDetail) {
        return null;
    }

    public List<AuditCustomerDetailVo> findAuditCustomerDetail(List<String> codes) {
        IAudit audit = this.getAudit(null);
        return audit.findAuditCustomerDetail(codes);
    }

    public String confirm(List<String> auditCodes) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.confirm(auditCodes);
    }

    public void endCaseInfoSave(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.endCaseInfoSave(dto);
    }

    public List<AuditEndCaseInfoVo> queryEndCaseInfo(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.queryEndCaseInfo(dto);
    }

    public Map<String, BigDecimal> getInvoiceTotalAmount(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.getInvoiceTotalAmount(dto);
    }

    public AuditVo queryCalculateHeaderData(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        return thisAudit.queryCalculateHeaderData(dto);
    }

    public List<AuditPayVo> collectSupplierPayInfo(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        return thisAudit.collectSupplierPayInfo(dto);
    }

    public Map<String, BigDecimal> listAuditStatistics(CustomerCostAuditStatisticsDto dto) {
        List<CustomerCostAuditStatisticsItemVo> list = this.auditCustomerDetailRepository.listAuditStatistics(dto);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String, BigDecimal> map = list.stream().collect(Collectors.toMap(CustomerCostAuditStatisticsItemVo::getCustomerCode, CustomerCostAuditStatisticsItemVo::getThisAuditAmount));
        return map;
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditDto autoAudit(AutoAuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditDto auditDto = (AuditDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditDto.class, null, null, new String[0]);
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        log.info("\u81ea\u52a8\u7ed3\u6848\u4e3b\u8868\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)auditDto));
        if (CollectionUtils.isNotEmpty((Collection)dto.getAuditCustomerDetailList())) {
            log.info("\u81ea\u52a8\u7ed3\u6848\u660e\u7ec6\u6570\u91cf:{}", (Object)dto.getAuditCustomerDetailList().size());
            auditDto.setAuditCustomerDetailList(dto.getAuditCustomerDetailList());
        }
        IAudit thisAudit = this.getAudit(auditDto);
        return thisAudit.autoAudit(auditDto);
    }

    public List<AuditSupplierDetailVo> getSupplierDetailByCodes(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return org.apache.commons.compress.utils.Lists.newArrayList();
        }
        return this.auditSupplierDetailRepository.getSupplierDetailByCodes(codes);
    }

    public List<AuditCustomerDetailCollectionVo> collectAuditDetail(Collection<AuditCustomerDetailVo> auditDetailVos) {
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit thisAudit = this.getAudit(auditDto);
        return thisAudit.collectAuditDetail(auditDetailVos, auditDto);
    }

    public AuditPrintVo queryPrintInfo(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        IAudit thisAudit = this.getAuditByAuditCode(auditCode);
        AuditVo auditVo = thisAudit.queryPrintInfo(auditCode);
        if (Objects.isNull(auditVo)) {
            return null;
        }
        return this.dataConversion(auditVo);
    }

    private AuditPrintVo dataConversion(AuditVo auditVo) {
        String preparedBy;
        AuditPrintVo auditPrintVo = new AuditPrintVo();
        String companyCode = auditVo.getCompanyCode();
        String belnr = auditVo.getBelnr();
        String gjahr = auditVo.getGjahr();
        auditPrintVo.setCompanyCode(companyCode);
        auditPrintVo.setCompanyName(auditVo.getCompanyName());
        List list = auditVo.getAuditCustomerDetailCollectionList();
        String s = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            AuditCustomerDetailCollectionVo detailCollectionVo = (AuditCustomerDetailCollectionVo)list.get(0);
            if (CustomerSupplierTypeEnum.CUSTOMER.getValue().equals(detailCollectionVo.getCustomerSupplierType())) {
                auditPrintVo.setCustomerSupplierName(detailCollectionVo.getCustomerName());
                auditPrintVo.setPaymentReference(detailCollectionVo.getCustomerCode());
            }
            if (CustomerSupplierTypeEnum.SUPPLIER.getValue().equals(detailCollectionVo.getCustomerSupplierType())) {
                auditPrintVo.setCustomerSupplierName(detailCollectionVo.getSupplierName());
                auditPrintVo.setPaymentReference(detailCollectionVo.getSupplierCode());
            }
            List taxRates = list.stream().map(AuditCustomerDetailCollectionVo::getReimburseTaxRate).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            StringBuilder taxRateStr = new StringBuilder();
            Iterator iterator = taxRates.iterator();
            while (iterator.hasNext()) {
                String next = (String)iterator.next();
                taxRateStr.append(next);
                if (!iterator.hasNext()) continue;
                taxRateStr.append(",");
            }
            auditPrintVo.setReimburseTaxRate(taxRateStr.toString());
            auditPrintVo.setReimburseItem(detailCollectionVo.getReimburseItemName());
            auditPrintVo.setCertificateTitleText(detailCollectionVo.getCostCenterName());
            String auditCode = detailCollectionVo.getAuditCode();
            auditPrintVo.setAppendices(auditVo.getAppendices());
        }
        s = (StringUtils.isNotBlank((CharSequence)belnr) ? belnr : "") + (StringUtils.isNotBlank((CharSequence)companyCode) ? companyCode : "") + (StringUtils.isNotBlank((CharSequence)gjahr) ? gjahr : "");
        auditPrintVo.setDocumentCode(s);
        auditPrintVo.setFiscalYear(gjahr);
        auditPrintVo.setCertificateCode(belnr);
        auditPrintVo.setThisEndCaseTaxTotalAmount(auditVo.getThisEndCaseTaxTotalAmount());
        auditPrintVo.setAuditTaxTotalAmount(auditVo.getAuditTaxTotalAmount());
        auditPrintVo.setAuditTotalAmount(auditVo.getAuditTotalAmount());
        auditPrintVo.setTaxTotalAmount(auditVo.getTaxTotalAmount());
        AbstractCrmUserIdentity loginDetails = this.loginUserService.getAbstractLoginUser();
        if (Objects.nonNull(loginDetails)) {
            auditPrintVo.setPreparedBy(auditVo.getCreateAccount() + "-" + auditVo.getCreateName());
        }
        if (StringUtils.isBlank((CharSequence)(preparedBy = auditPrintVo.getPreparedBy())) || preparedBy.contains("admin")) {
            auditPrintVo.setPreparedBy(auditVo.getModifyAccount() + "-" + auditVo.getModifyName());
        }
        try {
            auditPrintVo.setBarCode(Base64.getEncoder().encodeToString(s.getBytes("utf-8")));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return auditPrintVo;
    }

    public void clearAuditDetailCache(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        thisAudit.clearAuditDetailCache(dto);
        this.auditRedInvoiceProductService.clearCache(dto.getCacheKey());
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSubmitApproval(AuditBatchSubmitDto dto) {
        try {
            this.webSocketHelper.sendMsg("\u5f00\u59cb\u6279\u91cf\u63d0\u4ea4\u6570\u636e");
            Validate.notNull((Object)dto.getProcessBusiness(), (String)"\u63d0\u4ea4\u5ba1\u6279\u6d41\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List auditCodeList = dto.getAuditCodeList();
            Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)auditCodeList), (String)"\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            List auditCodeCollect = auditCodeList.stream().distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty((Collection)auditCodeList) && CharSequenceUtil.isEmpty((CharSequence)dto.getAuditCode()) && CharSequenceUtil.isEmpty((CharSequence)dto.getAuditName()) && CharSequenceUtil.isEmpty((CharSequence)dto.getActivityCode()) && CharSequenceUtil.isEmpty((CharSequence)dto.getActivityDetailCode()) && CharSequenceUtil.isEmpty((CharSequence)dto.getActivityFormCode()) && CharSequenceUtil.isEmpty((CharSequence)dto.getActivityTypeCode()) && CharSequenceUtil.isEmpty((CharSequence)dto.getEndCaseForm()) && CharSequenceUtil.isEmpty((CharSequence)dto.getEndCaseCustomerName()) && CharSequenceUtil.isEmpty((CharSequence)dto.getEndCaseCustomerCode())) {
                Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)auditCodeList), (String)"\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditRepository.lambdaQuery().in(Audit::getAuditCode, auditCodeCollect)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
            ArrayList payAuditCodes = org.apache.commons.compress.utils.Lists.newArrayList();
            for (Audit audit : list) {
                String paymentType = audit.getPaymentType();
                if (!CharSequenceUtil.isNotEmpty((CharSequence)paymentType) || !CharSequenceUtil.equals((CharSequence)paymentType, (CharSequence)"1")) continue;
                payAuditCodes.add(audit.getAuditCode());
            }
            if (CollUtil.isNotEmpty((Collection)payAuditCodes)) {
                this.webSocketHelper.sendMsg("\u6821\u9a8c\u9884\u4ed8\u6570\u636e");
                List shouldVoList = this.paymentReceiptSdkService.findPaymentReceiptShouldByAuditCode((List)payAuditCodes);
                Validate.notEmpty((Collection)shouldVoList, (String)("\u6838\u9500\u7f16\u7801:" + CharSequenceUtil.join((CharSequence)",", (Iterable)payAuditCodes) + "\u672a\u586b\u5199\u4ed8\u6b3e\u5355\u4fe1\u606f"), (Object[])new Object[0]);
                List auditCodes = shouldVoList.stream().filter(item -> CharSequenceUtil.isNotEmpty((CharSequence)item.getAuditCode())).map(PaymentReceiptShouldVo::getAuditCode).distinct().collect(Collectors.toList());
                List notContains = auditCodes.stream().filter(code -> !payAuditCodes.contains(code)).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(notContains)) {
                    throw new NullPointerException("\u6838\u9500\u7f16\u7801:" + CharSequenceUtil.join((CharSequence)",", notContains) + "\u672a\u586b\u5199\u4ed8\u6b3e\u5355\u4fe1\u606f");
                }
            }
            AuditDto auditDto = new AuditDto();
            auditDto.setEndCaseType(dto.getEndCaseType());
            IAudit thisAudit = this.getAudit(auditDto);
            this.webSocketHelper.sendMsg("\u6279\u91cf\u63d0\u4ea4\u6570\u636e");
            thisAudit.submitBatchApproval(dto);
            this.webSocketHelper.sendMsg("\u6279\u91cf\u63d0\u4ea4\u6570\u636e\u6210\u529f", ExecStatusEnum.FINISH.getDictCode());
        }
        catch (Exception e) {
            this.webSocketHelper.sendMsg("\u6279\u91cf\u63d0\u4ea4\u6570\u636e\u5931\u8d25:" + e.getMessage());
            throw e;
        }
    }

    public Page<AuditVo> findAuditApproval(Pageable pageable, String processNo) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findAuditApproval(pageable, processNo);
    }

    public Page<AuditPayVo> findSupplierByConditions(Pageable pageable, SupplierDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page supplierVoPage = this.supplierVoService.findByConditions(pageable, dto);
        if (Objects.isNull(supplierVoPage)) {
            return page;
        }
        page.setTotal(supplierVoPage.getTotal());
        ArrayList<AuditPayVo> auditPayVoList = new ArrayList<AuditPayVo>();
        if (CollectionUtils.isNotEmpty((Collection)supplierVoPage.getRecords())) {
            List records = supplierVoPage.getRecords();
            Set supplierCodeSet = records.stream().map(SupplierVo::getSupplierCode).collect(Collectors.toSet());
            List beachPrepaymentDetailsVoList = this.prepaymentDetailsService.findBySupplierCode(supplierCodeSet);
            Map<Object, Object> beachPrepaymentDetailsVoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)beachPrepaymentDetailsVoList)) {
                beachPrepaymentDetailsVoMap = beachPrepaymentDetailsVoList.stream().collect(Collectors.toMap(BeachPrepaymentDetailsVo::getSupplierCode, Function.identity()));
            }
            for (SupplierVo record : supplierVoPage.getRecords()) {
                AuditPayVo auditPayVo = new AuditPayVo();
                auditPayVo.setSupplierCode(record.getSupplierCode());
                auditPayVo.setSupplierName(record.getSupplierName());
                auditPayVo.setAccountName(record.getContactName());
                auditPayVo.setReceiptAccount(record.getBankCard());
                auditPayVo.setOpenAccountBank(record.getBankAccount());
                auditPayVo.setUnionpayCode(record.getUnionPayBankCard());
                auditPayVo.setEMailInformPeople("todo");
                ArrayList<AuditPayPrepayVo> auditPayPrepayList = new ArrayList<AuditPayPrepayVo>();
                BeachPrepaymentDetailsVo beachPrepaymentDetailsVo = (BeachPrepaymentDetailsVo)beachPrepaymentDetailsVoMap.get(record.getSupplierCode());
                if (beachPrepaymentDetailsVo != null) {
                    if (CollectionUtils.isNotEmpty((Collection)beachPrepaymentDetailsVo.getPrepaymentDetailsList())) {
                        for (PrepaymentDetailsVo prepaymentDetailsVo : beachPrepaymentDetailsVo.getPrepaymentDetailsList()) {
                            AuditPayPrepayVo auditPayPrepayVo = (AuditPayPrepayVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)prepaymentDetailsVo, AuditPayPrepayVo.class, null, null, new String[0]);
                            auditPayPrepayVo.setActivitiesDetailCode(prepaymentDetailsVo.getActivityDetailNo());
                            auditPayPrepayVo.setThisPayType(prepaymentDetailsVo.getPaymentType());
                            auditPayPrepayVo.setReason(prepaymentDetailsVo.getPrepaymentReason());
                            auditPayPrepayList.add(auditPayPrepayVo);
                        }
                    }
                    auditPayVo.setThisChargeAgainstPrepayTotalAmount(((List)Optional.ofNullable(beachPrepaymentDetailsVo.getPrepaymentDetailsList()).orElse(new ArrayList())).stream().map(PrepaymentDetailsVo::getCurrentAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                }
                auditPayVo.setAuditPayPrepayList(auditPayPrepayList);
                auditPayVoList.add(auditPayVo);
            }
        }
        page.setRecords(auditPayVoList);
        return page;
    }

    public String upAccount(List<String> auditCodes) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.handUpAccounts(auditCodes);
    }

    public String upAccountChargeAgainst(List<String> auditCodes) {
        AuditDto dto = new AuditDto();
        dto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit thisAudit = this.getAudit(dto);
        return thisAudit.upAccountChargeAgainst(auditCodes);
    }

    public AuditVo findAuditInfo(QueryAuditInfoDto dto) {
        AuditDto dto1 = new AuditDto();
        dto1.setEndCaseType(dto.getEndCaseType());
        IAudit thisAudit = this.getAudit(dto1);
        return thisAudit.findAuditInfo(dto);
    }

    public void saveAuditInfoCache(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.saveAuditInfoCache(dto);
    }

    public void saveAuditInvoiceCache2(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.saveAuditInvoiceCache2(dto);
    }

    public List<AuditEndCaseInfoVo> queryEndCaseInfo2(QueryEndCaseInfoDto dto) {
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit thisAudit = this.getAudit(auditDto);
        return thisAudit.queryEndCaseInfo2(dto);
    }

    public Page<AuditCustomerDetailCollectionVo> auditDetail(Pageable pageable, AuditCustomerDetailCollectionDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditCustomerDetailCollectionDto();
        }
        return this.auditCustomerDetailCollectionRepository.auditDetail(pageable, dto);
    }

    public List<AuditCustomerDetailCollectionVo> auditDetail(AuditCustomerDetailCollectionDto dto) {
        List<AuditCustomerDetailCollectionVo> auditCustomerDetailCollections = this.auditCustomerDetailCollectionRepository.auditDetail(dto);
        if (CollectionUtils.isEmpty(auditCustomerDetailCollections)) {
            return org.apache.commons.compress.utils.Lists.newArrayList();
        }
        return auditCustomerDetailCollections;
    }

    public List<String> auditDetailCustomerList(AuditCustomerDetailCollectionDto dto) {
        List<String> auditCustomerDetailCollections = this.auditCustomerDetailCollectionRepository.auditDetailCustomerList(dto);
        if (CollectionUtils.isEmpty(auditCustomerDetailCollections)) {
            return org.apache.commons.compress.utils.Lists.newArrayList();
        }
        return auditCustomerDetailCollections;
    }

    public List<String> auditDetailEndCaseCustomerList(AuditCustomerDetailCollectionDto dto) {
        List<String> auditCustomerDetailCollections = this.auditCustomerDetailCollectionRepository.auditDetailEndCaseCustomerList(dto);
        if (CollectionUtils.isEmpty(auditCustomerDetailCollections)) {
            return org.apache.commons.compress.utils.Lists.newArrayList();
        }
        return auditCustomerDetailCollections;
    }

    public List<AuditCustomerDetailCollectionVo> findAuditCustomerDetails(AuditCustomerDetailCollectionDto dto) {
        return this.auditCustomerDetailRepository.findAuditCustomerDetails(dto);
    }

    public Set<String> findCustomer(AuditCustomerDetailCollectionDto dto) {
        List<AuditCustomerDetailCollectionVo> auditCustomerDetailCollectionVos = this.auditDetail(dto);
        if (CollectionUtils.isEmpty(auditCustomerDetailCollectionVos)) {
            return Sets.newHashSet();
        }
        return auditCustomerDetailCollectionVos.stream().map(AuditCustomerDetailCollectionVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public Page<AuditCustomerDetailCollectionVo> auditUpAccountDetail(Pageable pageable, AuditCustomerDetailCollectionDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditCustomerDetailCollectionDto();
        }
        return this.auditCustomerDetailCollectionRepository.auditUpAccountDetail(pageable, dto);
    }

    public void updatSynchronizationByUuids(List<String> auditCodes) {
        this.auditRepository.updatSynchronizationByUuids(auditCodes);
    }

    public void pushEcrm(List<String> idList) {
        Assert.notEmpty(idList, (String)"\u8bf7\u9009\u62e9\u6570\u636e!");
        List result = this.auditService.findRequestEntityVoByIds(idList);
        Assert.notEmpty((Collection)result, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728\u6216\u5df2\u63a8\u9001,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        Map resultMap = result.stream().collect(Collectors.toMap(PreEndResultRequestEntityVo::getDetailPlanItemCode, Function.identity()));
        Set detailPlanItemCodeSet = result.stream().map(PreEndResultRequestEntityVo::getDetailPlanItemCode).collect(Collectors.toSet());
        List activityDetailPlanList = this.activityDetailPlanItemSdkService.listByItemCodeList(new ArrayList(detailPlanItemCodeSet));
        if (CollectionUtils.isEmpty((Collection)activityDetailPlanList) || idList.stream().distinct().count() != (long)activityDetailPlanList.size()) {
            throw new UnsupportedOperationException("\u5b58\u5728\u975e\u4e3b\u4f53\u6838\u9500\u660e\u7ec6\u6570\u636e\uff0c\u63a8\u9001\u4e2d\u6b62");
        }
        List detailedForecastVoList = this.detailedForecastService.findByActivityDetailItemCode(detailPlanItemCodeSet);
        Map<String, ActivityDetailPlanItemVo> detailPlanItemMap = activityDetailPlanList.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, v -> v, (newValue, oldValue) -> newValue));
        Map<String, DetailedForecastVo> detailedForecastMap = detailedForecastVoList.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, v -> v, (newValue, oldValue) -> newValue));
        List activityDetailPlanVoList = this.activityDetailPlanSdkService.findByCodes((Collection)activityDetailPlanList.stream().map(ActivityDetailPlanItemBase::getDetailPlanCode).collect(Collectors.toSet()));
        Map detailPlanMap = activityDetailPlanVoList.stream().collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, Function.identity()));
        List totalList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)result, PreEndResultRequestEntityVo.class, PreEndResultRequestVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List customerCodeList = activityDetailPlanList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getCustomerCode())).map(ActivityDetailPlanItemBase::getCustomerCode).distinct().filter(Objects::nonNull).collect(Collectors.toList());
        List customerVoList = this.customerVoService.findCustomerAndContactByCustomerCodes(customerCodeList);
        Map customerMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
        ArrayList salesOrgCodeList = new ArrayList();
        salesOrgCodeList.addAll(customerVoList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getSalesInstitutionCode())).map(CustomerVo::getSalesInstitutionCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));
        salesOrgCodeList.addAll(customerVoList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getSalesRegionCode())).map(CustomerVo::getSalesRegionCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));
        salesOrgCodeList.addAll(customerVoList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getSalesOrgCode())).map(CustomerVo::getSalesOrgCode).distinct().filter(Objects::nonNull).collect(Collectors.toList()));
        List salesOrgVoList = this.salesOrgVoService.findBySalesOrgCodes(salesOrgCodeList);
        Map salesOrgMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
        for (PreEndResultRequestVo requestVo : totalList) {
            CustomerVo customerVo;
            ActivityDetailPlanItemVo itemVo = detailPlanItemMap.get(requestVo.getDetailPlanItemCode());
            itemVo.setAuditDetailCode(requestVo.getAuditDetailCode());
            ActivityDetailPlanVo detailPlanVo = (ActivityDetailPlanVo)detailPlanMap.get(itemVo.getDetailPlanCode());
            DetailedForecastVo forecastVo = detailedForecastMap.getOrDefault(requestVo.getDetailPlanItemCode(), new DetailedForecastVo());
            PreEndResultRequestEntityVo entity = (PreEndResultRequestEntityVo)resultMap.get(itemVo.getDetailPlanItemCode());
            BeanUtils.copyProperties((Object)itemVo, (Object)requestVo);
            requestVo.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
            requestVo.setDetailPlanName(detailPlanVo.getDetailPlanName());
            requestVo.setDetailPlanItemCode(itemVo.getDetailPlanItemCode());
            if (StringUtils.isEmpty((CharSequence)entity.getSynchronization()) || BooleanEnum.FALSE.getNumStr().equals(entity.getSynchronization())) {
                requestVo.setStatus(PushECRMStatusEnum.ADD.getCode());
            } else {
                requestVo.setStatus(PushECRMStatusEnum.UPDATE.getCode());
            }
            requestVo.setAuditConditionValue(forecastVo.getWriteOffConditionValue());
            requestVo.setAuditCondition(forecastVo.getWriteOffConditions());
            requestVo.setAuditFormula(forecastVo.getWriteOffFormula());
            requestVo.setAuditFormulaValue(forecastVo.getWriteOffFormulaValue());
            requestVo.setCanAuditAmount(Objects.isNull(forecastVo.getEstimatedWriteOffAmount()) ? null : forecastVo.getEstimatedWriteOffAmount().toString());
            requestVo.setMonthSaleTask(itemVo.getMonthSalesTarget());
            requestVo.setNowSpreadMarketRatio(Objects.nonNull(itemVo.getCurrentMarketRate()) ? itemVo.getCurrentMarketRate().toString() : null);
            requestVo.setMonthSpreadMarketRatio(Objects.nonNull(itemVo.getMonthTargetMarketRate()) ? itemVo.getMonthTargetMarketRate().toString() : null);
            requestVo.setIsLaunchPatrolDemand(itemVo.getIsStartPatrol());
            requestVo.setPromoteSales(itemVo.getPeriodPromoteQuantity());
            requestVo.setPromotionAmount(itemVo.getPeriodPromoteAmount());
            requestVo.setPromoteChannelSales(itemVo.getPeriodChPromoteQuantity());
            requestVo.setPromotionChannelAmount(itemVo.getPeriodChPromoteAmount());
            requestVo.setMonthReplyQuantity(itemVo.getMonthReturnQuantity());
            requestVo.setMonthReplyAmount(itemVo.getMonthReturnAmount());
            requestVo.setStoreType(itemVo.getTerminalType());
            requestVo.setTerminalPredictMonthSaleAmount(itemVo.getTerminalMonthSalesAmount());
            requestVo.setUserName(itemVo.getPersonName());
            requestVo.setPersonnelType(itemVo.getPersonType());
            requestVo.setIdCard(itemVo.getPersonIdCard());
            requestVo.setPrice(itemVo.getMaterialPrice());
            requestVo.setStandeesDisplayQuantity(Objects.nonNull(itemVo.getQuantity()) ? new BigDecimal(itemVo.getQuantity()) : null);
            requestVo.setStandeesDisplayPrice(itemVo.getPrice());
            requestVo.setPurchaseType(itemVo.getProcurementType());
            requestVo.setDescription(itemVo.getFormDescription());
            requestVo.setTotalCost(itemVo.getTotalFeeAmount().toString());
            requestVo.setDealerBearFee(itemVo.getCustomerFeeAmountStr());
            BigDecimal applyFee = BigDecimal.ZERO;
            if (Objects.nonNull(itemVo.getHeadFeeAmount())) {
                applyFee = applyFee.add(itemVo.getHeadFeeAmount());
            }
            if (Objects.nonNull(itemVo.getDepartmentFeeAmount())) {
                applyFee = applyFee.add(itemVo.getDepartmentFeeAmount());
            }
            requestVo.setApplyFee(applyFee.toString());
            if (StringUtils.isNotEmpty((CharSequence)itemVo.getCustomerCode()) && (customerVo = (CustomerVo)customerMap.get(itemVo.getCustomerCode())) != null) {
                SalesOrgVo salesOrg;
                SalesOrgVo region;
                SalesOrgVo area;
                requestVo.setCustomerCode(customerVo.getErpCode());
                requestVo.setCustomerName(customerVo.getCustomerName());
                if (StringUtils.isNotEmpty((CharSequence)customerVo.getSalesInstitutionCode()) && (area = (SalesOrgVo)salesOrgMap.get(customerVo.getSalesInstitutionCode())) != null) {
                    requestVo.setSalesInstitutionCode(area.getErpCode());
                    requestVo.setSalesInstitutionName(area.getSalesOrgName());
                }
                if (StringUtils.isNotEmpty((CharSequence)customerVo.getSalesRegionCode()) && (region = (SalesOrgVo)salesOrgMap.get(customerVo.getSalesRegionCode())) != null) {
                    requestVo.setSalesOrgRegionCode(region.getErpCode());
                    requestVo.setSalesOrgRegionName(region.getSalesOrgName());
                }
                if (StringUtils.isNotEmpty((CharSequence)customerVo.getSalesRegionCode()) && (salesOrg = (SalesOrgVo)salesOrgMap.get(customerVo.getSalesOrgCode())) != null) {
                    requestVo.setSalesOrgProvinceCode(salesOrg.getErpCode());
                    requestVo.setSalesOrgProvinceName(salesOrg.getSalesOrgName());
                }
            }
            requestVo.setEndCaseTime(DateUtil.format((Object)entity.getEndCaseTime(), (String)"yyyy-MM-dd"));
            requestVo.setActivityBeginTime(DateUtil.format((Date)itemVo.getActivityBeginDate(), (String)"yyyy-MM-dd"));
            requestVo.setActivityEndTime(DateUtil.format((Date)itemVo.getActivityEndDate(), (String)"yyyy-MM-dd"));
            if (itemVo.getProductQuantity() != null) {
                requestVo.setProductQuantity(new BigDecimal(itemVo.getProductQuantity()));
            } else {
                requestVo.setProductQuantity(BigDecimal.ZERO);
            }
            if (itemVo.getGiftQuantity() != null) {
                requestVo.setGiftQuantity(new BigDecimal(itemVo.getGiftQuantity()));
            } else {
                requestVo.setProductQuantity(BigDecimal.ZERO);
            }
            if (itemVo.getHeadFeeAmount() != null) {
                requestVo.setApplyFee(itemVo.getHeadFeeAmount().toString());
            }
            if (itemVo.getCustomerFeeAmount() == null) continue;
            requestVo.setDealerBearFee(itemVo.getCustomerFeeAmount().toString());
        }
        if (CollectionUtils.isEmpty((Collection)totalList)) {
            return;
        }
        boolean flag = this.ecrmService.synchronizationPreEndResultRequest(totalList);
        if (flag) {
            List auditCodes = totalList.stream().map(PreEndResultRequestVo::getAuditCode).collect(Collectors.toList());
            this.auditService.updatSynchronizationByUuids(auditCodes);
        }
    }

    public List<PreEndResultRequestEntityVo> findRequestEntityVoByIds(List<String> idList) {
        return this.auditRepository.findRequestEntityVoByIds(idList);
    }

    public Page<PreEndResultRequestEntityVo> selectUnSynchronizedPage(Pageable pageable) {
        return this.auditRepository.selectUnSynchronizexdPage(pageable);
    }

    public AuditCustomerVo findByCode(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return new AuditCustomerVo();
        }
        return this.auditRepository.findByCode(code);
    }

    public List<AuditCustomerDetailCollectionVo> findAuditCustomerDetailCollectionByDetailPlanItemCodeList(List<String> detailItemCodeList) {
        List<AuditCustomerDetailCollection> collections = this.auditCustomerDetailCollectionRepository.findAuditCustomerDetailCollectionByDetailPlanItemCodeList(detailItemCodeList);
        return new ArrayList<AuditCustomerDetailCollectionVo>(this.nebulaToolkitService.copyCollectionByWhiteList(collections, AuditCustomerDetailCollection.class, AuditCustomerDetailCollectionVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public String batchAddActivityDetailByCode(ActivityDetailDto activityDetail) {
        AuditDto auditDto = new AuditDto();
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit thisAudit = this.getAudit(auditDto);
        Validate.notNull((Object)activityDetail.getCacheKey(), (String)"\u7f13\u5b58Key\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String cacheKey = activityDetail.getCacheKey();
        String cacheNumKey = cacheKey + CacheTypeEnum.BATCH_AUDIT_NUMBER.getCode();
        String detailCacheKey = cacheKey + CacheTypeEnum.CUSTOMER_AUDIT_DETAIL.getCode();
        Long cacheSize = this.redisTemplate.opsForList().size((Object)detailCacheKey);
        int cacheSizeInt = ObjectUtil.isNull((Object)cacheSize) ? 0 : Integer.parseInt(String.valueOf(cacheSize));
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int totalNum = thisAudit.queryActivityDetailPageTotal(activityDetail);
        stopWatch.stop();
        log.info("\u7ed3\u6848\u6838\u9500\u6839\u636e\u6d3b\u52a8\u7533\u8bf7\u7f16\u7801\u6279\u91cf\u6dfb\u52a0\u7f13\u5b58,\u7b2c\u4e00\u6b21\u67e5\u8be2\u603b\u6570:{},\u6d88\u8017\u65f6\u95f4\u4e3a:{}", (Object)totalNum, (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        Validate.isTrue((totalNum != 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u4e0b\u65e0\u6570\u636e", (Object[])new Object[0]);
        int cacheTotal = totalNum + cacheSizeInt;
        this.redisTemplate.delete((Object)cacheNumKey);
        this.redisTemplate.opsForValue().set((Object)cacheNumKey, (Object)cacheTotal, 1L, TimeUnit.HOURS);
        thisAudit.batchAddActivityDetailByCode(activityDetail);
        return cacheKey;
    }

    public List<AuditPrintVo> queryPrintInfoList(Map<String, String> map) {
        if (Objects.isNull(map)) {
            return null;
        }
        log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u6253\u5370:map-key:{},map-value{}", (Object)JsonUtils.obj2JsonString(map.keySet()), (Object)JsonUtils.obj2JsonString(map.values()));
        Map<String, List<String>> auditIdMap = this.changeArgument(map);
        ArrayList<AuditPrintVo> list = new ArrayList<AuditPrintVo>(map.size());
        for (String key : auditIdMap.keySet()) {
            Audit audit = (Audit)((Object)this.auditRepository.getById((Serializable)((Object)key)));
            Validate.notNull((Object)((Object)audit), (String)"ID\u3010%s\u3011\u7684\u6838\u9500\u6570\u636e\u672a\u5728\u7cfb\u7edf\u4e2d\u627e\u5230", (Object[])new Object[]{key});
            AuditDto auditDto = (AuditDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditDto.class, HashSet.class, ArrayList.class, new String[0]);
            IAudit iAudit = this.getAudit(auditDto);
            String auditCode = auditDto.getAuditCode();
            List<String> auditDetailCodes = auditIdMap.get(key);
            log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u6253\u53701 id:{},auditCode:{}", (Object)key, (Object)auditCode);
            List auditVos = iAudit.findPrintInfo(auditCode, auditDetailCodes);
            if (CollectionUtils.isEmpty((Collection)auditVos)) continue;
            for (AuditVo auditVo : auditVos) {
                log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u6253\u53702 id:{},auditCode:{}", (Object)key, (Object)auditVo.getAuditCode());
                AuditPrintVo auditPrintVo = this.dataConversion(auditVo);
                HashSet<String> set = new HashSet<String>(1);
                set.add(auditCode);
                this.getPaymentReceiptShould(set, auditPrintVo);
                auditPrintVo.setReference(auditCode);
                Date date = audit.getCreateTime();
                LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                int month = localDate.getMonthValue();
                auditPrintVo.setPeriod(String.valueOf(month));
                list.add(auditPrintVo);
            }
        }
        log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u6253\u5370\u8fd4\u56de\u7ed3\u679c:list:{}", (Object)JsonUtils.obj2JsonString(list));
        return list;
    }

    private Map<String, List<String>> changeArgument(Map<String, String> map) {
        LinkedHashMap<String, List<String>> auditIdMap = new LinkedHashMap<String, List<String>>();
        map.forEach((key, value) -> {
            String[] split = key.split("-");
            String s = split[1];
            ArrayList<String> ss = new ArrayList<String>();
            ss.add(s);
            auditIdMap.merge(split[0], ss, (o, n) -> {
                o.addAll(n);
                return o;
            });
        });
        log.info("\u7ed3\u6848\u6838\u9500\u6279\u91cf\u6253\u5370:auditIdMap-key:{},auditIdMap-value:{}", (Object)JsonUtils.obj2JsonString(auditIdMap.keySet()), (Object)JsonUtils.obj2JsonString(auditIdMap.values()));
        return auditIdMap;
    }

    private void getPaymentReceiptShould(Set<String> set, AuditPrintVo auditPrintVo) {
        List paymentReceiptShouldVos = this.paymentReceiptSdkService.findPaymentReceiptShouldByAuditCode(set);
        if (CollectionUtils.isNotEmpty((Collection)paymentReceiptShouldVos)) {
            auditPrintVo.setPaymentReceiptShouldVos((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)paymentReceiptShouldVos, PaymentReceiptShouldVo.class, PaymentReceiptShouldSdkVo.class, HashSet.class, ArrayList.class, new String[0]));
            Set paymentReceiptCodes = paymentReceiptShouldVos.stream().map(PaymentReceiptShouldVo::getPaymentReceiptCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            List receiptPayVos = this.paymentReceiptSdkService.findByPaymentReceiptCodes(paymentReceiptCodes);
            if (CollectionUtils.isNotEmpty((Collection)receiptPayVos)) {
                auditPrintVo.setReceiptPayVos((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)receiptPayVos, PaymentReceiptPayVo.class, PaymentReceiptPaySdkVo.class, HashSet.class, ArrayList.class, new String[0]));
            }
        }
    }

    public Page<AuditInvoiceVo> findAuditInfoData(Pageable pageable, QueryAuditInfoDto dto) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findAuditInfoData(pageable, dto);
    }

    public List<AuditInvoiceSdkVo> findAuditData(QueryAuditInfoDto dto) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findAuditData(dto);
    }

    public void createOrUpdateAutoConfiguration(AuditAutoConfigurationDto auditAutoConfiguration) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.createOrUpdateAutoConfiguration(auditAutoConfiguration);
    }

    public AuditAutoConfigurationVo getConfigurationById(String id) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.getConfigurationById(id);
    }

    public Page<AuditAutoConfigurationVo> findConfigurationPage(Pageable pageable, AuditAutoConfigurationDto configuration) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findConfigurationPage(pageable, configuration);
    }

    public List<AuditAutoConfigurationVo> findAutoConfigurationByDate(String autoAudit) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findAutoConfigurationByDate(autoAudit);
    }

    public void deleteConfiguration(String id) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.deleteConfiguration(id);
    }

    public String upAccountApportionOne(AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        try {
            thisAudit.upAccountApportionOne(dto);
        }
        catch (CustomerException e) {
            return "Y";
        }
        return "\u5206\u644a\u6210\u529f";
    }

    public AuditVo getAuditById(String auditId) {
        if (CharSequenceUtil.isEmpty((CharSequence)auditId)) {
            return null;
        }
        Audit audit = this.auditRepository.getAuditById(auditId);
        if (ObjectUtil.isNull((Object)((Object)audit))) {
            return null;
        }
        return (AuditVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)audit, AuditVo.class, null, null, new String[0]);
    }

    public void addProductCache(String cacheKey, String companyCode, String businessUnitCode, String id, AuditRedInvoiceProductDto dto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.addProductCache(cacheKey, companyCode, businessUnitCode, id, dto);
    }

    public void updateAppendices(AuditDto auditDto) {
        if (Objects.isNull(auditDto) || StringUtils.isBlank((CharSequence)auditDto.getAuditCode())) {
            return;
        }
        this.auditRepository.updateAppendices(auditDto);
        if (EndCaseTypeEnum.SUPPLIER.getCode().equals(auditDto.getEndCaseType())) {
            this.auditSupplierDetailRepository.updateAppendices(auditDto.getAuditCode(), auditDto.getAppendices());
        }
    }

    public void manualReturnBudget(AuditDto auditDto, boolean handReturn) {
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit thisAudit = this.getAudit(auditDto);
        thisAudit.manualReturnBudget(auditDto, handReturn);
    }

    public void createForOut(AuditOutDto audit) {
        IAudit thisAudit = this.getAudit((AuditDto)audit);
        try {
            thisAudit.createForOut(audit);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (!(e instanceof AuditTimestampException)) {
                this.deleteVerifyTimestamp((AuditDto)audit);
            }
            throw e;
        }
    }

    public AuditDto atomicAudit(AutoAuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AuditDto auditDto = (AuditDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditDto.class, null, null, new String[0]);
        auditDto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        log.info("\u81ea\u52a8\u7ed3\u6848\u4e3b\u8868\u4fe1\u606f:{}", (Object)JSONUtil.toJsonStr((Object)auditDto));
        if (CollectionUtils.isNotEmpty((Collection)dto.getAuditCustomerDetailList())) {
            log.info("\u81ea\u52a8\u7ed3\u6848\u660e\u7ec6\u6570\u91cf:{}", (Object)dto.getAuditCustomerDetailList().size());
            auditDto.setAuditCustomerDetailList(dto.getAuditCustomerDetailList());
        }
        IAudit thisAudit = this.getAudit(auditDto);
        return thisAudit.atomicAudit(auditDto);
    }

    public String updateCheckStatus(String auditCode, String checkStatus) {
        Validate.notBlank((CharSequence)auditCode, (String)"\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)checkStatus, (String)"\u68c0\u67e5\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        switch (checkStatus) {
            case "1": {
                checkStatus = CheckStatusEnum.PRELIMINARY_EXAMINATION.getCode();
                this.auditRepository.updateCheckStatusByCode(auditCode, checkStatus);
                break;
            }
            case "2": {
                checkStatus = CheckStatusEnum.FINAL_JUDGMENT.getCode();
                this.auditRepository.updateCheckStatusByCode(auditCode, checkStatus);
                break;
            }
            case "3": {
                checkStatus = CheckStatusEnum.UNEXAMINED.getCode();
                this.auditRepository.updateCheckStatusByCode(auditCode, checkStatus);
                break;
            }
        }
        return checkStatus;
    }

    public void batchRejectStatus(List<String> auditCodes) {
        if (CollectionUtils.isEmpty(auditCodes)) {
            return;
        }
        List<Audit> audits = this.auditRepository.findByAuditCodeList(auditCodes);
        ArrayList updateAudit = new ArrayList();
        audits.forEach(audit -> {
            Audit update = new Audit();
            update.setId(audit.getId());
            if (YesOrNoEnum.NO.getCode().equals(audit.getReject()) || StringUtils.isEmpty((CharSequence)audit.getReject())) {
                update.setReject(YesOrNoEnum.YES.getCode());
            } else if (YesOrNoEnum.YES.getCode().equals(audit.getReject())) {
                update.setReject(YesOrNoEnum.NO.getCode());
            }
            updateAudit.add(update);
        });
        this.auditRepository.updateBatchById(updateAudit);
    }

    public Page<AuditCustomerDetailCollectionVo> findDetailByConditions(Pageable pageable, AuditFindDetailDto dto) {
        IAudit iAudit = this.getAudit(null);
        return iAudit.findDetailByConditions(pageable, dto);
    }

    public List<AuditCustomerDetailVo> findDetailByListAuditCustomerDetailDto(List<AuditCustomerDetailDto> dtos, String processStatus, List<String> activityFormCodeList) {
        return this.auditCustomerDetailRepository.findDetailByListAuditCustomerDetailDto(dtos, processStatus, activityFormCodeList);
    }

    public Page<AuditDetailLookVo> auditDetailLook(Pageable pageable, AuditDetailLookDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditDetailLookDto();
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotEmpty((CharSequence)dto.getActivityFormCode()) && (dto.getActivityFormCode().contains(",") || dto.getActivityFormCode().contains(" "))) {
            dto.setActivityFormCodes(Arrays.asList(dto.getActivityFormCode().split("[, \uff0c]")));
            dto.setActivityFormCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getConstituentDetailPlanCode()) && (dto.getConstituentDetailPlanCode().contains(",") || dto.getConstituentDetailPlanCode().contains(" "))) {
            dto.setConstituentDetailPlanCodes(Arrays.asList(dto.getConstituentDetailPlanCode().split("[, \uff0c]")));
            dto.setConstituentDetailPlanCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getConstituentDetailPlanItemCode()) && (dto.getConstituentDetailPlanItemCode().contains(",") || dto.getConstituentDetailPlanItemCode().contains(" "))) {
            dto.setConstituentDetailPlanItemCodes(Arrays.asList(dto.getConstituentDetailPlanItemCode().split("[, \uff0c]")));
            dto.setConstituentDetailPlanItemCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getActivityType()) && (dto.getActivityType().contains(",") || dto.getActivityType().contains(" "))) {
            dto.setActivityTypes(Arrays.asList(dto.getActivityType().split("[, \uff0c]")));
            dto.setActivityType(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode()) && (dto.getCustomerCode().contains(",") || dto.getCustomerCode().contains(" "))) {
            dto.setCustomerCodes(Arrays.asList(dto.getCustomerCode().split("[, \uff0c]")));
            dto.setCustomerCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getTerminalCode()) && (dto.getTerminalCode().contains(",") || dto.getTerminalCode().contains(" "))) {
            dto.setTerminalCodes(Arrays.asList(dto.getTerminalCode().split("[, \uff0c]")));
            dto.setTerminalCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getAuditCode()) && (dto.getAuditCode().contains(",") || dto.getAuditCode().contains(" "))) {
            dto.setAuditCodes(Arrays.asList(dto.getAuditCode().split("[, \uff0c]")));
            dto.setAuditCode(null);
        }
        Page<AuditDetailLookVo> page = this.auditRepository.auditDetailLook(pageable, dto);
        stopWatch.stop();
        log.info("=====>    \u7ed3\u6848\u6838\u9500\u67e5\u770b\u4e3b\u8868\u8017\u65f6[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        List records = page.getRecords();
        stopWatch.start();
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            this.fillAuditDetailLookData(records);
        }
        stopWatch.stop();
        log.info("=====>    \u7ed3\u6848\u6838\u9500\u67e5\u770b\u660e\u7ec6\u8017\u65f6[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        return page;
    }

    private void fillAuditDetailLookData(List<AuditDetailLookVo> records) {
        if (CollectionUtil.isEmpty(records)) {
            return;
        }
        Set<String> codeSet = records.stream().filter(k -> StringUtil.isNotEmpty((String)k.getConstituentDetailPlanItemCode())).map(AuditDetailLookVo::getConstituentDetailPlanItemCode).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(codeSet)) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        List detailedForecastVos = this.detailedForecastService.findByPlanItemCodes(codeSet);
        stopWatch.stop();
        log.info("=====>    \u7ed3\u6848\u6838\u9500\u67e5\u770b\u660e\u7ec6\u7ec6\u6848\u9884\u6d4b\u8017\u65f6[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        stopWatch.start();
        List<AuditCustomerDetail> auditCustomerDetails = this.auditCustomerDetailRepository.findByActivityDetailCodeList(codeSet);
        List<String> auditCodes = auditCustomerDetails.stream().map(AuditCustomerDetail::getAuditCode).collect(Collectors.toList());
        Map<Object, Object> auditVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(auditCodes)) {
            List<AuditVo> auditVoList = this.auditRepository.findByCodes(auditCodes);
            auditVoMap = auditVoList.stream().filter(o -> ProcessStatusEnum.PASS.getDictCode().equals(o.getProcessStatus())).collect(Collectors.toMap(AuditVo::getAuditCode, Function.identity()));
        }
        stopWatch.stop();
        log.info("=====>    \u7ed3\u6848\u6838\u9500\u67e5\u770b\u6838\u9500\u5ba2\u6237\u660e\u7ec6\u8017\u65f6[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        stopWatch.start();
        List subComActivityDetailPlanVos = this.subComActivityDetailPlanVoService.findListByDetailCodes(codeSet);
        stopWatch.stop();
        log.info("=====>    \u7ed3\u6848\u6838\u9500\u67e5\u770b\u5206\u5b50\u6d3b\u52a8\u660e\u7ec6\u8017\u65f6[{}]    <=====", (Object)DateUtil.millisecondToStr((long)stopWatch.getLastTaskTimeMillis()));
        List subComActivityDesignBudgetVos = this.subComActivityDesignBudgetService.listByActivityDetailCodes(new ArrayList<String>(codeSet));
        Map<Object, Object> subComActivityDesignBudgetMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)subComActivityDesignBudgetVos)) {
            subComActivityDesignBudgetMap = subComActivityDesignBudgetVos.stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetVo::getActivityDesignDetailCode));
        }
        if (CollectionUtil.isEmpty((Collection)detailedForecastVos) && CollectionUtil.isEmpty(auditCustomerDetails)) {
            return;
        }
        if (detailedForecastVos == null) {
            detailedForecastVos = Collections.emptyList();
        }
        if (auditCustomerDetails == null) {
            auditCustomerDetails = Collections.emptyList();
        }
        if (subComActivityDetailPlanVos == null) {
            subComActivityDetailPlanVos = Collections.emptyList();
        }
        Map<Object, Object> finalAuditVoMap = auditVoMap;
        Map<String, List<AuditCustomerDetail>> auditCustomerDetailVoMap = auditCustomerDetails.stream().filter(o -> finalAuditVoMap.containsKey(o.getAuditCode())).collect(Collectors.groupingBy(AuditCustomerDetail::getActivityDetailCode));
        Map<String, DetailedForecastVo> detailedForecastVoMap = detailedForecastVos.stream().collect(Collectors.toMap(DetailedForecastVo::getActivityDetailItemCode, v -> v, (newValue, oldValue) -> newValue));
        Map<String, SubComActivityDetailPlanVo> subComActivityDetailPlanVoMap = subComActivityDetailPlanVos.stream().collect(Collectors.toMap(SubComActivityDetailPlanVo::getConstituentDetailPlanCode, v -> v, (newValue, oldValue) -> newValue));
        Map<Object, Object> finalSubComActivityDesignBudgetMap = subComActivityDesignBudgetMap;
        records.forEach(record -> {
            List subComActivityDesignBudgetVos1;
            List customerDetailList;
            DetailedForecastVo detailedForecastVo;
            SubComActivityDetailPlanVo planVo = (SubComActivityDetailPlanVo)subComActivityDetailPlanVoMap.get(record.getConstituentDetailPlanItemCode());
            if (planVo != null) {
                record.setOrgCode(planVo.getOrgCode());
                record.setOrgName(planVo.getOrgName());
            }
            if ((detailedForecastVo = (DetailedForecastVo)detailedForecastVoMap.get(record.getConstituentDetailPlanItemCode())) != null) {
                record.setEstimatedWriteOffAmount(detailedForecastVo.getEstimatedWriteOffAmount());
                record.setAuditConditionValue(detailedForecastVo.getWriteOffConditionValue());
            }
            if (CollectionUtils.isNotEmpty((Collection)(customerDetailList = (List)auditCustomerDetailVoMap.get(record.getConstituentDetailPlanItemCode())))) {
                AuditCustomerDetail auditCustomerDetail = (AuditCustomerDetail)((Object)((Object)customerDetailList.get(0)));
                AuditVo auditVo = (AuditVo)finalAuditVoMap.get(auditCustomerDetail.getAuditCode());
                record.setDiscountAmount(customerDetailList.stream().map(AuditCustomerDetail::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                Set endCaseFormList = customerDetailList.stream().flatMap(o -> Arrays.stream(o.getEndCaseForm().split(","))).collect(Collectors.toSet());
                record.setEndCaseForm(EndCaseFormEnum.codeTransitionStr((String)String.join((CharSequence)",", endCaseFormList)));
                record.setExecutedAmount(auditCustomerDetail.getExecutedAmount());
                record.setExecutedQuantity(auditCustomerDetail.getExecutedQuantity());
                record.setReimburseTaxAmount(customerDetailList.stream().map(AuditCustomerDetail::getReimburseTaxAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                record.setAuditName(auditVo.getAuditName());
                record.setAuditCode(auditVo.getAuditCode());
            }
            if (CollectionUtils.isNotEmpty((Collection)(subComActivityDesignBudgetVos1 = (List)finalSubComActivityDesignBudgetMap.get(record.getConstituentDetailPlanItemCode())))) {
                List autoFeeList;
                List offPointFeeList;
                List internalPointFeeList = subComActivityDesignBudgetVos1.stream().filter(o -> FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(internalPointFeeList)) {
                    record.setInPointBudget(((SubComActivityDesignBudgetVo)internalPointFeeList.get(0)).getBudgetAmount().toPlainString());
                    record.setInPointBudgetItems(((SubComActivityDesignBudgetVo)internalPointFeeList.get(0)).getBudgetItemCode());
                }
                if (CollectionUtils.isNotEmpty(offPointFeeList = subComActivityDesignBudgetVos1.stream().filter(o -> FeeSourceEnum.OFF_POINT_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList()))) {
                    record.setOffPointBudget(((SubComActivityDesignBudgetVo)offPointFeeList.get(0)).getBudgetAmount().toPlainString());
                    record.setOffPointBudgetItems(((SubComActivityDesignBudgetVo)offPointFeeList.get(0)).getBudgetItemCode());
                }
                if (CollectionUtils.isNotEmpty(autoFeeList = subComActivityDesignBudgetVos1.stream().filter(o -> FeeSourceEnum.AUTO_FEE.getCode().equals(o.getFeeSourceCode())).collect(Collectors.toList()))) {
                    record.setSelfInvestmentBudget(((SubComActivityDesignBudgetVo)autoFeeList.get(0)).getBudgetAmount().toPlainString());
                    record.setSelfInvestedBudgetItems(((SubComActivityDesignBudgetVo)autoFeeList.get(0)).getBudgetItemCode());
                }
            }
        });
    }

    public void updateAuditStatusForActivityDetailPlan(AuditDto auditDto) {
        List<AuditCustomerDetail> auditCustomerDetails;
        if (Objects.isNull(auditDto)) {
            return;
        }
        if ((BusinessUnitEnum.HEADQUARTERS.getCode().equals(auditDto.getBusinessUnitCode()) || BusinessUnitEnum.VERTICAL.getCode().equals(auditDto.getBusinessUnitCode())) && CollectionUtils.isNotEmpty(auditCustomerDetails = this.auditCustomerDetailRepository.findByAuditCode(auditDto.getAuditCode()))) {
            List activityDetailCodes = auditCustomerDetails.stream().map(AuditCustomerDetail::getActivityDetailCode).collect(Collectors.toList());
            this.activityDetailPlanItemSdkService.updateAuditStatusByActivityDetailCodes(activityDetailCodes, null, ProcessStatusEnum.REJECT);
        }
    }

    public Page<AuditCustomerDetailCollectionVo> auditReport(Pageable pageable, AuditCustomerDetailCollectionDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditCustomerDetailCollectionDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        if (StringUtils.isNotEmpty((CharSequence)dto.getActivityDetailCode()) && (dto.getActivityDetailCode().contains(",") || dto.getActivityDetailCode().contains(" "))) {
            dto.setActivityDetailCodeList(Arrays.asList(dto.getActivityDetailCode().split("[, \uff0c]")));
            dto.setActivityDetailCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getAuditCode()) && (dto.getAuditCode().contains(",") || dto.getAuditCode().contains(" "))) {
            dto.setAuditCodeList(Arrays.asList(dto.getAuditCode().split("[, \uff0c]")));
            dto.setAuditCode(null);
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getAuditDetailCode()) && (dto.getAuditDetailCode().contains(",") || dto.getAuditDetailCode().contains(" "))) {
            dto.setAuditDetailCodeList(Arrays.asList(dto.getAuditDetailCode().split("[, \uff0c]")));
            dto.setAuditDetailCode(null);
        }
        Page<AuditCustomerDetailCollectionVo> page = this.auditRepository.auditReport(pageable, dto);
        List records = page.getRecords();
        this.fillAuditReport(records);
        return page;
    }

    private void fillAuditReport(List<AuditCustomerDetailCollectionVo> records) {
        List activityDetailPlanVoList;
        if (CollectionUtil.isEmpty(records)) {
            return;
        }
        HashMap activityDetailPlanVoMap = Maps.newHashMap();
        List activityCodes = records.stream().map(AuditCustomerDetailCollectionVo::getActivityCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(activityCodes) && CollectionUtils.isNotEmpty((Collection)(activityDetailPlanVoList = this.activityDetailPlanSdkService.findByCodes(activityCodes)))) {
            activityDetailPlanVoMap.putAll(activityDetailPlanVoList.stream().collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, Function.identity(), (o, n) -> o)));
        }
        List<String> auditDetailCodes = records.stream().map(AuditCustomerDetailCollectionVo::getAuditDetailCode).collect(Collectors.toList());
        Map<Object, Object> auditCustomerDetailCollectionExtendMap = new HashMap();
        if (CollectionUtils.isNotEmpty(auditDetailCodes)) {
            List<AuditCustomerDetailCollectionExtend> detailCollectionExtends = this.auditCustomerDetailCollectionExtendRepository.findByAuditDetailCodes(auditDetailCodes);
            auditCustomerDetailCollectionExtendMap = detailCollectionExtends.stream().collect(Collectors.toMap(AuditCustomerDetailCollectionExtend::getAuditDetailCode, Function.identity()));
        }
        Map auditFormMap = this.dictToolkitService.findMapByDictTypeCode("tpm_audit_form");
        for (AuditCustomerDetailCollectionVo record : records) {
            ActivityDetailPlanVo activityDetailPlanVo;
            AuditCustomerDetailCollectionExtend auditCustomerDetailCollectionExtend = (AuditCustomerDetailCollectionExtend)((Object)auditCustomerDetailCollectionExtendMap.get(record.getAuditDetailCode()));
            if (auditCustomerDetailCollectionExtend != null) {
                record.setRedOrderOffsetNo(auditCustomerDetailCollectionExtend.getRedOrderOffsetNo());
            }
            if ((activityDetailPlanVo = (ActivityDetailPlanVo)activityDetailPlanVoMap.get(record.getActivityCode())) != null) {
                record.setDepartmentCode(activityDetailPlanVo.getDepartmentCode());
                record.setDepartmentName(activityDetailPlanVo.getDepartmentName());
            }
            if (!StringUtils.isNotEmpty((CharSequence)record.getEndCaseForm()) || !CollectionUtil.isNotEmpty((Map)auditFormMap)) continue;
            List nameList = Arrays.stream(record.getEndCaseForm().split(",")).filter(StringUtil::isNotEmpty).map(auditFormMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtil.isNotEmpty(nameList)) continue;
            record.setEndCaseForm(String.join((CharSequence)",", nameList));
        }
    }

    public void manualReturnBudgetWriteBackActivityStatus(String auditCode) {
        Validate.notBlank((CharSequence)auditCode, (String)"\u6838\u9500\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ProcessStatusDto processStatusDto = new ProcessStatusDto();
        processStatusDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        processStatusDto.setBusinessNoList(Collections.singletonList(auditCode));
        this.auditProcess.auditProcessComplete(processStatusDto, true);
    }

    public MobileAuditApprovedInfo2Vo mobileAuditApprovedInfo2(String processNo) {
        MobileAuditApprovedInfo2Vo mobileAuditApprovedVo = new MobileAuditApprovedInfo2Vo();
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return mobileAuditApprovedVo;
        }
        List<AuditCustomerDetailVo> auditCustomerDetailVoList = this.auditCustomerDetailRepository.findByProcessNo(processNo);
        if (CollectionUtils.isEmpty(auditCustomerDetailVoList)) {
            return mobileAuditApprovedVo;
        }
        MobileAuditApprovedInfo2Vo info2 = new MobileAuditApprovedInfo2Vo();
        for (AuditCustomerDetailVo auditCustomerDetailVo : auditCustomerDetailVoList) {
            info2.setTotalApplyAmount(info2.getTotalApplyAmount().add(Optional.ofNullable(auditCustomerDetailVo.getApplyAmount()).orElse(BigDecimal.ZERO)));
            info2.setTotalAuditAmount(info2.getTotalAuditAmount().add(Optional.ofNullable(auditCustomerDetailVo.getAuditAmount()).orElse(BigDecimal.ZERO)));
            info2.setTotalAlreadyAuditAmount(info2.getTotalAlreadyAuditAmount().add(Optional.ofNullable(auditCustomerDetailVo.getAlreadyAuditAmount()).orElse(BigDecimal.ZERO)));
            info2.setTotalThisAuditAmount(info2.getTotalThisAuditAmount().add(Optional.ofNullable(auditCustomerDetailVo.getThisAuditAmount()).orElse(BigDecimal.ZERO)));
        }
        return info2;
    }

    public Page<MobileAuditApprovedInfo1Vo> mobileAuditApprovedInfo1(Pageable pageable, AuditDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        String processNo = dto.getProcessNo();
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return page;
        }
        List<AuditCustomerDetailVo> auditCustomerDetailVoList = this.auditCustomerDetailRepository.findByProcessNo(processNo);
        if (CollectionUtils.isEmpty(auditCustomerDetailVoList)) {
            return page;
        }
        List customerDetailVos = auditCustomerDetailVoList.stream().filter(o -> CustomerSupplierTypeEnum.CUSTOMER.getValue().equals(o.getCustomerSupplierType())).filter(o -> StringUtils.isNotEmpty((CharSequence)o.getCustomerCode())).collect(Collectors.toList());
        List supplierDetailVos = auditCustomerDetailVoList.stream().filter(o -> CustomerSupplierTypeEnum.SUPPLIER.getValue().equals(o.getCustomerSupplierType())).filter(o -> StringUtils.isNotEmpty((CharSequence)o.getSupplierCode())).collect(Collectors.toList());
        Map<Object, Object> customerDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(customerDetailVos)) {
            customerDetailMap = customerDetailVos.stream().collect(Collectors.groupingBy(o -> o.getCustomerCode() + (Objects.nonNull(o.getFeeYearMonth()) ? o.getFeeYearMonth().toString() : "") + o.getActivityTypeCode() + o.getActivityFormCode()));
        }
        Map<Object, Object> supplierDetailMap = new HashMap();
        if (CollectionUtils.isNotEmpty(supplierDetailVos)) {
            supplierDetailMap = supplierDetailVos.stream().collect(Collectors.groupingBy(o -> o.getSupplierCode() + (Objects.nonNull(o.getFeeYearMonth()) ? o.getFeeYearMonth().toString() : "") + o.getActivityTypeCode() + o.getActivityFormCode()));
        }
        ArrayList pageList = new ArrayList();
        BigDecimal decimal = BigDecimal.valueOf(100L);
        customerDetailMap.forEach((key, value) -> {
            AuditCustomerDetailVo auditCustomerDetailVo = (AuditCustomerDetailVo)value.get(0);
            MobileAuditApprovedInfo1Vo info1 = new MobileAuditApprovedInfo1Vo();
            info1.setFeeYearMonth(auditCustomerDetailVo.getFeeYearMonth());
            info1.setCustomerCode(auditCustomerDetailVo.getCustomerCode());
            info1.setCustomerName(auditCustomerDetailVo.getCustomerName());
            info1.setActivityTypeCode(auditCustomerDetailVo.getActivityTypeCode());
            info1.setActivityTypeName(auditCustomerDetailVo.getActivityTypeName());
            info1.setActivityFormCode(auditCustomerDetailVo.getActivityFormCode());
            info1.setActivityFormName(auditCustomerDetailVo.getActivityFormName());
            info1.setApplyAmount(value.stream().map(AuditCustomerDetailVo::getApplyAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            info1.setAuditAmount(value.stream().map(AuditCustomerDetailVo::getAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            info1.setAlreadyAuditAmount(value.stream().map(AuditCustomerDetailVo::getAlreadyAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            info1.setThisAuditAmount(value.stream().map(AuditCustomerDetailVo::getThisAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            if (BigDecimal.ZERO.compareTo(info1.getApplyAmount()) != 0) {
                info1.setAddUpAuditRatio(info1.getThisAuditAmount().add(info1.getAlreadyAuditAmount()).divide(info1.getApplyAmount(), 6, RoundingMode.HALF_UP));
                info1.setAddUpAuditRatioDesc(info1.getAddUpAuditRatio().multiply(decimal).setScale(2, 4).toString() + "%");
            }
            pageList.add(info1);
        });
        supplierDetailMap.forEach((key, value) -> {
            AuditCustomerDetailVo auditCustomerDetailVo = (AuditCustomerDetailVo)value.get(0);
            MobileAuditApprovedInfo1Vo info1 = new MobileAuditApprovedInfo1Vo();
            info1.setFeeYearMonth(auditCustomerDetailVo.getFeeYearMonth());
            info1.setSupplierCode(auditCustomerDetailVo.getSupplierCode());
            info1.setSupplierName(auditCustomerDetailVo.getSupplierName());
            info1.setActivityTypeCode(auditCustomerDetailVo.getActivityTypeCode());
            info1.setActivityTypeName(auditCustomerDetailVo.getActivityTypeName());
            info1.setActivityFormCode(auditCustomerDetailVo.getActivityFormCode());
            info1.setActivityFormName(auditCustomerDetailVo.getActivityFormName());
            info1.setApplyAmount(value.stream().map(AuditCustomerDetailVo::getApplyAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            info1.setAuditAmount(value.stream().map(AuditCustomerDetailVo::getAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            info1.setAlreadyAuditAmount(value.stream().map(AuditCustomerDetailVo::getAlreadyAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            info1.setThisAuditAmount(value.stream().map(AuditCustomerDetailVo::getThisAuditAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            if (BigDecimal.ZERO.compareTo(info1.getApplyAmount()) != 0) {
                info1.setAddUpAuditRatio(info1.getThisAuditAmount().add(info1.getAlreadyAuditAmount()).divide(info1.getApplyAmount(), 6, RoundingMode.HALF_UP));
                info1.setAddUpAuditRatioDesc(info1.getAddUpAuditRatio().multiply(decimal).setScale(2, 4).toString() + "%");
            }
            pageList.add(info1);
        });
        page.setTotal((long)pageList.size());
        page.setRecords(pageList.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList()));
        return page;
    }

    public Integer queryAppendices(String cacheKey, String endCaseType) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.queryAppendices(cacheKey, endCaseType);
    }

    public void reimburseNotAlreadyReimburseAmount() {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.reimburseNotAlreadyReimburseAmount();
    }

    public void updateAutoAuditLock() {
        this.auditRepository.updateAutoAuditLock();
    }

    public List<String> getAuditByLock() {
        return this.auditRepository.getAuditByLock();
    }

    public void updatePassByAuditCodes(List<String> auditCodes) {
        if (CollectionUtils.isEmpty(auditCodes)) {
            return;
        }
        this.auditRepository.updatePassByAuditCodes(auditCodes);
    }

    public void updateProcessStatusByAuditCodeList2(AuditDto auditDto, List<String> auditCodeList) {
        if (CollectionUtils.isEmpty(auditCodeList)) {
            return;
        }
        this.auditRepository.updateProcessStatusByAuditCodeList2(auditDto, auditCodeList);
    }

    public String redInvoiceUpAccount(List<String> auditCodes) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.redInvoiceUpAccount(auditCodes);
    }

    public Page<AuditManageOneProductFeeVo> findPageItemForManageOneProductFee(Pageable pageable, List<String> yearList, String companyCode, String productCode) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditRepository.findPageItemForManageOneProductFee((Page<AuditManageOneProductFeeVo>)page, yearList, companyCode, productCode);
    }

    public Page<AuditManageActivityTypeFeeVo> findPageItemForManageActivityTypeFee(Pageable pageable, List<String> yearList) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditRepository.findPageItemForManageActivityTypeFee((Page<AuditManageActivityTypeFeeVo>)page, yearList);
    }

    public Page<AuditManageChannelFeeVo> findPageItemForManageChannelFee(Pageable pageable, List<String> yearList) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.auditRepository.findPageItemForManageChannelFee((Page<AuditManageChannelFeeVo>)page, yearList);
    }

    public void supplierMaterialSaveCacheAuditInfo(AuditDto dto) {
        IAudit iAudit = this.getAudit(dto);
        iAudit.supplierMaterialSaveCacheAuditInfo(dto);
    }

    public List<AuditSupplierMaterialFileVo> supplierMaterialFindCacheAuditInfo(AuditDto dto) {
        IAudit iAudit = this.getAudit(dto);
        return iAudit.supplierMaterialFindCacheAuditInfo(dto);
    }

    public List<String> findCacheMaterialPurchaseCode(AuditDto dto) {
        IAudit iAudit = this.getAudit(dto);
        return iAudit.findCacheMaterialPurchaseCode(dto);
    }

    public Page<AuditSupplierDetailVo> supplierAuditReport(Pageable pageable, AuditSupplierDetailDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditSupplierDetailDto();
        }
        Page<AuditSupplierDetailVo> page = this.auditRepository.supplierAuditReport(pageable, dto);
        return page;
    }

    public void redInvoiceOffset(List<String> auditCodes) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.redInvoiceOffset(auditCodes);
    }

    public void copyInvoiceCache(String fromCacheKey, String toCacheKey) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.copyInvoiceCache(fromCacheKey, toCacheKey);
    }

    public String batchExpensePoolVerify(List<String> auditCodes) {
        AuditDto dto = new AuditDto();
        dto.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        IAudit iAudit = this.getAudit(dto);
        return iAudit.batchExpensePoolVerify(auditCodes);
    }

    public Page<AuditVo> findPageForOut(Pageable pageable, AuditDto dto) {
        return this.auditRepository.findPageForOut(pageable, dto);
    }

    public void updateRejectByAuditCodes(List<String> rejectCodes) {
        if (CollectionUtils.isNotEmpty(rejectCodes)) {
            this.auditRepository.updateRejectByAuditCodes(rejectCodes);
        }
    }

    public AuditSubmitAmountVo findSubmitAmount(AuditBatchSubmitQueryDto audit) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findSubmitAmount(audit);
    }

    public String batchSubmitApprovalWarning(AuditDto dto) {
        List auditCodes = dto.getAuditCodes();
        if (CollectionUtils.isNotEmpty((Collection)auditCodes)) {
            auditCodes = auditCodes.stream().distinct().collect(Collectors.toList());
            dto.setAuditCodes(auditCodes);
        }
        IAudit audit = this.getAudit(dto);
        return audit.batchSubmitApprovalWarning(dto);
    }

    public Page<AuditProductUpAccountVo> tpmAuditUpAccount(Pageable pageable, AuditProductUpAccountDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AuditProductUpAccountDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page<AuditProductUpAccountVo> page = this.auditRepository.tpmAuditUpAccount(pageable, dto);
        List result = page.getRecords();
        if (CollectionUtil.isEmpty((Collection)result)) {
            return page;
        }
        List<String> codeList = result.stream().filter(k -> StringUtil.isNotEmpty((String)k.getAuditDetailCode())).map(AuditProductUpAccountVo::getActivityDetailCode).distinct().collect(Collectors.toList());
        if (CollectionUtil.isEmpty(codeList)) {
            return page;
        }
        List<AuditCustomerDetailCollection> auditCustomerDetailCollectionList = this.auditCustomerDetailCollectionRepository.findByCodes(codeList);
        if (CollectionUtil.isEmpty(auditCustomerDetailCollectionList)) {
            return page;
        }
        Map<String, AuditCustomerDetailCollection> detailCollectionMap = auditCustomerDetailCollectionList.stream().filter(k -> StringUtil.isNotEmpty((String)k.getAuditDetailCode())).collect(Collectors.toMap(AuditCustomerDetailCollection::getAuditDetailCode, v -> v, (newValue, oldValue) -> newValue));
        if (CollectionUtil.isEmpty(detailCollectionMap)) {
            return page;
        }
        result.stream().filter(k -> StringUtil.isNotEmpty((String)k.getAuditDetailCode())).filter(k -> Objects.nonNull(detailCollectionMap.get(k.getAuditDetailCode()))).forEach(item -> {
            AuditCustomerDetailCollection detailCollection = (AuditCustomerDetailCollection)((Object)((Object)detailCollectionMap.get(item.getAuditDetailCode())));
            item.setUpAccountStatus(item.getDiscountAccountStatus());
        });
        page.setRecords(result);
        return page;
    }

    public List<AuditCustomerDetailVo> findListByDetailPlanCodes(List<String> detailPlanCodes) {
        if (CollectionUtils.isEmpty(detailPlanCodes)) {
            return org.apache.commons.compress.utils.Lists.newArrayList();
        }
        return this.auditCustomerDetailRepository.findListByDetailPlanCodes(detailPlanCodes);
    }

    public List<String> findProcessDateByActivityDetailCodes(String detailPlanItemCode) {
        if (StringUtils.isEmpty((CharSequence)detailPlanItemCode)) {
            List<String> list = this.auditCustomerDetailRepository.findProcessDateByActivityDetailCodes(detailPlanItemCode);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String discountUpAccount(String auditCode) {
        IAudit thisAudit = this.getAudit(null);
        String key = "audit:discount_up_account:" + auditCode;
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock(key, TimeUnit.SECONDS, 30L);
            Validate.isTrue((boolean)lockSuccess, (String)"\u6838\u9500\u7f16\u7801\u3010%s\u3011\u5df2\u7ecf\u5728\u4e0a\u8d26\u4e0a\u8d26\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5", (Object[])new Object[]{auditCode});
            String string = thisAudit.discountUpAccount(auditCode);
            return string;
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock(key);
            }
        }
    }

    public Page<AuditVo> findBatchSubmit(Pageable pageable, AuditBatchSubmitQueryDto audit) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findBatchSubmit(pageable, audit);
    }

    public Page<AuditCustomerDetailVo> findBatchDetailSubmit(Pageable pageable, AuditBatchSubmitQueryDto audit) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findBatchDetailSubmit(pageable, audit);
    }

    public Page<AuditCustomerDetailVo> findAuditDetailGroupSubmit(Pageable pageable, AuditBatchSubmitQueryDto audit) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.findAuditDetailGroupSubmit(pageable, audit);
    }

    public List<AuditCustomerDetailCollectionVo> findDetailByAuditCode(String auditCode) {
        if (StringUtils.isBlank((CharSequence)auditCode)) {
            return null;
        }
        List<AuditCustomerDetailCollection> detailCollections = this.auditCustomerDetailCollectionRepository.findDetailByAuditCode(auditCode);
        if (CollectionUtils.isEmpty(detailCollections)) {
            return null;
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailCollections, AuditCustomerDetailCollection.class, AuditCustomerDetailCollectionVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public String expensePoolVerify(AuditDto auditDto) {
        IAudit thisAudit = this.getAudit(auditDto);
        return thisAudit.expensePoolVerify(auditDto);
    }

    public List<PreEndResultRequestEntityVo> selectUnSynchronizexdAll() {
        return this.auditRepository.selectUnSynchronizexdAll();
    }

    public String splitAuditCustomerDetail(SplitAuditCustomerDetailDto dto, FacturerUserDetails userIdentity) {
        CompletableFuture.runAsync(() -> {
            UrlAddressVo mdmUser = new UrlAddressVo();
            mdmUser.setUserName(userIdentity.getAccount());
            mdmUser.setFullName(userIdentity.getRealName());
            this.loginUserService.refreshAuthentication((Object)mdmUser);
            AbstractCrmUserIdentity identity = this.loginUserService.getAbstractLoginUser();
            String account = null;
            if (!Objects.isNull(identity)) {
                account = identity.getAccount();
            }
            SplitAuditCustomerDetailMsgVo msgVo = new SplitAuditCustomerDetailMsgVo();
            msgVo.setAccount(account);
            try {
                List splitVoList2;
                Thread.sleep(2000L);
                AuditVo auditVo = dto.getAuditVo();
                List auditCustomerDetailVoList = auditVo.getAuditCustomerDetailList();
                List targetCustomerList = dto.getTargetCustomerList();
                if (CollectionUtils.isEmpty((Collection)auditCustomerDetailVoList)) {
                    throw new UnsupportedOperationException("\u9700\u8981\u62c6\u5206\u7684\u6838\u9500\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (CollectionUtils.isEmpty((Collection)targetCustomerList)) {
                    throw new UnsupportedOperationException("\u62c6\u5206\u7684\u76ee\u6807\u5ba2\u6237\u4e0d\u80fd\u4e3a\u7a7a");
                }
                ArrayList customerList = new ArrayList();
                HashMap customerMap = new HashMap();
                targetCustomerList.forEach(v -> {
                    customerList.add(v.getCustomerCode());
                    customerMap.put(v.getCustomerCode(), v.getCustomerName());
                });
                ArrayList splitVoList = new ArrayList();
                for (AuditCustomerDetailVo auditCustomerDetailVo : auditCustomerDetailVoList) {
                    Set productCodeSet;
                    msgVo.setCheckType(AuditMsgCheckTypeEnum.PROCESSING.getCode());
                    msgVo.setRemark("\u5f00\u59cb\u5bf9\u3010" + auditCustomerDetailVo.getActivityDetailCode() + "\u3011\u8fdb\u884c\u5ba2\u6237\u62c6\u5206......");
                    this.auditMsgService.sendProcessMsg(msgVo);
                    if (!"DS038".equals(auditCustomerDetailVo.getActivityFormCode())) {
                        Ce1MnjtSearchDto ce1SearchDto = new Ce1MnjtSearchDto();
                        ce1SearchDto.setCustomerCodeList(customerList);
                        ce1SearchDto.setStartDate(DateUtil.format((Date)auditCustomerDetailVo.getActivityBeginTime(), (String)"yyyyMMdd"));
                        ce1SearchDto.setEndDate(DateUtil.format((Date)auditCustomerDetailVo.getActivityEndTime(), (String)"yyyyMMdd"));
                        List ce1MnjtVos = this.ce1MnjtService.findProductListByCustomerGroup(ce1SearchDto);
                        if (!CollectionUtils.isNotEmpty((Collection)ce1MnjtVos)) continue;
                        HashSet productCodeSet2 = Sets.newHashSet();
                        for (Ce1MnjtFullVo2 fullVo2 : ce1MnjtVos) {
                            if (!StringUtils.isNotEmpty((CharSequence)fullVo2.getProductCode())) continue;
                            productCodeSet2.add(fullVo2.getProductCode());
                        }
                        List productVos = this.productVoService.findByCodes(new ArrayList(productCodeSet2));
                        Map productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
                        Map<String, List<Ce1MnjtFullVo2>> ce1MnjtVoMap = ce1MnjtVos.stream().collect(Collectors.groupingBy(Ce1MnjtFullVo2::getCustomerCode));
                        ce1MnjtVoMap.forEach((customerCode, ce1List) -> {
                            for (Ce1MnjtFullVo2 ce1 : ce1List) {
                                AuditCustomerDetailVo splitVo = (AuditCustomerDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCustomerDetailVo, AuditCustomerDetailVo.class, null, null, new String[0]);
                                splitVo.setEndCaseCustomerCode(customerCode);
                                splitVo.setEndCaseCustomerName((String)customerMap.get(customerCode));
                                splitVo.setProductCode(ce1.getProductCode());
                                ProductVo productVo = (ProductVo)productMap.get(ce1.getProductCode());
                                if (productVo == null) {
                                    throw new UnsupportedOperationException("\u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u4ea7\u54c1:" + ce1.getProductCode() + ",\u672a\u5728\u4e3b\u6570\u636e\u83b7\u53d6\u5230\u4ea7\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
                                }
                                splitVo.setProductName(productVo.getProductName());
                                splitVoList.add(splitVo);
                            }
                        });
                        continue;
                    }
                    if (!CollectionUtils.isNotEmpty(customerList)) continue;
                    int size = customerList.size();
                    HashMap<String, String> cusMap = new HashMap<String, String>(size);
                    ArrayList<String> list = new ArrayList<String>(size);
                    for (String oldCustomerCode : customerList) {
                        String newCustomerCode = oldCustomerCode.substring(0, 10);
                        list.add(newCustomerCode);
                        cusMap.put(newCustomerCode, oldCustomerCode);
                    }
                    TpmDistributionCustomerAuditDataDto customerAuditDataDto = new TpmDistributionCustomerAuditDataDto();
                    customerAuditDataDto.setCustomerCodeList(list);
                    customerAuditDataDto.setTenantCode(TenantUtils.getTenantCode());
                    customerAuditDataDto.setDistributionCustomerAuditYearMonth(DateUtil.format((Date)auditCustomerDetailVo.getActivityBeginTime(), (String)"yyyy-MM"));
                    List customerAuditDataRespVos = this.tpmDistributionCustomerAuditDataService.findProductListByConditions(customerAuditDataDto);
                    if (!CollectionUtils.isNotEmpty((Collection)customerAuditDataRespVos) || !CollectionUtils.isNotEmpty(productCodeSet = customerAuditDataRespVos.stream().map(TpmDistributionCustomerAuditDataRespVo::getProductCode).filter(StringUtils::isNotBlank).collect(Collectors.toSet()))) continue;
                    List productVos = this.productVoService.findByCodes(new ArrayList(productCodeSet));
                    Map productMap = productVos.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
                    Map<String, List<TpmDistributionCustomerAuditDataRespVo>> ce1MnjtVoMap = customerAuditDataRespVos.stream().collect(Collectors.groupingBy(TpmDistributionCustomerAuditDataRespVo::getCustomerCode));
                    ce1MnjtVoMap.forEach((customerCode, ce1List) -> {
                        for (TpmDistributionCustomerAuditDataRespVo ce1 : ce1List) {
                            AuditCustomerDetailVo splitVo = (AuditCustomerDetailVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditCustomerDetailVo, AuditCustomerDetailVo.class, null, null, new String[0]);
                            String cus = (String)cusMap.get(customerCode);
                            splitVo.setEndCaseCustomerCode(cus);
                            splitVo.setEndCaseCustomerName((String)customerMap.get(cus));
                            splitVo.setProductCode(ce1.getProductCode());
                            ProductVo productVo = (ProductVo)productMap.get(ce1.getProductCode());
                            if (productVo == null) {
                                throw new UnsupportedOperationException("\u7535\u5546\u65e5\u9500\u552e\u62a5\u8868\u4ea7\u54c1:" + ce1.getProductCode() + ",\u672a\u5728\u4e3b\u6570\u636e\u83b7\u53d6\u5230\u4ea7\u54c1\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01");
                            }
                            splitVo.setProductName(productVo.getProductName());
                            splitVoList.add(splitVo);
                        }
                    });
                }
                List customerVoList = this.customerVoService.findBaseByCustomerCodes(customerList);
                Map<String, CustomerVo> customerVoMap = customerVoList.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, Function.identity()));
                Set activityDetailCodes = splitVoList.stream().map(AuditCustomerDetailVo::getActivityDetailCode).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(activityDetailCodes)) {
                    List generalExpensesVoList = this.promotionPlanService.findByDetailCodes(activityDetailCodes);
                    List salesOrgCodes = generalExpensesVoList.stream().map(GeneralExpensesVo::getSalesOrgCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
                    ArrayList salesOrgVoList = new ArrayList();
                    if (CollectionUtils.isNotEmpty(salesOrgCodes)) {
                        Lists.partition(salesOrgCodes, (int)200).forEach(codes -> {
                            List list = this.salesOrgVoService.findAllParentBySalesOrgCodes(salesOrgCodes);
                            if (CollectionUtils.isNotEmpty((Collection)list)) {
                                salesOrgVoList.addAll(list);
                            }
                        });
                    }
                    HashMap<String, SalesOrgVo> salesOrgVoMap = new HashMap();
                    if (CollectionUtils.isNotEmpty(salesOrgVoList)) {
                        salesOrgVoMap = salesOrgVoList.stream().collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, Function.identity()));
                    }
                    Map generalExpensesVoMap = generalExpensesVoList.stream().collect(Collectors.toMap(ExpensesVo::getExpensesCode, Function.identity()));
                    for (AuditCustomerDetailVo auditCustomerDetailVo : splitVoList) {
                        GeneralExpensesVo generalExpensesVo = (GeneralExpensesVo)generalExpensesVoMap.get(auditCustomerDetailVo.getActivityDetailCode());
                        if (TpmAuditTypeEnum.AUDITTYPE3.getCode().equals(generalExpensesVo.getAuditConditionType())) {
                            auditCustomerDetailVo.setAuditAmount(auditCustomerDetailVo.getApplyAmount());
                        } else {
                            auditCustomerDetailVo.setAuditAmount(this.buildUnit4Param(auditVo, auditCustomerDetailVo, generalExpensesVo, customerVoMap, salesOrgVoMap));
                        }
                        auditCustomerDetailVo.setId(null);
                    }
                }
                if (CollectionUtils.isNotEmpty(splitVoList2 = splitVoList.stream().filter(o -> Objects.nonNull(o.getAuditAmount())).filter(o -> o.getAuditAmount().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList()))) {
                    List activityDetailDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(splitVoList2, AuditCustomerDetailVo.class, ActivityDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    List<AuditEcAlreadyEndCaseAmountVo> auditEcAlreadyEndCaseAmountVos = this.auditEcAlreadyEndCaseAmountRepository.findListByCondition(activityDetailDtos);
                    Map<Object, Object> auditEcAlreadyEndCaseAmountVoMap = new HashMap();
                    if (CollectionUtils.isNotEmpty(auditEcAlreadyEndCaseAmountVos)) {
                        auditEcAlreadyEndCaseAmountVoMap = auditEcAlreadyEndCaseAmountVos.stream().collect(Collectors.toMap(o -> o.getActivityDetailCode() + o.getProductCode() + o.getEndCaseCustomerCode(), Function.identity()));
                    }
                    for (AuditCustomerDetailVo auditCustomerDetailVo : splitVoList2) {
                        auditCustomerDetailVo.setEcSplit(YesOrNoEnum.YES.getCode());
                        AuditEcAlreadyEndCaseAmountVo auditEcAlreadyEndCaseAmountVo = (AuditEcAlreadyEndCaseAmountVo)auditEcAlreadyEndCaseAmountVoMap.get(auditCustomerDetailVo.getActivityDetailCode() + auditCustomerDetailVo.getProductCode() + auditCustomerDetailVo.getEndCaseCustomerCode());
                        if (auditEcAlreadyEndCaseAmountVo == null) {
                            auditCustomerDetailVo.setActivityDetailAlreadyEndCaseAmount(auditCustomerDetailVo.getAlreadyAuditAmount());
                            auditCustomerDetailVo.setAlreadyAuditAmount(BigDecimal.ZERO);
                            continue;
                        }
                        auditCustomerDetailVo.setActivityDetailAlreadyEndCaseAmount(auditCustomerDetailVo.getAlreadyAuditAmount());
                        auditCustomerDetailVo.setAlreadyAuditAmount(auditEcAlreadyEndCaseAmountVo.getAlreadyAuditAmount());
                    }
                }
                auditVo.setAuditCustomerDetailList(splitVoList2);
                log.info("\u7ed3\u6848\u6838\u9500\u5ba2\u6237\u62c6\u5206,\u6b65\u9aa41");
                log.info("\u7ed3\u6848\u6838\u9500\u5ba2\u6237\u62c6\u5206\uff0csplitAuditCustomerDetail\uff0c\u53c2\u65701:{}", (Object)JsonUtils.obj2JsonString(splitVoList2));
                auditVo.setEcSplit(true);
                this.collectionAuditCustomerDetail(auditVo);
                msgVo.setCheckType(AuditMsgCheckTypeEnum.SUCCESS.getCode());
                msgVo.setRemark("\u6267\u884c\u5b8c\u6210\uff01");
                this.auditMsgService.sendProcessMsg(msgVo);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                msgVo.setCheckType(AuditMsgCheckTypeEnum.FAIL.getCode());
                msgVo.setRemark(e.getMessage());
                this.auditMsgService.sendProcessMsg(msgVo);
            }
        });
        return dto.getAuditVo().getCacheKey();
    }

    public BigDecimal buildUnit4Param(AuditVo auditVo, AuditCustomerDetailVo vo, GeneralExpensesVo item, Map<String, CustomerVo> customerVoMap, Map<String, SalesOrgVo> salesOrgVoMap) {
        log.info("\u7ed3\u6848\u6838\u9500\u62c6\u5206\u5ba2\u6237\uff0c\u53c2\u65701:auditVo:{},vo:{},item:{},customerVoMap:{},salesOrgVoMap:{}", new Object[]{JsonUtils.obj2JsonString((Object)auditVo), JsonUtils.obj2JsonString((Object)vo), JsonUtils.obj2JsonString((Object)item), JsonUtils.obj2JsonString(customerVoMap), JsonUtils.obj2JsonString(salesOrgVoMap)});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("productCode", vo.getProductCode());
        paramMap.put("productName", vo.getProductName());
        paramMap.put("productBrandCode", vo.getProductBrandCode());
        paramMap.put("productBrandName", vo.getProductBrandName());
        paramMap.put("planItemCode", item.getExpensesCode());
        paramMap.put("detailPlanItemCode", item.getExpensesCode());
        paramMap.put("activityTypeCode", item.getActivityTypeCode());
        paramMap.put("activityFormCode", item.getActivityFormCode());
        paramMap.put("yearMonthStr", item.getYearMonthLy());
        if (customerVoMap.get(vo.getEndCaseCustomerCode()) != null) {
            CustomerVo customerVo = customerVoMap.get(vo.getEndCaseCustomerCode());
            paramMap.put("estoreCustomerLevel", customerVo.getEstoreCustomerLevel());
            paramMap.put("channelCode", customerVo.getCustomerChannelCode());
            paramMap.put("channelName", customerVo.getCustomerChannelName());
        }
        paramMap.put("date", DateUtil.format((Date)item.getStartDate(), (String)"yyyy-MM-dd"));
        if (TpmAuditTypeEnum.AUDITTYPE2.getCode().equals(item.getAuditConditionType())) {
            AuditFormulaMainVo auditFormulaMainVo = this.auditFormulaMainService.findByCode(item.getAuditConditionCode());
            if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty((Collection)auditFormulaMainVo.getAuditFormulaInfoVoList())) {
                CalculateDto calDto = this.buildCalParam(auditVo, auditFormulaMainVo, vo, item, item.getAuditConditionType(), paramMap, customerVoMap, salesOrgVoMap);
                log.info("\u7ed3\u6848\u6838\u9500\u62c6\u5206\u5ba2\u6237,\u53c2\u65702\uff1aauditFormulaMainVo:{},calDto:{}", (Object)JsonUtils.obj2JsonString((Object)auditFormulaMainVo), (Object)JsonUtils.obj2JsonString((Object)calDto));
                return this.setParam(auditFormulaMainVo, vo, calDto, paramMap);
            }
        } else if (TpmAuditTypeEnum.AUDITTYPE1.getCode().equals(item.getAuditConditionType())) {
            AuditFormulaMainDto dto = new AuditFormulaMainDto();
            dto.setBusinessFormatCode(auditVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(auditVo.getBusinessUnitCode());
            dto.setAuditType(item.getAuditConditionType());
            dto.setSalesOrgCodes(item.getSalesOrgCode());
            dto.setActivityFormCode(vo.getActivityFormCode());
            dto.setActivityTypeCode(vo.getActivityTypeCode());
            List formulaMainVoList = this.auditFormulaMainService.findListByDto(dto);
            formulaMainVoList = formulaMainVoList.stream().filter(e -> CollectionUtils.isNotEmpty((Collection)e.getAuditFormulaInfoVoList())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(formulaMainVoList)) {
                CalculateDto calDto = this.buildCalParam(auditVo, (AuditFormulaMainVo)formulaMainVoList.get(0), vo, item, TpmAuditTypeEnum.AUDITTYPE1.getCode(), paramMap, customerVoMap, salesOrgVoMap);
                log.info("\u7ed3\u6848\u6838\u9500\u62c6\u5206\u5ba2\u6237,\u53c2\u65703\uff1aformulaMainVoList:{},calDto:{}", (Object)JsonUtils.obj2JsonString(formulaMainVoList), (Object)JsonUtils.obj2JsonString((Object)calDto));
                return this.setParam((AuditFormulaMainVo)formulaMainVoList.get(0), vo, calDto, paramMap);
            }
        }
        return BigDecimal.ZERO;
    }

    public CalculateDto buildCalParam(AuditVo auditVo, AuditFormulaMainVo auditFormulaMainVo, AuditCustomerDetailVo vo, GeneralExpensesVo generalExpensesVo, String auditType, Map<String, String> paramMap, Map<String, CustomerVo> customerVoMap, Map<String, SalesOrgVo> salesOrgVoMap) {
        if (Objects.nonNull(auditFormulaMainVo) && CollectionUtil.isNotEmpty((Collection)auditFormulaMainVo.getAuditFormulaInfoVoList())) {
            CalculateDto dto = new CalculateDto();
            SalesOrgVo salesOrgVo3 = salesOrgVoMap.get(generalExpensesVo.getSalesOrgCode());
            if (salesOrgVo3 == null) {
                salesOrgVo3 = new SalesOrgVo();
            }
            SalesOrgVo salesOrgVo2 = salesOrgVoMap.get(salesOrgVo3.getParentCode());
            SalesOrgVo salesOrgVo1 = null;
            if (salesOrgVo2 != null) {
                salesOrgVo1 = salesOrgVoMap.get(salesOrgVo3.getParentCode());
            }
            dto.setCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
            dto.setCustomerCode(vo.getEndCaseCustomerCode());
            CustomerVo customerVo = customerVoMap.get(vo.getEndCaseCustomerCode());
            dto.setCustomerErpCode(customerVoMap.get(vo.getEndCaseCustomerCode()).getErpCode());
            dto.setCustomerName(customerVo.getCustomerName());
            dto.setBusinessFormatCode(auditVo.getBusinessFormatCode());
            dto.setBusinessUnitCode(auditVo.getBusinessUnitCode());
            dto.setActivityTypeCode(vo.getActivityTypeCode());
            dto.setActivityTypeName(vo.getActivityTypeName());
            dto.setActivityFormCode(vo.getActivityFormCode());
            dto.setActivityFormName(vo.getActivityFormName());
            dto.setStartTimeOrDate(generalExpensesVo.getStartDate());
            dto.setEndTimeOrDate(vo.getActivityEndTime());
            dto.setFormulaInfoDtoList(this.copyFormulaInfoList(auditFormulaMainVo.getAuditFormulaInfoVoList()));
            dto.setAuditType(auditType);
            dto.setSalesOrgCode(generalExpensesVo.getSalesOrgCode());
            dto.setSalesOrgErpCode(salesOrgVo3.getErpCode());
            dto.setDistributionChannel(salesOrgVo3.getChannelCode());
            if (salesOrgVo3 != null && SalesOrgLevelTypeEnum.DEPARTMENT.getCode().equals(salesOrgVo3.getSalesOrgLevel())) {
                salesOrgVo1 = salesOrgVo2;
                salesOrgVo2 = salesOrgVo3;
                salesOrgVo3 = null;
            }
            if (salesOrgVo3 != null && SalesOrgLevelTypeEnum.MECHANISM.getCode().equals(salesOrgVo3.getSalesOrgLevel())) {
                salesOrgVo1 = salesOrgVo3;
                salesOrgVo3 = null;
            }
            if (salesOrgVo1 != null) {
                dto.setSalesOrganizationCode(salesOrgVo1.getSalesOrgCode());
                dto.setSalesOrganizationErpCode(salesOrgVo1.getErpCode());
            }
            if (salesOrgVo2 != null) {
                dto.setSalesRegionCode(salesOrgVo2.getSalesOrgCode());
                dto.setSalesRegionErpCode(salesOrgVo2.getErpCode());
            }
            if (salesOrgVo3 != null) {
                dto.setSalesGroupCode(salesOrgVo3.getSalesOrgCode());
                dto.setSalesGroupErpCode(salesOrgVo3.getErpCode());
            }
            dto.setProductCode(paramMap.get("productCode"));
            dto.setYearMonthLy(paramMap.get("yearMonthStr"));
            dto.setStoresCode(paramMap.get("terminalCode"));
            dto.setBrandCode(paramMap.get("productBrandCode"));
            dto.setCategoryCode(paramMap.get("productCategoryCode"));
            dto.setItemCode(paramMap.get("productItemCode"));
            dto.setDetailPlanItemCode(paramMap.get("detailPlanItemCode"));
            dto.setPlanItemCode(paramMap.get("planItemCode"));
            dto.setActivityOrgCode(paramMap.get("region"));
            dto.setActivityOrgName(paramMap.get("regionName"));
            dto.setRetailBusinessmanCode(paramMap.get("systemCode"));
            dto.setRetailBusinessmanName(paramMap.get("systemName"));
            dto.setActivityTypeCode(paramMap.get("activityTypeCode"));
            dto.setActivityFormCode(paramMap.get("activityFormCode"));
            dto.setPersonCode(paramMap.get("personCode"));
            dto.setIdentityCard(paramMap.get("identityCard"));
            dto.setSecondChannelCode(paramMap.get("secondChannelCode"));
            dto.setEstoreCustomerLevel(paramMap.get("estoreCustomerLevel"));
            if (StringUtils.isNotEmpty((CharSequence)paramMap.get("date"))) {
                if (paramMap.get("date").length() == 10) {
                    dto.setDate(DateUtil.parse((String)paramMap.get("date"), (String)"yyyy-MM-dd"));
                } else if (paramMap.get("date").length() == 19) {
                    dto.setDate(DateUtil.parse((String)paramMap.get("date"), (String)"yyyy-MM-dd HH:mm:ss"));
                }
            }
            dto.setChannel(paramMap.get("channelCode"));
            dto.setStartTimeOrDate(vo.getActivityBeginTime());
            dto.setEndTimeOrDate(vo.getActivityEndTime());
            dto.setPersonIdCard(vo.getIdentityCard());
            dto.setFirstChannelCode(vo.getFirstChannelCode());
            dto.setSecondChannelCode(vo.getSecondChannelCode());
            dto.setSpecification(vo.getFormDescription());
            if (StringUtils.isNotEmpty((CharSequence)dto.getCustomerCode())) {
                Map map = this.tpmCustomerSummaryConfigureService.configureIncludeMap((List)Lists.newArrayList((Object[])new String[]{dto.getCustomerCode()}));
                if (map.containsKey(dto.getCustomerCode())) {
                    dto.setCustomerCodeList((Set)map.get(dto.getCustomerCode()));
                } else {
                    dto.setCustomerCodeList((Set)Sets.newHashSet((Object[])new String[]{dto.getCustomerCode()}));
                }
            }
            return dto;
        }
        log.info("\u7ec6\u6848\u9884\u6d4b=====\u300b\u6838\u9500\u6761\u4ef6\u4e3a\u7a7a");
        return null;
    }

    public List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        ArrayList<FormulaInfoDto> list = new ArrayList<FormulaInfoDto>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }

    public BigDecimal setParam(AuditFormulaMainVo auditFormulaMainVo, AuditCustomerDetailVo vo, CalculateDto calDto, Map<String, String> paramMap) {
        if (Objects.isNull(calDto)) {
            return BigDecimal.ZERO;
        }
        List calculateVos = Lists.newArrayList();
        try {
            calculateVos = this.variableService.orCalculateConditionAndExpression((List)Lists.newArrayList((Object[])new CalculateDto[]{calDto}));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error("\u62c6\u5206\u5ba2\u6237\u51fa\u9519", (Throwable)ex);
            throw ex;
        }
        AtomicReference<String> filterCondition = new AtomicReference<String>();
        List filterVos = calculateVos.stream().filter(CalculateVo::getFormulaConditionValue).collect(Collectors.toList());
        if (filterVos.size() > 1) {
            log.error("\u6838\u9500\u516c\u5f0f\u7f16\u7801 [" + auditFormulaMainVo.getAuditFormulaCode() + "] \u8ba1\u7b97\u7ed3\u679c\uff1a\u591a\u4e2a\u6838\u9500\u516c\u5f0f\u6761\u4ef6\u540c\u65f6\u6ee1\u8db3\uff01");
        } else if (CollectionUtils.isNotEmpty(filterVos)) {
            filterCondition.set(((CalculateVo)filterVos.get(0)).getFormulaConditionName());
        }
        BigDecimal estimatedWriteOffAmount = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(filterVos)) {
            estimatedWriteOffAmount = ((CalculateVo)filterVos.get(0)).getFormulaValue();
        }
        return estimatedWriteOffAmount;
    }

    public BigDecimal findAuditAmountForVariable(AuditCustomerDetailCollectionDto dto) {
        return this.auditCustomerDetailCollectionRepository.findAuditAmountForVariable(dto);
    }

    public AuditInvoiceSdkVo getInvoiceAmountCollect(AuditDto dto) {
        IAudit thisAudit = this.getAudit(null);
        return thisAudit.getInvoiceAmountCollect(dto);
    }

    public void updateProcessStatusByAuditCodeList(AuditDto auditDto, List<AuditVo> auditVos) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(auditVos), (String)"\u6838\u9500\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> auditCodeList = auditVos.stream().map(AuditVo::getAuditCode).collect(Collectors.toList());
        Assert.notEmpty(auditCodeList, (String)"\u6838\u9500\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.notNull((Object)auditDto, (String)"\u6d41\u7a0b\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.hasLength((String)auditDto.getProcessStatus(), (String)"\u6d41\u7a0b\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        if (ProcessStatusEnum.PASS.getDictCode().equals(auditDto.getProcessStatus())) {
            List reject;
            List pass = auditVos.stream().filter(o -> StringUtils.isEmpty((CharSequence)o.getReject()) || YesOrNoEnum.NO.getCode().equals(o.getReject())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(pass)) {
                auditCodeList = pass.stream().map(AuditVo::getAuditCode).collect(Collectors.toList());
                this.auditRepository.updateProcessStatusByAuditCodeList(auditDto, auditCodeList);
            }
            if (CollectionUtils.isNotEmpty(reject = auditVos.stream().filter(o -> YesOrNoEnum.YES.getCode().equals(o.getReject())).collect(Collectors.toList()))) {
                auditCodeList = reject.stream().map(AuditVo::getAuditCode).collect(Collectors.toList());
                auditDto.setProcessStatus(ProcessStatusEnum.REJECTING.getDictCode());
                this.auditRepository.updateProcessStatusByAuditCodeList(auditDto, auditCodeList);
            }
        } else {
            auditDto.setProcessStatus(ProcessStatusEnum.REJECTING.getDictCode());
            this.auditRepository.updateProcessStatusByAuditCodeList(auditDto, auditCodeList);
        }
    }

    public AuditVo customerCopyNumber(Pageable pageable, AuditDto dto) {
        IAudit thisAudit = this.getAudit(dto);
        return thisAudit.customerCopyNumber(pageable, dto);
    }

    public void checkInvoiceCustomer(QueryAuditInfoDto dto) {
        IAudit thisAudit = this.getAudit(null);
        thisAudit.checkInvoiceCustomer(dto);
    }

    public Page<AuditVo> findByName(Pageable pageable, String auditName) {
        IAudit iAudit = this.getAudit(null);
        return iAudit.findByName(pageable, auditName);
    }

    public List<AuditInvoiceVo> findInvoiceByAuditCode(String auditCode) {
        List<AuditInvoice> auditInvoices = this.auditInvoiceRepository.findByAuditCode(auditCode);
        ArrayList auditInvoiceVos = (ArrayList)this.nebulaToolkitService.copyCollectionByWhiteList(auditInvoices, AuditInvoice.class, AuditInvoiceVo.class, HashSet.class, ArrayList.class, new String[0]);
        return auditInvoiceVos;
    }
}

