/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SapRedInvoiceSaleOrderCreateCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SapRedInvoiceSaleOrderCreateCallbackItem1Dto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDataDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDto;
import com.biz.crm.tpm.business.audit.local.entity.Audit;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollection;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailCollectionExtend;
import com.biz.crm.tpm.business.audit.local.entity.AuditCustomerDetailExtend;
import com.biz.crm.tpm.business.audit.local.entity.AuditProductUpAccount;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionExtendRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailCollectionRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailExtendRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditCustomerDetailRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditProductUpAccountRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditRepository;
import com.biz.crm.tpm.business.audit.local.repository.AuditSonCompanyDiscountSumRepository;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditFindDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditRedInvoiceDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.RedInvoiceSapApiFlagEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.RedOrderCreateStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.SucessOrFailEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.UpAccountStatusEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditSdkService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditTotalReimburseTaxAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AuditUpAccountCallBackServiceImpl
implements AuditSdkService {
    private static final Logger log = LoggerFactory.getLogger(AuditUpAccountCallBackServiceImpl.class);
    @Autowired(required=false)
    private AuditProductUpAccountRepository auditProductUpAccountRepository;
    @Autowired(required=false)
    private AuditCustomerDetailCollectionRepository auditCustomerDetailCollectionRepository;
    @Autowired(required=false)
    private AuditCustomerDetailCollectionExtendRepository auditCustomerDetailCollectionExtendRepository;
    @Autowired(required=false)
    private AuditCustomerDetailExtendRepository auditCustomerDetailExtendRepository;
    @Autowired(required=false)
    private AuditCustomerDetailRepository auditCustomerDetailRepository;
    @Autowired(required=false)
    private AuditRepository auditRepository;
    @Autowired(required=false)
    protected AuditSonCompanyDiscountSumRepository auditSonCompanyDiscountSumRepository;

    @Transactional(rollbackFor={Exception.class})
    public void sdAuditCostPostingHeadCallback(AuditCostPostingCallbackDto dto) {
        List data = dto.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            Map collect = data.stream().collect(Collectors.toMap(AuditCostPostingCallbackDataDto::getCamp_id, Function.identity(), (o, n) -> o));
            Set<String> activityDetailCodes = data.stream().map(AuditCostPostingCallbackDataDto::getCamp_id).collect(Collectors.toSet());
            List<Object> auditCustomerDetailCollectionVos = this.auditCustomerDetailCollectionRepository.findByActivityDetailCodes(activityDetailCodes);
            if (CollectionUtils.isNotEmpty(auditCustomerDetailCollectionVos)) {
                List<String> auditCodes = auditCustomerDetailCollectionVos.stream().map(AuditCustomerDetailCollectionVo::getAuditCode).distinct().collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(auditCodes)) {
                    List<Object> auditVos = this.auditRepository.findByCodes(auditCodes);
                    Calendar today = Calendar.getInstance();
                    Date endTime = today.getTime();
                    today.add(10, -5);
                    Date beginTime = today.getTime();
                    auditVos = auditVos.stream().filter(o -> ProcessStatusEnum.PASS.getDictCode().equals(o.getProcessStatus())).filter(o -> Objects.nonNull(o.getProcessDate())).filter(o -> o.getProcessDate().after(beginTime) && o.getProcessDate().before(endTime)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(auditVos)) {
                        List<String> finalAuditCodes = auditCodes = auditVos.stream().map(AuditVo::getAuditCode).collect(Collectors.toList());
                        auditCustomerDetailCollectionVos = auditCustomerDetailCollectionVos.stream().filter(o -> finalAuditCodes.contains(o.getAuditCode())).collect(Collectors.toList());
                    }
                }
                ArrayList<AuditCustomerDetailCollection> updateDetail = new ArrayList<AuditCustomerDetailCollection>();
                for (AuditCustomerDetailCollectionVo auditCustomerDetailCollectionVo : auditCustomerDetailCollectionVos) {
                    AuditCustomerDetailCollection auditCustomerDetailCollection1 = new AuditCustomerDetailCollection();
                    auditCustomerDetailCollection1.setId(auditCustomerDetailCollectionVo.getId());
                    AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (AuditCostPostingCallbackDataDto)collect.get(auditCustomerDetailCollectionVo.getActivityDetailCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        auditCustomerDetailCollection1.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTED.getCode());
                    } else {
                        auditCustomerDetailCollection1.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNT_FAILD.getCode());
                        auditCustomerDetailCollection1.setDiscountUpAccountFailMsg(auditCostPostingCallbackDataDto.getMessage());
                    }
                    updateDetail.add(auditCustomerDetailCollection1);
                }
                if (CollectionUtils.isNotEmpty(updateDetail)) {
                    this.auditCustomerDetailCollectionRepository.updateBatchById(updateDetail);
                }
            } else {
                auditCustomerDetailCollectionVos = this.auditCustomerDetailCollectionRepository.findByUpAccountActivityCodes(activityDetailCodes);
                ArrayList<AuditCustomerDetailCollection> updateDetail = new ArrayList<AuditCustomerDetailCollection>();
                for (AuditCustomerDetailCollectionVo auditCustomerDetailCollectionVo : auditCustomerDetailCollectionVos) {
                    AuditCustomerDetailCollection auditCustomerDetailCollection1 = new AuditCustomerDetailCollection();
                    auditCustomerDetailCollection1.setId(auditCustomerDetailCollectionVo.getId());
                    AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (AuditCostPostingCallbackDataDto)collect.get(auditCustomerDetailCollectionVo.getUpAccountActivityCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        auditCustomerDetailCollection1.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTED.getCode());
                    } else {
                        auditCustomerDetailCollection1.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNT_FAILD.getCode());
                        auditCustomerDetailCollection1.setDiscountUpAccountFailMsg(auditCostPostingCallbackDataDto.getMessage());
                    }
                    updateDetail.add(auditCustomerDetailCollection1);
                }
                if (CollectionUtils.isNotEmpty(updateDetail)) {
                    this.auditCustomerDetailCollectionRepository.updateBatchById(updateDetail);
                }
            }
        }
    }

    private void updateAuditDetailUpAccountStatus(List<AuditCostPostingCallbackDataDto> data, List<AuditProductUpAccount> list) {
        Set auditDetailCodeSet = list.stream().map(AuditProductUpAccount::getAuditDetailCode).collect(Collectors.toSet());
        Map<String, List<AuditProductUpAccount>> auditProductUpAccountMap = list.stream().collect(Collectors.groupingBy(AuditProductUpAccount::getAuditDetailCode));
        Map auditCostPostingCallbackDataDtoMap = data.stream().collect(Collectors.toMap(AuditCostPostingCallbackDataDto::getCamp_id, Function.identity(), (o, n) -> o));
        if (CollectionUtils.isNotEmpty(auditDetailCodeSet)) {
            List auditCustomerDetailCollectionList = ((LambdaQueryChainWrapper)this.auditCustomerDetailCollectionRepository.lambdaQuery().in(AuditCustomerDetailCollection::getAuditDetailCode, auditDetailCodeSet)).list();
            ArrayList<AuditCustomerDetailCollection> updateDetail = new ArrayList<AuditCustomerDetailCollection>();
            for (AuditCustomerDetailCollection auditCustomerDetailCollection : auditCustomerDetailCollectionList) {
                AuditCustomerDetailCollection auditCustomerDetailCollection1 = new AuditCustomerDetailCollection();
                auditCustomerDetailCollection1.setId(auditCustomerDetailCollection.getId());
                boolean upAccountSuccess = false;
                boolean upAccountFail = false;
                List<AuditProductUpAccount> auditProductUpAccounts = auditProductUpAccountMap.get(auditCustomerDetailCollection.getAuditDetailCode());
                if (CollectionUtils.isNotEmpty(auditProductUpAccounts)) {
                    for (AuditProductUpAccount auditProductUpAccount : auditProductUpAccounts) {
                        AuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (AuditCostPostingCallbackDataDto)auditCostPostingCallbackDataDtoMap.get(auditProductUpAccount.getActivityDetailCode());
                        if (auditCostPostingCallbackDataDto == null) continue;
                        if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                            upAccountSuccess = true;
                            continue;
                        }
                        upAccountFail = true;
                    }
                }
                if (upAccountSuccess && !upAccountFail) {
                    auditCustomerDetailCollection1.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTED.getCode());
                }
                if (!upAccountSuccess && upAccountFail) {
                    auditCustomerDetailCollection1.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNT_FAILD.getCode());
                }
                if (upAccountSuccess && upAccountFail) {
                    auditCustomerDetailCollection1.setUpAccountStatus(UpAccountStatusEnum.PART_UP_ACCOUNT.getCode());
                }
                updateDetail.add(auditCustomerDetailCollection1);
            }
            this.auditCustomerDetailCollectionRepository.updateBatchById(updateDetail);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void sdAuditCostPostingBranchCallback(SonAuditCostPostingCallbackDto dto) {
        List data = dto.getData();
        if (CollectionUtils.isNotEmpty((Collection)data)) {
            Map collect = data.stream().collect(Collectors.toMap(SonAuditCostPostingCallbackDataDto::getZftpmhxd, Function.identity()));
            List upAccountActivityCodeList = data.stream().map(SonAuditCostPostingCallbackDataDto::getZftpmhxd).collect(Collectors.toList());
            List auditCustomerDetailCollectionList = ((LambdaQueryChainWrapper)this.auditCustomerDetailCollectionRepository.lambdaQuery().in(AuditCustomerDetailCollection::getUpAccountActivityCode, upAccountActivityCodeList)).list();
            if (CollectionUtils.isNotEmpty((Collection)auditCustomerDetailCollectionList)) {
                ArrayList<AuditCustomerDetailCollection> updateList = new ArrayList<AuditCustomerDetailCollection>();
                for (AuditCustomerDetailCollection one : auditCustomerDetailCollectionList) {
                    AuditCustomerDetailCollection update = new AuditCustomerDetailCollection();
                    update.setId(one.getId());
                    SonAuditCostPostingCallbackDataDto auditCostPostingCallbackDataDto = (SonAuditCostPostingCallbackDataDto)collect.get(one.getUpAccountActivityCode());
                    if (SucessOrFailEnum.SUCESS.getCode().equals(auditCostPostingCallbackDataDto.getFlag())) {
                        update.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTED.getCode());
                        update.setEnterCostPoolDate(new Date());
                    } else {
                        update.setUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNT_FAILD.getCode());
                        update.setUpAccountMessage(auditCostPostingCallbackDataDto.getMessage());
                        update.setDiscountUpAccountFailMsg(auditCostPostingCallbackDataDto.getMessage());
                    }
                    updateList.add(update);
                }
                this.auditCustomerDetailCollectionRepository.updateBatchById(updateList);
            }
        }
    }

    public void saleOrderCreateCallback(SapRedInvoiceSaleOrderCreateCallbackDto dto) {
        block10: {
            try {
                Validate.notNull((Object)dto, (String)"\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notEmpty((Collection)dto.getITEM1(), (String)"\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa\u8fd4\u56de\u4fe1\u606fitem1\u4e3a\u7a7a", (Object[])new Object[0]);
                SapRedInvoiceSaleOrderCreateCallbackItem1Dto item1Vo = (SapRedInvoiceSaleOrderCreateCallbackItem1Dto)dto.getITEM1().get(0);
                Validate.notBlank((CharSequence)item1Vo.getFLAG(), (String)"\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa\u8fd4\u56de\u4fe1\u606fitem1\u4e2d\uff0c\u6210\u529f\u6807\u8bc6Flag\u4e3a\u7a7a", (Object[])new Object[0]);
                String bstkd = item1Vo.getBSTKD();
                Audit audit = this.auditRepository.findEntityByAuditCode(bstkd);
                if (RedInvoiceSapApiFlagEnum.S.getCode().equals(item1Vo.getFLAG())) {
                    Validate.notBlank((CharSequence)bstkd, (String)"\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa\u8fd4\u56de\u4fe1\u606fitem1\u4e2d\uff0cTPM\u51ed\u8bc1\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
                    if (audit == null) {
                        List<AuditCustomerDetailCollectionExtend> extendList;
                        List<AuditCustomerDetailCollection> detailCollectionList = this.auditCustomerDetailCollectionRepository.findByRedOrderNo(bstkd);
                        if (CollectionUtils.isNotEmpty(detailCollectionList)) {
                            AuditRedInvoiceDto redInvoiceDto = new AuditRedInvoiceDto();
                            redInvoiceDto.setRedOrderNo(bstkd);
                            redInvoiceDto.setMassageCode(item1Vo.getVBELN());
                            redInvoiceDto.setRedOrderCreateStatus(RedOrderCreateStatusEnum.SUCCESS_CREATE.getCode());
                            this.auditCustomerDetailCollectionRepository.updateRedInvoiceStatus(redInvoiceDto);
                            this.auditCustomerDetailRepository.updateRedInvoiceStatus(redInvoiceDto);
                        }
                        if (CollectionUtils.isNotEmpty(extendList = this.auditCustomerDetailCollectionExtendRepository.findByRedOrderOffsetNo(bstkd))) {
                            AuditRedInvoiceDto redInvoiceDto = new AuditRedInvoiceDto();
                            redInvoiceDto.setRedOrderOffsetNo(bstkd);
                            redInvoiceDto.setMassageCode(item1Vo.getVBELN());
                            redInvoiceDto.setRedOrderCreateStatus(RedOrderCreateStatusEnum.OFFSET.getCode());
                            List<AuditCustomerDetailCollectionExtend> extendList1 = this.auditCustomerDetailCollectionExtendRepository.updateRedInvoiceOffsetStatus(redInvoiceDto);
                            this.auditCustomerDetailCollectionRepository.updateRedInvoiceStatusById(redInvoiceDto, extendList1.stream().map(UuidEntity::getId).collect(Collectors.toList()));
                            List<AuditCustomerDetailExtend> extendList2 = this.auditCustomerDetailExtendRepository.updateRedInvoiceOffsetStatus(redInvoiceDto);
                            this.auditCustomerDetailRepository.updateRedInvoiceStatusById(redInvoiceDto, extendList2.stream().map(UuidEntity::getId).collect(Collectors.toList()));
                        }
                    } else {
                        Validate.notBlank((CharSequence)item1Vo.getVBELN(), (String)"\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa\u8fd4\u56de\u4fe1\u606fitem1\u4e2d\uff0c\u9500\u552e\u51ed\u8bc1\u4e3a\u7a7a", (Object[])new Object[0]);
                        Validate.notNull((Object)((Object)audit), (String)"\u6839\u636e\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa\u8fd4\u56de\u4fe1\u606fitem1\u4e2dTPM\u51ed\u8bc1\u53f7\uff0c\u672a\u67e5\u627e\u5230\u6838\u9500\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
                        Audit newAudit = new Audit();
                        newAudit.setId(audit.getId());
                        newAudit.setRedOrderCreateStatus(RedOrderCreateStatusEnum.SUCCESS_CREATE.getCode());
                        newAudit.setRedOrderCreateNo(item1Vo.getVBELN());
                        newAudit.setRedInvoiceUpAccountDate(new Date());
                        this.auditRepository.updateById((Object)newAudit);
                    }
                    break block10;
                }
                if (RedInvoiceSapApiFlagEnum.E.getCode().equals(item1Vo.getFLAG())) {
                    if (audit == null) {
                        AuditRedInvoiceDto redInvoiceDto = new AuditRedInvoiceDto();
                        redInvoiceDto.setRedOrderNo(bstkd);
                        redInvoiceDto.setRedOrderCreateStatus(RedOrderCreateStatusEnum.FAIL_CREATE_SAP.getCode());
                        this.auditCustomerDetailCollectionRepository.updateRedInvoiceStatus(redInvoiceDto);
                        this.auditCustomerDetailRepository.updateRedInvoiceStatus(redInvoiceDto);
                    } else {
                        Validate.notNull((Object)((Object)audit), (String)"\u6839\u636e\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa\u8fd4\u56de\u4fe1\u606fitem1\u4e2dTPM\u51ed\u8bc1\u53f7\uff0c\u672a\u67e5\u627e\u5230\u6838\u9500\u4fe1\u606f\u4e3a\u7a7a", (Object[])new Object[0]);
                        Audit newAudit = new Audit();
                        newAudit.setId(audit.getId());
                        newAudit.setRedOrderCreateStatus(RedOrderCreateStatusEnum.FAIL_CREATE_SAP.getCode());
                        this.auditRepository.updateById((Object)newAudit);
                    }
                    break block10;
                }
                throw new RuntimeException("\u7ea2\u5b57\u53d1\u7968-\u9500\u552e\u8ba2\u5355\u521b\u5efa\u5931\u8d25\uff0c\u8fd4\u56de\u6210\u529f\u6807\u8bc6\u65e0\u6cd5\u8bc6\u522bFlag=" + item1Vo.getFLAG());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("SAP\u9500\u552e\u8ba2\u5355\u521b\u5efa\u63a5\u53e3\u56de\u8c03\u63a5\u53e3\u62a5\u9519:" + e.getMessage());
            }
        }
    }

    public Object create(AutoAuditDto dto) {
        return null;
    }

    public AuditVo findByCode(String code) {
        return null;
    }

    public AutoAuditDto atomicCreate(AutoAuditDto dto) {
        return null;
    }

    public Page<AuditCustomerDetailCollectionVo> findDetailByConditions(Pageable pageable, AuditFindDetailDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)2000));
        return this.auditCustomerDetailCollectionRepository.findDetailByConditions(pageable, dto);
    }

    public List<AuditTotalReimburseTaxAmountVo> findAuditVoListByCondition(AuditQueryDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dto.setReimburseUpAccountStatus(UpAccountStatusEnum.UP_ACCOUNTED.getCode());
        dto.setEndCaseForm(EndCaseFormEnum.REIMBURSE.getCode());
        dto.setBusinessUnitCode(BusinessUnitEnum.VERTICAL.getCode());
        dto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        Validate.notBlank((CharSequence)dto.getYearMonth(), (String)"\u67e5\u8be2\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.auditCustomerDetailCollectionRepository.findAuditVoListByCondition(dto);
    }

    public List<AuditCustomerDetailCollectionVo> findDetailByActivityDetailCodeList(AuditFindDetailDto dto) {
        if (CollectionUtils.isEmpty((Collection)dto.getActivityCodeList()) && CollectionUtils.isEmpty((Collection)dto.getActivityDetailCodeList())) {
            return Collections.emptyList();
        }
        return this.auditCustomerDetailCollectionRepository.findDetailByActivityDetailCodeList(dto);
    }

    public String findBusinessUnitByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return null;
        }
        Audit one = this.auditRepository.findBusinessUnitByProcessNo(processNo);
        if (one != null) {
            return one.getBusinessUnitCode();
        }
        return null;
    }
}

