/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.alibaba.excel.util.StringUtils;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.CallAuditResponse;
import com.biz.crm.tpm.business.detailed.forecast.sdk.dto.DetailedForecastCallAuditEventDto;
import com.biz.crm.tpm.business.detailed.forecast.sdk.event.DetailedForecastCallAuditListener;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DetailedForecastCallAuditListenerImpl
implements DetailedForecastCallAuditListener {
    private static final Logger log = LoggerFactory.getLogger(DetailedForecastCallAuditListenerImpl.class);
    @Autowired(required=false)
    private AuditService auditService;

    public CallAuditResponse selectWholeAuditFromAuditByActivityCode(DetailedForecastCallAuditEventDto dto) {
        CallAuditResponse response = new CallAuditResponse();
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getActivityDetailItemCode())) {
            return response;
        }
        ArrayList codes = Lists.newArrayList();
        codes.add(dto.getActivityDetailItemCode());
        List list = this.auditService.findAuditCustomerDetailCollectionByDetailPlanItemCodeList((List)codes);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return response;
        }
        AuditCustomerDetailCollectionVo vo = list.stream().filter(l -> BooleanEnum.TRUE.getCapital().equals(l.getWholeAudit())).findFirst().orElse(null);
        if (Objects.isNull(vo)) {
            response.setWholeAudit(BooleanEnum.FALSE.getCapital());
        } else {
            response.setWholeAudit(BooleanEnum.TRUE.getCapital());
        }
        return response;
    }
}

