/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.service.internal;

import com.biz.crm.tpm.business.audit.local.entity.TaxAccount;
import com.biz.crm.tpm.business.audit.local.repository.TaxAccountRepository;
import com.biz.crm.tpm.business.audit.sdk.dto.TaxAccountDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.TaxTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.TaxAccountService;
import com.biz.crm.tpm.business.audit.sdk.vo.TaxAccountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="taxAccountService")
public class TaxAccountServiceImpl
implements TaxAccountService {
    private static final Logger log = LoggerFactory.getLogger(TaxAccountServiceImpl.class);
    @Autowired(required=false)
    private TaxAccountRepository taxAccountRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public TaxAccountVo findByReimburseTaxRate(String reimburseTaxRate) {
        String zero = "0";
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)reimburseTaxRate) && !zero.equals(reimburseTaxRate) ? 1 : 0) != 0, (String)"\u62a5\u9500\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u4e3a0\uff01", (Object[])new Object[0]);
        TaxAccount taxAccount = this.taxAccountRepository.findByReimburseTaxRate(reimburseTaxRate, TaxTypeEnum.IN);
        return (TaxAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)taxAccount, TaxAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void create(TaxAccountDto taxAccount) {
        Validate.notNull((Object)taxAccount, (String)"\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String zero = "0";
        String reimburseTaxRate = taxAccount.getReimburseTaxRate();
        Validate.isTrue((StringUtils.isNotEmpty((CharSequence)reimburseTaxRate) && !zero.equals(reimburseTaxRate) ? 1 : 0) != 0, (String)"\u62a5\u9500\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u4e3a0\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taxAccount.getTaxSubject(), (String)"\u7a0e\u8d39\u79d1\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)taxAccount.getTaxSubjectName(), (String)"\u7a0e\u8d39\u79d1\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TaxAccount byReimburseTaxRate = this.taxAccountRepository.findByReimburseTaxRate(reimburseTaxRate, TaxTypeEnum.IN);
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)byReimburseTaxRate)), (String)"\u5df2\u5b58\u5728\u76f8\u540c\u62a5\u9500\u7a0e\u7387\u7684\u6620\u5c04\uff01", (Object[])new Object[0]);
        this.taxAccountRepository.save(this.nebulaToolkitService.copyObjectByWhiteList((Object)taxAccount, TaxAccount.class, HashSet.class, ArrayList.class, new String[0]));
    }

    public Collection<TaxAccountVo> findByTaxRateList(Set<String> taxRates) {
        if (CollectionUtils.isEmpty(taxRates)) {
            return null;
        }
        List<TaxAccount> taxAccount = this.taxAccountRepository.findByTaxRateList(taxRates, TaxTypeEnum.IN);
        return this.nebulaToolkitService.copyCollectionByWhiteList(taxAccount, TaxAccount.class, TaxAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

