/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.task.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.third.system.ecrm.sdk.service.EcrmService;
import com.biz.crm.mn.third.system.ecrm.sdk.vo.PreEndResultRequestVo;
import com.biz.crm.tpm.business.audit.local.task.impl.AutoAuditHelper;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.PreEndResultRequestEntityVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class AuditDetailSchedulingImp
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(AuditDetailSchedulingImp.class);
    private static final String DEFAULT_CRON = "0 0 1,12,17,23 * * ?";
    private String cron = "0 0 1,12,17,23 * * ?";
    @Autowired
    private AuditService auditService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private EcrmService ecrmService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private AutoAuditHelper autoAuditHelper;
    @Value(value="${ce1.ce1EnableSchedulingFlag}")
    private boolean ce1EnableSchedulingFlag;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        if (this.ce1EnableSchedulingFlag) {
            taskRegistrar.addTriggerTask(this::executePullTask, triggerContext -> {
                CronTrigger trigger = new CronTrigger(this.cron);
                return trigger.nextExecutionTime(triggerContext);
            });
        } else {
            log.info("\u672a\u5f00\u542f\u5b9a\u65f6\u4efb\u52a1\uff0c\u8bf7\u624b\u52a8\u8c03\u7528");
        }
    }

    private void executePullTask() {
        int pageNum = 1;
        int pageSize = 200;
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        Page page = this.auditService.selectUnSynchronizedPage((Pageable)pageable);
        while (CollectionUtils.isNotEmpty((Collection)page.getRecords())) {
            List<PreEndResultRequestVo> preEndResultRequestVos = this.TypeChange(page.getRecords());
            boolean flag = this.ecrmService.synchronizationPreEndResultRequest(preEndResultRequestVos);
            if (flag) {
                List auditCodes = preEndResultRequestVos.stream().map(preEndResultRequestVo -> preEndResultRequestVo.getAuditCode()).collect(Collectors.toList());
                this.auditService.updatSynchronizationByUuids(auditCodes);
            }
            if (page.getRecords().size() == pageSize) {
                pageable = PageRequest.of((int)(++pageNum), (int)pageSize);
                page = this.auditService.selectUnSynchronizedPage((Pageable)pageable);
                continue;
            }
            page.setRecords(new ArrayList());
        }
    }

    private List<PreEndResultRequestVo> TypeChange(List<PreEndResultRequestEntityVo> preEndResultRequestEntityVos) {
        List preEndResultRequestVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(preEndResultRequestEntityVos, PreEndResultRequestEntityVo.class, PreEndResultRequestVo.class, HashSet.class, ArrayList.class, new String[0]);
        return preEndResultRequestVos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DynamicTaskService(cornExpression="0 30 1 * * ?", taskDesc="\u81ea\u52a8\u6838\u9500")
    public void autoAudit() {
        this.loginUserService.refreshAuthentication(null);
        String lockKey = "audit:auto";
        boolean lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 24L);
        if (!lock) {
            log.info("\u81ea\u52a8\u6838\u9500\u4e0a\u6b21\u672a\u6267\u884c\u5b8c\u6210,\u672c\u6b21\u8df3\u8fc7\u6267\u884c...............");
            return;
        }
        long autoStart = System.currentTimeMillis();
        try {
            log.info("\u81ea\u52a8\u6838\u9500\u5f00\u59cb...............");
            this.autoAuditHelper.autoAuditActivityHandler();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        finally {
            this.redisLockService.unlock(lockKey);
            log.info("\u81ea\u52a8\u6838\u9500\u7ed3\u675f...............");
        }
        long autoEnd = System.currentTimeMillis();
        log.info("\u81ea\u52a8\u6838\u9500\u6267\u884c\u8017\u65f6\u79d2\u6570:{}", (Object)((autoEnd - autoStart) / 1000L));
    }
}

