/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.task.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.dto.audit.AutoAuditParamsDto;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.ActivityDetailPlanRollbackBudgetEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanWhereFrom;
import com.biz.crm.tpm.business.audit.local.service.AuditProcess;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditCustomerDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.enumeration.AuditDimensionalityEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.AutoAuditTimeTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseFormEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.EndCaseTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.enumeration.SaveTypeEnum;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditAutoConfigurationVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.PromotionPlanService;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.ExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.GeneralExpensesVo;
import com.biz.crm.tpm.business.promotion.plan.sdk.vo.PromotionPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemBudgetShareVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AutoAuditHelper {
    private static final Logger log = LoggerFactory.getLogger(AutoAuditHelper.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanVoService subComActivityDetailPlanVoService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;
    @Autowired(required=false)
    private AuditProcess auditProcess;
    @Autowired(required=false)
    private PromotionPlanService promotionPlanService;
    private static final String CUSTOMER_NAME_VALUE_KEY = "customer_name";
    private static final String ACTIVITY_TYPE_NAME_KEY = "activity_type_name";
    private static final String FEE_YEAR_MONTH_KEY = "fee_year_month";
    private static final String SUPPLIER_NAME_KEY = "supplier_name";
    private static final String BUSINESS_UNIT_CODE_KEY = "business_unit_code";
    private static final String BUSINESS_FORMAT_CODE_KEY = "business_format_code";

    private LocalDate strToLocalDate(String date, DateTimeFormatter dateFormatter) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        return LocalDate.parse(date, dateFormatter);
    }

    public void autoAuditActivityHandler() {
        List configurationList = this.auditService.findAutoConfigurationByDate(BooleanEnum.TRUE.getCapital());
        if (CollUtil.isEmpty((Collection)configurationList)) {
            log.error("=====>    \u81ea\u52a8\u7ed3\u6848\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728,\u4e0d\u6267\u884c\u540e\u9762\u81ea\u52a8\u6838\u9500\u903b\u8f91    <=====");
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM");
        LocalDate now = LocalDate.now();
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        String yearMonthly = dateFormat.format(calendar.getTime());
        for (AuditAutoConfigurationVo configuration : configurationList) {
            if (!this.isAutoAudit(configuration, now)) continue;
            log.info("\u81ea\u52a8\u6838\u9500\u7f16\u7801\u4e3a\u5f00\u59cb\uff1a{}", (Object)configuration.getAuditAutoConfigCode());
            AutoAuditParamsDto autoAuditParams = new AutoAuditParamsDto();
            this.baseBuildAutoAuditInfo(configuration, autoAuditParams, yearMonthly, now);
            try {
                this.autoAuditBodyHandle(configuration, autoAuditParams, dateFormat);
            }
            catch (Exception e) {
                log.error("\u4e3b\u4f53\u5782\u76f4\u81ea\u52a8\u7ed3\u6848\u5f02\u5e38:{}", (Object)e.getMessage());
                log.error("", (Throwable)e);
            }
            try {
                this.moleculeAutoAuditHandle(configuration, autoAuditParams, dateFormat);
            }
            catch (Exception e) {
                log.error("\u5206\u5b50\u516c\u53f8\u81ea\u52a8\u7ed3\u6848\u5f02\u5e38:{}", (Object)e.getMessage());
                log.error("", (Throwable)e);
            }
            try {
                this.ecomAutoAuditHandle(configuration, autoAuditParams, dateFormat);
            }
            catch (Exception e) {
                log.error("\u7535\u5546\u81ea\u52a8\u7ed3\u6848\u5f02\u5e38:{}", (Object)e.getMessage());
                log.error("", (Throwable)e);
            }
            log.info("\u81ea\u52a8\u6838\u9500\u7f16\u7801\u4e3a\u7ed3\u675f\uff1a{}", (Object)configuration.getAuditAutoConfigCode());
        }
    }

    private void ecomAutoAuditHandle(AuditAutoConfigurationVo configuration, AutoAuditParamsDto autoAuditParams, SimpleDateFormat dateFormat) {
        Page pageResult;
        if (!BusinessUnitEnum.isOnlineBusinessUnit((String)configuration.getBusinessUnitCode())) {
            return;
        }
        HashSet<String> setActivityPlanCodes = new HashSet<String>();
        ArrayList<AutoAuditDto> autoAuditList = new ArrayList<AutoAuditDto>();
        PageRequest pageable = PageRequest.of((int)1, (int)2000);
        do {
            List canAutoAuditItemList;
            if (CollUtil.isNotEmpty((Collection)(canAutoAuditItemList = (pageResult = this.promotionPlanService.findCanAutoAuditItemPage((Pageable)pageable, autoAuditParams)).getRecords()))) {
                log.info("\u7535\u5546\u6d3b\u52a8\u7ec6\u6848\u67e5\u8be2\u6570\u91cf:{}", (Object)canAutoAuditItemList.size());
                this.ecomAutoAuditDataHandle(autoAuditList, canAutoAuditItemList, dateFormat, configuration);
                this.executeAutoAudit(autoAuditList, setActivityPlanCodes);
                autoAuditList.clear();
            } else {
                log.error("=====>   \u53c2\u6570[{}]\u672a\u67e5\u8be2\u5230\u9700\u8981\u81ea\u52a8\u6838\u9500\u7684\u6570\u636e   <=====", (Object)JSON.toJSONString((Object)autoAuditParams));
            }
            log.info("\u81ea\u52a8\u6838\u9500\u6b63\u5728\u67e5\u8be2\u7535\u5546\u672a\u7ed3\u6848\u7684\u7ec6\u6848\u660e\u7ec6\u6570\u636e \u5f53\u524d\u8fdb\u5ea6[{}/{}]\u5171{}\u6761\u6570\u636e", new Object[]{pageResult.getCurrent(), pageResult.getPages(), pageResult.getTotal()});
            pageable = pageable.next();
        } while (pageResult.hasNext());
        List partition = Lists.partition(new ArrayList<String>(setActivityPlanCodes), (int)2000);
        partition.forEach(item -> this.promotionPlanService.updateAutoAuditFlag(item, BooleanEnum.TRUE.getCapital()));
        setActivityPlanCodes.clear();
        this.autoApproved(configuration);
    }

    private void ecomAutoAuditDataHandle(List<AutoAuditDto> autoAuditList, List<GeneralExpensesVo> canAutoAuditItemList, SimpleDateFormat dateFormat, AuditAutoConfigurationVo configuration) {
        List expensesCodes = canAutoAuditItemList.stream().map(ExpensesVo::getExpensesCode).collect(Collectors.toList());
        List promotionPlanVoList = this.promotionPlanService.findByCodes(expensesCodes);
        this.ecomCustomerSplit(autoAuditList, promotionPlanVoList, canAutoAuditItemList, dateFormat, configuration);
    }

    private void ecomCustomerSplit(List<AutoAuditDto> autoAuditList, List<PromotionPlanVo> promotionPlanVoList, List<GeneralExpensesVo> canAutoAuditItemList, SimpleDateFormat dateFormat, AuditAutoConfigurationVo configuration) {
        if (CollUtil.isEmpty(promotionPlanVoList)) {
            return;
        }
        if (AuditDimensionalityEnum.ACTIVITY_DETAIL.getCode().equals(configuration.getAuditDimensionality())) {
            canAutoAuditItemList.stream().filter(o -> CharSequenceUtil.isNotEmpty((CharSequence)o.getCustomerCode())).forEach(o -> {
                AutoAuditDto autoAudit = new AutoAuditDto();
                ArrayList itemValue = Lists.newArrayList((Object[])new GeneralExpensesVo[]{o});
                List<PromotionPlanVo> detailList = this.getPromotionPlan(promotionPlanVoList, itemValue);
                autoAudit.setAuditDimensionality(configuration.getAuditDimensionality());
                autoAudit.setDimensionalityKey(o.getExpensesCode());
                this.autoEcomAuditPartBean(autoAudit, detailList, itemValue);
                String customerName = this.getEcomValue(null, itemValue, CUSTOMER_NAME_VALUE_KEY);
                String activityTypeName = this.getEcomValue(null, itemValue, ACTIVITY_TYPE_NAME_KEY);
                String auditName = customerName + o.getYearMonthLy() + activityTypeName + "\u7ed3\u6848\u6838\u9500";
                autoAudit.setAuditName(auditName);
                ArrayList customerDetailList = Lists.newArrayList();
                itemValue.forEach(detailPlanItem -> this.createecomDetailBean(customerDetailList, (GeneralExpensesVo)detailPlanItem, (PromotionPlanVo)detailList.get(0)));
                autoAudit.setAuditCustomerDetailList((List)customerDetailList);
                autoAuditList.add(autoAudit);
            });
        } else if (AuditDimensionalityEnum.ACTIVITY_FORM_MONTH.getCode().equals(configuration.getAuditDimensionality())) {
            Map<String, List<GeneralExpensesVo>> collect = canAutoAuditItemList.stream().filter(o -> CharSequenceUtil.isNotEmpty((CharSequence)o.getCustomerCode())).collect(Collectors.groupingBy(o -> o.getActivityFormCode() + o.getYearMonthLy()));
            collect.forEach((key, itemValue) -> {
                AutoAuditDto autoAudit = new AutoAuditDto();
                String customerName = this.getEcomValue(null, (List<GeneralExpensesVo>)itemValue, CUSTOMER_NAME_VALUE_KEY);
                String activityTypeName = this.getEcomValue(null, (List<GeneralExpensesVo>)itemValue, ACTIVITY_TYPE_NAME_KEY);
                String feeYearMonthly = this.getEcomValue(null, (List<GeneralExpensesVo>)itemValue, FEE_YEAR_MONTH_KEY);
                List<PromotionPlanVo> detailList = this.getPromotionPlan(promotionPlanVoList, (List<GeneralExpensesVo>)itemValue);
                autoAudit.setAuditDimensionality(configuration.getAuditDimensionality());
                autoAudit.setDimensionalityKey(key);
                this.autoEcomAuditPartBean(autoAudit, detailList, (List<GeneralExpensesVo>)itemValue);
                String auditName = customerName + feeYearMonthly + activityTypeName + "\u7ed3\u6848\u6838\u9500";
                autoAudit.setAuditName(auditName);
                ArrayList customerDetailList = new ArrayList();
                itemValue.forEach(detailPlanItem -> this.createecomDetailBean(customerDetailList, (GeneralExpensesVo)detailPlanItem, (PromotionPlanVo)detailList.get(0)));
                autoAudit.setAuditCustomerDetailList(customerDetailList);
                autoAuditList.add(autoAudit);
            });
        }
    }

    private void createecomDetailBean(List<AuditCustomerDetailDto> customerDetailList, GeneralExpensesVo detailPlanItem, PromotionPlanVo promotionPlanVo) {
        AuditCustomerDetailDto auditCustomerDetailDto = (AuditCustomerDetailDto)this.nebulaToolkitService.copyObjectByBlankList((Object)detailPlanItem, AuditCustomerDetailDto.class, null, null, new String[0]);
        auditCustomerDetailDto.setActivityDetailCode(detailPlanItem.getExpensesCode());
        auditCustomerDetailDto.setActivityCode(detailPlanItem.getPromotionPlanCode());
        auditCustomerDetailDto.setActivityName(detailPlanItem.getPromotionPlanName());
        auditCustomerDetailDto.setActivityBeginTime(detailPlanItem.getStartDate());
        auditCustomerDetailDto.setActivityEndTime(detailPlanItem.getEndDate());
        auditCustomerDetailDto.setSalesOrgCode(promotionPlanVo.getSalesOrgCode());
        auditCustomerDetailDto.setEndCaseCustomerCode(detailPlanItem.getCustomerCode());
        auditCustomerDetailDto.setEndCaseCustomerName(detailPlanItem.getCustomerName());
        if (StringUtils.isNotEmpty((CharSequence)detailPlanItem.getAuditWayCode())) {
            ArrayList<String> endCaseFormList = new ArrayList<String>();
            endCaseFormList.add(detailPlanItem.getAuditWayCode());
            auditCustomerDetailDto.setEndCaseFormList(endCaseFormList);
            auditCustomerDetailDto.setEndCaseForm(detailPlanItem.getAuditWayCode());
        }
        auditCustomerDetailDto.setIsPushSap(YesOrNoEnum.NO.getCode());
        customerDetailList.add(auditCustomerDetailDto);
    }

    private void autoEcomAuditPartBean(AutoAuditDto autoAudit, List<PromotionPlanVo> detailList, List<GeneralExpensesVo> itemValue) {
        String businessUnitCode = this.getEcomValue(detailList, null, BUSINESS_UNIT_CODE_KEY);
        String businessFormCode = this.getEcomValue(detailList, null, BUSINESS_FORMAT_CODE_KEY);
        autoAudit.setAutoAuditLock(YesOrNoEnum.YES.getCode());
        autoAudit.setBusinessUnitCode(businessUnitCode);
        autoAudit.setBusinessFormatCode(businessFormCode);
        autoAudit.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        autoAudit.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        autoAudit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        autoAudit.setIsCollection(Boolean.valueOf(true));
        List filterDetailList = itemValue.stream().filter(plan -> CharSequenceUtil.isNotBlank((CharSequence)plan.getOrgCode())).collect(Collectors.toList());
        List expensesCodes = filterDetailList.stream().map(ExpensesVo::getExpensesCode).collect(Collectors.toList());
        autoAudit.setExpensesCode(CharSequenceUtil.join((CharSequence)",", expensesCodes));
        List orgCodes = filterDetailList.stream().map(GeneralExpensesVo::getOrgCode).collect(Collectors.toList());
        List orgNames = filterDetailList.stream().map(GeneralExpensesVo::getOrgName).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(orgCodes)) {
            String orgCodeJoin = CollUtil.join(orgCodes, (CharSequence)",");
            autoAudit.setOrgCode(orgCodeJoin);
            autoAudit.setDepartmentCode(orgCodeJoin);
        }
        if (CollUtil.isNotEmpty(orgNames)) {
            String orgNameJoin = CollUtil.join(orgNames, (CharSequence)",");
            autoAudit.setOrgName(orgNameJoin);
            autoAudit.setDepartmentName(orgNameJoin);
        }
    }

    private String getEcomValue(List<PromotionPlanVo> list, List<GeneralExpensesVo> detailList, String valueType) {
        String resultValue = "";
        switch (valueType) {
            case "customer_name": {
                Optional<String> customerNameOptional = detailList.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getCustomerName())).map(ExpensesVo::getCustomerName).distinct().findFirst();
                if (!customerNameOptional.isPresent()) break;
                resultValue = customerNameOptional.get();
                break;
            }
            case "activity_type_name": {
                Optional<String> activityTypeNameOptional = detailList.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getActivityTypeName())).map(GeneralExpensesVo::getActivityTypeName).distinct().findFirst();
                if (!activityTypeNameOptional.isPresent()) break;
                resultValue = activityTypeNameOptional.get();
                break;
            }
            case "business_unit_code": {
                Optional<String> businessUnitCodeOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getBusinessUnitCode())).map(PromotionPlanVo::getBusinessUnitCode).distinct().findFirst();
                if (!businessUnitCodeOptional.isPresent()) break;
                resultValue = businessUnitCodeOptional.get();
                break;
            }
            case "business_format_code": {
                Optional<String> businessFormatCodeOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getBusinessFormatCode())).map(PromotionPlanVo::getBusinessFormatCode).distinct().findFirst();
                resultValue = businessFormatCodeOptional.isPresent() ? businessFormatCodeOptional.get() : "";
                break;
            }
            case "fee_year_month": {
                Optional<String> feeYearMonth = detailList.stream().map(GeneralExpensesVo::getYearMonthLy).findFirst();
                if (!feeYearMonth.isPresent()) break;
                resultValue = feeYearMonth.get();
            }
        }
        return resultValue;
    }

    private List<PromotionPlanVo> getPromotionPlan(List<PromotionPlanVo> promotionPlanVoList, List<GeneralExpensesVo> itemValue) {
        List promotionPlanCodes = itemValue.stream().map(ExpensesVo::getPromotionPlanCode).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(promotionPlanCodes)) {
            List<PromotionPlanVo> collect = promotionPlanVoList.stream().filter(o -> promotionPlanCodes.contains(o.getPromotionPlanCode())).collect(Collectors.toList());
            return collect;
        }
        return Lists.newArrayList();
    }

    private boolean isAutoAudit(AuditAutoConfigurationVo configuration, LocalDate now) {
        if (AutoAuditTimeTypeEnum.AUDIT.getCode().equals(configuration.getAutoAuditTimeType())) {
            return now.getDayOfMonth() == configuration.getAutoAuditTime().intValue();
        }
        return true;
    }

    private List<ActivityDetailPlanVo> getDetailPlanList(List<ActivityDetailPlanItemVo> itemValue, List<ActivityDetailPlanVo> detailPlanList) {
        List detailPlanCodes = itemValue.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getDetailPlanCode())).map(ActivityDetailPlanItemBase::getDetailPlanCode).distinct().collect(Collectors.toList());
        return detailPlanList.stream().filter(detailPlan -> detailPlanCodes.contains(detailPlan.getDetailPlanCode())).collect(Collectors.toList());
    }

    private List<String> getDepartmentName(List<ActivityDetailPlanVo> detailPlanList) {
        return detailPlanList.stream().filter(plan -> CharSequenceUtil.isNotBlank((CharSequence)plan.getDepartmentName())).map(ActivityDetailPlanBase::getDepartmentName).distinct().collect(Collectors.toList());
    }

    private List<String> getDepartmentCode(List<ActivityDetailPlanVo> detailPlanList) {
        return detailPlanList.stream().filter(plan -> CharSequenceUtil.isNotBlank((CharSequence)plan.getDepartmentCode())).map(ActivityDetailPlanBase::getDepartmentCode).distinct().collect(Collectors.toList());
    }

    private void autoAuditPartBean(List<ActivityDetailPlanItemVo> itemValue, List<ActivityDetailPlanVo> detailPlanList, AutoAuditDto autoAudit, AuditAutoConfigurationVo configuration) {
        autoAudit.setAuditCode(null);
        autoAudit.setAutoAuditLock(YesOrNoEnum.YES.getCode());
        autoAudit.setIsMuchCostCenter(YesOrNoEnum.NO.getCode());
        List<ActivityDetailPlanVo> detailPlanVoList = this.getDetailPlanList(itemValue, detailPlanList);
        List planCodes = detailPlanVoList.stream().map(ActivityDetailPlanBase::getDetailPlanCode).collect(Collectors.toList());
        autoAudit.setDetailPlanCode(CharSequenceUtil.join((CharSequence)",", planCodes));
        String businessUnitCode = detailPlanVoList.stream().filter(plan -> CharSequenceUtil.isNotBlank((CharSequence)plan.getBusinessUnitCode())).map(ActivityDetailPlanBase::getBusinessUnitCode).distinct().findFirst().orElse("");
        String businessFormCode = detailPlanVoList.stream().filter(plan -> CharSequenceUtil.isNotBlank((CharSequence)plan.getBusinessFormatCode())).map(ActivityDetailPlanBase::getBusinessFormatCode).distinct().findFirst().orElse("");
        autoAudit.setBusinessUnitCode(businessUnitCode);
        autoAudit.setBusinessFormatCode(businessFormCode);
        autoAudit.setWhetherSpeciallyApproved(YesOrNoEnum.NO.getCode());
        List<String> departmentNames = this.getDepartmentName(detailPlanVoList);
        List<String> departmentCodes = this.getDepartmentCode(detailPlanVoList);
        if (CollUtil.isNotEmpty(departmentCodes)) {
            String departmentCodeJoin = StringUtils.join(departmentCodes, (String)",");
            autoAudit.setDepartmentCode(departmentCodeJoin);
            autoAudit.setOrgCode(departmentCodeJoin);
            autoAudit.setOrgCode3(departmentCodes.get(0));
        }
        if (CollUtil.isNotEmpty(departmentNames)) {
            String departmentNameJoin = StringUtils.join(departmentNames, (String)",");
            autoAudit.setDepartmentName(departmentNameJoin);
            autoAudit.setOrgName(departmentNameJoin);
        }
        if (StringUtils.equals((CharSequence)businessFormCode, (CharSequence)BusinessFormatEnum.NORMAL.getCode()) && BusinessUnitEnum.isDefaultBusinessUnit((String)businessUnitCode)) {
            autoAudit.setCompanyCode("6000");
            autoAudit.setCompanyName("\u7ecf\u9500-\u5e38\u6e29-\u548c\u6797\u9500\u552e\u7ec4\u7ec7");
        }
        if (CharSequenceUtil.equals((CharSequence)businessUnitCode, (CharSequence)BusinessUnitEnum.VERTICAL.getCode())) {
            List salesOrgCodes;
            List topSalesList;
            String companyCode = "";
            String companyName = "";
            List activityOrgCodes = itemValue.stream().filter(item -> CharSequenceUtil.isNotEmpty((CharSequence)item.getActivityOrgCode())).map(ActivityDetailPlanItemBase::getActivityOrgCode).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(activityOrgCodes) && CollUtil.isNotEmpty(topSalesList = (salesOrgCodes = this.salesOrgVoService.findAllParentBySalesOrgCodes(activityOrgCodes)).stream().filter(item -> CharSequenceUtil.isEmpty((CharSequence)item.getParentCode())).collect(Collectors.toList()))) {
                SalesOrgVo salesOrgVo = (SalesOrgVo)topSalesList.get(0);
                companyCode = salesOrgVo.getErpCode();
                companyName = salesOrgVo.getSalesOrgName();
            }
            autoAudit.setCompanyCode(companyCode);
            autoAudit.setCompanyName(companyName);
        }
        autoAudit.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        autoAudit.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        autoAudit.setIsCollection(Boolean.valueOf(true));
        if (YesOrNoEnum.NO.getCode().equals(configuration.getAutoApprove())) {
            autoAudit.setSaveType(SaveTypeEnum.TEMPORARY_SAVE.getCode());
        } else if (YesOrNoEnum.YES.getCode().equals(configuration.getAutoApprove())) {
            autoAudit.setSaveType(SaveTypeEnum.SUBMIT.getCode());
        }
        autoAudit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    }

    private void customerAutoAuditHandle(List<AutoAuditDto> autoAuditList, List<ActivityDetailPlanItemVo> customerItemList, List<ActivityDetailPlanVo> detailPlanList, SimpleDateFormat format, AuditAutoConfigurationVo configuration) {
        if (CollUtil.isEmpty(customerItemList)) {
            return;
        }
        log.info("\u6839\u636e\u5ba2\u6237\u62c6\u5206+++++++++++++++++++++++");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String toDay = df.format(new Date());
        if (AuditDimensionalityEnum.ACTIVITY_DETAIL.getCode().equals(configuration.getAuditDimensionality())) {
            customerItemList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getCustomerCode())).forEach(o -> {
                AutoAuditDto autoAudit = new AutoAuditDto();
                ArrayList customerDetailList = Lists.newArrayList();
                ArrayList itemValue = Lists.newArrayList((Object[])new ActivityDetailPlanItemVo[]{o});
                String customerName = this.getValue(itemValue, CUSTOMER_NAME_VALUE_KEY);
                String activityTypeName = this.getValue(itemValue, ACTIVITY_TYPE_NAME_KEY);
                autoAudit.setAuditDimensionality(configuration.getAuditDimensionality());
                autoAudit.setDimensionalityKey(o.getDetailPlanItemCode());
                this.autoAuditPartBean(itemValue, detailPlanList, autoAudit, configuration);
                String auditName = customerName + format.format(o.getFeeYearMonth()) + activityTypeName + "\u7ed3\u6848\u6838\u9500";
                autoAudit.setAuditName(auditName);
                itemValue.forEach(detailPlanItem -> this.customerDetailCreate(customerDetailList, (ActivityDetailPlanItemVo)detailPlanItem, detailPlanList));
                autoAudit.setAuditCustomerDetailList((List)customerDetailList);
                autoAudit.setIsSplit(YesOrNoEnum.YES.getCode());
                autoAuditList.add(autoAudit);
            });
        } else if (AuditDimensionalityEnum.ACTIVITY_TYPE_CUSTOMER_MONTH.getCode().equals(configuration.getAuditDimensionality())) {
            Map<String, List<ActivityDetailPlanItemVo>> collect = customerItemList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getCustomerCode())).collect(Collectors.groupingBy(o -> o.getActivityTypeCode() + o.getCustomerCode() + format.format(o.getFeeYearMonth())));
            collect.forEach((key, value) -> {
                AutoAuditDto autoAudit = new AutoAuditDto();
                ArrayList customerDetailList = Lists.newArrayList();
                List itemValue = value;
                String customerName = this.getValue(itemValue, CUSTOMER_NAME_VALUE_KEY);
                String activityTypeName = this.getValue(itemValue, ACTIVITY_TYPE_NAME_KEY);
                String yearMonthLy = this.getValue(itemValue, FEE_YEAR_MONTH_KEY);
                autoAudit.setAuditDimensionality(configuration.getAuditDimensionality());
                autoAudit.setDimensionalityKey(key);
                this.autoAuditPartBean(itemValue, detailPlanList, autoAudit, configuration);
                String auditName = customerName + yearMonthLy + activityTypeName + "\u7ed3\u6848\u6838\u9500";
                autoAudit.setAuditName(auditName);
                itemValue.forEach(detailPlanItem -> this.customerDetailCreate(customerDetailList, (ActivityDetailPlanItemVo)detailPlanItem, detailPlanList));
                autoAudit.setAuditCustomerDetailList((List)customerDetailList);
                autoAuditList.add(autoAudit);
            });
        } else if (AuditDimensionalityEnum.TRADESMAN_REGION_MONTH.getCode().equals(configuration.getAuditDimensionality())) {
            Map<String, List<ActivityDetailPlanItemVo>> collect = customerItemList.stream().collect(Collectors.groupingBy(o -> o.getDetailPlanCode() + o.getSystemCode() + o.getRegion() + format.format(o.getFeeYearMonth())));
            collect.forEach((key, value) -> {
                AutoAuditDto autoAudit = new AutoAuditDto();
                ArrayList customerDetailList = Lists.newArrayList();
                List itemValue = value;
                String activityName = this.getActivityName(detailPlanList, itemValue);
                autoAudit.setAuditDimensionality(configuration.getAuditDimensionality());
                autoAudit.setDimensionalityKey(key);
                this.autoAuditPartBean(itemValue, detailPlanList, autoAudit, configuration);
                String auditName = configuration.getAuditAutoConfigCode() + activityName + toDay;
                autoAudit.setAuditName(auditName);
                itemValue.forEach(detailPlanItem -> this.customerDetailCreate(customerDetailList, (ActivityDetailPlanItemVo)detailPlanItem, detailPlanList));
                autoAudit.setAuditCustomerDetailList((List)customerDetailList);
                autoAudit.setIsSplit(YesOrNoEnum.YES.getCode());
                autoAuditList.add(autoAudit);
            });
        }
    }

    private String getActivityName(List<ActivityDetailPlanVo> detailPlanList, List<ActivityDetailPlanItemVo> itemValue) {
        if (CollectionUtils.isEmpty(itemValue)) {
            return null;
        }
        if (CollectionUtils.isEmpty(detailPlanList)) {
            return null;
        }
        ActivityDetailPlanItemVo itemVo = (ActivityDetailPlanItemVo)itemValue.stream().findFirst().get();
        ActivityDetailPlanVo activityDetailPlanVo = detailPlanList.stream().filter(o -> itemVo.getDetailPlanCode().equals(o.getDetailPlanCode())).findFirst().orElse(new ActivityDetailPlanVo());
        return activityDetailPlanVo.getDetailPlanName();
    }

    private void autoAuditDataDispose(List<AutoAuditDto> autoAuditList, List<ActivityDetailPlanItemVo> itemList, List<ActivityDetailPlanVo> detailPlanList, SimpleDateFormat format, AuditAutoConfigurationVo configuration) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        this.customerAutoAuditHandle(autoAuditList, itemList, detailPlanList, format, configuration);
    }

    private void customerDetailCreate(List<AuditCustomerDetailDto> customerDetailList, ActivityDetailPlanItemVo detailPlanItem, List<ActivityDetailPlanVo> activityDetailPlanList) {
        Map detailPlanMap = activityDetailPlanList.stream().filter(item -> CharSequenceUtil.isNotEmpty((CharSequence)item.getDetailPlanCode())).collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, Function.identity(), (newValue, oldValue) -> newValue));
        AuditCustomerDetailDto auditCustomerDetailDto = new AuditCustomerDetailDto();
        BeanUtils.copyProperties((Object)detailPlanItem, (Object)auditCustomerDetailDto);
        auditCustomerDetailDto.setRegion(detailPlanItem.getRegion());
        auditCustomerDetailDto.setActivityCode(detailPlanItem.getDetailPlanCode());
        auditCustomerDetailDto.setActivityName(detailPlanItem.getDetailPlanName());
        auditCustomerDetailDto.setActivityDetailCode(detailPlanItem.getDetailPlanItemCode());
        auditCustomerDetailDto.setActivityBeginTime(detailPlanItem.getActivityBeginDate());
        auditCustomerDetailDto.setActivityEndTime(detailPlanItem.getActivityEndDate());
        auditCustomerDetailDto.setStoreCode(detailPlanItem.getTerminalCode());
        auditCustomerDetailDto.setStoreName(detailPlanItem.getTerminalName());
        auditCustomerDetailDto.setSalesInstitutionCode(detailPlanItem.getSalesInstitutionCode());
        auditCustomerDetailDto.setSalesInstitutionName(detailPlanItem.getSalesInstitutionName());
        auditCustomerDetailDto.setSalesRegionName(detailPlanItem.getSalesRegionName());
        auditCustomerDetailDto.setSalesRegionCode(detailPlanItem.getSalesRegionCode());
        auditCustomerDetailDto.setSalesOrgCode(detailPlanItem.getSalesOrgCode());
        auditCustomerDetailDto.setSalesOrgName(detailPlanItem.getSalesOrgName());
        auditCustomerDetailDto.setEndCaseCustomerCode(detailPlanItem.getCustomerCode());
        auditCustomerDetailDto.setEndCaseCustomerName(detailPlanItem.getCustomerName());
        auditCustomerDetailDto.setWholeAudit(YesOrNoEnum.YES.getCode());
        if (StringUtils.isNotEmpty((CharSequence)detailPlanItem.getAuditForm())) {
            ArrayList<String> endCaseFormList = new ArrayList<String>();
            endCaseFormList.add(detailPlanItem.getAuditForm());
            auditCustomerDetailDto.setEndCaseFormList(endCaseFormList);
            auditCustomerDetailDto.setEndCaseForm(detailPlanItem.getAuditForm());
        }
        auditCustomerDetailDto.setApplyAmount(detailPlanItem.getFeeAmount());
        String detailPlanCode = detailPlanItem.getDetailPlanCode();
        ActivityDetailPlanVo activityDetailPlanVo = (ActivityDetailPlanVo)detailPlanMap.get(detailPlanCode);
        String businessUnitCode = activityDetailPlanVo.getBusinessUnitCode();
        if (BusinessUnitEnum.VERTICAL.getCode().equals(businessUnitCode) && ActivityPlanWhereFrom.KMS.getCode().equals(activityDetailPlanVo.getWhereFrom())) {
            auditCustomerDetailDto.setThisAuditAmount(auditCustomerDetailDto.getApplyAmount());
        } else {
            BigDecimal decimal = this.activityDetailPlanItemSdkService.findByCode(detailPlanItem.getDetailPlanItemCode());
            detailPlanItem.setEstimatedWriteOffAmount(decimal);
            BigDecimal estimatedWriteOffAmount = detailPlanItem.getEstimatedWriteOffAmount();
            estimatedWriteOffAmount = ObjectUtil.isNull((Object)estimatedWriteOffAmount) ? BigDecimal.ZERO : estimatedWriteOffAmount;
            BigDecimal alreadyAuditAmount = detailPlanItem.getAlreadyAuditAmount();
            alreadyAuditAmount = ObjectUtil.isNull((Object)alreadyAuditAmount) ? BigDecimal.ZERO : alreadyAuditAmount;
            auditCustomerDetailDto.setThisAuditAmount(estimatedWriteOffAmount.subtract(alreadyAuditAmount));
            auditCustomerDetailDto.setAuditAmount(decimal);
        }
        String auditForm = detailPlanItem.getAuditForm();
        auditCustomerDetailDto.setEndCaseForm(auditForm);
        if (CharSequenceUtil.isNotEmpty((CharSequence)auditForm)) {
            String[] split;
            boolean flag = CharSequenceUtil.contains((CharSequence)auditForm, (CharSequence)EndCaseFormEnum.DISCOUNT.getCode());
            if (flag) {
                auditCustomerDetailDto.setIsPushSap(YesOrNoEnum.YES.getCode());
            }
            if ((split = auditForm.split(",")).length == 1 && CharSequenceUtil.equals((CharSequence)EndCaseFormEnum.DISCOUNT.getCode(), (CharSequence)auditForm)) {
                auditCustomerDetailDto.setDiscountTaxAmount(auditCustomerDetailDto.getThisAuditAmount());
            } else if (split.length == 1 && CharSequenceUtil.equals((CharSequence)EndCaseFormEnum.REIMBURSE.getCode(), (CharSequence)auditForm)) {
                auditCustomerDetailDto.setReimburseTaxAmount(auditCustomerDetailDto.getThisAuditAmount());
            } else if (split.length == 2 && CharSequenceUtil.contains((CharSequence)auditForm, (CharSequence)EndCaseFormEnum.DISCOUNT.getCode()) && CharSequenceUtil.contains((CharSequence)auditForm, (CharSequence)EndCaseFormEnum.REIMBURSE.getCode())) {
                auditCustomerDetailDto.setDiscountAmount(BigDecimal.ZERO);
                auditCustomerDetailDto.setReimburseTaxAmount(BigDecimal.ZERO);
            }
        }
        auditCustomerDetailDto.setDiscountAmount(auditCustomerDetailDto.getDiscountTaxAmount());
        auditCustomerDetailDto.setIsDeductionFeePool(detailPlanItem.getIsDeductionFeePool());
        auditCustomerDetailDto.setEndCaseHeadFeeAmount(detailPlanItem.getAlreadyEndCaseHeadFeeAmount());
        auditCustomerDetailDto.setEndCaseDepartmentFeeAmount(detailPlanItem.getAlreadyEndCaseDepartmentFeeAmount());
        auditCustomerDetailDto.setEndCaseIntraCompanyAmount(detailPlanItem.getIntraCompanyAmount());
        auditCustomerDetailDto.setEndCaseOffPointAmount(detailPlanItem.getOffPointAmount());
        auditCustomerDetailDto.setOrgCode2(activityDetailPlanVo.getDepartmentCode());
        auditCustomerDetailDto.setOrgName2(activityDetailPlanVo.getDepartmentName());
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)businessUnitCode)) {
            if (Objects.nonNull(auditCustomerDetailDto.getDepartmentFeeAmount()) && (Objects.isNull(auditCustomerDetailDto.getHeadFeeAmount()) || auditCustomerDetailDto.getHeadFeeAmount().compareTo(BigDecimal.ZERO) == 0)) {
                auditCustomerDetailDto.setEndCaseDepartmentFeeAmount(auditCustomerDetailDto.getDepartmentFeeAmount());
            }
            if (Objects.nonNull(auditCustomerDetailDto.getHeadFeeAmount()) && (Objects.isNull(auditCustomerDetailDto.getDepartmentFeeAmount()) || auditCustomerDetailDto.getDepartmentFeeAmount().compareTo(BigDecimal.ZERO) == 0)) {
                auditCustomerDetailDto.setEndCaseHeadFeeAmount(auditCustomerDetailDto.getHeadFeeAmount());
            }
            if (Objects.nonNull(auditCustomerDetailDto.getDepartmentFeeAmount()) && auditCustomerDetailDto.getDepartmentFeeAmount().compareTo(BigDecimal.ZERO) != 0 && Objects.nonNull(auditCustomerDetailDto.getHeadFeeAmount()) && auditCustomerDetailDto.getHeadFeeAmount().compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal totalAmount = auditCustomerDetailDto.getDepartmentFeeAmount().add(auditCustomerDetailDto.getHeadFeeAmount());
                auditCustomerDetailDto.setEndCaseDepartmentFeeAmount(auditCustomerDetailDto.getDepartmentFeeAmount().divide(totalAmount, 6, RoundingMode.HALF_UP).multiply(totalAmount).setScale(2, RoundingMode.HALF_UP));
                auditCustomerDetailDto.setEndCaseHeadFeeAmount(totalAmount.subtract(auditCustomerDetailDto.getEndCaseDepartmentFeeAmount()));
            }
        }
        customerDetailList.add(auditCustomerDetailDto);
    }

    private String getValue(List<ActivityDetailPlanItemVo> list, String codeType) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        String resultValue = "";
        switch (codeType) {
            case "supplier_name": {
                Optional supplierNameOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getSupplierName())).map(ActivityDetailPlanItemBase::getSupplierName).distinct().collect(Collectors.toList()).stream().findFirst();
                if (!supplierNameOptional.isPresent()) break;
                resultValue = (String)supplierNameOptional.get();
                break;
            }
            case "business_unit_code": {
                Optional businessUnitCodeOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getBusinessUnitCode())).map(ActivityDetailPlanItemVo::getBusinessUnitCode).distinct().collect(Collectors.toList()).stream().findFirst();
                if (!businessUnitCodeOptional.isPresent()) break;
                resultValue = (String)businessUnitCodeOptional.get();
                break;
            }
            case "business_format_code": {
                Optional businessFormatCodeOptional = list.stream().map(ActivityDetailPlanItemVo::getBusinessFormatCode).distinct().collect(Collectors.toList()).stream().findFirst();
                if (!businessFormatCodeOptional.isPresent()) break;
                resultValue = (String)businessFormatCodeOptional.get();
                break;
            }
            case "customer_name": {
                Optional customerNameOptional = list.stream().map(ActivityDetailPlanItemBase::getCustomerName).distinct().collect(Collectors.toList()).stream().findFirst();
                if (!customerNameOptional.isPresent()) break;
                resultValue = (String)customerNameOptional.get();
                break;
            }
            case "activity_type_name": {
                Optional activityTypeNameOptional = list.stream().map(ActivityDetailPlanItemBase::getActivityTypeName).distinct().collect(Collectors.toList()).stream().findFirst();
                if (!activityTypeNameOptional.isPresent()) break;
                resultValue = (String)activityTypeNameOptional.get();
                break;
            }
            case "fee_year_month": {
                Optional<Date> first = list.stream().map(ActivityDetailPlanItemBase::getFeeYearMonth).filter(Objects::nonNull).distinct().findFirst();
                if (!first.isPresent()) break;
                resultValue = df.format(first.get());
                break;
            }
        }
        return resultValue;
    }

    private List<ActivityDetailPlanVo> findDetailPlanCode(List<ActivityDetailPlanItemVo> list) {
        List detailPlanCodes = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getDetailPlanCode())).map(ActivityDetailPlanItemBase::getDetailPlanCode).distinct().collect(Collectors.toList());
        return this.activityDetailPlanSdkService.findActivityDetailPlanByCodes(detailPlanCodes);
    }

    private void autoAuditHandle(List<AutoAuditDto> autoAuditList, List<ActivityDetailPlanItemVo> canAutoAuditItemList, List<ActivityDetailPlanVo> detailPlanList, SimpleDateFormat dateFormat, AuditAutoConfigurationVo configuration) {
        List detailPlanCodes = canAutoAuditItemList.stream().map(ActivityDetailPlanItemBase::getDetailPlanCode).collect(Collectors.toList());
        List detailPlanVoList = detailPlanList.stream().filter(plan -> detailPlanCodes.contains(plan.getDetailPlanCode())).collect(Collectors.toList());
        log.info("\u53ef\u6838\u9500\u6570\u636edetailPlan:{}", (Object)JSONUtil.toJsonStr(detailPlanVoList));
        this.autoAuditDataDispose(autoAuditList, canAutoAuditItemList, detailPlanList, dateFormat, configuration);
    }

    private void autoAuditBodyHandle(AuditAutoConfigurationVo configuration, AutoAuditParamsDto autoAuditParams, SimpleDateFormat dateFormat) {
        Page pageResult;
        if (!BusinessUnitEnum.isDefaultBusinessUnit((String)configuration.getBusinessUnitCode()) && !BusinessUnitEnum.VERTICAL.getCode().equals(configuration.getBusinessUnitCode())) {
            return;
        }
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)configuration.getBusinessUnitCode())) {
            autoAuditParams.setIsClose(YesOrNoEnum.NO.getCode());
        }
        if (BusinessUnitEnum.VERTICAL.getCode().equals(configuration.getBusinessUnitCode())) {
            autoAuditParams.setRollbackBudgetTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
        }
        HashSet<String> setActivityPlanCodes = new HashSet<String>();
        ArrayList<AutoAuditDto> autoAuditList = new ArrayList<AutoAuditDto>();
        PageRequest pageable = PageRequest.of((int)1, (int)2000);
        do {
            List canAutoAuditItemList;
            if (CollUtil.isNotEmpty((Collection)(canAutoAuditItemList = (pageResult = this.activityDetailPlanItemSdkService.findCanAutoAuditItemPage((Pageable)pageable, autoAuditParams)).getRecords()))) {
                log.info("\u6d3b\u52a8\u7ec6\u6848\u67e5\u8be2\u6570\u91cf:{}", (Object)canAutoAuditItemList.size());
                List<ActivityDetailPlanVo> detailPlanList = this.findDetailPlanCode(canAutoAuditItemList);
                this.autoAuditHandle(autoAuditList, canAutoAuditItemList, detailPlanList, dateFormat, configuration);
                this.executeAutoAudit(autoAuditList, setActivityPlanCodes);
                autoAuditList.clear();
            } else {
                log.error("=====>   \u53c2\u6570[{}]\u672a\u67e5\u8be2\u5230\u9700\u8981\u81ea\u52a8\u6838\u9500\u7684\u6570\u636e   <=====", (Object)JSON.toJSONString((Object)autoAuditParams));
            }
            log.info("\u81ea\u52a8\u6838\u9500\u6b63\u5728\u67e5\u8be2\u4e3b\u4f53\u5782\u76f4\u672a\u7ed3\u6848\u7684\u7ec6\u6848\u660e\u7ec6\u6570\u636e \u5f53\u524d\u8fdb\u5ea6[{}/{}]\u5171{}\u6761\u6570\u636e", new Object[]{pageResult.getCurrent(), pageResult.getPages(), pageResult.getTotal()});
            pageable = pageable.next();
        } while (pageResult.hasNext());
        List partition = Lists.partition(new ArrayList<String>(setActivityPlanCodes), (int)2000);
        partition.forEach(item -> this.activityDetailPlanSdkService.updateAutoAuditFlag(item, BooleanEnum.TRUE.getCapital()));
        setActivityPlanCodes.clear();
        this.autoApproved(configuration);
    }

    private void autoApproved(AuditAutoConfigurationVo configuration) {
        List auditCodes;
        if (YesOrNoEnum.YES.getCode().equals(configuration.getAutoApprove()) && CollectionUtil.isNotEmpty((Collection)(auditCodes = this.auditService.getAuditByLock()))) {
            try {
                log.info("\u81ea\u52a8\u7ed3\u6848\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7\uff0cauditCodes:{}", (Object)JsonUtils.obj2JsonString((Object)auditCodes));
                this.auditProcess.autoPassAudit(auditCodes);
            }
            catch (Exception e) {
                log.error("\u81ea\u52a8\u7ed3\u6848\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7\uff0c\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        this.auditService.updateAutoAuditLock();
    }

    private void baseBuildAutoAuditInfo(AuditAutoConfigurationVo configuration, AutoAuditParamsDto autoAuditParams, String yearMonthly, LocalDate now) {
        String activityTypeCode;
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        List<Object> salesOrgCodeList = new ArrayList();
        List<Object> activityTypeCodeList = new ArrayList();
        List<Object> activityFormCodeList = new ArrayList();
        String salesOrgCode = configuration.getSalesOrgCode();
        if (StringUtils.isNotEmpty((CharSequence)salesOrgCode) && CollectionUtil.isNotEmpty(salesOrgCodeList = Arrays.stream(salesOrgCode.split(",")).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList()))) {
            Set salesOrgCodeVoList;
            HashSet salesOrgCodeSet = new HashSet(salesOrgCodeList);
            List salesOrgVoList = this.salesOrgVoService.findAllChildrenBySalesOrgCodes(salesOrgCodeList);
            if (CollUtil.isNotEmpty((Collection)salesOrgVoList) && CollUtil.isNotEmpty(salesOrgCodeVoList = salesOrgVoList.stream().filter(org -> StringUtils.isNotBlank((CharSequence)org.getSalesOrgCode())).map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toSet()))) {
                salesOrgCodeSet.addAll(salesOrgCodeVoList);
            }
            autoAuditParams.setSalesOrgCodes(new ArrayList(salesOrgCodeSet));
        }
        if (StringUtils.isNotEmpty((CharSequence)(activityTypeCode = configuration.getActivityTypeCode()))) {
            activityTypeCodeList = Arrays.stream(activityTypeCode.split(",")).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        }
        autoAuditParams.setActivityTypeCodes(activityTypeCodeList);
        String activityFormCode = configuration.getActivityFormCode();
        if (StringUtils.isNotEmpty((CharSequence)activityFormCode)) {
            activityFormCodeList = Arrays.stream(activityFormCode.split(",")).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        }
        autoAuditParams.setActivityFormCodes(activityFormCodeList);
        autoAuditParams.setEndCaseForm(configuration.getEndCaseForm());
        autoAuditParams.setAuditMethod(configuration.getAuditMethod());
        autoAuditParams.setWholeAudit(YesOrNoEnum.YES.getCode());
        autoAuditParams.setAutoAudit(YesOrNoEnum.YES.getCode());
        autoAuditParams.setBusinessUnitCode(configuration.getBusinessUnitCode());
        autoAuditParams.setBusinessFormatCode(configuration.getBusinessFormatCode());
        autoAuditParams.setWriteOffMethod(configuration.getWriteOffMethod());
        autoAuditParams.setActivitySource(configuration.getActivitySource());
        autoAuditParams.setActivityTemplate(configuration.getActivityTemplate());
        autoAuditParams.setAutoAuditTimeType(configuration.getAutoAuditTimeType());
        autoAuditParams.setAutoAuditTime(configuration.getAutoAuditTime());
        autoAuditParams.setAutoApprove(configuration.getAutoApprove());
        String systemCode = configuration.getSystemCode();
        if (StringUtils.isNotEmpty((CharSequence)systemCode)) {
            autoAuditParams.setSystemCodes(Arrays.asList(systemCode.split(",")));
        }
        if (AutoAuditTimeTypeEnum.AUDIT.getCode().equals(configuration.getAutoAuditTimeType())) {
            autoAuditParams.setYearMonthly(yearMonthly);
        }
        if (AutoAuditTimeTypeEnum.ORDER.getCode().equals(configuration.getAutoAuditTimeType()) || AutoAuditTimeTypeEnum.ACTIVITY.getCode().equals(configuration.getAutoAuditTimeType())) {
            autoAuditParams.setYearMonthDayly(dtf.format(now));
        }
    }

    private void moleculeAutoAuditHandle(AuditAutoConfigurationVo configuration, AutoAuditParamsDto autoAuditParams, SimpleDateFormat dateFormat) {
        Page pageResult;
        if (!CharSequenceUtil.equals((CharSequence)BusinessUnitEnum.SON_COMPANY.getCode(), (CharSequence)configuration.getBusinessUnitCode())) {
            return;
        }
        autoAuditParams.setCloseTag(ActivityDetailPlanRollbackBudgetEnum.ALL_ROLLBACK.getCode());
        ArrayList autoAuditList = Lists.newArrayList();
        HashSet<String> setActivityPlanCodes = new HashSet<String>();
        PageRequest pageable = PageRequest.of((int)1, (int)2000);
        do {
            List canAutoAuditItemList;
            if (CollUtil.isNotEmpty((Collection)(canAutoAuditItemList = (pageResult = this.subComActivityDetailPlanItemVoService.findCanAutoAuditSubComItemPage((Pageable)pageable, autoAuditParams)).getRecords()))) {
                log.info("\u6d3b\u52a8\u7ec6\u6848\u67e5\u8be2\u6570\u91cf:{}", (Object)canAutoAuditItemList.size());
                if (CollUtil.isEmpty((Collection)canAutoAuditItemList)) {
                    log.error("=====>   \u53c2\u6570[{}]\u672a\u67e5\u8be2\u5230\u9700\u8981\u81ea\u52a8\u6838\u9500\u7684\u6570\u636e   <=====", (Object)JSON.toJSONString((Object)autoAuditParams));
                    continue;
                }
                log.info("\u6d3b\u52a8\u7ec6\u6848\u67e5\u8be2\u6570\u91cf:{}", (Object)canAutoAuditItemList.size());
                this.subComHandle(canAutoAuditItemList, autoAuditList, dateFormat, configuration);
                this.executeAutoAudit(autoAuditList, setActivityPlanCodes);
                autoAuditList.clear();
            } else {
                log.error("=====>   \u53c2\u6570[{}]\u672a\u67e5\u8be2\u5230\u9700\u8981\u81ea\u52a8\u6838\u9500\u7684\u6570\u636e   <=====", (Object)JSON.toJSONString((Object)autoAuditParams));
            }
            log.info("\u81ea\u52a8\u6838\u9500\u6b63\u5728\u67e5\u8be2\u5206\u5b50\u516c\u53f8\u672a\u7ed3\u6848\u7684\u7ec6\u6848\u660e\u7ec6\u6570\u636e \u5f53\u524d\u8fdb\u5ea6[{}/{}]\u5171{}\u6761\u6570\u636e", new Object[]{pageResult.getCurrent(), pageResult.getPages(), pageResult.getTotal()});
            pageable = pageable.next();
        } while (pageResult.hasNext());
        List partition = Lists.partition(new ArrayList(setActivityPlanCodes), (int)2000);
        partition.forEach(item -> this.subComActivityDetailPlanVoService.updateSubComAutoAudit(item, BooleanEnum.TRUE.getCapital()));
        setActivityPlanCodes.clear();
        this.autoApproved(configuration);
    }

    private void subComHandle(List<SubComActivityDetailPlanItemVo> itemList, List<AutoAuditDto> autoAuditList, SimpleDateFormat dateFormat, AuditAutoConfigurationVo configuration) {
        List detailPlanCodes = itemList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanCode).distinct().collect(Collectors.toList());
        List subComActivityDetailPlanList = this.subComActivityDetailPlanVoService.findDetailByPlanCodeList(detailPlanCodes);
        this.subComCustomerSplit(autoAuditList, itemList, subComActivityDetailPlanList, dateFormat, configuration);
    }

    private void subComCustomerSplit(List<AutoAuditDto> autoAuditList, List<SubComActivityDetailPlanItemVo> supplierCustomerList, List<SubComActivityDetailPlanVo> subComActivityDetailPlanList, SimpleDateFormat dateFormat, AuditAutoConfigurationVo configuration) {
        if (CollUtil.isEmpty(supplierCustomerList)) {
            return;
        }
        List<String> itemCodes = supplierCustomerList.stream().map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode).collect(Collectors.toList());
        List<SubComActivityDetailPlanItemBudgetShareVo> itemBudgetShareVoList = this.findInOutSelfByItemCodes(itemCodes);
        if (AuditDimensionalityEnum.ACTIVITY_DETAIL.getCode().equals(configuration.getAuditDimensionality())) {
            supplierCustomerList.stream().filter(o -> CharSequenceUtil.isNotEmpty((CharSequence)o.getCustomerCode())).forEach(o -> {
                AutoAuditDto autoAudit = new AutoAuditDto();
                ArrayList itemValue = Lists.newArrayList((Object[])new SubComActivityDetailPlanItemVo[]{o});
                List<SubComActivityDetailPlanVo> detailList = this.getSubComDetailPlan(subComActivityDetailPlanList, itemValue);
                autoAudit.setAuditDimensionality(configuration.getAuditDimensionality());
                autoAudit.setDimensionalityKey(o.getConstituentDetailPlanItemCode());
                this.autoAuditPartBean(autoAudit, detailList, itemValue);
                String auditName = detailList.get(0).getConstituentDetailPlanName() + configuration.getAuditAutoConfigCode() + dateFormat.format(o.getFeeYearMonth()) + "-\u81ea\u52a8\u6838\u9500";
                autoAudit.setAuditName(auditName);
                ArrayList customerDetailList = Lists.newArrayList();
                itemValue.forEach(detailPlanItem -> this.createSubComDetailBean(customerDetailList, (SubComActivityDetailPlanItemVo)detailPlanItem, itemBudgetShareVoList));
                autoAudit.setAuditCustomerDetailList((List)customerDetailList);
                autoAudit.setIsSplit(YesOrNoEnum.YES.getCode());
                autoAuditList.add(autoAudit);
            });
        } else if (AuditDimensionalityEnum.ACTIVITY_TYPE_CUSTOMER_MONTH.getCode().equals(configuration.getAuditDimensionality())) {
            Map<String, List<SubComActivityDetailPlanItemVo>> collect = supplierCustomerList.stream().filter(o -> CharSequenceUtil.isNotEmpty((CharSequence)o.getCustomerCode())).collect(Collectors.groupingBy(o -> this.lastFourChar(o.getSalesInstitutionCode()) + o.getActivityType() + o.getCustomerCode() + dateFormat.format(o.getFeeYearMonth())));
            collect.forEach((key, itemValue) -> {
                AutoAuditDto autoAudit = new AutoAuditDto();
                String customerName = this.getSubComValue((List<SubComActivityDetailPlanItemVo>)itemValue, CUSTOMER_NAME_VALUE_KEY);
                String activityTypeName = this.getSubComValue((List<SubComActivityDetailPlanItemVo>)itemValue, ACTIVITY_TYPE_NAME_KEY);
                String feeYearMonthly = this.getSubComValue((List<SubComActivityDetailPlanItemVo>)itemValue, FEE_YEAR_MONTH_KEY);
                List<SubComActivityDetailPlanVo> detailList = this.getSubComDetailPlan(subComActivityDetailPlanList, (List<SubComActivityDetailPlanItemVo>)itemValue);
                autoAudit.setAuditDimensionality(configuration.getAuditDimensionality());
                autoAudit.setDimensionalityKey(key);
                this.autoAuditPartBean(autoAudit, detailList, (List<SubComActivityDetailPlanItemVo>)itemValue);
                String auditName = "\u4e8b\u4e2d\u81ea\u52a8\u7ed3\u6848" + activityTypeName + configuration.getAuditAutoConfigCode() + customerName + feeYearMonthly;
                autoAudit.setAuditName(auditName);
                ArrayList customerDetailList = new ArrayList();
                itemValue.forEach(detailPlanItem -> this.createSubComDetailBean(customerDetailList, (SubComActivityDetailPlanItemVo)detailPlanItem, itemBudgetShareVoList));
                autoAudit.setAuditCustomerDetailList(customerDetailList);
                autoAuditList.add(autoAudit);
            });
        }
    }

    private List<SubComActivityDetailPlanItemBudgetShareVo> findInOutSelfByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            return Lists.newArrayList();
        }
        return this.subComActivityDetailPlanVoService.findInOutSelfByItemCodes(itemCodes);
    }

    private String lastFourChar(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        return str.substring(str.length() - 4);
    }

    private void createSubComDetailBean(List<AuditCustomerDetailDto> customerDetailList, SubComActivityDetailPlanItemVo subComItem, List<SubComActivityDetailPlanItemBudgetShareVo> itemBudgetShareVoList) {
        Map<String, List<SubComActivityDetailPlanItemBudgetShareVo>> map;
        List<SubComActivityDetailPlanItemBudgetShareVo> budgetShareVos;
        AuditCustomerDetailDto auditCustomerDetailDto = (AuditCustomerDetailDto)this.nebulaToolkitService.copyObjectByBlankList((Object)subComItem, AuditCustomerDetailDto.class, null, null, new String[0]);
        String constituentDetailPlanItemCode = subComItem.getConstituentDetailPlanItemCode();
        auditCustomerDetailDto.setActivityDetailCode(constituentDetailPlanItemCode);
        auditCustomerDetailDto.setActivityCode(subComItem.getConstituentDetailPlanCode());
        auditCustomerDetailDto.setActivityName(subComItem.getConstituentDetailPlanName());
        auditCustomerDetailDto.setActivityTypeCode(subComItem.getActivityType());
        auditCustomerDetailDto.setSalesOrgCode(subComItem.getSalesInstitutionCode());
        auditCustomerDetailDto.setProductBrandCode(subComItem.getProductBrandCode());
        auditCustomerDetailDto.setEndCaseCustomerCode(subComItem.getCustomerCode());
        auditCustomerDetailDto.setEndCaseCustomerName(subComItem.getCustomerName());
        auditCustomerDetailDto.setWholeAudit(YesOrNoEnum.YES.getCode());
        BigDecimal decimal = this.subComActivityDetailPlanVoService.findEstimatedWriteOffAmountByItemCode(subComItem.getConstituentDetailPlanItemCode());
        BigDecimal estimatedWriteOffAmount = ObjectUtil.isNull((Object)decimal) ? BigDecimal.ZERO : decimal;
        BigDecimal alreadyAuditAmount = subComItem.getAlreadyAuditAmount();
        alreadyAuditAmount = ObjectUtil.isNull((Object)alreadyAuditAmount) ? BigDecimal.ZERO : alreadyAuditAmount;
        auditCustomerDetailDto.setThisAuditAmount(estimatedWriteOffAmount.subtract(alreadyAuditAmount));
        auditCustomerDetailDto.setIsPushSap(YesOrNoEnum.YES.getCode());
        if (StringUtils.isNotEmpty((CharSequence)subComItem.getAuditForm())) {
            ArrayList<String> endCaseFormList = new ArrayList<String>();
            endCaseFormList.add(subComItem.getAuditForm());
            auditCustomerDetailDto.setEndCaseFormList(endCaseFormList);
            auditCustomerDetailDto.setEndCaseForm(subComItem.getAuditForm());
            if (endCaseFormList.contains(EndCaseFormEnum.DISCOUNT.getCode()) && endCaseFormList.size() == 1) {
                auditCustomerDetailDto.setDiscountTaxRate("0");
                auditCustomerDetailDto.setDiscountTaxAmount(auditCustomerDetailDto.getThisAuditAmount());
            }
            if (endCaseFormList.contains(EndCaseFormEnum.REIMBURSE.getCode()) && endCaseFormList.size() == 1) {
                auditCustomerDetailDto.setReimburseTaxRate("0");
                auditCustomerDetailDto.setReimburseTaxAmount(auditCustomerDetailDto.getThisAuditAmount());
            }
            if (endCaseFormList.contains(EndCaseFormEnum.WITH_ORDER.getCode())) {
                auditCustomerDetailDto.setIsPushSap(YesOrNoEnum.NO.getCode());
            }
        }
        auditCustomerDetailDto.setApplyAmount(subComItem.getTotalCost());
        if (CollectionUtils.isNotEmpty(itemBudgetShareVoList) && org.apache.commons.collections.CollectionUtils.isNotEmpty(budgetShareVos = (map = itemBudgetShareVoList.stream().collect(Collectors.groupingBy(SubComActivityDetailPlanItemBudgetShareVo::getConstituentDetailPlanItemCode))).get(subComItem.getConstituentDetailPlanItemCode())) && budgetShareVos.size() > 0) {
            SubComActivityDetailPlanItemBudgetShareVo subComActivityDetailPlanItemBudgetShareVo = budgetShareVos.get(0);
            auditCustomerDetailDto.setExtraBudgetaryAmount(subComActivityDetailPlanItemBudgetShareVo.getExtraBudgetaryAmount());
            auditCustomerDetailDto.setInternalBudgetAmount(subComActivityDetailPlanItemBudgetShareVo.getInternalBudgetAmount());
            auditCustomerDetailDto.setSelfInvestedBudgetAmount(subComActivityDetailPlanItemBudgetShareVo.getSelfInvestedBudgetAmount());
            auditCustomerDetailDto.setInPointBudget(subComActivityDetailPlanItemBudgetShareVo.getInPointBudget());
            auditCustomerDetailDto.setInPointBudgetItems(subComActivityDetailPlanItemBudgetShareVo.getInPointBudgetItems());
            auditCustomerDetailDto.setOffPointBudget(subComActivityDetailPlanItemBudgetShareVo.getOffPointBudget());
            auditCustomerDetailDto.setOffPointBudgetItems(subComActivityDetailPlanItemBudgetShareVo.getOffPointBudgetItems());
            auditCustomerDetailDto.setSelfInvestmentBudget(subComActivityDetailPlanItemBudgetShareVo.getSelfInvestmentBudget());
            auditCustomerDetailDto.setSelfInvestedBudgetItems(subComActivityDetailPlanItemBudgetShareVo.getSelfInvestedBudgetItems());
        }
        customerDetailList.add(auditCustomerDetailDto);
    }

    private void autoAuditPartBean(AutoAuditDto autoAudit, List<SubComActivityDetailPlanVo> detailPlanList, List<SubComActivityDetailPlanItemVo> itemList) {
        String businessUnitCode = this.getSubComValue(itemList, BUSINESS_UNIT_CODE_KEY);
        String businessFormCode = this.getSubComValue(itemList, BUSINESS_FORMAT_CODE_KEY);
        autoAudit.setAutoAuditLock(YesOrNoEnum.YES.getCode());
        autoAudit.setBusinessUnitCode(businessUnitCode);
        autoAudit.setBusinessFormatCode(businessFormCode);
        autoAudit.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
        autoAudit.setEndCaseType(EndCaseTypeEnum.CUSTOMER.getCode());
        autoAudit.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        autoAudit.setIsCollection(Boolean.valueOf(true));
        List filterSubComActivityDetailPlans = detailPlanList.stream().filter(plan -> CharSequenceUtil.isNotBlank((CharSequence)plan.getOrgCode())).collect(Collectors.toList());
        List constituentDetailPlanCodes = filterSubComActivityDetailPlans.stream().map(SubComActivityDetailPlanVo::getConstituentDetailPlanCode).collect(Collectors.toList());
        autoAudit.setConstitunetDetailPlanCode(CharSequenceUtil.join((CharSequence)",", constituentDetailPlanCodes));
        List orgCodes = filterSubComActivityDetailPlans.stream().map(SubComActivityDetailPlanVo::getOrgCode).collect(Collectors.toList());
        List orgNames = filterSubComActivityDetailPlans.stream().map(SubComActivityDetailPlanVo::getOrgName).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(itemList)) {
            autoAudit.setCompanyCode(this.lastFourChar(itemList.get(0).getSalesInstitutionCode()));
            autoAudit.setCompanyName(itemList.get(0).getSalesInstitutionName());
            autoAudit.setChannelCode(itemList.stream().map(SubComActivityDetailPlanItemVo::getDistributionChannelCode).distinct().collect(Collectors.joining(",")));
            autoAudit.setChannelName(itemList.stream().map(SubComActivityDetailPlanItemVo::getDistributionChannelName).distinct().collect(Collectors.joining(",")));
        }
        if (CollUtil.isNotEmpty(orgCodes)) {
            String orgCodeJoin = CollUtil.join(orgCodes, (CharSequence)",");
            autoAudit.setOrgCode(orgCodeJoin);
            autoAudit.setDepartmentCode(orgCodeJoin);
        }
        if (CollUtil.isNotEmpty(orgNames)) {
            String orgNameJoin = CollUtil.join(orgNames, (CharSequence)",");
            autoAudit.setOrgName(orgNameJoin);
            autoAudit.setDepartmentName(orgNameJoin);
        }
    }

    private List<SubComActivityDetailPlanVo> getSubComDetailPlan(List<SubComActivityDetailPlanVo> subComActivityDetailPlanList, List<SubComActivityDetailPlanItemVo> itemList) {
        List detailPlanCodes = itemList.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getConstituentDetailPlanCode())).map(SubComActivityDetailPlanItemVo::getConstituentDetailPlanCode).distinct().collect(Collectors.toList());
        return subComActivityDetailPlanList.stream().filter(plan -> detailPlanCodes.contains(plan.getConstituentDetailPlanCode())).collect(Collectors.toList());
    }

    private String getSubComValue(List<SubComActivityDetailPlanItemVo> list, String valueType) {
        String resultValue = "";
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        switch (valueType) {
            case "customer_name": {
                Optional<String> customerNameOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getCustomerName())).map(SubComActivityDetailPlanItemVo::getCustomerName).distinct().findFirst();
                if (!customerNameOptional.isPresent()) break;
                resultValue = customerNameOptional.get();
                break;
            }
            case "activity_type_name": {
                Optional<String> activityTypeNameOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getActivityTypeName())).map(SubComActivityDetailPlanItemVo::getActivityTypeName).distinct().findFirst();
                if (!activityTypeNameOptional.isPresent()) break;
                resultValue = activityTypeNameOptional.get();
                break;
            }
            case "business_unit_code": {
                Optional<String> businessUnitCodeOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getBusinessUnitCode())).map(SubComActivityDetailPlanItemVo::getBusinessUnitCode).distinct().findFirst();
                if (!businessUnitCodeOptional.isPresent()) break;
                resultValue = businessUnitCodeOptional.get();
                break;
            }
            case "business_format_code": {
                Optional<String> businessFormatCodeOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getBusinessFormatCode())).map(SubComActivityDetailPlanItemVo::getBusinessFormatCode).distinct().findFirst();
                resultValue = businessFormatCodeOptional.isPresent() ? businessFormatCodeOptional.get() : "";
                break;
            }
            case "supplier_name": {
                Optional<String> supplierNameOptional = list.stream().filter(item -> CharSequenceUtil.isNotBlank((CharSequence)item.getSupplierName())).map(SubComActivityDetailPlanItemVo::getSupplierName).distinct().findFirst();
                if (!supplierNameOptional.isPresent()) break;
                resultValue = supplierNameOptional.get();
                break;
            }
            case "fee_year_month": {
                Optional<Date> feeYearMonth = list.stream().map(SubComActivityDetailPlanItemVo::getFeeYearMonth).findFirst();
                if (!feeYearMonth.isPresent()) break;
                resultValue = df.format(feeYearMonth.get());
            }
        }
        return resultValue;
    }

    private void executeAutoAudit(List<AutoAuditDto> autoAuditList, Set<String> codes) {
        if (CollUtil.isEmpty(autoAuditList)) {
            return;
        }
        autoAuditList.forEach(autoAudit -> {
            try {
                autoAudit.setAutoAuditFlag(YesOrNoEnum.YES.getCode());
                autoAudit.setWhetherSpeciallyApproved(YesOrNoEnum.NO.getCode());
                this.autoAuditCacheKey((AutoAuditDto)autoAudit);
                this.summaryAuditAmount((AutoAuditDto)autoAudit);
                if (CharSequenceUtil.equals((CharSequence)autoAudit.getBusinessUnitCode(), (CharSequence)BusinessUnitEnum.SON_COMPANY.getCode())) {
                    autoAudit.setIsDirectBilling(YesOrNoEnum.NO.getCode());
                }
                log.info("\u6267\u884c\u81ea\u52a8\u6838\u9500\u6570\u636e:{}", (Object)JSONUtil.toJsonStr((Object)autoAudit));
                AuditDto audit = this.auditService.autoAudit(autoAudit);
                Boolean isAutoAuditFlag = audit.getIsAutoAuditFlag();
                if (Boolean.TRUE.equals(isAutoAuditFlag)) {
                    List auditCustomerDetailList = audit.getAuditCustomerDetailList();
                    List activityDetailCodes = auditCustomerDetailList.stream().filter(item -> CharSequenceUtil.isNotEmpty((CharSequence)item.getActivityDetailCode())).map(AuditCustomerDetailDto::getActivityDetailCode).collect(Collectors.toList());
                    if (StringUtils.isNotEmpty((CharSequence)audit.getDetailPlanCode())) {
                        codes.addAll(activityDetailCodes);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)audit.getConstitunetDetailPlanCode())) {
                        codes.addAll(activityDetailCodes);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)audit.getExpensesCode())) {
                        codes.addAll(activityDetailCodes);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u81ea\u52a8\u7ed3\u6848\u6570\u636e\u5f02\u5e38[{}]", (Object)JSON.toJSONString((Object)autoAudit));
                log.error("\u81ea\u52a8\u7ed3\u6848\u5f02\u5e38[{}]", (Object)e.getMessage());
                log.error("", (Throwable)e);
            }
        });
    }

    private void autoAuditCacheKey(AutoAuditDto autoAudit) {
        autoAudit.setCacheKey("AUDIT:" + UuidCrmUtil.general());
    }

    private void summaryAuditAmount(AutoAuditDto autoAudit) {
        List auditCustomerDetailList = autoAudit.getAuditCustomerDetailList();
        if (org.springframework.util.CollectionUtils.isEmpty((Collection)auditCustomerDetailList)) {
            return;
        }
        BigDecimal totalAuditAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountTaxAmount = BigDecimal.ZERO;
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        BigDecimal totalThisAuditAmount = BigDecimal.ZERO;
        BigDecimal totalReimburseTaxAmount = BigDecimal.ZERO;
        for (AuditCustomerDetailDto auditCustomerDetail : auditCustomerDetailList) {
            BigDecimal reimburseAmount = auditCustomerDetail.getReimburseAmount();
            reimburseAmount = Objects.isNull(reimburseAmount) ? BigDecimal.ZERO : reimburseAmount;
            totalAuditAmount = totalAuditAmount.add(reimburseAmount);
            BigDecimal discountTaxAmount = auditCustomerDetail.getDiscountTaxAmount();
            discountTaxAmount = ObjectUtil.isNull((Object)discountTaxAmount) ? BigDecimal.ZERO : discountTaxAmount;
            totalDiscountTaxAmount = totalDiscountTaxAmount.add(discountTaxAmount);
            BigDecimal discountAmount = auditCustomerDetail.getDiscountAmount();
            discountAmount = ObjectUtil.isNull((Object)discountAmount) ? BigDecimal.ZERO : discountAmount;
            totalDiscountAmount = totalDiscountAmount.add(discountAmount);
            BigDecimal thisAuditAmount = auditCustomerDetail.getThisAuditAmount();
            thisAuditAmount = ObjectUtil.isNull((Object)thisAuditAmount) ? BigDecimal.ZERO : thisAuditAmount;
            totalThisAuditAmount = totalAuditAmount.add(thisAuditAmount);
            BigDecimal reimburseTaxAmount = auditCustomerDetail.getReimburseTaxAmount();
            reimburseTaxAmount = ObjectUtil.isNull((Object)reimburseTaxAmount) ? BigDecimal.ZERO : reimburseTaxAmount;
            totalReimburseTaxAmount = totalReimburseTaxAmount.add(reimburseTaxAmount);
        }
        autoAudit.setThisEndCaseTaxTotalAmount(totalThisAuditAmount);
        autoAudit.setAuditTotalAmount(totalAuditAmount);
        autoAudit.setDiscountTaxTotalAmount(totalDiscountTaxAmount);
        autoAudit.setDiscountTotalAmount(totalDiscountAmount);
        autoAudit.setAuditTaxTotalAmount(totalReimburseTaxAmount);
    }

    private String getFirstOrLastDay(String activityDate, Boolean firstFlag) {
        LocalDate date = LocalDate.parse(activityDate + "01", DateTimeFormatter.BASIC_ISO_DATE);
        return firstFlag != false ? date.with(TemporalAdjusters.firstDayOfMonth()).toString() : date.with(TemporalAdjusters.lastDayOfMonth()).toString();
    }
}

