/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.util;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaInfo;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaInfoRepository;
import com.biz.crm.tpm.business.audit.sdk.enumeration.DataSourceEnum;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.ExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.dto.GeneralExpensesDto;
import com.biz.crm.tpm.business.promotion.plan.sdk.service.GeneralExpensesService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.service.SubComActivityDetailPlanItemVoService;
import com.biz.crm.tpm.business.subsidiary.activity.detail.plan.sdk.vo.SubComActivityDetailPlanItemVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditFormulaLoadUtil {
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDetailPlanItemVoService subComActivityDetailPlanItemVoService;
    @Autowired(required=false)
    private GeneralExpensesService generalExpensesService;
    @Autowired(required=false)
    private AuditFormulaInfoRepository auditFormulaInfoRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    public Map<String, String> getMapByDetailCodes(List<String> detailCodes, String businessUnitCode) {
        if (CollectionUtils.isEmpty(detailCodes)) {
            return Maps.newHashMap();
        }
        Map<String, String> formulaMap = new HashMap<String, String>();
        if (DataSourceEnum.ACTIVITY_DETAIL.getCode().equals(DataSourceEnum.getCodeByBusinessUnit((String)businessUnitCode))) {
            List list = this.activityDetailPlanItemSdkService.findByActivityDetailItemCodes((Set)Sets.newHashSet(detailCodes));
            formulaMap = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getAuditConditionCode())).collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, ActivityDetailPlanItemBase::getAuditConditionCode));
        } else if (DataSourceEnum.SON_ACTIVITY_DETAIL.getCode().equals(DataSourceEnum.getCodeByBusinessUnit((String)businessUnitCode))) {
            List list = this.subComActivityDetailPlanItemVoService.findDetailByItemCodeList(detailCodes);
            formulaMap = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getAuditConditionCode()) || StringUtils.isNotBlank((CharSequence)e.getAuditFormulaCode())).collect(Collectors.toMap(SubComActivityDetailPlanItemVo::getConstituentDetailPlanItemCode, e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getAuditFormulaCode())) {
                    return e.getAuditFormulaCode();
                }
                return e.getAuditConditionCode();
            }));
        } else if (DataSourceEnum.PROMOTION_PLAN.getCode().equals(DataSourceEnum.getCodeByBusinessUnit((String)businessUnitCode))) {
            List list = this.generalExpensesService.findByDetailCodeList(detailCodes);
            formulaMap = list.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getAuditConditionCode())).collect(Collectors.toMap(ExpensesDto::getExpensesCode, GeneralExpensesDto::getAuditConditionCode));
        }
        return formulaMap;
    }

    public Map<String, List<AuditFormulaInfoVo>> getFormulaInfoMap(List<String> formulaCodes) {
        List infoVoList;
        if (CollectionUtils.isEmpty(formulaCodes)) {
            return Maps.newHashMap();
        }
        List auditFormulaInfos = new ArrayList();
        if (CollectionUtils.isNotEmpty(formulaCodes)) {
            auditFormulaInfos = ((LambdaQueryChainWrapper)this.auditFormulaInfoRepository.lambdaQuery().in(AuditFormulaInfo::getAuditFormulaCode, (Collection)Sets.newHashSet(formulaCodes))).list();
        }
        Map<String, List<AuditFormulaInfoVo>> formulaInfoMap = new HashMap<String, List<AuditFormulaInfoVo>>();
        if (CollectionUtils.isNotEmpty(auditFormulaInfos) && CollectionUtils.isNotEmpty((Collection)(infoVoList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(auditFormulaInfos, AuditFormulaInfo.class, AuditFormulaInfoVo.class, HashSet.class, ArrayList.class, new String[0])))) {
            formulaInfoMap = infoVoList.stream().collect(Collectors.groupingBy(AuditFormulaInfoVo::getAuditFormulaCode));
        }
        return formulaInfoMap;
    }
}

