/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.util;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.sdk.vo.ActivityDetailVo;
import com.biz.crm.tpm.business.variable.sdk.executeIndicator.service.AuditExecuteIndicatorService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditLoadActualDataUtil {
    @Autowired(required=false)
    private AuditExecuteIndicatorService auditExecuteIndicatorService;

    public void load(Page<ActivityDetailVo> page) {
        if (Objects.isNull(page) || CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return;
        }
        List detailItemCodes = page.getRecords().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getActivityDetailCode())).map(ActivityDetailVo::getActivityDetailCode).distinct().collect(Collectors.toList());
        Map amountMap = this.auditExecuteIndicatorService.getSapAmountByDetailItemNos(detailItemCodes, "sapOccurrenceAmount");
        Map quantityMap = this.auditExecuteIndicatorService.getSapAmountByDetailItemNos(detailItemCodes, "sapOccurrenceAmount");
        page.getRecords().forEach(v -> {
            if (StringUtils.isNotEmpty((CharSequence)v.getActivityDetailCode())) {
                v.setAlreadyExeAmount((BigDecimal)amountMap.get(v.getActivityDetailCode()));
                v.setAlreadyExeQuantity((BigDecimal)quantityMap.get(v.getActivityDetailCode()));
            }
        });
    }
}

