/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.workFlowListener;

import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.audit.local.service.AuditCustomerService;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class AuditProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(AuditProcessCallBackListener.class);
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private AuditCustomerService auditCustomerService;

    public String getBusinessCode() {
        return "ordinary_audit_process";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        Assert.notNull((Object)dto, (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u5931\u8d25\uff0c\u5ba1\u6279\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!");
        log.info("=====>    \u7ed3\u6848\u6838\u9500\u6279\u91cf\u5ba1\u6279\u56de\u8c03\u53c2\u6570\u4fe1\u606f:{}    <=====", (Object)JSON.toJSONString((Object)dto));
        String processStatus = dto.getProcessStatus();
        Assert.hasLength((String)processStatus, (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u5931\u8d25\uff0c\u5ba1\u6279\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!");
        ProcessStatusEnum processStatusEnum = ProcessStatusEnum.getStatusEnumByDictCode((String)processStatus);
        Assert.notNull((Object)processStatusEnum, (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u7a0b\u5931\u8d25\uff0c\u5ba1\u6279\u72b6\u6001\u4e0d\u5408\u6cd5!");
        List<String> auditCodeList = dto.getBusinessNoList();
        Assert.notEmpty((Collection)auditCodeList, (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u5931\u8d25\uff0c\u6838\u9500\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        List list = this.auditService.findByAuditCodeList((List)auditCodeList);
        Assert.notNull((Object)list, (String)("\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u76f8\u5173[" + auditCodeList + "]\u6838\u9500\u5355\u636e!"));
        ArrayList<AuditVo> list2 = new ArrayList<AuditVo>();
        for (AuditVo auditVo : list) {
            if (!ProcessStatusEnum.COMMIT.getDictCode().equals(auditVo.getProcessStatus())) continue;
            list2.add(auditVo);
        }
        List<String> codes = list2.stream().map(AuditVo::getAuditCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(codes)) {
            return;
        }
        dto.setBusinessNoList(codes);
        auditCodeList = codes;
        AbstractCrmUserIdentity user = this.loginUserService.getAbstractLoginUser();
        AuditDto auditDto = new AuditDto();
        auditDto.setProcessDate(new Date());
        auditDto.setProcessStatus(processStatus);
        auditDto.setApprovalAccount(user.getUsername());
        auditDto.setApprovalName(user.getRealName());
        this.auditService.updateProcessStatusByAuditCodeList(auditDto, list2);
        if (ProcessStatusEnum.PASS.getDictCode().equals(processStatus)) {
            this.auditCustomerService.updateUpAccountStatus(auditCodeList);
        }
        MqMessageVo updateAuditMsgVo = new MqMessageVo();
        updateAuditMsgVo.setTopic("TPM_DETAILED_FORECAST_TOPIC" + RocketMqUtil.mqEnvironment());
        updateAuditMsgVo.setTag("TPM_DETAILED_FORECAST_UPDATE_AUDIT_AMOUNT");
        updateAuditMsgVo.setMsgBody(JSON.toJSONString(auditCodeList));
        this.rocketMqProducer.sendMqMsg(updateAuditMsgVo, 10L);
        MqMessageVo bpmProcessVo = new MqMessageVo();
        bpmProcessVo.setTopic("TPM_AUDIT_BPM_PROCESS_TOP" + RocketMqUtil.mqEnvironment());
        bpmProcessVo.setTag("TPM_AUDIT_BPM_PROCESS_TAG");
        bpmProcessVo.setMsgBody(JSON.toJSONString((Object)dto));
        this.rocketMqProducer.sendMqMsg(bpmProcessVo, 600L);
    }
}

