/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.local.workFlowListener;

import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.audit.sdk.service.IAudit;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class AuditSupplierProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(AuditSupplierProcessCallBackListener.class);
    @Autowired(required=false)
    private AuditService auditService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private List<IAudit> auditStrategyList;

    public String getBusinessCode() {
        return "supplier_ordinary_audit_process";
    }

    public void onProcessComplete(ProcessStatusDto dto) {
        log.info("\u4f9b\u5e94\u5546\u7ed3\u6848\u6838\u9500:{}", (Object)JsonUtils.obj2JsonString((Object)dto));
        try {
            List auditCodeList = dto.getBusinessNoList();
            Assert.notEmpty((Collection)auditCodeList, (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u5931\u8d25\uff0c\u6838\u9500\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
            List list = this.auditService.findByAuditCodeList(auditCodeList);
            String processStatus = dto.getProcessStatus();
            ProcessStatusEnum processStatusEnum = ProcessStatusEnum.getStatusEnumByDictCode((String)processStatus);
            for (Object auditVo : list) {
                Validate.isTrue((boolean)ProcessStatusEnum.COMMIT.getDictCode().equals(auditVo.getProcessStatus()), (String)"\u5ba1\u6279\u8fc7\u7684\u72b6\u6001\u4e0d\u5bf9", (Object[])new Object[0]);
            }
            if (ProcessStatusEnum.PASS.equals((Object)processStatusEnum) && CollectionUtils.isNotEmpty((Collection)list)) {
                Collection pass = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditVo.class, AuditDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                for (AuditDto auditDto : pass) {
                    IAudit thisAudit = this.getAudit(auditDto);
                    log.info("\u7269\u6599\u8d39\u6838\u9500\u6279\u91cf\u5ba1\u6279\u901a\u8fc71:\u6838\u9500\u5355\u53f7:{}", (Object)auditDto.getAuditCode());
                    thisAudit.approvalPass(auditDto);
                    log.info("\u7269\u6599\u8d39\u6838\u9500\u6279\u91cf\u5ba1\u6279\u901a\u8fc72:\u6838\u9500\u5355\u53f7:{}", (Object)auditDto.getAuditCode());
                }
            }
            if (ProcessStatusEnum.REJECT.equals((Object)processStatusEnum) || ProcessStatusEnum.RECOVER.equals((Object)processStatusEnum)) {
                // empty if block
            }
            AbstractCrmUserIdentity user = this.loginUserService.getAbstractLoginUser();
            AuditDto auditDto = new AuditDto();
            auditDto.setProcessDate(new Date());
            auditDto.setProcessStatus(processStatus);
            auditDto.setApprovalAccount(user.getUsername());
            auditDto.setApprovalName(user.getRealName());
            this.auditService.updateProcessStatusByAuditCodeList2(auditDto, auditCodeList);
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u7ed3\u6848\u6838\u9500\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    public IAudit getAudit(AuditDto audit) {
        for (IAudit audit1 : this.auditStrategyList) {
            if (!audit1.isSupport(audit)) continue;
            return audit1;
        }
        for (IAudit iAudit : this.auditStrategyList) {
            if (!iAudit.isDefault()) continue;
            return iAudit;
        }
        return null;
    }
}

