package com.biz.crm.tpm.business.budget.controls.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.controls.config.local.entity.BudgetProject;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BasicInformationQueryBudgetItemsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.BudgetProjectDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.BudgetProjectService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.BudgetProjectVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * (BudgetProjectController)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-08 12:05:57
 */

@RestController
@RequestMapping("/v1/budgetProject")
@Slf4j
@Api(tags = "选择预算项目")
public class BudgetProjectController {

    @Autowired
    private BudgetProjectService projectService;

    /**
     * 通过基本信息查询预算项目接口
     *
     * @param dto 对
     */
    @ApiOperation(value = "通过基本信息查询预算项目接口")
    @PostMapping
    public Result<List<BudgetProjectVo>> basicInformationQueryBudgetItems(@ApiParam(name = "dto", value = "选择预算项目") @RequestBody @Valid BasicInformationQueryBudgetItemsDto dto) {
        try {
            List<BudgetProjectVo> result = this.projectService.basicInformationQueryBudgetItems(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto)     查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<BudgetProjectVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dimensionBudget", value = "预算管理配置表") BudgetProjectDto dto) {
        try {
            Page<BudgetProjectVo> page = this.projectService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
