package com.biz.crm.tpm.business.budget.controls.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.DimensionControlsDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.dto.ControlTypeDataDto;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.DimensionControlsService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.ControlTypeDataVo;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.DimensionControlsVo;
import com.biz.crm.tpm.business.budget.dimension.config.sdk.vo.DimensionVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;
import java.util.Set;

/**
 * (DimensionControlsVo)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-08 12:05:57
 */

@RestController
@RequestMapping("/v1/dimensionControls")
@Slf4j
@Api(tags = "预算管控配置")
public class DimensionControlsController {

    /**
     * 服务对象
     */
    @Autowired
    private DimensionControlsService dimensionControlsService;


    /**
     * 分页查询所有数据
     *
     * @param pageable             分页对象
     * @param dimensionControlsDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<DimensionControlsVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                              @ApiParam(name = "dimensionBudget", value = "预算管理配置表") DimensionControlsDto dimensionControlsDto) {
        try {
            Page<DimensionControlsVo> page = this.dimensionControlsService.findByConditions(pageable, dimensionControlsDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增整体管控和管控维度数据
     *
     * @param dimensionControlsDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "整体管控新增数据")
    @PostMapping
    public Result<DimensionControlsVo> create(@ApiParam(name = "dimensionControlsDto", value = "预算管控配置表") @RequestBody @Valid ControlTypeDataDto dimensionControlsDto) {
        try {
            DimensionControlsVo dimensionBudgetVo = this.dimensionControlsService.create(dimensionControlsDto);
            return Result.ok(dimensionBudgetVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("detail")
    public Result<ControlTypeDataVo> detail(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            return Result.ok(this.dimensionControlsService.findById(id));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 编辑数据
     *
     * @param dto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<?> update(@ApiParam(name = "ControlTypeDataDto", value = "预算管控配置整体数据") @RequestBody ControlTypeDataDto dto) {
        try {
            this.dimensionControlsService.update(dto);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @DeleteMapping
    @ApiOperation(value = "删除数据")
    public Result<?> delete(@RequestParam("ids") Set<String> ids) {
        try {
            this.dimensionControlsService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 启用
     *
     * @param ids
     * @return
     */
    @ApiOperation(value = "启用", httpMethod = "PATCH")
    @PatchMapping("/enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.dimensionControlsService.enableBatch(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 禁用
     *
     * @param ids 主键列表
     * @return 禁用结果
     */
    @ApiOperation(value = "禁用", httpMethod = "PATCH")
    @PatchMapping("/disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.dimensionControlsService.disableBatch(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询所有数据
     *
     * @param dimensionControlsDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/listByConditions")
    public Result<List<DimensionControlsVo>> listByConditions(@ApiParam(name = "dimensionBudget", value = "预算管理配置表") DimensionControlsDto dimensionControlsDto) {
        try {
            List<DimensionControlsVo> list = this.dimensionControlsService.listByConditions(dimensionControlsDto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
