package com.biz.crm.tpm.business.budget.controls.config.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.tpm.business.budget.controls.config.local.repository.BudgetProjectRepository;
import com.biz.crm.tpm.business.budget.controls.config.sdk.service.BudgetProjectService;
import com.biz.crm.tpm.business.budget.controls.config.sdk.vo.BudgetProjectVo;
import com.bizunited.nebula.europa.database.register.sdk.service.MnDataviewRegister;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.strategy.ParameterOperatorBindingStrategy;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 预算管控
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.5 14:23
 */
@Component
public class DimensionControlsDataViewRegister implements MnDataviewRegister {

    @Autowired(required = false)
    @Qualifier("inParameterOperatorBindingStrategy")
    private ParameterOperatorBindingStrategy inParameterOperatorBindingStrategy;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private BudgetProjectService budgetProjectService;

    @Autowired(required = false)
    private BudgetProjectRepository budgetProjectRepository;

    @Override
    public String code() {
        return "tpm_budget_controls_config_data_view";
    }

    @Override
    public String desc() {
        return "TPM 预算管控配置设置数据视图";
    }

    @Override
    public String buildSql() {
        return "SELECT t.*,'' as sales_org_name ,\n" +
                "'' as budget_item_level,\n" +
                "'' as budget_item_code,\n" +
                "'' as budget_item_name\n" +
                "FROM tpm_dimension_controls t" +
                "  WHERE  t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' " +
                "  AND t.tenant_code = :tenantCode ";
    }

    @Override
    public Object customBindingFieldValue(ExecuteParameter executeParameter, DatabaseExecuteExternalRequest databaseExecuteExternalRequest) {
        if (!(executeParameter instanceof DatabaseExecuteParameter)) {
            return null;
        }
        DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter) executeParameter;
        String paramName = databaseExecuteParameter.getParamName();
        Object value = databaseExecuteExternalRequest.getAttribute(paramName);
        if (value == null) {
            return null;
        }
        String valueStr = String.valueOf(value);
        if (DimensionControlsExecuteParameterBuildInterceptor.sales_org_name.equals(databaseExecuteParameter.getTargetFieldName())){
            return salesOrgNameQuery(databaseExecuteParameter, valueStr);
        } else if (DimensionControlsExecuteParameterBuildInterceptor.budget_item_level.equals(databaseExecuteParameter.getTargetFieldName())) {
            return budgetItemLevelQuery(databaseExecuteParameter, valueStr);
        } else if (DimensionControlsExecuteParameterBuildInterceptor.budget_item_code.equals(databaseExecuteParameter.getTargetFieldName())) {
            return budgetItemCodeQuery(databaseExecuteParameter, valueStr);
        } else if (DimensionControlsExecuteParameterBuildInterceptor.budget_item_name.equals(databaseExecuteParameter.getTargetFieldName())) {
            return budgetItemNameQuery(databaseExecuteParameter, valueStr);
        }
        return value;
    }


    private Object budgetItemNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "controls_config_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        List<String> controlsConfigCodeList = Lists.newArrayList("_");
        List<String> budgetItemNameList = Arrays.asList(valueStr.split("[, ，]"));
        List<BudgetProjectVo> byBudgetItemNames = budgetProjectService.findByBudgetItemNames(budgetItemNameList);
        List<String> collect = byBudgetItemNames.stream().map(BudgetProjectVo::getControlsConfigCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)){
            controlsConfigCodeList.addAll(collect);
        }
        return controlsConfigCodeList;
    }

    private Object budgetItemCodeQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "controls_config_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        List<String> controlsConfigCodeList = Lists.newArrayList("_");
        List<String> budgetItemCodeList = Arrays.asList(valueStr.split("[, ，]"));
        List<BudgetProjectVo> byBudgetItemNames = budgetProjectRepository.findByBudgetItemCodes(budgetItemCodeList);
        List<String> collect = byBudgetItemNames.stream().map(BudgetProjectVo::getControlsConfigCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)){
            controlsConfigCodeList.addAll(collect);
        }
        return controlsConfigCodeList;
    }

    private Object budgetItemLevelQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "controls_config_code";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);

        List<String> controlsConfigCodeList = Lists.newArrayList("_");
        List<String> budgetItemLevelList = Arrays.asList(valueStr.split("[, ，]"));
        List<BudgetProjectVo> byBudgetItemNames = budgetProjectRepository.findByBudgetItemLevels(budgetItemLevelList);
        List<String> collect = byBudgetItemNames.stream().map(BudgetProjectVo::getControlsConfigCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)){
            controlsConfigCodeList.addAll(collect);
        }
        return controlsConfigCodeList;
    }

    private Object salesOrgNameQuery(DatabaseExecuteParameter databaseExecuteParameter, String valueStr) {
        String targetAlias = databaseExecuteParameter.getTargetAlias();
        String targetTableName = databaseExecuteParameter.getTargetTableName();
        String targetFieldName = "market_organization";
        String parameterName = databaseExecuteParameter.getParamName();

        String expression = inParameterOperatorBindingStrategy.expression(targetAlias, targetTableName, targetFieldName, parameterName);
        databaseExecuteParameter.setTargetOpExpression(expression);
        List<String> salesOrgCode = Lists.newArrayList("_");
        List<SalesOrgVo> bySalesOrgNames = salesOrgVoService.findListBySalesOrgName(valueStr);
        List<String> codeList = bySalesOrgNames.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(codeList)){
            salesOrgCode.addAll(codeList);
        }

        return salesOrgCode;
    }

}
