package com.biz.crm.tpm.business.budget.controls.config.local.dataview;

import com.bizunited.nebula.europa.database.local.service.bind.MnCustomParamFieldBindingStrategy;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteParameter;
import com.bizunited.nebula.europa.database.sdk.service.ExecuteParameterBuildInterceptor;
import com.bizunited.nebula.europa.database.sdk.vo.DatabaseViewVo;
import com.bizunited.nebula.europa.sdk.context.execute.ExecuteParameter;
import com.bizunited.nebula.europa.sdk.context.matedata.MetaData;
import com.bizunited.nebula.europa.sdk.vo.EuropaInfoVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * @author baokai
 * @date 2023/11/4 11:02
 */
@Component
public class DimensionControlsExecuteParameterBuildInterceptor implements ExecuteParameterBuildInterceptor {

    /**
     * 销售组织
     */
    public static final String sales_org_name = "sales_org_name";

    /**
     * 预算项目名称
     */
    public static final String budget_item_code = "budget_item_code";
    /**
     * 预算项目名称
     */
    public static final String budget_item_level = "budget_item_level";

    /**
     * 预算项目名称
     */
    public static final String budget_item_name = "budget_item_name";

    @Autowired(required = false)
    private MnCustomParamFieldBindingStrategy mnCustomParamFieldBindingStrategy;

    @Autowired(required = false)
    private DimensionControlsDataViewRegister register;
    @Override
    public void onBuildExecuteParameters(MetaData metaData, EuropaInfoVo europaInfoVo, Set<ExecuteParameter> set) {
        DatabaseViewVo view = (DatabaseViewVo)europaInfoVo.getView();
        String dataViewCode = view.getRegisterCode();
        if (!StringUtils.equals(register.code(), dataViewCode)) {
            return;
        }
        for (ExecuteParameter executeParameter : set) {
            if (executeParameter instanceof DatabaseExecuteParameter){
                DatabaseExecuteParameter databaseExecuteParameter = (DatabaseExecuteParameter) executeParameter;
                if (sales_org_name.equals(databaseExecuteParameter.getTargetFieldName())
                        || budget_item_level.equals(databaseExecuteParameter.getTargetFieldName())
                        || budget_item_code.equals(databaseExecuteParameter.getTargetFieldName())
                        || budget_item_name.equals(databaseExecuteParameter.getTargetFieldName())
                ){
                    //销售组织、预算项目名称
                    databaseExecuteParameter.setValueBindType(MnCustomParamFieldBindingStrategy.PARAM_BIND_TYPE);
                    mnCustomParamFieldBindingStrategy.setEuropaInfoVo(europaInfoVo);
                }
            }
        }
    }
}
