package com.biz.crm.tpm.business.budget.controls.config.local.entity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author BudgetItem
 */
@ApiModel(value = "BudgetProject", description = "选择预算项目")
@Data
@Entity(name = "tpm_budget_project")
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_project", comment = "选择预算项目")
@TableName("tpm_budget_project")
@EqualsAndHashCode(callSuper = true)
@Table(name = "tpm_budget_project", indexes = {
        @Index(name = "tpm_budget_project_index1", columnList = "controls_config_code"),
        @Index(name = "tpm_budget_project_index2", columnList = "budget_item_code"),
})
public class BudgetProject extends UuidFlagOpEntity {

    /**
     * 管控配置编码
     */
    @ApiModelProperty("管控配置编码")
    @Column(name = "controls_config_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '管控配置编码'")
    private String controlsConfigCode;

    /**
     * 预算项目编码
     */
    @ApiModelProperty("预算项目编码")
    @Column(name = "budget_item_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '预算项目编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty("预算项目名称")
    @Column(name = "budget_item_name", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '预算项目名称'")
    private String budgetItemName;

    /**
     * 预算项目层级
     */
    @ApiModelProperty("预算项目层级")
    @Column(name = "budget_item_hierarchy", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '预算项目层级'")
    private String budgetItemHierarchy;

    /**
     * 上级预算项目编码
     */
    @ApiModelProperty("上级预算项目编码")
    @Column(name = "superior_budget_project_coding", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '上级预算项目编码'")
    private String superiorBudgetProjectCoding;

    /**
     * 上级预算项目名称
     */
    @ApiModelProperty("上级预算项目名称")
    @Column(name = "superior_budget_project_name", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '上级预算项目编码'")
    private String superiorBudgetProjectName;

    /**
     * 费用属性
     */
    @ApiModelProperty("费用属性")
    @Column(name = "cost_property", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '费用属性'")
    private String costProperty;


}
