package com.biz.crm.tpm.business.budget.controls.config.local.entity;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;


/**
 * (DimensionBudget)
 *
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@ApiModel(value = "DimensionControls", description = "预算管理")
@Data
@Entity(name = "tpm_dimension_controls")
@org.hibernate.annotations.Table(appliesTo = "tpm_dimension_controls", comment = "预算管理")
@TableName("tpm_dimension_controls")
@EqualsAndHashCode(callSuper = false)
@Table(name = "tpm_dimension_controls", indexes = {
        @Index(name = "tpm_dimension_controls_index1", columnList = "control_type"),
})
public class DimensionControls  extends TenantFlagOpEntity {

    /**
     * 管控配置编码
     */
    @ApiModelProperty("管控配置编码 ")
    @Column(name = "controls_config_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '管控配置编码'")
    private String controlsConfigCode;

    /**
     * 规则名称
     */
    @ApiModelProperty("管控配置名称")
    @Column(name = "controls_config_name", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '管控配置名称'")
    private String controlsConfigName;

    /**
     * 业态
     */
    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    /**
     * 业务单元编码
     */
    @ApiModelProperty(value = "业务单元编码", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 60, columnDefinition = "varchar(60) COMMENT '业务单元编码'")
    private String businessUnitCode;

    /**
     * 管控类型
     */
    @ApiModelProperty("管控类型")
    @Column(name = "control_type", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '管控类型'")
    private String controlType;

    /**
     * 销售机构
     */
    @ApiModelProperty("销售机构")
    @Column(name = "market_organization", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '销售机构'")
    private String marketOrganization;

    /**
     * 管控形势[数据字典:control_situation]
     */
    @ApiModelProperty("管控形势[数据字典:control_situation]")
    @Column(name = "control_situation", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '管控形势[数据字典:control_situation]'")
    private String controlSituation;

    /**
     * 管控口径
     */
    @ApiModelProperty("管控口径")
    @Column(name = "controls_caliber", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '管控口径'")
    private String controlsCaliber;


    /**
     * 字段维度
     */
    @ApiModelProperty("字段维度")
    @Column(name = "fields_dimensionality", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '字段维度'")
    private String fieldsDimensionality;


    /**
     * 是否滚动
     */
    @ApiModelProperty("是否滚动")
    @Column(name = "if_rolling", nullable = true, length = 2, columnDefinition = "varchar(64) COMMENT '是否滚动'")
    private String ifRolling;


    /**
     * 滚动类型
     */
    @ApiModelProperty("滚动类型")
    @Column(name = "rolling_type", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '滚动类型'")
    private String rollingType;

    /**
     * 时间维度
     */
    @ApiModelProperty("时间维度")
    @Column(name = "time_dimension", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '时间维度'")
    private String timeDimension;

    /**
     *
     * 部门编码
     */
    @ApiModelProperty(name = "部门编码", notes = "")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '部门编码 '")
    private String orgCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(name = "部门名称", notes = "")
    @Column(name = "org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '部门名称 '")
    private String orgName;


}
