package com.biz.crm.tpm.business.budget.controls.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;


/**
 * (DimensionBudget)
 *
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@ApiModel(value = "RulesEnact", description = "规则制定表")
@Data
@Entity(name = "tpm_rules_enact")
@org.hibernate.annotations.Table(appliesTo = "tpm_rules_enact", comment = "规则制定表")
@TableName("tpm_rules_enact")
@EqualsAndHashCode(callSuper = true)
public class RulesEnact extends UuidFlagOpEntity {

    /**
     * 管控配置编码
     */
    @ApiModelProperty("管控配置编码")
    @Column(name = "controls_config_code", nullable = true, length = 64, columnDefinition = "varchar(64) COMMENT '管控配置编码'")
    private String controlsConfigCode;

    @Column(name = "formula_code" ,   columnDefinition = "VARCHAR(500) COMMENT '公式'")
    @ApiModelProperty("公式")
    private String formulaCode;

    @Column(name = "formula_name" ,   columnDefinition = "VARCHAR(500) COMMENT '公式（展示用）'")
    @ApiModelProperty("公式（展示用）")
    private String formulaName;

    @Column(name = "formula_json" ,   columnDefinition = "VARCHAR(500) COMMENT '公式json'")
    @ApiModelProperty("公式json")
    private String formulaJson;
}